# Summary

[Introduction](index.md)

* [Getting Started](getting-started/index.md)
    * [Installation](getting-started/installation.md)
    * [First Steps with Cargo](getting-started/first-steps.md)

* [Cargo Guide](guide/index.md)
    * [Why Cargo Exists](guide/why-cargo-exists.md)
    * [Creating a New Package](guide/creating-a-new-project.md)
    * [Working on an Existing Package](guide/working-on-an-existing-project.md)
    * [Dependencies](guide/dependencies.md)
    * [Package Layout](guide/project-layout.md)
    * [Cargo.toml vs Cargo.lock](guide/cargo-toml-vs-cargo-lock.md)
    * [Tests](guide/tests.md)
    * [Continuous Integration](guide/continuous-integration.md)
    * [Cargo Home](guide/cargo-home.md)
    * [Build Cache](guide/build-cache.md)

* [Cargo Reference](reference/index.md)
    * [Specifying Dependencies](reference/specifying-dependencies.md)
        * [Overriding Dependencies](reference/overriding-dependencies.md)
    * [The Manifest Format](reference/manifest.md)
        * [Cargo Targets](reference/cargo-targets.md)
    * [Workspaces](reference/workspaces.md)
    * [Features](reference/features.md)
    * [Profiles](reference/profiles.md)
    * [Configuration](reference/config.md)
    * [Environment Variables](reference/environment-variables.md)
    * [Build Scripts](reference/build-scripts.md)
        * [Build Script Examples](reference/build-script-examples.md)
    * [Publishing on crates.io](reference/publishing.md)
    * [Package ID Specifications](reference/pkgid-spec.md)
    * [Source Replacement](reference/source-replacement.md)
    * [External Tools](reference/external-tools.md)
    * [Registries](reference/registries.md)
    * [Unstable Features](reference/unstable.md)

* [Cargo Commands](commands/index.md)
    * [General Commands](commands/general-commands.md)
        * [cargo](commands/cargo.md)
        * [cargo help](commands/cargo-help.md)
        * [cargo version](commands/cargo-version.md)
    * [Build Commands](commands/build-commands.md)
        * [cargo bench](commands/cargo-bench.md)
        * [cargo build](commands/cargo-build.md)
        * [cargo check](commands/cargo-check.md)
        * [cargo clean](commands/cargo-clean.md)
        * [cargo doc](commands/cargo-doc.md)
        * [cargo fetch](commands/cargo-fetch.md)
        * [cargo fix](commands/cargo-fix.md)
        * [cargo run](commands/cargo-run.md)
        * [cargo rustc](commands/cargo-rustc.md)
        * [cargo rustdoc](commands/cargo-rustdoc.md)
        * [cargo test](commands/cargo-test.md)
    * [Manifest Commands](commands/manifest-commands.md)
        * [cargo generate-lockfile](commands/cargo-generate-lockfile.md)
        * [cargo locate-project](commands/cargo-locate-project.md)
        * [cargo metadata](commands/cargo-metadata.md)
        * [cargo pkgid](commands/cargo-pkgid.md)
        * [cargo update](commands/cargo-update.md)
        * [cargo vendor](commands/cargo-vendor.md)
        * [cargo verify-project](commands/cargo-verify-project.md)
    * [Package Commands](commands/package-commands.md)
        * [cargo init](commands/cargo-init.md)
        * [cargo install](commands/cargo-install.md)
        * [cargo new](commands/cargo-new.md)
        * [cargo search](commands/cargo-search.md)
        * [cargo uninstall](commands/cargo-uninstall.md)
    * [Publishing Commands](commands/publishing-commands.md)
        * [cargo login](commands/cargo-login.md)
        * [cargo owner](commands/cargo-owner.md)
        * [cargo package](commands/cargo-package.md)
        * [cargo publish](commands/cargo-publish.md)
        * [cargo yank](commands/cargo-yank.md)

* [FAQ](faq.md)
* [Appendix: Glossary](appendix/glossary.md)
* [Appendix: Git Authentication](appendix/git-authentication.md)
