/////////////////////////////////////////////////////////////////////////////
//
//  Captury - http://rm-rf.in/captury
//  $Id$
//
//  Copyright (c) 2007 by Christian Parpart <trapni@gentoo.org>
//
//  This file as well as its whole library is licensed under
//  the terms of GPL. See the file COPYING.
//
/////////////////////////////////////////////////////////////////////////////
#include "log.h"

#include <sys/time.h>
#include <time.h>
#include <stdio.h>
#include <stdlib.h>
#include <stdarg.h>
#include <string.h>
#include <errno.h>
#include <assert.h>

#include <sys/types.h>
#include <fcntl.h>
#include <pthread.h>
#include <unistd.h>

int errorCount = 0;

const char *getTimeStamp() {
	time_t t = time(0);
	struct tm *tm = localtime(&t);

	static char timestamp[128];
	strftime(timestamp, sizeof(timestamp), "%F %T", tm);

	return timestamp;
}

void logError(const char *msg, ...) {
	va_list va;

	++errorCount;

	fprintf(stderr, "%s CAPTURY(EE) ", getTimeStamp());
	va_start(va, msg);
	vfprintf(stderr, msg, va);
	va_end(va);
	fprintf(stderr, "\n");
}

void logWarning(const char *msg, ...) {
	va_list va;

	fprintf(stderr, "%s CAPTURY(WW) ", getTimeStamp());
	va_start(va, msg);
	vfprintf(stderr, msg, va);
	va_end(va);
	fprintf(stderr, "\n");
}

int verbosity() {
	static char *verbosity = NULL;
	int level = 0;
	if (!verbosity) {
		verbosity = getenv("CAPTURY_VERBOSE");
		if (verbosity && *verbosity)
			level = atoi(verbosity);
	}

	return level;
}

void log(int level, const char *msg, ...) {
	static int vlevel = verbosity();
	if (level <= vlevel) {
		va_list va;

		fprintf(stderr, "%s CAPTURY(%d) ", getTimeStamp(), vlevel);
		va_start(va, msg);
		vfprintf(stderr, msg, va);
		va_end(va);
		fprintf(stderr, "\n");
	}
}

void debug(const char *fmt, ...) {
#if !defined(NDEBUG)
	va_list va;

	fprintf(stderr, "%s CAPTURY(DD) ", getTimeStamp());
	va_start(va, fmt);
	vfprintf(stderr, fmt, va);
	va_end(va);
	fprintf(stderr, "\n");
	fflush(stderr);
#endif
}

// vim:ai:noet:ts=4:nowrap
