(***********************************************************************)
(*                                                                     *)
(*                           Objective Caml                            *)
(*                                                                     *)
(*            Jun Furuse, projet Cristal, INRIA Rocquencourt           *)
(*                                                                     *)
(*  Copyright 1999,2000,2001,2002,2001,2002                            *)
(*  Institut National de Recherche en Informatique et en Automatique.  *)
(*  Distributed only by permission.                                    *)
(*                                                                     *)
(***********************************************************************)
open Gdk
open GDraw
open GMain

let _ = GMain.Main.init ()

let active = ref true

let sync () =
(*
  while Glib.Main.pending () do
    Glib.Main.iteration false
  done
*)
  while Glib.Main.iteration false do () done

let window = GWindow.window ~title: "lv"
    ~auto_shrink: true 
    ~allow_shrink: true 
    ~allow_grow: true 
    () 
let _ = window#set_resize_mode `IMMEDIATE
let _ = window#connect#destroy ~callback:Main.quit

let fixed = GPack.fixed ~width:100 ~height:100 ~packing: window#add ()

let darea = GMisc.drawing_area 
    ~show: true
    ~packing: (fixed#put ~x:0 ~y:0) ()

class new_progress_bar obj = object
  inherit GRange.progress_bar obj as super
  val mutable previous = 0.0
  method set_percentage x =
    let x = floor (x *. 10.0) /. 10.0 in
    if x = previous then ()
    else begin super#set_percentage x; sync () end
end

let new_progress_bar ?adjustment ?bar_style ?discrete_blocks
    ?activity_step ?activity_blocks ?value ?percentage ?activity_mode
    ?show_text ?format_string ?text_xalign ?text_yalign
    ?packing ?show () =
  let w =
    match adjustment with None -> GtkRange.ProgressBar.create ()
    | Some adj ->
	GtkRange.ProgressBar.create_with_adjustment (GData.as_adjustment adj)
  in
  GtkRange.ProgressBar.set w ?bar_style ?discrete_blocks
    ?activity_step ?activity_blocks;
  GtkRange.Progress.set w ?value ?percentage ?activity_mode
    ?show_text ?format_string ?text_xalign ?text_yalign;
  GObj.pack_return (new new_progress_bar w) ~packing ~show

let prog = 
  new_progress_bar ~packing: (fixed#put ~x:0 ~y:0)
    ~format_string: ""
    ~show_text: true ()

let visual = window#misc#visual
let screen_width = Screen.width ()
let screen_height = Screen.height ()

let quick_color_create = Truecolor.color_creator visual
let quick_color_parser = Truecolor.color_parser visual

let root_win = Window.root_parent ()

let root_size = Window.get_size root_win

let _ = darea#misc#realize ()
let drawing = new drawable darea#misc#window
let drawing_root = new drawable root_win

let infowindow = GWindow.window ~title:"lv info" ~width:300 ~height:150 ()

let _ =
  infowindow#connect#destroy ~callback:Main.quit
;;

(*
let imglbox = GFrame.scrolled_window ~packing:infowindow#add 
    ~hpolicy: `AUTOMATIC ~vpolicy: `ALWAYS ()
*)
let imglbox = GPack.hbox ~packing:infowindow#add ()
let sb = GRange.scrollbar `VERTICAL 
    ~packing:(imglbox#pack ~from:`END ~expand:false) ()
let imglist = (GList.clist ~shadow_type:`OUT 
    ~columns: 1 ~packing: imglbox#add ~vadjustment:sb#adjustment () : string GList.clist)

let colormap = Gdk.Color.get_system_colormap ()
