/*****************************************************************************
 * $CAMITK_LICENCE_BEGIN$
 *
 * CamiTK - Computer Assisted Medical Intervention ToolKit
 * (c) 2001-2018 Univ. Grenoble Alpes, CNRS, TIMC-IMAG UMR 5525 (GMCAO)
 *
 * Visit http://camitk.imag.fr for more information
 *
 * This file is part of CamiTK.
 *
 * CamiTK is free software: you can redistribute it and/or modify
 * it under the terms of the GNU Lesser General Public License version 3
 * only, as published by the Free Software Foundation.
 *
 * CamiTK is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU Lesser General Public License version 3 for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * version 3 along with CamiTK.  If not, see <http://www.gnu.org/licenses/>.
 *
 * $CAMITK_LICENCE_END$
 ****************************************************************************/
#ifndef DENCIESWIDGET_H
#define DENCIESWIDGET_H

// Include GUI  automatically generated file
#include "ui_DependenciesWidget.h"

// includes from Qt
#include <QWidget>
#include <QStringList>
#include <QCheckBox>

/**
 * @ingroup group_sdk_application_wizard
 *
 * @brief
 * Widget to define dependencies
 *
 */
class  DependenciesWidget : public QWidget {

    Q_OBJECT;

public:
    /**  Constructor */
    DependenciesWidget(QWidget* parent);
    /**  Destructor */
    ~DependenciesWidget() override = default;

    void setToDefault();

    void setElement(QString element);
    void updateCEPLibraries(QStringList cepLibraries);
    void updateCEPComponents(QMap<QString, bool> cepComponents);
    void updateCEPActions(QStringList cepActions);

    void setItkDependency(bool checked);

    QStringList getCEPLibrariesDependencies();
    QStringList getCEPComponentsDependencies();
    QStringList getCEPActionsDependencies();

    QStringList getCamiTKLibrariesDependencies();
    QStringList getCamiTKComponentsDependencies();
    QStringList getCamiTKActionsDependencies();

    QStringList getExternalLibsDependencies();


public slots:
    virtual void nextButtonClicked();
    virtual void cancelButtonClicked();
    virtual void previousButtonClicked();

signals:
    void next();
    void previous();
    void cancel();

private:
    Ui::DependenciesWidget ui;

    QVector<QCheckBox*> cepLibrariesCheckBox;
    QVector<QCheckBox*> cepComponentsCheckBox;
    QVector<QCheckBox*> cepActionsCheckBox;

};
#endif
