/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: Pine.pmod,v 1.10 2004/01/13 11:01:38 vida Exp $
 */

//! file: Pine.pmod
//!   Pine Address book handler for Camas
//! cvs_version: $Id: Pine.pmod,v 1.10 2004/01/13 11:01:38 vida Exp $

//! method: string imp(string abook)
//!  Return the address book from pine's format handler
//! returns:
//!  String with : "name:address\nname:addres".
string imp(string abook)
{
  string ab = "";
  array (string) words = ({ "", "", "" });
  int i = 0;
  while(sscanf(abook,"(%s)%s",words[i],abook) ||
        sscanf(abook, "%[^\t\n]%*c%s", words[i], abook) > 1) {
    i++;
    if (sizeof(abook) && abook[0] == '\n')
      abook = abook[1..];
    if (i > 2) {
      i = 0;
      words[2] = replace(words[2], "\n", "");
      array names = Array.map (ab / "\n", lambda (string s){ return ((s / ":")[0]);});
      string name = words[0];
      int no = 0;
      while (has_value (names, name + (no ? " - " + (string)no : "")))
        no++;
      if (no)
        name += (" - " + (string)no);
      if (sizeof (ab))
        ab += "\n" + name + ":" + words[2];
      else
        ab = name + ":" + words[2];
    }
  }
  return (ab);
}

/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

