/*
 * Caudium - An extensible World Wide Web server
 * Copyright  2000-2004 The Caudium Group
 * Based on IMHO  Stefan Wallstrm and Bosse Lincoln.
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License as
 * published by the Free Software Foundation; either version 2 of the
 * License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 * General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */
/*
 * $Id: screens.h,v 1.21 2004/01/13 11:01:37 vida Exp $
 */

#ifndef __SCREENS_H
#define __SCREENS_H

#include "language.h"

#define LOGINPROMPT -1 // not in camas tags, don't need to
#define LOGINFAILED -2 // not in camas tags, don't need to
#define LOGINFAILEDIMAP -3 // not in camas tags, don't need to

// Below's screen and their respective status in camas_tags

#define MAINMENU 3             // is that a screen?
#define LOGOUT 4               // 100%
#define SETUP 5                // 90%
#define COMPOSE 6              // 100%
#define MAILINDEX 7            // 100%
#define READMAIL 8             // 100% (minus X-Face and X-Image-URL)
#define FOLDERLIST 9           // 80%
#define FILES 10               // 100%
#define DIALOGBOX 11           // 100%
#define SPELLCHECK 12          // 100%
#define ATTACHMENTS 13         // 100%
#define ADDRESSBOOK 14         // 100%
#define EDITADDRESS 15         // 100%
#define IMPORTADDRESS 16       // 100%
#define IMPORTADDRESS2 17      // 100%
#define LDAPSEARCH 18          // 100%
#define LDAPRESULT 19          // 100%
#define ADMINMAIN 20           // 0%
#define SEARCHMAIL 21          // 100%
#define MAILFILTER 22          // 100% but called filterboook - see below
#define EDITADDRESSFILTER 23   // 100%
#define ADDRESSBOOK2 24        // 100%
#define LDAPRESULT2 25         // 100%
#define MDNDIALOG 26           // 100%
#define MAILPART 27            // 100%
#define NOTIFY 28	       // 100%

// this mapping is used to fetch layout files
// the first element of the array is the name of the screen
// the second element is only used by <imho_title />
constant screennames = ([
                          LOGINPROMPT : ({ "login", -1 }),
                          LOGINFAILED : ({ "login", -1 }),
                          LOGINFAILEDIMAP : ({ "login", -1 }),
                          LOGOUT : ({ "logout", M_LOGGEDOUT }),
                          SETUP : ({ "setup", M_PREFS }),
                          COMPOSE : ({ "compose", M_COMPOSEMAIL }),
                          MAILINDEX : ({ "mailindex", M_CURRMAILBOX }),
                          READMAIL : ({ "readmail", M_MAIL }),
                          FOLDERLIST : ({ "folderlist", M_MAILBOXES }),
                          FILES : ({ "files", M_FILES }),
                          DIALOGBOX : ({ "dialogbox", M_INFO }),
                          SPELLCHECK : ({ "spellcheck", M_SPELLCHECK }),
                          ATTACHMENTS : ({ "attachments", M_ATTACHMENTSHEADER }),
                          MAILFILTER : ({ "filterbook", M_FILTERBOOKTITLE }),
                          EDITADDRESSFILTER : ({ "editaddressfilter", M_FILTERBOOKTITLE }),
                          ADDRESSBOOK : ({ "addressbook", M_ADDRESSBOOKTITLE }),
                          ADDRESSBOOK2 : ({ "addressbooktoccbcc", M_ADDRESSBOOKTITLE }),
                          EDITADDRESS : ({ "editaddress", M_ADDRESSBOOKTITLE }),
                          IMPORTADDRESS : ({ "importaddress", M_ADDRESSBOOKTITLE }),
			  IMPORTADDRESS2 : ({ "importaddress2", M_ADDRESSBOOKTITLE }),
                          LDAPSEARCH : ({ "ldapsearch", M_LDAPTITLE}),
                          LDAPRESULT : ({ "ldapresult", M_LDAPTITLE}),
                          LDAPRESULT2 : ({ "ldapresulttoccbcc", M_LDAPTITLE}),
                          SEARCHMAIL : ({ "searchmail", M_SEARCHMAILTITLE}),
			  MAILPART : ({ "mailpart", "" }),
			  NOTIFY : ({ "notify", "" }),
			  MDNDIALOG: ({ "mdndialog", "" }),
                        ]);

#endif // __SCREENS_H
/*                                                                             
 * Local Variables:                                                            
 * c-basic-offset: 2                                                           
 * End:                                                                        
 *                                                                             
 * vim: softtabstop=2 tabstop=2 expandtab autoindent formatoptions=croqlt smartindent cindent shiftwidth=2
 */

