/*
 * Check for correct handling of a reentrant
 * signal handler
 */


#include <stdio.h>
#include <signal.h>

/* spurious comment only here to test cvs mail notifications. */

volatile int spin;

int in_sig_hdlr = 0;

void sig_hdlr ( int signo )
{
   printf ( "caught signal (in_sig_hdlr %d)\n",
	    in_sig_hdlr);

   if (in_sig_hdlr)
     spin = 0;
   else {
     in_sig_hdlr = 1;
     kill(0, SIGINT);
     in_sig_hdlr = 0;
   }
   
   printf ( "signal returns\n" );
}

int main ( void )
{
  struct sigaction sa;
  sa.sa_handler = sig_hdlr;
  sigemptyset(&(sa.sa_mask));
  sa.sa_flags = SA_NODEFER;
  
  spin = 1;
  printf ( "installing sig handler\n" );
  sigaction(SIGINT, &sa, 0);
  printf ( "entering busy wait\n" );
  while (spin) { };
  printf ( "exited\n" );
  return 0;
}
