
/*
 Copyright 2013, Kovid Goyal <kovid at kovidgoyal.net>
 Released under the GPLv3 License
*/


(function() {
  var FontStats, font_dict, font_usage, log;

  if (typeof window !== "undefined" && window !== null ? window.calibre_utils : void 0) {
    log = window.calibre_utils.log;
  }

  font_dict = function(style, computed) {
    var f, family, fams, _i, _len;
    if (computed == null) {
      computed = false;
    }
    if (computed) {
      fams = [];
      family = style.getPropertyCSSValue('font-family');
      if (family.cssValueType === CSSValue.CSS_PRIMITIVE_VALUE) {
        fams.push(family.getStringValue());
      } else {
        for (_i = 0, _len = family.length; _i < _len; _i++) {
          f = family[_i];
          fams.push(f.getStringValue());
        }
      }
    } else {
      fams = style.getPropertyValue('font-family');
    }
    return {
      'font-family': fams,
      'font-weight': style.getPropertyValue('font-weight'),
      'font-style': style.getPropertyValue('font-style'),
      'font-stretch': style.getPropertyValue('font-stretch')
    };
  };

  font_usage = function(node) {
    var ans, child, style, text, _i, _len, _ref;
    style = window.getComputedStyle(node, null);
    ans = font_dict(style, true);
    text = [];
    _ref = node.childNodes;
    for (_i = 0, _len = _ref.length; _i < _len; _i++) {
      child = _ref[_i];
      if (child.nodeType === Node.TEXT_NODE) {
        text.push(child.nodeValue);
      }
    }
    ans['text'] = text;
    return ans;
  };

  FontStats = (function() {

    FontStats.name = 'FontStats';

    function FontStats() {
      if (!this instanceof arguments.callee) {
        throw new Error('FontStats constructor called as function');
      }
    }

    FontStats.prototype.get_font_face_rules = function() {
      var fd, font_faces, rule, sheet, _i, _j, _len, _len1, _ref, _ref1;
      font_faces = [];
      _ref = document.styleSheets;
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        sheet = _ref[_i];
        _ref1 = sheet.cssRules;
        for (_j = 0, _len1 = _ref1.length; _j < _len1; _j++) {
          rule = _ref1[_j];
          if (rule.type === rule.FONT_FACE_RULE) {
            fd = font_dict(rule.style);
            fd['src'] = rule.style.getPropertyValue('src');
            font_faces.push(fd);
          }
        }
      }
      return py_bridge.value = font_faces;
    };

    FontStats.prototype.get_font_usage = function() {
      var ans, busage, node, usage, _i, _len, _ref;
      ans = [];
      busage = font_usage(document.body);
      if (busage !== null) {
        ans.push(busage);
      }
      _ref = document.body.getElementsByTagName('*');
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        node = _ref[_i];
        usage = font_usage(node);
        if (usage !== null) {
          ans.push(usage);
        }
      }
      return py_bridge.value = ans;
    };

    FontStats.prototype.get_font_families = function() {
      var ans, family, node, rule, rules, style, _i, _j, _len, _len1, _ref;
      ans = {};
      _ref = document.getElementsByTagName('*');
      for (_i = 0, _len = _ref.length; _i < _len; _i++) {
        node = _ref[_i];
        rules = document.defaultView.getMatchedCSSRules(node, '');
        if (rules) {
          for (_j = 0, _len1 = rules.length; _j < _len1; _j++) {
            rule = rules[_j];
            style = rule.style;
            family = style.getPropertyValue('font-family');
            if (family) {
              ans[family] = true;
            }
          }
        }
      }
      return py_bridge.value = ans;
    };

    return FontStats;

  })();

  if (typeof window !== "undefined" && window !== null) {
    window.font_stats = new FontStats();
  }

}).call(this);

