<?/*
+-------------------------------------------------------------------------+
| Copyright (C) 2002 Ian Berry                                            |
|                                                                         |
| This program is free software; you can redistribute it and/or           |
| modify it under the terms of the GNU General Public License             |
| as published by the Free Software Foundation; either version 2          |
| of the License, or (at your option) any later version.                  |
|                                                                         |
| This program is distributed in the hope that it will be useful,         |
| but WITHOUT ANY WARRANTY; without even the implied warranty of          |
| MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the           |
| GNU General Public License for more details.                            |
+-------------------------------------------------------------------------+
| cacti: the rrdtool frontend [php-auth, php-tree, php-form]              |
+-------------------------------------------------------------------------+
| This code is currently maintained and debugged by Ian Berry, any        |
| questions or comments regarding this code should be directed to:        |
| - iberry@raxnet.net                                                     |
+-------------------------------------------------------------------------+
| - raXnet - http://www.raxnet.net/                                       |
+-------------------------------------------------------------------------+
*/?>
<?

function rrdtool_execute($command_line, $log_command, $output_flag) {
	include ('include/config.php');
	include_once ('include/functions.php');
	
	if ($log_command == true) {
		LogData("CMD: " . $config["path_rrdtool"]["value"] . " $command_line");
	}
	
	if ($output_flag == "") { $output_flag = "1"; }
	
	/* WIN32: before sending this command off to rrdtool, get rid
	of all of the '\' characters. Unix does not care; win32 does. 
	Also make sure to replace all of the fancy \'s at the end of the line,
	but make sure not to get rid of the "\n"'s that are supposed to be
	in there (text format) */
	$command_line = str_replace("\\\n", " ", $command_line);
	
	/* if we want to see the error output from rrdtool; make sure to specify this */
	if ($output_flag == "2") {
		$command_line .= " 2>&1";
	}
	
	/* use popen to eliminate the zombie issue */
	if ($cacti_server_os == "unix") {
		$fp = popen($config["path_rrdtool"]["value"] . " $command_line", "r");
	}elseif ($cacti_server_os == "win32") {
		$fp = popen($config["path_rrdtool"]["value"] . " $command_line", "rb");
	}
	
	/* Return Flag:
	0: Null
	1: Pass output back
	2: Pass error output back */
	
	switch ($output_flag) {
		case '0':
			return; break;
		case '1':
			return fpassthru($fp); break;
		case '2':
			$output = fgets($fp, 1000000);
			
			if (substr($output, 0, 4) == "PNG") {
				return "OK";
			}
			
			if (substr($output, 0, 5) == "GIF87") {
				return "OK";
			}
			
			print $output;
			break;
	}
}

function rrdtool_function_create($dsid, $show_source) {
	include ('include/config.php');
	include_once ('include/functions.php');
	include ("include/database.php");
	
	$data_source_path = GetDataSourcePath($dsid, true);
	
	/* ok, if that passes lets check to make sure an rra does not already
	exist, the last thing we want to do is overright data! */
	if ($show_source != true) {
		if (file_exists($data_source_path) == true) {
			return -1;
		}
	}
	
	/* the first thing we must do is make sure there is at least one
	rra associated with this data source... 
	
	UPDATE: As of version 0.6.6, we are splitting this up into two
	SQL strings because of the multiple DS per RRD support. This is 
	not a big deal however since this function gets called once per
	data source */
	
	$sql_id = mysql_query("select 
		d.step, 
		r.*,
		c.name as cname,
		(r.rows*r.steps) as rs 
		from rrd_ds d left join lnk_ds_rra l on l.dsid=d.id
		left join rrd_rra r on l.rraid=r.id
		left join lnk_rra_cf rc on rc.rraid=r.id
		left join def_cf c on rc.consolidationfunctionid=c.id
		where d.id=$dsid
		order by rc.consolidationfunctionid, rs",$cnn_id);
	
	/* if we find that this DS has no RRA associated; get out */
	if (mysql_num_rows($sql_id) == 0) {
		LogData("There are no RRA's assigned to DSID $dsid!");
		return -1;
	}
	
	/* create the "--step" line */
	$create_ds .= " \\\n--step " . mysql_result($sql_id, 0, "step") . " \\\n";
	
	/* query the data sources to be used in this .rrd file */
	$sql_id_ds = mysql_query("select 
		d.id, d.heartbeat, d.minvalue, d.maxvalue,d.subdsid,
		t.name
		from rrd_ds d left join def_ds t on d.datasourcetypeid=t.id
		where d.id=$dsid
		or d.subdsid=$dsid
		order by d.id",$cnn_id);
	$rows = mysql_num_rows($sql_id_ds);
	
	/* ONLY make a new DS entry if:
	   - There is multiple data sources and this item is not the main one.
	   - There is only one data source (then use it) */
	
	while ($i < $rows) {
		if ((($rows > 1) && (mysql_result($sql_id_ds, $i, "subdsid") != 0)) || ($rows == 1)) {
			/* use the cacti ds name by default or the user defined one, if entered */
			$data_source_name = GetDataSourceName(mysql_result($sql_id_ds, $i, "id"));
			
			$create_ds .= "DS:$data_source_name:" . 
				mysql_result($sql_id_ds, $i, "name") . ":" . 
				mysql_result($sql_id_ds, $i, "heartbeat") . ":" . 
				mysql_result($sql_id_ds, $i, "minvalue") . ":" . 
				mysql_result($sql_id_ds, $i, "maxvalue") . " \\\n";
		}
		
		$i++;
	}
	
	/* loop through each available RRA for this DS */
	$rows = mysql_num_rows($sql_id); $i = 0;
	
	while ($i < $rows) {
		$create_rra .= "RRA:" . mysql_result($sql_id, $i, "cname") . ":" . 
		mysql_result($sql_id, $i, "xfilesfactor") . ":" . 
		mysql_result($sql_id, $i, "steps") . ":" . 
		mysql_result($sql_id, $i, "rows") . " \\\n";
		
		$i++;
	}
	
	if ($show_source == true) {
		return $config["path_rrdtool"]["value"] . " create \\\n$data_source_path$create_ds$create_rra";
	}else{
		if ($config["log_create"]["value"] == "on") { $log_data = true; }
		rrdtool_execute("create $data_source_path $create_ds$create_rra",$log_data,1);
	}
}

function rrdtool_function_update($dsid, $multi_data_source, $show_source) {
	include ('include/config.php');
	include_once ('include/functions.php');
	include ("include/database.php");
	
	$data_source_path = GetDataSourcePath($dsid, true);
	
	if ($multi_data_source == "") {
		/* find out if this DS has multiple outputs */
		$sql_id_multi = mysql_query("select id from rrd_ds where subdsid=$dsid", $cnn_id);
		
		if (mysql_num_rows($sql_id_multi) == 0) {
			$multi_data_source = false;
		}else{
			$multi_data_source = true;
		}
	}
	
	if ($multi_data_source == true) {
		/* multi DS: This string joins on the rrd_ds->src_fields to get the 
		field names */
		$sql_id = mysql_query("select 
			d.dsname,
			a.value
			from rrd_ds d left join src_fields f on d.subfieldid=f.id 
			left join src_data a on d.id=a.dsid
			where d.subdsid=$dsid
			and f.inputoutput=\"out\"
			and f.updaterra=\"on\"
			order by d.id",$cnn_id);
	}else{
		/* single DS: This string joins on the src_data->src_fields table to get 
		the field name */
		$sql_id = mysql_query("select 
			d.dsname,
			a.value
			from rrd_ds d left join src_data a on d.id=a.dsid
			left join src_fields f on a.fieldid=f.id 
			where d.id=$dsid
			and f.inputoutput=\"out\"
			and f.updaterra=\"on\"
			order by d.id",$cnn_id);
	}
	
	/* setup the counter */
	$rows = mysql_num_rows($sql_id); $i = 0;
	
	/* set initial values for strings to be used in the loop */
	$update_string = "N";
	$template_string = "--template ";
	
	/* loop through each item in this data source and build the UPDATE string */
	while ($i < $rows) {
		if (trim(mysql_result($sql_id, $i, "value")) == "") {
			$data_value = "U"; /* rrdtool: unknown */
		}else{
			$data_value = mysql_result($sql_id, $i, "value");
		}
		
		$update_string .= ":$data_value";
		$template_string .= mysql_result($sql_id, $i, "dsname");
		
		$i++;
		
		/* do NOT put a colon after the last template item */
		if ($i < $rows) { $template_string .= ":"; }
	}
	
	$update_string = "update $data_source_path $template_string $update_string";
	
	if ($show_source == true) {
		return $config["path_rrdtool"]["value"] . " $update_string";
	}else{
		if ($config["log_update"]["value"] == "on") { $log_data = true; }
		rrdtool_execute($update_string,true,1);
	}
}

function rrdtool_function_tune($rrd_tune_array) {
	include ('include/config.php');
	include_once ('include/functions.php');
	
	$data_source_name = GetDataSourceName($rrd_tune_array["data_source_id"]);
	$data_source_type = GetDataSourceType($rrd_tune_array["data-source-type"]);
	$data_source_path = GetDataSourcePath($rrd_tune_array["data_source_id"], true);
	
	if ($rrd_tune_array["heartbeat"] != "") {
		$rrd_tune .= " --heartbeat $data_source_name:" . $rrd_tune_array["heartbeat"];
	}
	
	if ($rrd_tune_array["minimum"] != "") {
		$rrd_tune .= " --minimum $data_source_name:" . $rrd_tune_array["minimum"];
	}
	
	if ($rrd_tune_array["maximum"] != "") {
		$rrd_tune .= " --maximum $data_source_name:" . $rrd_tune_array["maximum"];
	}
	
	if ($rrd_tune_array["data-source-type"] != "") {
		$rrd_tune .= " --data-source-type $data_source_name:" . $data_source_type;
	}
	
	if ($rrd_tune_array["data-source-rename"] != "") {
		$rrd_tune .= " --data-source-rename $data_source_name:" . $rrd_tune_array["data-source-rename"];
	}
	
	if ($rrd_tune != "") {
		if (file_exists($data_source_path) == true) {
			$fp = popen($config["path_rrdtool"]["value"] . " tune $data_source_path $rrd_tune", "r");
			pclose($fp);
			
			LogData("CMD: " . $config["path_rrdtool"]["value"] . " tune $data_source_path $rrd_tune");
		}
	}
}

function rrdtool_function_graph($graphid, $rra, $graph_data_array) {
	include ('include/config.php');
	include_once ('include/functions.php');
	include ("include/database.php");
	
	/* before we do anything; make sure the user has permission to view this graph,
	if not then get out */
	if ($config["global_auth"]["value"] == "on") {
		global $HTTP_COOKIE_VARS;
		
		$sql_id = mysql_query("select userid from auth_graph where graphid=$graphid and userid=" . GetCurrentUserID($HTTP_COOKIE_VARS["cactilogin"],$config["guest_user"]["value"]),$cnn_id);
		
		if ($config["graph_policy"]["auth"] == "1") {
			if (mysql_num_rows($sql_id) > 0) { $access_denied = true; }
		}elseif ($config["graph_policy"]["auth"] == "2") {
			if (mysql_num_rows($sql_id) == 0) { $access_denied = true; }
		}
		
		if ($access_denied == true) {
			return "GRAPH ACCESS DENIED";
		}
	}
	
	$sql_id = mysql_query("select g.*, i.name from rrd_graph g left join def_image_type i 
		on g.imageformatid=i.id where g.id=$graphid",$cnn_id);
	
	/* define the time span, which decides which rra to use */
	$sql_id_rra = mysql_query("select rows,steps from rrd_rra where id=$rra",$cnn_id);
	$timespan = -(mysql_result($sql_id_rra, 0, "rows") * mysql_result($sql_id_rra, 0, "steps") * 144);
	
	/* this is so we do not show the data for MIN/MAX data on daily graphs (steps <= 1),
	this code is a little hacked at the moment as GPRINT's are not covered. some changes will have
	to be made for this to be included also */
	if (mysql_result($sql_id_rra, 0, "steps") > 1) {
		$sql_order_by = "";
	}else{
		$sql_order_by = "and !(cf.id != 1 and (t.name=\"LINE1\" or t.name=\"AREA\" or t.name=\"STACK\"
			or t.name=\"LINE2\" or t.name=\"LINE3\"))";
	}
	
	/* lets make that sql query... */
	$sql_id_item = mysql_query("select 
		i.id as iid, i.cdefid, i.textformat, i.value, i.hardreturn, i.consolidationfunction, i.parent,
		c.hex, 
		d.dsname, d.name as dname, d.id,
		cf.name as cname, t.name as tname 
		from rrd_graph_item i 
		left join rrd_ds d 
		on i.dsid=d.id 
		left join def_colors c 
		on i.colorid=c.id 
		left join def_graph_type t 
		on i.graphtypeid=t.id 
		left join def_cf cf 
		on i.consolidationfunction=cf.id 
		where i.graphid=$graphid 
		$sql_order_by
		order by i.sequenceparent,i.sequence",$cnn_id);
	$rows = mysql_num_rows($sql_id_item);
	
	/* +-------------------------------------------------------------------+
	   |                           GRAPH OPTIONS                           |
	   +-------------------------------------------------------------------+ */
	
	if (mysql_result($sql_id, 0, "autoscale") == "on") {
		switch (mysql_result($sql_id, 0, "autoscaleopts")) {
			case "1":
				$scale = "--alt-autoscale" . " \\\n";
				break;
			case "2":
				$scale = "--alt-autoscale-max" . " \\\n";
				break;
		}
	}else{
		$scale = "--upper-limit=" . mysql_result($sql_id, 0, "upperlimit") . " \\\n" .
			"--lower-limit=" . mysql_result($sql_id, 0, "lowerlimit") . " \\\n";
	}
	
	if (mysql_result($sql_id, 0, "rigid") == "on") {
		$rigid = "--rigid" . " \\\n";
	}
	
	/* optionally you can specify and array that overrides some of the db's
	values, lets set that all up here */
	if ($graph_data_array["use"] == true) {
		if ($graph_data_array["graph_start"] == "0") {
			$graph_start = $timespan;
		}else{
			$graph_start = $graph_data_array["graph_start"];
		}
		
		$graph_height = $graph_data_array["graph_height"];
		$graph_width = $graph_data_array["graph_width"];
	}else{
		$graph_start = $timespan;
		$graph_height = mysql_result($sql_id, 0, "height");
		$graph_width = mysql_result($sql_id, 0, "width");
	}
	
	if ($graph_data_array["graph_nolegend"] == true) {
		$graph_legend = "--no-legend" . " \\\n";
	}else{
		$graph_legend = "";
	}
	
	/* export options */
	if ($graph_data_array["export"] == true) {
		$graph_opts = $config["path_html_export"]["value"] . "/" . $graph_data_array["export_filename"] . " \\\n";
	}else{
		if ($graph_data_array["output_filename"] == "") {
			$graph_opts = "- \\\n";
		}else{
			$graph_opts = $graph_data_array["output_filename"] . " \\\n";
		}
	}
	
	/* basic graph options */
	$graph_opts .= "--imgformat=" . mysql_result($sql_id, 0, "name") . " \\\n" .
		"--start=\"$graph_start\"" . " \\\n" .
		"--title=\"" . mysql_result($sql_id, 0, "title") . "\"" . " \\\n" .
		"$rigid" .
		"--base=" . mysql_result($sql_id, 0, "basevalue") . " \\\n" .
		"--height=$graph_height \\\n" .
		"--width=$graph_width \\\n" .
		"$scale" .
		"$graph_legend" .
		"--vertical-label=\"" . mysql_result($sql_id, 0, "verticallabel") . "\"" . " \\\n";
	
	/* a note about different CF's on a graph. for now we are only going to display MAX/MIN CF
	data when viewing anything greater than daily graphs. From what I know, rrdtool does not
	store AVERAGE MAX/MIN data for any RRA with less than 1 step */
	if (mysql_result($sql_id_rra, 0, "steps") > 1) {
		$sql_group_by = "group by d.id,i.consolidationfunction";
	}else{
		$sql_group_by = "and c.name=\"AVERAGE\" group by d.id";
	}
	
	/* +-------------------------------------------------------------------+
	   |                           GRAPH DEFS                              |
	   +-------------------------------------------------------------------+ */
	
	/* define the datasources used; only once */
	$sql_id_defs = mysql_query("select 
		i.id as iid, i.cdefid, i.consolidationfunction,
		d.id, d.name, d.dsname, d.dspath,
		c.name as cname
		from rrd_graph_item i 
		left join rrd_ds d 
		on i.dsid=d.id 
		left join def_cf c 
		on i.consolidationfunction=c.id
		left join def_graph_type t 
		on i.graphtypeid=t.id
		where i.graphid=$graphid 
		and (t.name=\"AREA\" or t.name=\"STACK\" 
		or t.name=\"LINE1\" or t.name=\"LINE2\" 
		or t.name=\"LINE3\") 
		and d.dsname is not null
		$sql_group_by",$cnn_id);
	$rows_defs = mysql_num_rows($sql_id_defs);
	
	$i = 0;
	while ($i < $rows_defs) {
		if (mysql_result($sql_id_defs, $i, "dsname") == "") {
			$dsname = CheckDataSourceName(mysql_result($sql_id_defs, $i, "name"));
		}else{
			$dsname = mysql_result($sql_id_defs, $i, "dsname");
		}
		
		/* use a user-specified ds path if one is entered */
		$dspath = GetDataSourcePath(mysql_result($sql_id_defs, $i, "id"), true);
		
		/* FOR WIN32: Ecsape all colon for drive letters (ex. D\:/path/to/rra) */
		$dspath = str_replace(":", "\:", $dspath);
		
		/* NOTE: (Update) Data source DEF names are created using the graph_item_id; then passed
		to a function that matches the digits with letters. rrdtool likes letters instead
		of numbers in DEF names; especially with CDEF's. cdef's are created
		the same way, except a 'cdef' is put on the beginning of the hash */
		
		if ($dsname != "") {
			$graph_defs .= "DEF:" . CreateGraphDefName(("$i")) . "=\"$dspath\":$dsname:" . mysql_result($sql_id_defs, $i, "cname") . " \\\n";
		}
		
		$cf_ds_cache[mysql_result($sql_id_defs, $i, "id")][mysql_result($sql_id_defs, $i, "consolidationfunction")] = "$i";
		$graph_group_cache[mysql_result($sql_id_defs, $i, "iid")] = "$i";
		
		$i++;
	}
	
	/* if we are not displaying a legend there is no point in us even processing the auto padding,
	text format stuff. */
	if ($graph_data_array["graph_nolegend"] != true) {
		/* use this loop to to setup all textformat data (hr, padding, subsitution, etc) */
		$i = 0; $greatest_text_format = 0;
		while ($i < $rows) {
			/* +-------------------------------------------------------------------+
			   |                   LEGEND: TEXT SUBSITUTION (<>'s)                 |
	  		   +-------------------------------------------------------------------+ */
			   
			/* format the textformat string, and add values where there are <>'s */
			$text_format[$i] = mysql_result($sql_id_item, $i, "textformat");
			$value_format[$i] = mysql_result($sql_id_item, $i, "value");
			
			/* set hard return variable if selected (\n) */
			if (mysql_result($sql_id_item, $i, "hardreturn") == "on") { 
				$hardreturn[$i] = "\\n"; 
			}else{
				$hardreturn[$i] = "";
			}
			
			if (mysql_result($sql_id_item, $i, "id") != "") {
				$sql_id_field = mysql_query("select d.fieldid, d.dsid, d.value, 
					f.srcid, f.dataname
					from src_data d
					left join src_fields f
					on d.fieldid=f.id
					where d.dsid=" . mysql_result($sql_id_item, $i, "id"),$cnn_id);
				$rows_field = mysql_num_rows($sql_id_field); $i_field = 0;
				
				while ($i_field < $rows_field) {
					$text_format[$i] = ereg_replace ("<" . mysql_result($sql_id_field, $i_field, "dataname") . ">", mysql_result($sql_id_field, $i_field, "value"),$text_format[$i]);
					$value_format[$i] = ereg_replace ("<" . mysql_result($sql_id_field, $i_field, "dataname") . ">", mysql_result($sql_id_field, $i_field, "value"),$value_format[$i]);
					
					$i_field++;
				}
			}
			
			/* +-------------------------------------------------------------------+
			   |                       LEGEND: AUTO PADDING                        |
	  		   +-------------------------------------------------------------------+ */
			
			/* PADDING: remember this is not perfect! its main use is for the basic graph setup of:
			AREA - GPRINT-CURRENT - GPRINT-AVERAGE - GPRINT-MAXIMUM \n
			of course it can be used in other situations, however may not work as intended.
			If you have any additions to this small peice of code, feel free to send them to me. */
			if (mysql_result($sql_id, 0, "autopadding") == "on") {
				$item_dsid = mysql_result($sql_id_item, $i, "id");
				
				/* only applies to AREA and STACK */
				if ((mysql_result($sql_id_item, $i, "tname") == "AREA") || (mysql_result($sql_id_item, $i, "tname") == "STACK") || (mysql_result($sql_id_item, $i, "tname") == "LINE1") || (mysql_result($sql_id_item, $i, "tname") == "LINE2") || (mysql_result($sql_id_item, $i, "tname") == "LINE3")) {
					$text_format_lengths[$item_dsid] = strlen($text_format[$i]);
					
					if (strlen($text_format[$i]) > $greatest_text_format) {
						if (mysql_result($sql_id_item, $i, "tname") != "COMMENT") {
							$greatest_text_format = strlen($text_format[$i]);
						}
					}
				}
			}
			
			$i++;
		}
	}
	
	/* draw the actual items on the graph */
	
	/* +-------------------------------------------------------------------+
	   |                   GRAPH ITEMS: CDEF's                             |
 	   +-------------------------------------------------------------------+ */
	
	$i = 0;
	while ($i < $rows) {
		/* ------ CDEF ------ */
		/* make cdef string here; a note about CDEF's in cacti. A CDEF is neither unique to a 
		data source of global cdef, but is unique when those two variables combine. */
		$cdef_graph_defs = "";
		if ((mysql_result($sql_id_item, $i, "cdefid") != "0") && (isset($cdef_cache[mysql_result($sql_id_item, $i, "cdefid")][mysql_result($sql_id_item, $i, "id")]) == false)) {
			
			/* pull out what kind of cdef type this is */
			$sql_id_cdef = mysql_query("select type from rrd_ds_cdef where id=" . mysql_result($sql_id_item, $i, "cdefid"), $cnn_id);
			
			/* get all of the items for this cdef */
			$sql_id_cdef_items = mysql_query("select case
				when ci.type=\"CDEF Function\" then cf.name
				when ci.type=\"Data Source\" then ds.name
				when ci.type=\"Custom Entry\" then ci.custom
				end 'cdef',
				ci.type,ci.dsid,ci.currentds
				from rrd_ds_cdef_item ci left join def_cdef cf on cf.id=ci.cdeffunctionid left 
				join rrd_ds ds on ds.id=ci.dsid
				where ci.cdefid=" . mysql_result($sql_id_item, $i, "cdefid") . 
				" order by ci.sequence",$cnn_id);
			$rows_cdef = mysql_num_rows($sql_id_cdef_items); $i_cdef = 0;
			
			/* CF rules: if we are using a CF because it's defined in the AREA, STACK, LINE[1-3] then
			it is ok to use it elsewhere on the graph. But it is not ok to use a CF DEF because
			its used in a GPRINT; so check that here */
			if (isset($cf_ds_cache[mysql_result($sql_id_item, $i, "id")][mysql_result($sql_id_item, $i, "consolidationfunction")]) == true) {
				$cf_id = mysql_result($sql_id_item, $i, "consolidationfunction");
			}else{
				$cf_id = 1; /* CF: AVERAGE */
			}
			
			/* make the initial "virtual" cdef name: 'cdef' + md5(dsid) */
			$cdef_graph_defs .= "CDEF:cdef" . CreateGraphDefName("$i") . "=";
			
			/* form the cdef string by looping through each item. Additionally MD5 hash each
			data source that we come across so this works right */
			switch (mysql_result($sql_id_cdef, $i_cdef, "type")) {
				case "1": /* normal */
					while ($i_cdef < $rows_cdef) {
						if (mysql_result($sql_id_cdef_items, $i_cdef, "type") == "Data Source") {
							if (mysql_result($sql_id_cdef_items, $i_cdef, "currentds") == "on") {
								$cdef_current_item = CreateGraphDefName($cf_ds_cache[mysql_result($sql_id_item, $i, "id")][$cf_id]);
							}else{
								$cdef_current_item = CreateGraphDefName($cf_ds_cache[mysql_result($sql_id_cdef_items, $i_cdef, "dsid")][$cf_id]);
							}
						}else{
							$cdef_current_item = mysql_result($sql_id_cdef_items, $i_cdef, "cdef");
						}
						
						if ($i_cdef == 0) { $delimeter = ""; }else{ $delimeter = ","; }
						$cdef_graph_defs .= "$delimeter$cdef_current_item";
						
						$i_cdef++;
					}
					break;
				case "2": /* total */
					/* for this special case, we are going to loop through all of the DEF's on this
					graph, and make a cdef string total each of these items */
					$first = true; $o = 0; /* "o" is used to count how many items this cdef has,
					"$i_cdef" will not work because we may skip some items */
					
					/* only add "real" graph items: AREA, STACK, LINE[1-3] */
					while ($i_cdef < $rows_defs) {
						if (mysql_result($sql_id_defs, $i_cdef, "id") != "") {
							$cdef_current_item = CreateGraphDefName($cf_ds_cache[mysql_result($sql_id_defs, $i_cdef, "id")][$cf_id]);
							
							if ($first == true) { $delimeter = ""; }else{ $delimeter = ","; }
							$cdef_graph_defs .= "$delimeter$cdef_current_item";
							$first = false; $o++;
						}
						
						$i_cdef++;
					}
					
					/* create the ending ",+"'s ($o-1) times */
					$cdef_graph_defs .= str_pad("", strlen(",+")*($o-1), ",+");
					
					break;
				case "3": /* total staggered data sources */
					/* for this special case, we are going to loop through all of the DEF's on this
					graph, and make a cdef string total for the odd numbered items */
					$first = true; $o = 0; /* "o" is used to count how many items this cdef has,
					"$i_cdef" will not work because we may skip some items */
					
					/* parse the value string: start=<position>&skip=<count> */
					parse_str(mysql_result($sql_id_item, $i, "value"));
					
					/* only add "real" graph items: AREA, STACK, LINE[1-3] */
					$skipcount = 0; $begin = 0; $i_cdef = 0;
					while ($i_cdef < $rows_defs) {
						if (mysql_result($sql_id_defs, $i_cdef, "id") != "") {
							$begin++;
							$skipcount++;
							if (($begin == $start) || ($begin > $start && $skipcount == $skip)) {
								$cdef_current_item = CreateGraphDefName($cf_ds_cache[mysql_result($sql_id_defs, $i_cdef, "id")][$cf_id]);
								
								if ($first == true) { $delimeter = ""; }else{ $delimeter = ","; }
								
								$cdef_graph_defs .= "$delimeter$cdef_current_item";
								$first = false; $o++; $skipcount = 0;
							}
						}
						
						$i_cdef++;
					}
					
					/* create the ending ",+"'s ($o-1) times */
					$cdef_graph_defs .= str_pad("", strlen(",+")*($o-1), ",+");
					
					break;
				case "4": /* average all data sources */
					/* for this special case, we are going to loop through all of the DEF's on this
					graph, and make a cdef string average of these items.*/
					$first = true; $o = 0; /* "o" is used to count how many items this cdef has,
					"$i_cdef" will not work because we may skip some items */
					
					/* only add "real" graph items: AREA, STACK, LINE[1-3] */
					$i_cdef = 0;
					while ($i_cdef < $rows_defs) {
						if (mysql_result($sql_id_defs, $i_cdef, "id") != "") {
							$cdef_current_item = CreateGraphDefName($cf_ds_cache[mysql_result($sql_id_defs, $i_cdef, "id")][$cf_id]);
							
							if ($first == true) {
								$delimeter = "";
							}else{
								$delimeter = ",";
							}
							
							$cdef_graph_defs .= "$delimeter$cdef_current_item";
							$first = false; $o++;
						}
						
						$i_cdef++;
					}
					
					/* create the ending ",+"'s ($o-1) times */
					$cdef_graph_defs .= str_pad("", strlen(",+")*($o-1), ",+");
					$cdef_graph_defs .= "," . $o . ",/";
					
					break;
				case "5": /* average staggered data sources */
					/* for this special case, we are going to loop through all of the DEF's on this
					graph, and make a cdef string average for the staggered data sources */
					$first = true; $o = 0; /* "o" is used to count how many items this cdef has,
					"$i_cdef" will not work because we may skip some items */
					
					/* parse the value string: start=<position>&skip=<count> */
					parse_str(mysql_result($sql_id_item, $i, "value"));
					
					/* only add "real" graph items: AREA, STACK, LINE[1-3] */
					$skipcount = 0; $begin = 0; $i_cdef = 0;
					while ($i_cdef < $rows_defs) {
						if (mysql_result($sql_id_defs, $i_cdef, "id") != "") {
							$begin++; $skipcount++;
							if (($begin == $start) || ($begin > $start && $skipcount == $skip)) {
								$cdef_current_item = CreateGraphDefName($cf_ds_cache[mysql_result($sql_id_defs, $i_cdef, "id")][$cf_id]);
								
								if ($first == true) { $delimeter = ""; }else{ $delimeter = ","; }
								$cdef_graph_defs .= "$delimeter$cdef_current_item";
								$first = false; $o++; $skipcount = 0;
							}
						}
						
						$i_cdef++;
					}
					
					/* create the ending ",+"'s ($o-1) times */
					$cdef_graph_defs .= str_pad("", strlen(",+")*($o-1), ",+");
					$cdef_graph_defs .= "," . $o . ",/";
					
					break;
			}
			
			$cdef_graph_defs .= " \\\n";
			
			/* the CDEF cache is so we do not create duplicate CDEF's on a graph */
			$cdef_cache[mysql_result($sql_id_item, $i, "cdefid")][mysql_result($sql_id_item, $i, "id")] = "$i";
		}
		
		/* add the cdef string to the end of the def string */
		$graph_defs .= $cdef_graph_defs;
		
		/* if we are not displaying a legend there is no point in us even processing the auto padding,
		text format stuff. */
		if ($graph_data_array["graph_nolegend"] != true) {
			if (mysql_result($sql_id, 0, "autopadding") == "on") {
				$item_dsid = mysql_result($sql_id_item, $i, "id");
				
				/* we are basing how much to pad on area and stack text format, 
				not gprint. but of course the padding has to be displayed in gprint,
				how fun! */
				
				$pad_number = ($greatest_text_format - $text_format_lengths[$item_dsid]);
				//LogData("MAX: $greatest_text_format, CURR: $text_format_lengths[$item_dsid], DSID: $item_dsid");
				$text_padding = str_pad("", $pad_number);
				
				/* two GPRINT's in a row screws up the padding, lets not do that */
				if ((mysql_result($sql_id_item, $i, "tname") == "GPRINT") && ($last_graph_type == "GPRINT")) {
					$text_padding = "";
				}
				
				$last_graph_type = mysql_result($sql_id_item, $i, "tname");
			}
		}
		
		/* we put this in a variable so it can be manipulated before mainly used
		if we want to skip it, like below */
		$current_graph_item_type = mysql_result($sql_id_item, $i, "tname");
		
		/* CF rules: if we are using a CF because it's defined in the AREA, STACK, LINE[1-3] then
		it is ok to use it elsewhere on the graph. But it is not ok to use a CF DEF because
		its used in a GPRINT; so check that here */
		if ((isset($cf_ds_cache[mysql_result($sql_id_item, $i, "id")][mysql_result($sql_id_item, $i, "consolidationfunction")])) && (mysql_result($sql_id_item, $i, "tname") != "GPRINT")) {
			$cf_id = mysql_result($sql_id_item, $i, "consolidationfunction");
		}else{
			$cf_id = 1; /* CF: AVERAGE */
		}
		
		/* make sure grouping is on, before we make decisions based on the group */
		if (mysql_result($sql_id, 0, "grouping") == "on") {
			/* if this item belongs to a graph group that has a parent that does not exist, do
			not show the child item. this happens with MAX/MIN items on daily graphs mostly. */
			if ((isset($graph_group_cache[mysql_result($sql_id_item, $i, "parent")]) == false) && (mysql_result($sql_id_item, $i, "tname") == "GPRINT")) {
				$current_graph_item_type = "SKIP";
			}
		}
		
		/* use cdef if one if specified */
		if (mysql_result($sql_id_item, $i, "cdefid") == "0") {
			$data_source_name = CreateGraphDefName($cf_ds_cache[mysql_result($sql_id_item, $i, "id")][$cf_id]);
		}else{
			$data_source_name = "cdef" . CreateGraphDefName($cdef_cache[mysql_result($sql_id_item, $i, "cdefid")][mysql_result($sql_id_item, $i, "id")]);
		}
		
		/* +-------------------------------------------------------------------+
		   |                           GRAPH ITEMS                             |
  		   +-------------------------------------------------------------------+ */
		
		/* this switch statement is basically used to grab all of the graph data above and
		print it out in an rrdtool-friendly fashion, not too much calculation done here. */
		switch ($current_graph_item_type) {
			case 'AREA':
				$text_format[$i] = ereg_replace (":", "\:" ,$text_format[$i]); /* escape colons */
				$graph_items .= mysql_result($sql_id_item, $i, "tname") . ":" . 
					$data_source_name . "#" . 
					mysql_result($sql_id_item, $i, "hex") . ":" . 
					"\"$text_format[$i]$hardreturn[$i]\" ";
				break;
			case 'STACK':
				$text_format[$i] = ereg_replace (":", "\:" ,$text_format[$i]); /* escape colons */
				$graph_items .= mysql_result($sql_id_item, $i, "tname") . ":" . 
					$data_source_name . "#" . 
					mysql_result($sql_id_item, $i, "hex") . ":" .
					"\"$text_format[$i]$hardreturn[$i]\" ";
				break;
			case 'LINE1':
				$text_format[$i] = ereg_replace (":", "\:" ,$text_format[$i]); /* escape colons */
				$graph_items .= mysql_result($sql_id_item, $i, "tname") . ":" . 
					$data_source_name . "#" . 
					mysql_result($sql_id_item, $i, "hex") . ":" . 
					"\"$text_format[$i]$hardreturn[$i]\" ";
				break;
			case 'LINE2':
				$text_format[$i] = ereg_replace (":", "\:" ,$text_format[$i]); /* escape colons */
				$graph_items .= mysql_result($sql_id_item, $i, "tname") . ":" . 
					$data_source_name . "#" . 
					mysql_result($sql_id_item, $i, "hex") . ":" . 
					"\"$text_format[$i]$hardreturn[$i]\" ";
				break;
			case 'LINE3':
				$text_format[$i] = ereg_replace (":", "\:" ,$text_format[$i]); /* escape colons */
				$graph_items .= mysql_result($sql_id_item, $i, "tname") . ":" . 
					$data_source_name . "#" . 
					mysql_result($sql_id_item, $i, "hex") . ":" . 
					"\"$text_format[$i]$hardreturn[$i]\" ";
				break;
			case 'COMMENT':
				$graph_items .= mysql_result($sql_id_item, $i, "tname") . ":\"" .
					"$text_format[$i]$hardreturn[$i]\" ";
				break;
			case 'GPRINT':
				if ($graph_data_array["graph_nolegend"] != true) {
					$gprint_text = "%8.2lf %s";
				}
				
				$text_format[$i] = ereg_replace (":", "\:" ,$text_format[$i]); /* escape colons */
				$graph_items .= mysql_result($sql_id_item, $i, "tname") . ":" .
					$data_source_name . ":" . mysql_result($sql_id_item, $i, "cname") .
					":\"$text_padding$text_format[$i]$gprint_text$hardreturn[$i]\" ";
				break;
			case 'HRULE':
				$text_format[$i] = ereg_replace (":", "\:" ,$text_format[$i]); /* escape colons */
				
				if ($graph_data_array["graph_nolegend"] == true) {
					$value_format[$i] = "0";
				}else{
					$value_format[$i] = ereg_replace (":", "\:" ,$value_format[$i]); /* escape colons */
				}
				
				$graph_items .= mysql_result($sql_id_item, $i, "tname") . ":" .
					$value_format[$i] . "#" . mysql_result($sql_id_item, $i, "hex") . ":\"" . 
					"$text_format[$i]$hardreturn[$i]\" ";
				break;
			case 'VRULE':
				$text_format[$i] = ereg_replace (":", "\:" ,$text_format[$i]); /* escape colons */
				
				$value_array = explode(":", mysql_result($sql_id_item, $i, "value"));
				$value = date("U", mktime($value_array[0],$value_array[1],0));
				
				$graph_items .= mysql_result($sql_id_item, $i, "tname") . ":" .
					$value . "#" . mysql_result($sql_id_item, $i, "hex") . ":\"" . 
					"$text_format[$i]$hardreturn[$i]\" ";
				break;
		}
		
		$i++;
		
		if ($i < $rows) {
			$graph_items .= "\\\n";
		}
	}
	
	/* either print out the source or pass the source onto rrdtool to get us a nice PNG */
	if ($graph_data_array["print_source"] == "true") {
		print "<PRE>" . $config["path_rrdtool"]["value"] . " graph $graph_opts$graph_defs$graph_items</PRE>";
	}else{
		if ($graph_data_array["export"] == true) {
			rrdtool_execute("graph $graph_opts$graph_defs$graph_items", false, "0");
			return 0;
		}else{
			if ($config["log_graph"]["value"] == "on") { $log_data = true; }
			//if ($graph_data_array["output_flag"] == "") { $graph_data_array["output_flag"] = 1; }
			return rrdtool_execute("graph $graph_opts$graph_defs$graph_items",$log_data,$graph_data_array["output_flag"]);
		}
	}
}


?>