# Copyright 2005 Canonical Ltd.
# Written by Hans Ulrich Niedermann

# This program is free software; you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation; either version 2 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
#
# You should have received a copy of the GNU General Public License
# along with this program; if not, write to the Free Software
# Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA

"bash_completion.py - create bash completion script from built-in bzr help"

import os
import sys
import time

import bzrlib
import bzrlib.help
import bzrlib.commands


def get_filename(options):
    return "%s.bash_completion" % (options.bzr_name)


def infogen(options, outfile):
    t = time.time()
    tt = time.gmtime(t)
    params = \
           { "bzrcmd": options.bzr_name,
             "datestamp": time.strftime("%Y-%m-%d",tt),
             "timestamp": time.strftime("%Y-%m-%d %H:%M:%S +0000",tt),
             "version": bzrlib.__version__,
             }

    outfile.write(preamble % params)


preamble = """\
# bash completion functions for for Bazaar (%(bzrcmd)s)
#
# Large parts of this file are autogenerated from the internal
# Bazaar documentation and data structures.
#
# Generation time: %(timestamp)s
"""

