/* shim.c generated by valac 0.32.1, the Vala compiler
 * generated from shim.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <gio/gio.h>
#include <meta/display.h>
#include <meta/meta-plugin.h>
#include <meta/screen.h>
#include <meta/prefs.h>


#define BUDGIE_TYPE_GSD_ACCEL (budgie_gsd_accel_get_type ())
typedef struct _BudgieGsdAccel BudgieGsdAccel;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_SESSION_HANDLER (budgie_session_handler_get_type ())
#define BUDGIE_SESSION_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SESSION_HANDLER, BudgieSessionHandler))
#define BUDGIE_SESSION_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SESSION_HANDLER, BudgieSessionHandlerClass))
#define BUDGIE_IS_SESSION_HANDLER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SESSION_HANDLER))
#define BUDGIE_IS_SESSION_HANDLER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SESSION_HANDLER))
#define BUDGIE_SESSION_HANDLER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SESSION_HANDLER, BudgieSessionHandlerClass))

typedef struct _BudgieSessionHandler BudgieSessionHandler;
typedef struct _BudgieSessionHandlerClass BudgieSessionHandlerClass;
typedef struct _BudgieSessionHandlerPrivate BudgieSessionHandlerPrivate;

#define BUDGIE_TYPE_END_SESSION_DIALOG (budgie_end_session_dialog_get_type ())
#define BUDGIE_END_SESSION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialog))
#define BUDGIE_IS_END_SESSION_DIALOG(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_END_SESSION_DIALOG))
#define BUDGIE_END_SESSION_DIALOG_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_END_SESSION_DIALOG, BudgieEndSessionDialogIface))

typedef struct _BudgieEndSessionDialog BudgieEndSessionDialog;
typedef struct _BudgieEndSessionDialogIface BudgieEndSessionDialogIface;

#define BUDGIE_TYPE_END_SESSION_DIALOG_PROXY (budgie_end_session_dialog_proxy_get_type ())
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef GDBusProxy BudgieEndSessionDialogProxy;
typedef GDBusProxyClass BudgieEndSessionDialogProxyClass;

#define BUDGIE_TYPE_BUDGIE_OSD (budgie_budgie_osd_get_type ())
#define BUDGIE_BUDGIE_OSD(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BUDGIE_OSD, BudgieBudgieOSD))
#define BUDGIE_IS_BUDGIE_OSD(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BUDGIE_OSD))
#define BUDGIE_BUDGIE_OSD_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), BUDGIE_TYPE_BUDGIE_OSD, BudgieBudgieOSDIface))

typedef struct _BudgieBudgieOSD BudgieBudgieOSD;
typedef struct _BudgieBudgieOSDIface BudgieBudgieOSDIface;

#define BUDGIE_TYPE_BUDGIE_OSD_PROXY (budgie_budgie_osd_proxy_get_type ())
typedef GDBusProxy BudgieBudgieOSDProxy;
typedef GDBusProxyClass BudgieBudgieOSDProxyClass;
#define _g_hash_table_unref0(var) ((var == NULL) ? NULL : (var = (g_hash_table_unref (var), NULL)))

#define BUDGIE_TYPE_SHELL_SHIM (budgie_shell_shim_get_type ())
#define BUDGIE_SHELL_SHIM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_SHELL_SHIM, BudgieShellShim))
#define BUDGIE_SHELL_SHIM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_SHELL_SHIM, BudgieShellShimClass))
#define BUDGIE_IS_SHELL_SHIM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_SHELL_SHIM))
#define BUDGIE_IS_SHELL_SHIM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_SHELL_SHIM))
#define BUDGIE_SHELL_SHIM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_SHELL_SHIM, BudgieShellShimClass))

typedef struct _BudgieShellShim BudgieShellShim;
typedef struct _BudgieShellShimClass BudgieShellShimClass;
typedef struct _BudgieShellShimPrivate BudgieShellShimPrivate;

#define BUDGIE_TYPE_BUDGIE_WM (budgie_budgie_wm_get_type ())
#define BUDGIE_BUDGIE_WM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWM))
#define BUDGIE_BUDGIE_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWMClass))
#define BUDGIE_IS_BUDGIE_WM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BUDGIE_WM))
#define BUDGIE_IS_BUDGIE_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BUDGIE_WM))
#define BUDGIE_BUDGIE_WM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWMClass))

typedef struct _BudgieBudgieWM BudgieBudgieWM;
typedef struct _BudgieBudgieWMClass BudgieBudgieWMClass;

struct _BudgieGsdAccel {
	gchar* accelerator;
	guint flags;
};

struct _BudgieSessionHandler {
	GObject parent_instance;
	BudgieSessionHandlerPrivate * priv;
};

struct _BudgieSessionHandlerClass {
	GObjectClass parent_class;
};

struct _BudgieEndSessionDialogIface {
	GTypeInterface parent_iface;
	void (*Open) (BudgieEndSessionDialog* self, guint type, guint timestamp, guint open_length, char** inhibiters, int inhibiters_length1, GError** error);
	void (*Close) (BudgieEndSessionDialog* self, GError** error);
};

struct _BudgieSessionHandlerPrivate {
	gboolean showing;
	BudgieEndSessionDialog* proxy;
};

struct _BudgieBudgieOSDIface {
	GTypeInterface parent_iface;
	void (*ShowOSD) (BudgieBudgieOSD* self, GHashTable* params, GAsyncReadyCallback _callback_, gpointer _user_data_);
	void (*ShowOSD_finish) (BudgieBudgieOSD* self, GAsyncResult* _res_, GError** error);
};

struct _BudgieShellShim {
	GObject parent_instance;
	BudgieShellShimPrivate * priv;
};

struct _BudgieShellShimClass {
	GObjectClass parent_class;
};

struct _BudgieShellShimPrivate {
	GHashTable* grabs;
	GHashTable* watches;
	MetaDisplay* display;
	BudgieSessionHandler* handler;
	BudgieBudgieOSD* osd_proxy;
};


static gpointer budgie_session_handler_parent_class = NULL;
static gpointer budgie_shell_shim_parent_class = NULL;

GType budgie_gsd_accel_get_type (void) G_GNUC_CONST;
BudgieGsdAccel* budgie_gsd_accel_dup (const BudgieGsdAccel* self);
void budgie_gsd_accel_free (BudgieGsdAccel* self);
void budgie_gsd_accel_copy (const BudgieGsdAccel* self, BudgieGsdAccel* dest);
void budgie_gsd_accel_destroy (BudgieGsdAccel* self);
GType budgie_session_handler_get_type (void) G_GNUC_CONST;
guint budgie_session_handler_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType budgie_end_session_dialog_proxy_get_type (void) G_GNUC_CONST;
guint budgie_end_session_dialog_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType budgie_end_session_dialog_get_type (void) G_GNUC_CONST;
#define BUDGIE_SESSION_HANDLER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_SESSION_HANDLER, BudgieSessionHandlerPrivate))
enum  {
	BUDGIE_SESSION_HANDLER_DUMMY_PROPERTY
};
BudgieSessionHandler* budgie_session_handler_new (void);
BudgieSessionHandler* budgie_session_handler_construct (GType object_type);
static void budgie_session_handler_has_dialog (BudgieSessionHandler* self);
static void _budgie_session_handler_has_dialog_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self);
static void budgie_session_handler_lost_dialog (BudgieSessionHandler* self);
static void _budgie_session_handler_lost_dialog_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void budgie_session_handler_on_dialog_get (BudgieSessionHandler* self, GObject* o, GAsyncResult* res);
static void ___lambda9_ (BudgieSessionHandler* self);
static void ____lambda9__budgie_end_session_dialog_confirmed_logout (BudgieEndSessionDialog* _sender, gpointer self);
static void ___lambda10_ (BudgieSessionHandler* self);
static void ____lambda10__budgie_end_session_dialog_confirmed_reboot (BudgieEndSessionDialog* _sender, gpointer self);
static void ___lambda11_ (BudgieSessionHandler* self);
static void ____lambda11__budgie_end_session_dialog_confirmed_shutdown (BudgieEndSessionDialog* _sender, gpointer self);
static void ___lambda12_ (BudgieSessionHandler* self);
static void ____lambda12__budgie_end_session_dialog_canceled (BudgieEndSessionDialog* _sender, gpointer self);
static void ___lambda13_ (BudgieSessionHandler* self);
static void ____lambda13__budgie_end_session_dialog_closed (BudgieEndSessionDialog* _sender, gpointer self);
static void _budgie_session_handler_on_dialog_get_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
void budgie_session_handler_Open (BudgieSessionHandler* self, guint type, guint timestamp, guint open_length, char** inhibiters, int inhibiters_length1);
void budgie_end_session_dialog_Open (BudgieEndSessionDialog* self, guint type, guint timestamp, guint open_length, char** inhibiters, int inhibiters_length1, GError** error);
void budgie_session_handler_Close (BudgieSessionHandler* self);
void budgie_end_session_dialog_Close (BudgieEndSessionDialog* self, GError** error);
static void budgie_session_handler_finalize (GObject* obj);
static void _dbus_budgie_session_handler_Open (BudgieSessionHandler* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_session_handler_Close (BudgieSessionHandler* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void budgie_session_handler_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* budgie_session_handler_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean budgie_session_handler_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_budgie_session_handler_confirmed_logout (GObject* _sender, gpointer* _data);
static void _dbus_budgie_session_handler_confirmed_reboot (GObject* _sender, gpointer* _data);
static void _dbus_budgie_session_handler_confirmed_shutdown (GObject* _sender, gpointer* _data);
static void _dbus_budgie_session_handler_canceled (GObject* _sender, gpointer* _data);
static void _dbus_budgie_session_handler_closed (GObject* _sender, gpointer* _data);
static void _budgie_session_handler_unregister_object (gpointer user_data);
static void budgie_end_session_dialog_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _dbus_handle_budgie_end_session_dialog_confirmed_logout (BudgieEndSessionDialog* self, GVariant* parameters);
static void _dbus_handle_budgie_end_session_dialog_confirmed_reboot (BudgieEndSessionDialog* self, GVariant* parameters);
static void _dbus_handle_budgie_end_session_dialog_confirmed_shutdown (BudgieEndSessionDialog* self, GVariant* parameters);
static void _dbus_handle_budgie_end_session_dialog_canceled (BudgieEndSessionDialog* self, GVariant* parameters);
static void _dbus_handle_budgie_end_session_dialog_closed (BudgieEndSessionDialog* self, GVariant* parameters);
static void budgie_end_session_dialog_proxy_Open (BudgieEndSessionDialog* self, guint type, guint timestamp, guint open_length, char** inhibiters, int inhibiters_length1, GError** error);
static void budgie_end_session_dialog_proxy_Close (BudgieEndSessionDialog* self, GError** error);
static void budgie_end_session_dialog_proxy_budgie_end_session_dialog_interface_init (BudgieEndSessionDialogIface* iface);
static void _dbus_budgie_end_session_dialog_Open (BudgieEndSessionDialog* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_end_session_dialog_Close (BudgieEndSessionDialog* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void budgie_end_session_dialog_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* budgie_end_session_dialog_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean budgie_end_session_dialog_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_budgie_end_session_dialog_confirmed_logout (GObject* _sender, gpointer* _data);
static void _dbus_budgie_end_session_dialog_confirmed_reboot (GObject* _sender, gpointer* _data);
static void _dbus_budgie_end_session_dialog_confirmed_shutdown (GObject* _sender, gpointer* _data);
static void _dbus_budgie_end_session_dialog_canceled (GObject* _sender, gpointer* _data);
static void _dbus_budgie_end_session_dialog_closed (GObject* _sender, gpointer* _data);
static void _budgie_end_session_dialog_unregister_object (gpointer user_data);
GType budgie_budgie_osd_proxy_get_type (void) G_GNUC_CONST;
guint budgie_budgie_osd_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
GType budgie_budgie_osd_get_type (void) G_GNUC_CONST;
void budgie_budgie_osd_ShowOSD (BudgieBudgieOSD* self, GHashTable* params, GAsyncReadyCallback _callback_, gpointer _user_data_);
void budgie_budgie_osd_ShowOSD_finish (BudgieBudgieOSD* self, GAsyncResult* _res_, GError** error);
static void budgie_budgie_osd_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data);
static void budgie_budgie_osd_proxy_ShowOSD_async (BudgieBudgieOSD* self, GHashTable* params, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void budgie_budgie_osd_proxy_ShowOSD_finish (BudgieBudgieOSD* self, GAsyncResult* _res_, GError** error);
static void budgie_budgie_osd_proxy_budgie_budgie_osd_interface_init (BudgieBudgieOSDIface* iface);
static void _dbus_budgie_budgie_osd_ShowOSD (BudgieBudgieOSD* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_budgie_osd_ShowOSD_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_);
static void budgie_budgie_osd_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* budgie_budgie_osd_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean budgie_budgie_osd_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _budgie_budgie_osd_unregister_object (gpointer user_data);
GType budgie_shell_shim_get_type (void) G_GNUC_CONST;
guint budgie_shell_shim_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
#define BUDGIE_SHELL_SHIM_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_SHELL_SHIM, BudgieShellShimPrivate))
enum  {
	BUDGIE_SHELL_SHIM_DUMMY_PROPERTY
};
GType budgie_budgie_wm_get_type (void) G_GNUC_CONST;
BudgieShellShim* budgie_shell_shim_new (BudgieBudgieWM* wm);
BudgieShellShim* budgie_shell_shim_construct (GType object_type, BudgieBudgieWM* wm);
static void _g_free0_ (gpointer var);
static void budgie_shell_shim_on_accelerator_activated (BudgieShellShim* self, guint action, guint device_id);
static void _budgie_shell_shim_on_accelerator_activated_meta_display_accelerator_activated (MetaDisplay* _sender, guint object, guint p0, guint p1, gpointer self);
static void budgie_shell_shim_has_osd_proxy (BudgieShellShim* self);
static void _budgie_shell_shim_has_osd_proxy_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self);
static void budgie_shell_shim_lost_osd_proxy (BudgieShellShim* self);
static void _budgie_shell_shim_lost_osd_proxy_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void budgie_shell_shim_on_osd_proxy_get (BudgieShellShim* self, GObject* o, GAsyncResult* res);
static void _budgie_shell_shim_on_osd_proxy_get_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void _g_variant_unref0_ (gpointer var);
static GVariant* _variant_new1 (guint value);
static void budgie_shell_shim_on_disappeared (BudgieShellShim* self, GDBusConnection* conn, const gchar* name);
static guint _budgie_shell_shim_grab (BudgieShellShim* self, const gchar* sender, const gchar* seq, guint flag);
static void _budgie_shell_shim_on_disappeared_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self);
static void budgie_shell_shim_on_bus_acquired (BudgieShellShim* self, GDBusConnection* conn);
void budgie_shell_shim_serve (BudgieShellShim* self);
static void _budgie_shell_shim_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self);
guint budgie_shell_shim_GrabAccelerator (BudgieShellShim* self, const char* sender, const gchar* accelerator, guint flags);
guint* budgie_shell_shim_GrabAccelerators (BudgieShellShim* self, const char* sender, BudgieGsdAccel* accelerators, int accelerators_length1, int* result_length1);
static void _vala_array_add3 (guint** array, int* length, int* size, guint value);
gboolean budgie_shell_shim_ungrab_accelerator (BudgieShellShim* self, const char* sender, guint action);
void budgie_shell_shim_ShowOSD (BudgieShellShim* self, GHashTable* params);
static void g_cclosure_user_marshal_VOID__UINT_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data);
static void budgie_shell_shim_finalize (GObject* obj);
static void _dbus_budgie_shell_shim_GrabAccelerator (BudgieShellShim* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _vala_BudgieGsdAccel_array_free (BudgieGsdAccel* array, gint array_length);
static void _dbus_budgie_shell_shim_GrabAccelerators (BudgieShellShim* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_shell_shim_ungrab_accelerator (BudgieShellShim* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void _dbus_budgie_shell_shim_ShowOSD (BudgieShellShim* self, GVariant* _parameters_, GDBusMethodInvocation* invocation);
static void budgie_shell_shim_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* budgie_shell_shim_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static gboolean budgie_shell_shim_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_budgie_shell_shim_accelerator_activated (GObject* _sender, guint action, GHashTable* parameters, gpointer* _data);
static void _budgie_shell_shim_unregister_object (gpointer user_data);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);

static const GDBusArgInfo _budgie_session_handler_dbus_arg_info_Open_type = {-1, "type", "u"};
static const GDBusArgInfo _budgie_session_handler_dbus_arg_info_Open_timestamp = {-1, "timestamp", "u"};
static const GDBusArgInfo _budgie_session_handler_dbus_arg_info_Open_open_length = {-1, "open_length", "u"};
static const GDBusArgInfo _budgie_session_handler_dbus_arg_info_Open_inhibiters = {-1, "inhibiters", "ao"};
static const GDBusArgInfo * const _budgie_session_handler_dbus_arg_info_Open_in[] = {&_budgie_session_handler_dbus_arg_info_Open_type, &_budgie_session_handler_dbus_arg_info_Open_timestamp, &_budgie_session_handler_dbus_arg_info_Open_open_length, &_budgie_session_handler_dbus_arg_info_Open_inhibiters, NULL};
static const GDBusArgInfo * const _budgie_session_handler_dbus_arg_info_Open_out[] = {NULL};
static const GDBusMethodInfo _budgie_session_handler_dbus_method_info_Open = {-1, "Open", (GDBusArgInfo **) (&_budgie_session_handler_dbus_arg_info_Open_in), (GDBusArgInfo **) (&_budgie_session_handler_dbus_arg_info_Open_out)};
static const GDBusArgInfo * const _budgie_session_handler_dbus_arg_info_Close_in[] = {NULL};
static const GDBusArgInfo * const _budgie_session_handler_dbus_arg_info_Close_out[] = {NULL};
static const GDBusMethodInfo _budgie_session_handler_dbus_method_info_Close = {-1, "Close", (GDBusArgInfo **) (&_budgie_session_handler_dbus_arg_info_Close_in), (GDBusArgInfo **) (&_budgie_session_handler_dbus_arg_info_Close_out)};
static const GDBusMethodInfo * const _budgie_session_handler_dbus_method_info[] = {&_budgie_session_handler_dbus_method_info_Open, &_budgie_session_handler_dbus_method_info_Close, NULL};
static const GDBusArgInfo * const _budgie_session_handler_dbus_arg_info_confirmed_logout[] = {NULL};
static const GDBusSignalInfo _budgie_session_handler_dbus_signal_info_confirmed_logout = {-1, "ConfirmedLogout", (GDBusArgInfo **) (&_budgie_session_handler_dbus_arg_info_confirmed_logout)};
static const GDBusArgInfo * const _budgie_session_handler_dbus_arg_info_confirmed_reboot[] = {NULL};
static const GDBusSignalInfo _budgie_session_handler_dbus_signal_info_confirmed_reboot = {-1, "ConfirmedReboot", (GDBusArgInfo **) (&_budgie_session_handler_dbus_arg_info_confirmed_reboot)};
static const GDBusArgInfo * const _budgie_session_handler_dbus_arg_info_confirmed_shutdown[] = {NULL};
static const GDBusSignalInfo _budgie_session_handler_dbus_signal_info_confirmed_shutdown = {-1, "ConfirmedShutdown", (GDBusArgInfo **) (&_budgie_session_handler_dbus_arg_info_confirmed_shutdown)};
static const GDBusArgInfo * const _budgie_session_handler_dbus_arg_info_canceled[] = {NULL};
static const GDBusSignalInfo _budgie_session_handler_dbus_signal_info_canceled = {-1, "Canceled", (GDBusArgInfo **) (&_budgie_session_handler_dbus_arg_info_canceled)};
static const GDBusArgInfo * const _budgie_session_handler_dbus_arg_info_closed[] = {NULL};
static const GDBusSignalInfo _budgie_session_handler_dbus_signal_info_closed = {-1, "Closed", (GDBusArgInfo **) (&_budgie_session_handler_dbus_arg_info_closed)};
static const GDBusSignalInfo * const _budgie_session_handler_dbus_signal_info[] = {&_budgie_session_handler_dbus_signal_info_confirmed_logout, &_budgie_session_handler_dbus_signal_info_confirmed_reboot, &_budgie_session_handler_dbus_signal_info_confirmed_shutdown, &_budgie_session_handler_dbus_signal_info_canceled, &_budgie_session_handler_dbus_signal_info_closed, NULL};
static const GDBusPropertyInfo * const _budgie_session_handler_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_session_handler_dbus_interface_info = {-1, "org.gnome.SessionManager.EndSessionDialog", (GDBusMethodInfo **) (&_budgie_session_handler_dbus_method_info), (GDBusSignalInfo **) (&_budgie_session_handler_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_session_handler_dbus_property_info)};
static const GDBusInterfaceVTable _budgie_session_handler_dbus_interface_vtable = {budgie_session_handler_dbus_interface_method_call, budgie_session_handler_dbus_interface_get_property, budgie_session_handler_dbus_interface_set_property};
static const GDBusArgInfo _budgie_end_session_dialog_dbus_arg_info_Open_type = {-1, "type", "u"};
static const GDBusArgInfo _budgie_end_session_dialog_dbus_arg_info_Open_timestamp = {-1, "timestamp", "u"};
static const GDBusArgInfo _budgie_end_session_dialog_dbus_arg_info_Open_open_length = {-1, "open_length", "u"};
static const GDBusArgInfo _budgie_end_session_dialog_dbus_arg_info_Open_inhibiters = {-1, "inhibiters", "ao"};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_Open_in[] = {&_budgie_end_session_dialog_dbus_arg_info_Open_type, &_budgie_end_session_dialog_dbus_arg_info_Open_timestamp, &_budgie_end_session_dialog_dbus_arg_info_Open_open_length, &_budgie_end_session_dialog_dbus_arg_info_Open_inhibiters, NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_Open_out[] = {NULL};
static const GDBusMethodInfo _budgie_end_session_dialog_dbus_method_info_Open = {-1, "Open", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_Open_in), (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_Open_out)};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_Close_in[] = {NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_Close_out[] = {NULL};
static const GDBusMethodInfo _budgie_end_session_dialog_dbus_method_info_Close = {-1, "Close", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_Close_in), (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_Close_out)};
static const GDBusMethodInfo * const _budgie_end_session_dialog_dbus_method_info[] = {&_budgie_end_session_dialog_dbus_method_info_Open, &_budgie_end_session_dialog_dbus_method_info_Close, NULL};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_confirmed_logout[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_confirmed_logout = {-1, "ConfirmedLogout", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_confirmed_logout)};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_confirmed_reboot[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_confirmed_reboot = {-1, "ConfirmedReboot", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_confirmed_reboot)};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_confirmed_shutdown[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_confirmed_shutdown = {-1, "ConfirmedShutdown", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_confirmed_shutdown)};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_canceled[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_canceled = {-1, "Canceled", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_canceled)};
static const GDBusArgInfo * const _budgie_end_session_dialog_dbus_arg_info_closed[] = {NULL};
static const GDBusSignalInfo _budgie_end_session_dialog_dbus_signal_info_closed = {-1, "Closed", (GDBusArgInfo **) (&_budgie_end_session_dialog_dbus_arg_info_closed)};
static const GDBusSignalInfo * const _budgie_end_session_dialog_dbus_signal_info[] = {&_budgie_end_session_dialog_dbus_signal_info_confirmed_logout, &_budgie_end_session_dialog_dbus_signal_info_confirmed_reboot, &_budgie_end_session_dialog_dbus_signal_info_confirmed_shutdown, &_budgie_end_session_dialog_dbus_signal_info_canceled, &_budgie_end_session_dialog_dbus_signal_info_closed, NULL};
static const GDBusPropertyInfo * const _budgie_end_session_dialog_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_end_session_dialog_dbus_interface_info = {-1, "com.solus_project.Session.EndSessionDialog", (GDBusMethodInfo **) (&_budgie_end_session_dialog_dbus_method_info), (GDBusSignalInfo **) (&_budgie_end_session_dialog_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_end_session_dialog_dbus_property_info)};
static const GDBusInterfaceVTable _budgie_end_session_dialog_dbus_interface_vtable = {budgie_end_session_dialog_dbus_interface_method_call, budgie_end_session_dialog_dbus_interface_get_property, budgie_end_session_dialog_dbus_interface_set_property};
static const GDBusArgInfo _budgie_budgie_osd_dbus_arg_info_ShowOSD_params = {-1, "params", "a{sv}"};
static const GDBusArgInfo * const _budgie_budgie_osd_dbus_arg_info_ShowOSD_in[] = {&_budgie_budgie_osd_dbus_arg_info_ShowOSD_params, NULL};
static const GDBusArgInfo * const _budgie_budgie_osd_dbus_arg_info_ShowOSD_out[] = {NULL};
static const GDBusMethodInfo _budgie_budgie_osd_dbus_method_info_ShowOSD = {-1, "ShowOSD", (GDBusArgInfo **) (&_budgie_budgie_osd_dbus_arg_info_ShowOSD_in), (GDBusArgInfo **) (&_budgie_budgie_osd_dbus_arg_info_ShowOSD_out)};
static const GDBusMethodInfo * const _budgie_budgie_osd_dbus_method_info[] = {&_budgie_budgie_osd_dbus_method_info_ShowOSD, NULL};
static const GDBusSignalInfo * const _budgie_budgie_osd_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo * const _budgie_budgie_osd_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_budgie_osd_dbus_interface_info = {-1, "com.solus_project.BudgieOSD", (GDBusMethodInfo **) (&_budgie_budgie_osd_dbus_method_info), (GDBusSignalInfo **) (&_budgie_budgie_osd_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_budgie_osd_dbus_property_info)};
static const GDBusInterfaceVTable _budgie_budgie_osd_dbus_interface_vtable = {budgie_budgie_osd_dbus_interface_method_call, budgie_budgie_osd_dbus_interface_get_property, budgie_budgie_osd_dbus_interface_set_property};
static const GDBusArgInfo _budgie_shell_shim_dbus_arg_info_GrabAccelerator_accelerator = {-1, "accelerator", "s"};
static const GDBusArgInfo _budgie_shell_shim_dbus_arg_info_GrabAccelerator_flags = {-1, "flags", "u"};
static const GDBusArgInfo _budgie_shell_shim_dbus_arg_info_GrabAccelerator_result = {-1, "result", "u"};
static const GDBusArgInfo * const _budgie_shell_shim_dbus_arg_info_GrabAccelerator_in[] = {&_budgie_shell_shim_dbus_arg_info_GrabAccelerator_accelerator, &_budgie_shell_shim_dbus_arg_info_GrabAccelerator_flags, NULL};
static const GDBusArgInfo * const _budgie_shell_shim_dbus_arg_info_GrabAccelerator_out[] = {&_budgie_shell_shim_dbus_arg_info_GrabAccelerator_result, NULL};
static const GDBusMethodInfo _budgie_shell_shim_dbus_method_info_GrabAccelerator = {-1, "GrabAccelerator", (GDBusArgInfo **) (&_budgie_shell_shim_dbus_arg_info_GrabAccelerator_in), (GDBusArgInfo **) (&_budgie_shell_shim_dbus_arg_info_GrabAccelerator_out)};
static const GDBusArgInfo _budgie_shell_shim_dbus_arg_info_GrabAccelerators_accelerators = {-1, "accelerators", "a(su)"};
static const GDBusArgInfo _budgie_shell_shim_dbus_arg_info_GrabAccelerators_result = {-1, "result", "au"};
static const GDBusArgInfo * const _budgie_shell_shim_dbus_arg_info_GrabAccelerators_in[] = {&_budgie_shell_shim_dbus_arg_info_GrabAccelerators_accelerators, NULL};
static const GDBusArgInfo * const _budgie_shell_shim_dbus_arg_info_GrabAccelerators_out[] = {&_budgie_shell_shim_dbus_arg_info_GrabAccelerators_result, NULL};
static const GDBusMethodInfo _budgie_shell_shim_dbus_method_info_GrabAccelerators = {-1, "GrabAccelerators", (GDBusArgInfo **) (&_budgie_shell_shim_dbus_arg_info_GrabAccelerators_in), (GDBusArgInfo **) (&_budgie_shell_shim_dbus_arg_info_GrabAccelerators_out)};
static const GDBusArgInfo _budgie_shell_shim_dbus_arg_info_ungrab_accelerator_action = {-1, "action", "u"};
static const GDBusArgInfo _budgie_shell_shim_dbus_arg_info_ungrab_accelerator_result = {-1, "result", "b"};
static const GDBusArgInfo * const _budgie_shell_shim_dbus_arg_info_ungrab_accelerator_in[] = {&_budgie_shell_shim_dbus_arg_info_ungrab_accelerator_action, NULL};
static const GDBusArgInfo * const _budgie_shell_shim_dbus_arg_info_ungrab_accelerator_out[] = {&_budgie_shell_shim_dbus_arg_info_ungrab_accelerator_result, NULL};
static const GDBusMethodInfo _budgie_shell_shim_dbus_method_info_ungrab_accelerator = {-1, "UngrabAccelerator", (GDBusArgInfo **) (&_budgie_shell_shim_dbus_arg_info_ungrab_accelerator_in), (GDBusArgInfo **) (&_budgie_shell_shim_dbus_arg_info_ungrab_accelerator_out)};
static const GDBusArgInfo _budgie_shell_shim_dbus_arg_info_ShowOSD_params = {-1, "params", "a{sv}"};
static const GDBusArgInfo * const _budgie_shell_shim_dbus_arg_info_ShowOSD_in[] = {&_budgie_shell_shim_dbus_arg_info_ShowOSD_params, NULL};
static const GDBusArgInfo * const _budgie_shell_shim_dbus_arg_info_ShowOSD_out[] = {NULL};
static const GDBusMethodInfo _budgie_shell_shim_dbus_method_info_ShowOSD = {-1, "ShowOSD", (GDBusArgInfo **) (&_budgie_shell_shim_dbus_arg_info_ShowOSD_in), (GDBusArgInfo **) (&_budgie_shell_shim_dbus_arg_info_ShowOSD_out)};
static const GDBusMethodInfo * const _budgie_shell_shim_dbus_method_info[] = {&_budgie_shell_shim_dbus_method_info_GrabAccelerator, &_budgie_shell_shim_dbus_method_info_GrabAccelerators, &_budgie_shell_shim_dbus_method_info_ungrab_accelerator, &_budgie_shell_shim_dbus_method_info_ShowOSD, NULL};
static const GDBusArgInfo _budgie_shell_shim_dbus_arg_info_accelerator_activated_action = {-1, "action", "u"};
static const GDBusArgInfo _budgie_shell_shim_dbus_arg_info_accelerator_activated_parameters = {-1, "parameters", "a{sv}"};
static const GDBusArgInfo * const _budgie_shell_shim_dbus_arg_info_accelerator_activated[] = {&_budgie_shell_shim_dbus_arg_info_accelerator_activated_action, &_budgie_shell_shim_dbus_arg_info_accelerator_activated_parameters, NULL};
static const GDBusSignalInfo _budgie_shell_shim_dbus_signal_info_accelerator_activated = {-1, "AcceleratorActivated", (GDBusArgInfo **) (&_budgie_shell_shim_dbus_arg_info_accelerator_activated)};
static const GDBusSignalInfo * const _budgie_shell_shim_dbus_signal_info[] = {&_budgie_shell_shim_dbus_signal_info_accelerator_activated, NULL};
static const GDBusPropertyInfo * const _budgie_shell_shim_dbus_property_info[] = {NULL};
static const GDBusInterfaceInfo _budgie_shell_shim_dbus_interface_info = {-1, "org.gnome.Shell", (GDBusMethodInfo **) (&_budgie_shell_shim_dbus_method_info), (GDBusSignalInfo **) (&_budgie_shell_shim_dbus_signal_info), (GDBusPropertyInfo **) (&_budgie_shell_shim_dbus_property_info)};
static const GDBusInterfaceVTable _budgie_shell_shim_dbus_interface_vtable = {budgie_shell_shim_dbus_interface_method_call, budgie_shell_shim_dbus_interface_get_property, budgie_shell_shim_dbus_interface_set_property};

void budgie_gsd_accel_copy (const BudgieGsdAccel* self, BudgieGsdAccel* dest) {
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	_tmp0_ = (*self).accelerator;
	_tmp1_ = g_strdup (_tmp0_);
	_g_free0 ((*dest).accelerator);
	(*dest).accelerator = _tmp1_;
	_tmp2_ = (*self).flags;
	(*dest).flags = _tmp2_;
}


void budgie_gsd_accel_destroy (BudgieGsdAccel* self) {
	_g_free0 ((*self).accelerator);
}


BudgieGsdAccel* budgie_gsd_accel_dup (const BudgieGsdAccel* self) {
	BudgieGsdAccel* dup;
	dup = g_new0 (BudgieGsdAccel, 1);
	budgie_gsd_accel_copy (self, dup);
	return dup;
}


void budgie_gsd_accel_free (BudgieGsdAccel* self) {
	budgie_gsd_accel_destroy (self);
	g_free (self);
}


GType budgie_gsd_accel_get_type (void) {
	static volatile gsize budgie_gsd_accel_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_gsd_accel_type_id__volatile)) {
		GType budgie_gsd_accel_type_id;
		budgie_gsd_accel_type_id = g_boxed_type_register_static ("BudgieGsdAccel", (GBoxedCopyFunc) budgie_gsd_accel_dup, (GBoxedFreeFunc) budgie_gsd_accel_free);
		g_once_init_leave (&budgie_gsd_accel_type_id__volatile, budgie_gsd_accel_type_id);
	}
	return budgie_gsd_accel_type_id__volatile;
}


static void _budgie_session_handler_has_dialog_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self) {
	budgie_session_handler_has_dialog ((BudgieSessionHandler*) self);
}


static void _budgie_session_handler_lost_dialog_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	budgie_session_handler_lost_dialog ((BudgieSessionHandler*) self);
}


BudgieSessionHandler* budgie_session_handler_construct (GType object_type) {
	BudgieSessionHandler * self = NULL;
	self = (BudgieSessionHandler*) g_object_new (object_type, NULL);
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, "com.solus_project.Session.EndSessionDialog", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_budgie_session_handler_has_dialog_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_session_handler_has_dialog_gbus_name_appeared_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((_budgie_session_handler_lost_dialog_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_session_handler_lost_dialog_gbus_name_vanished_callback, g_object_ref (self), g_object_unref)));
	return self;
}


BudgieSessionHandler* budgie_session_handler_new (void) {
	return budgie_session_handler_construct (BUDGIE_TYPE_SESSION_HANDLER);
}


static void ___lambda9_ (BudgieSessionHandler* self) {
	g_signal_emit_by_name (self, "confirmed-logout");
}


static void ____lambda9__budgie_end_session_dialog_confirmed_logout (BudgieEndSessionDialog* _sender, gpointer self) {
	___lambda9_ ((BudgieSessionHandler*) self);
}


static void ___lambda10_ (BudgieSessionHandler* self) {
	g_signal_emit_by_name (self, "confirmed-reboot");
}


static void ____lambda10__budgie_end_session_dialog_confirmed_reboot (BudgieEndSessionDialog* _sender, gpointer self) {
	___lambda10_ ((BudgieSessionHandler*) self);
}


static void ___lambda11_ (BudgieSessionHandler* self) {
	g_signal_emit_by_name (self, "confirmed-shutdown");
}


static void ____lambda11__budgie_end_session_dialog_confirmed_shutdown (BudgieEndSessionDialog* _sender, gpointer self) {
	___lambda11_ ((BudgieSessionHandler*) self);
}


static void ___lambda12_ (BudgieSessionHandler* self) {
	g_signal_emit_by_name (self, "canceled");
}


static void ____lambda12__budgie_end_session_dialog_canceled (BudgieEndSessionDialog* _sender, gpointer self) {
	___lambda12_ ((BudgieSessionHandler*) self);
}


static void ___lambda13_ (BudgieSessionHandler* self) {
	g_signal_emit_by_name (self, "closed");
}


static void ____lambda13__budgie_end_session_dialog_closed (BudgieEndSessionDialog* _sender, gpointer self) {
	___lambda13_ ((BudgieSessionHandler*) self);
}


static void budgie_session_handler_on_dialog_get (BudgieSessionHandler* self, GObject* o, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieEndSessionDialog* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		BudgieEndSessionDialog* _tmp2_ = NULL;
		BudgieEndSessionDialog* _tmp3_ = NULL;
		BudgieEndSessionDialog* _tmp4_ = NULL;
		BudgieEndSessionDialog* _tmp5_ = NULL;
		BudgieEndSessionDialog* _tmp6_ = NULL;
		BudgieEndSessionDialog* _tmp7_ = NULL;
		BudgieEndSessionDialog* _tmp8_ = NULL;
		BudgieEndSessionDialog* _tmp9_ = NULL;
		_tmp1_ = res;
		_tmp2_ = g_async_result_get_source_object (_tmp1_);
		_tmp3_ = g_async_initable_new_finish (_tmp2_, _tmp1_, &_inner_error_);
		g_object_unref (_tmp2_);
		_tmp0_ = (BudgieEndSessionDialog*) _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch4_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->proxy);
		self->priv->proxy = _tmp4_;
		_tmp5_ = self->priv->proxy;
		g_signal_connect_object (_tmp5_, "confirmed-logout", (GCallback) ____lambda9__budgie_end_session_dialog_confirmed_logout, self, 0);
		_tmp6_ = self->priv->proxy;
		g_signal_connect_object (_tmp6_, "confirmed-reboot", (GCallback) ____lambda10__budgie_end_session_dialog_confirmed_reboot, self, 0);
		_tmp7_ = self->priv->proxy;
		g_signal_connect_object (_tmp7_, "confirmed-shutdown", (GCallback) ____lambda11__budgie_end_session_dialog_confirmed_shutdown, self, 0);
		_tmp8_ = self->priv->proxy;
		g_signal_connect_object (_tmp8_, "canceled", (GCallback) ____lambda12__budgie_end_session_dialog_canceled, self, 0);
		_tmp9_ = self->priv->proxy;
		g_signal_connect_object (_tmp9_, "closed", (GCallback) ____lambda13__budgie_end_session_dialog_closed, self, 0);
		_g_object_unref0 (_tmp0_);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_object_unref0 (self->priv->proxy);
		self->priv->proxy = NULL;
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _budgie_session_handler_on_dialog_get_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	budgie_session_handler_on_dialog_get ((BudgieSessionHandler*) self, source_object, res);
	g_object_unref (self);
}


static void budgie_session_handler_has_dialog (BudgieSessionHandler* self) {
	BudgieEndSessionDialog* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->proxy;
	if (_tmp0_ != NULL) {
		return;
	}
	g_async_initable_new_async (BUDGIE_TYPE_END_SESSION_DIALOG_PROXY, 0, NULL, _budgie_session_handler_on_dialog_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", "com.solus_project.Session.EndSessionDialog", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/com/solus_project/Session/EndSessionDialog", "g-interface-name", "com.solus_project.Session.EndSessionDialog", "g-interface-info", g_type_get_qdata (BUDGIE_TYPE_END_SESSION_DIALOG, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
}


static void budgie_session_handler_lost_dialog (BudgieSessionHandler* self) {
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->proxy);
	self->priv->proxy = NULL;
}


void budgie_session_handler_Open (BudgieSessionHandler* self, guint type, guint timestamp, guint open_length, char** inhibiters, int inhibiters_length1) {
	BudgieEndSessionDialog* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->proxy;
	if (_tmp0_ == NULL) {
		return;
	}
	{
		BudgieEndSessionDialog* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		guint _tmp3_ = 0U;
		guint _tmp4_ = 0U;
		char** _tmp5_ = NULL;
		gint _tmp5__length1 = 0;
		_tmp1_ = self->priv->proxy;
		_tmp2_ = type;
		_tmp3_ = timestamp;
		_tmp4_ = open_length;
		_tmp5_ = inhibiters;
		_tmp5__length1 = inhibiters_length1;
		budgie_end_session_dialog_Open (_tmp1_, _tmp2_, _tmp3_, _tmp4_, _tmp5_, _tmp5__length1, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch5_g_error;
		}
	}
	goto __finally5;
	__catch5_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_message ("shim.vala:84: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally5:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


void budgie_session_handler_Close (BudgieSessionHandler* self) {
	BudgieEndSessionDialog* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->proxy;
	if (_tmp0_ == NULL) {
		{
			BudgieEndSessionDialog* _tmp1_ = NULL;
			_tmp1_ = self->priv->proxy;
			budgie_end_session_dialog_Close (_tmp1_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch6_g_error;
			}
		}
		goto __finally6;
		__catch6_g_error:
		{
			GError* e = NULL;
			GError* _tmp2_ = NULL;
			const gchar* _tmp3_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp2_ = e;
			_tmp3_ = _tmp2_->message;
			g_message ("shim.vala:94: %s", _tmp3_);
			_g_error_free0 (e);
		}
		__finally6:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
	}
}


static void budgie_session_handler_class_init (BudgieSessionHandlerClass * klass) {
	budgie_session_handler_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieSessionHandlerPrivate));
	G_OBJECT_CLASS (klass)->finalize = budgie_session_handler_finalize;
	g_signal_new ("confirmed_logout", BUDGIE_TYPE_SESSION_HANDLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("confirmed_reboot", BUDGIE_TYPE_SESSION_HANDLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("confirmed_shutdown", BUDGIE_TYPE_SESSION_HANDLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("canceled", BUDGIE_TYPE_SESSION_HANDLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	g_signal_new ("closed", BUDGIE_TYPE_SESSION_HANDLER, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
}


static void budgie_session_handler_instance_init (BudgieSessionHandler * self) {
	self->priv = BUDGIE_SESSION_HANDLER_GET_PRIVATE (self);
	self->priv->showing = FALSE;
	self->priv->proxy = NULL;
}


static void budgie_session_handler_finalize (GObject* obj) {
	BudgieSessionHandler * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SESSION_HANDLER, BudgieSessionHandler);
	_g_object_unref0 (self->priv->proxy);
	G_OBJECT_CLASS (budgie_session_handler_parent_class)->finalize (obj);
}


GType budgie_session_handler_get_type (void) {
	static volatile gsize budgie_session_handler_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_session_handler_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieSessionHandlerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_session_handler_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieSessionHandler), 0, (GInstanceInitFunc) budgie_session_handler_instance_init, NULL };
		GType budgie_session_handler_type_id;
		budgie_session_handler_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieSessionHandler", &g_define_type_info, 0);
		g_type_set_qdata (budgie_session_handler_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_session_handler_register_object);
		g_once_init_leave (&budgie_session_handler_type_id__volatile, budgie_session_handler_type_id);
	}
	return budgie_session_handler_type_id__volatile;
}


static void _dbus_budgie_session_handler_Open (BudgieSessionHandler* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint type = 0U;
	GVariant* _tmp0_;
	guint timestamp = 0U;
	GVariant* _tmp1_;
	guint open_length = 0U;
	GVariant* _tmp2_;
	char** inhibiters = NULL;
	int inhibiters_length1 = 0;
	GVariant* _tmp3_;
	char** _tmp4_;
	int _tmp4__length;
	int _tmp4__size;
	int _tmp4__length1;
	GVariantIter _tmp5_;
	GVariant* _tmp6_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp0_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_uint32 (_tmp0_);
	g_variant_unref (_tmp0_);
	_tmp1_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp1_);
	g_variant_unref (_tmp1_);
	_tmp2_ = g_variant_iter_next_value (&_arguments_iter);
	open_length = g_variant_get_uint32 (_tmp2_);
	g_variant_unref (_tmp2_);
	_tmp3_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp4_ = g_new (char*, 5);
	_tmp4__length = 0;
	_tmp4__size = 4;
	_tmp4__length1 = 0;
	g_variant_iter_init (&_tmp5_, _tmp3_);
	for (; (_tmp6_ = g_variant_iter_next_value (&_tmp5_)) != NULL; _tmp4__length1++) {
		if (_tmp4__size == _tmp4__length) {
			_tmp4__size = 2 * _tmp4__size;
			_tmp4_ = g_renew (char*, _tmp4_, _tmp4__size + 1);
		}
		_tmp4_[_tmp4__length++] = g_variant_dup_string (_tmp6_, NULL);
		g_variant_unref (_tmp6_);
	}
	inhibiters_length1 = _tmp4__length1;
	_tmp4_[_tmp4__length] = NULL;
	inhibiters = _tmp4_;
	g_variant_unref (_tmp3_);
	budgie_session_handler_Open (self, type, timestamp, open_length, inhibiters, inhibiters_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	inhibiters = (_vala_array_free (inhibiters, inhibiters_length1, (GDestroyNotify) g_free), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_budgie_session_handler_Close (BudgieSessionHandler* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_session_handler_Close (self);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void budgie_session_handler_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Open") == 0) {
		_dbus_budgie_session_handler_Open (object, parameters, invocation);
	} else if (strcmp (method_name, "Close") == 0) {
		_dbus_budgie_session_handler_Close (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* budgie_session_handler_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean budgie_session_handler_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_budgie_session_handler_confirmed_logout (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.EndSessionDialog", "ConfirmedLogout", _arguments, NULL);
}


static void _dbus_budgie_session_handler_confirmed_reboot (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.EndSessionDialog", "ConfirmedReboot", _arguments, NULL);
}


static void _dbus_budgie_session_handler_confirmed_shutdown (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.EndSessionDialog", "ConfirmedShutdown", _arguments, NULL);
}


static void _dbus_budgie_session_handler_canceled (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.EndSessionDialog", "Canceled", _arguments, NULL);
}


static void _dbus_budgie_session_handler_closed (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.SessionManager.EndSessionDialog", "Closed", _arguments, NULL);
}


guint budgie_session_handler_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_session_handler_dbus_interface_info), &_budgie_session_handler_dbus_interface_vtable, data, _budgie_session_handler_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "confirmed-logout", (GCallback) _dbus_budgie_session_handler_confirmed_logout, data);
	g_signal_connect (object, "confirmed-reboot", (GCallback) _dbus_budgie_session_handler_confirmed_reboot, data);
	g_signal_connect (object, "confirmed-shutdown", (GCallback) _dbus_budgie_session_handler_confirmed_shutdown, data);
	g_signal_connect (object, "canceled", (GCallback) _dbus_budgie_session_handler_canceled, data);
	g_signal_connect (object, "closed", (GCallback) _dbus_budgie_session_handler_closed, data);
	return result;
}


static void _budgie_session_handler_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_session_handler_confirmed_logout, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_session_handler_confirmed_reboot, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_session_handler_confirmed_shutdown, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_session_handler_canceled, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_session_handler_closed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void budgie_end_session_dialog_Open (BudgieEndSessionDialog* self, guint type, guint timestamp, guint open_length, char** inhibiters, int inhibiters_length1, GError** error) {
	g_return_if_fail (self != NULL);
	BUDGIE_END_SESSION_DIALOG_GET_INTERFACE (self)->Open (self, type, timestamp, open_length, inhibiters, inhibiters_length1, error);
}


void budgie_end_session_dialog_Close (BudgieEndSessionDialog* self, GError** error) {
	g_return_if_fail (self != NULL);
	BUDGIE_END_SESSION_DIALOG_GET_INTERFACE (self)->Close (self, error);
}


static void budgie_end_session_dialog_base_init (BudgieEndSessionDialogIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
		g_signal_new ("confirmed_logout", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("confirmed_reboot", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("confirmed_shutdown", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("canceled", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
		g_signal_new ("closed", BUDGIE_TYPE_END_SESSION_DIALOG, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_marshal_VOID__VOID, G_TYPE_NONE, 0);
	}
}


/**
 * Wrap the EndSessionDialog type inside Budgie itself
 */
GType budgie_end_session_dialog_get_type (void) {
	static volatile gsize budgie_end_session_dialog_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_end_session_dialog_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieEndSessionDialogIface), (GBaseInitFunc) budgie_end_session_dialog_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType budgie_end_session_dialog_type_id;
		budgie_end_session_dialog_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieEndSessionDialog", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (budgie_end_session_dialog_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (budgie_end_session_dialog_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_end_session_dialog_proxy_get_type);
		g_type_set_qdata (budgie_end_session_dialog_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.solus_project.Session.EndSessionDialog");
		g_type_set_qdata (budgie_end_session_dialog_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_end_session_dialog_dbus_interface_info));
		g_type_set_qdata (budgie_end_session_dialog_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_end_session_dialog_register_object);
		g_once_init_leave (&budgie_end_session_dialog_type_id__volatile, budgie_end_session_dialog_type_id);
	}
	return budgie_end_session_dialog_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (BudgieEndSessionDialogProxy, budgie_end_session_dialog_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_END_SESSION_DIALOG, budgie_end_session_dialog_proxy_budgie_end_session_dialog_interface_init) )
static void budgie_end_session_dialog_proxy_class_init (BudgieEndSessionDialogProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_end_session_dialog_proxy_g_signal;
}


static void _dbus_handle_budgie_end_session_dialog_confirmed_logout (BudgieEndSessionDialog* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "confirmed-logout");
}


static void _dbus_handle_budgie_end_session_dialog_confirmed_reboot (BudgieEndSessionDialog* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "confirmed-reboot");
}


static void _dbus_handle_budgie_end_session_dialog_confirmed_shutdown (BudgieEndSessionDialog* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "confirmed-shutdown");
}


static void _dbus_handle_budgie_end_session_dialog_canceled (BudgieEndSessionDialog* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "canceled");
}


static void _dbus_handle_budgie_end_session_dialog_closed (BudgieEndSessionDialog* self, GVariant* parameters) {
	GVariantIter _arguments_iter;
	g_variant_iter_init (&_arguments_iter, parameters);
	g_signal_emit_by_name (self, "closed");
}


static void budgie_end_session_dialog_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
	if (strcmp (signal_name, "ConfirmedLogout") == 0) {
		_dbus_handle_budgie_end_session_dialog_confirmed_logout ((BudgieEndSessionDialog*) proxy, parameters);
	} else if (strcmp (signal_name, "ConfirmedReboot") == 0) {
		_dbus_handle_budgie_end_session_dialog_confirmed_reboot ((BudgieEndSessionDialog*) proxy, parameters);
	} else if (strcmp (signal_name, "ConfirmedShutdown") == 0) {
		_dbus_handle_budgie_end_session_dialog_confirmed_shutdown ((BudgieEndSessionDialog*) proxy, parameters);
	} else if (strcmp (signal_name, "Canceled") == 0) {
		_dbus_handle_budgie_end_session_dialog_canceled ((BudgieEndSessionDialog*) proxy, parameters);
	} else if (strcmp (signal_name, "Closed") == 0) {
		_dbus_handle_budgie_end_session_dialog_closed ((BudgieEndSessionDialog*) proxy, parameters);
	}
}


static void budgie_end_session_dialog_proxy_init (BudgieEndSessionDialogProxy* self) {
}


static void budgie_end_session_dialog_proxy_Open (BudgieEndSessionDialog* self, guint type, guint timestamp, guint open_length, char** inhibiters, int inhibiters_length1, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	char** _tmp7_;
	GVariantBuilder _tmp8_;
	int _tmp9_;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.solus_project.Session.EndSessionDialog", "Open");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (type));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (timestamp));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (open_length));
	_tmp7_ = inhibiters;
	g_variant_builder_init (&_tmp8_, G_VARIANT_TYPE ("ao"));
	for (_tmp9_ = 0; _tmp9_ < inhibiters_length1; _tmp9_++) {
		g_variant_builder_add_value (&_tmp8_, g_variant_new_object_path (*_tmp7_));
		_tmp7_++;
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp8_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void budgie_end_session_dialog_proxy_Close (BudgieEndSessionDialog* self, GError** error) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GDBusMessage *_reply_message;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.solus_project.Session.EndSessionDialog", "Close");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	_reply_message = g_dbus_connection_send_message_with_reply_sync (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, error);
	g_object_unref (_message);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void budgie_end_session_dialog_proxy_budgie_end_session_dialog_interface_init (BudgieEndSessionDialogIface* iface) {
	iface->Open = budgie_end_session_dialog_proxy_Open;
	iface->Close = budgie_end_session_dialog_proxy_Close;
}


static void _dbus_budgie_end_session_dialog_Open (BudgieEndSessionDialog* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint type = 0U;
	GVariant* _tmp10_;
	guint timestamp = 0U;
	GVariant* _tmp11_;
	guint open_length = 0U;
	GVariant* _tmp12_;
	char** inhibiters = NULL;
	int inhibiters_length1 = 0;
	GVariant* _tmp13_;
	char** _tmp14_;
	int _tmp14__length;
	int _tmp14__size;
	int _tmp14__length1;
	GVariantIter _tmp15_;
	GVariant* _tmp16_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp10_ = g_variant_iter_next_value (&_arguments_iter);
	type = g_variant_get_uint32 (_tmp10_);
	g_variant_unref (_tmp10_);
	_tmp11_ = g_variant_iter_next_value (&_arguments_iter);
	timestamp = g_variant_get_uint32 (_tmp11_);
	g_variant_unref (_tmp11_);
	_tmp12_ = g_variant_iter_next_value (&_arguments_iter);
	open_length = g_variant_get_uint32 (_tmp12_);
	g_variant_unref (_tmp12_);
	_tmp13_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp14_ = g_new (char*, 5);
	_tmp14__length = 0;
	_tmp14__size = 4;
	_tmp14__length1 = 0;
	g_variant_iter_init (&_tmp15_, _tmp13_);
	for (; (_tmp16_ = g_variant_iter_next_value (&_tmp15_)) != NULL; _tmp14__length1++) {
		if (_tmp14__size == _tmp14__length) {
			_tmp14__size = 2 * _tmp14__size;
			_tmp14_ = g_renew (char*, _tmp14_, _tmp14__size + 1);
		}
		_tmp14_[_tmp14__length++] = g_variant_dup_string (_tmp16_, NULL);
		g_variant_unref (_tmp16_);
	}
	inhibiters_length1 = _tmp14__length1;
	_tmp14_[_tmp14__length] = NULL;
	inhibiters = _tmp14_;
	g_variant_unref (_tmp13_);
	budgie_end_session_dialog_Open (self, type, timestamp, open_length, inhibiters, inhibiters_length1, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	inhibiters = (_vala_array_free (inhibiters, inhibiters_length1, (GDestroyNotify) g_free), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_budgie_end_session_dialog_Close (BudgieEndSessionDialog* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	budgie_end_session_dialog_Close (self, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void budgie_end_session_dialog_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "Open") == 0) {
		_dbus_budgie_end_session_dialog_Open (object, parameters, invocation);
	} else if (strcmp (method_name, "Close") == 0) {
		_dbus_budgie_end_session_dialog_Close (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* budgie_end_session_dialog_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean budgie_end_session_dialog_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_budgie_end_session_dialog_confirmed_logout (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.Session.EndSessionDialog", "ConfirmedLogout", _arguments, NULL);
}


static void _dbus_budgie_end_session_dialog_confirmed_reboot (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.Session.EndSessionDialog", "ConfirmedReboot", _arguments, NULL);
}


static void _dbus_budgie_end_session_dialog_confirmed_shutdown (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.Session.EndSessionDialog", "ConfirmedShutdown", _arguments, NULL);
}


static void _dbus_budgie_end_session_dialog_canceled (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.Session.EndSessionDialog", "Canceled", _arguments, NULL);
}


static void _dbus_budgie_end_session_dialog_closed (GObject* _sender, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "com.solus_project.Session.EndSessionDialog", "Closed", _arguments, NULL);
}


guint budgie_end_session_dialog_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_end_session_dialog_dbus_interface_info), &_budgie_end_session_dialog_dbus_interface_vtable, data, _budgie_end_session_dialog_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "confirmed-logout", (GCallback) _dbus_budgie_end_session_dialog_confirmed_logout, data);
	g_signal_connect (object, "confirmed-reboot", (GCallback) _dbus_budgie_end_session_dialog_confirmed_reboot, data);
	g_signal_connect (object, "confirmed-shutdown", (GCallback) _dbus_budgie_end_session_dialog_confirmed_shutdown, data);
	g_signal_connect (object, "canceled", (GCallback) _dbus_budgie_end_session_dialog_canceled, data);
	g_signal_connect (object, "closed", (GCallback) _dbus_budgie_end_session_dialog_closed, data);
	return result;
}


static void _budgie_end_session_dialog_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_confirmed_logout, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_confirmed_reboot, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_confirmed_shutdown, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_canceled, data);
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_end_session_dialog_closed, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


void budgie_budgie_osd_ShowOSD (BudgieBudgieOSD* self, GHashTable* params, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BUDGIE_BUDGIE_OSD_GET_INTERFACE (self)->ShowOSD (self, params, _callback_, _user_data_);
}


void budgie_budgie_osd_ShowOSD_finish (BudgieBudgieOSD* self, GAsyncResult* _res_, GError** error) {
	BUDGIE_BUDGIE_OSD_GET_INTERFACE (self)->ShowOSD_finish (self, _res_, error);
}


static void budgie_budgie_osd_base_init (BudgieBudgieOSDIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


/**
 * Expose the BudgieOSD functionality for proxying of the Shell OSD Functionality
 */
GType budgie_budgie_osd_get_type (void) {
	static volatile gsize budgie_budgie_osd_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_budgie_osd_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieBudgieOSDIface), (GBaseInitFunc) budgie_budgie_osd_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
		GType budgie_budgie_osd_type_id;
		budgie_budgie_osd_type_id = g_type_register_static (G_TYPE_INTERFACE, "BudgieBudgieOSD", &g_define_type_info, 0);
		g_type_interface_add_prerequisite (budgie_budgie_osd_type_id, G_TYPE_OBJECT);
		g_type_set_qdata (budgie_budgie_osd_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) budgie_budgie_osd_proxy_get_type);
		g_type_set_qdata (budgie_budgie_osd_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "com.solus_project.BudgieOSD");
		g_type_set_qdata (budgie_budgie_osd_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_budgie_budgie_osd_dbus_interface_info));
		g_type_set_qdata (budgie_budgie_osd_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_budgie_osd_register_object);
		g_once_init_leave (&budgie_budgie_osd_type_id__volatile, budgie_budgie_osd_type_id);
	}
	return budgie_budgie_osd_type_id__volatile;
}


G_DEFINE_TYPE_EXTENDED (BudgieBudgieOSDProxy, budgie_budgie_osd_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE (BUDGIE_TYPE_BUDGIE_OSD, budgie_budgie_osd_proxy_budgie_budgie_osd_interface_init) )
static void budgie_budgie_osd_proxy_class_init (BudgieBudgieOSDProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = budgie_budgie_osd_proxy_g_signal;
}


static void budgie_budgie_osd_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void budgie_budgie_osd_proxy_init (BudgieBudgieOSDProxy* self) {
}


static void _vala_g_async_ready_callback (GObject *source_object, GAsyncResult *res, void *user_data) {
	g_simple_async_result_set_op_res_gpointer (user_data, g_object_ref (res), g_object_unref);
	g_simple_async_result_complete (user_data);
	g_object_unref (user_data);
}


static void budgie_budgie_osd_proxy_ShowOSD_async (BudgieBudgieOSD* self, GHashTable* params, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	GDBusMessage *_message;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp17_;
	GHashTableIter _tmp18_;
	gpointer _tmp19_;
	gpointer _tmp20_;
	_message = g_dbus_message_new_method_call (g_dbus_proxy_get_name ((GDBusProxy *) self), g_dbus_proxy_get_object_path ((GDBusProxy *) self), "com.solus_project.BudgieOSD", "ShowOSD");
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_hash_table_iter_init (&_tmp18_, params);
	g_variant_builder_init (&_tmp17_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp18_, &_tmp19_, &_tmp20_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp19_;
		_value = (GVariant*) _tmp20_;
		g_variant_builder_add (&_tmp17_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp17_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_message_set_body (_message, _arguments);
	g_dbus_connection_send_message_with_reply (g_dbus_proxy_get_connection ((GDBusProxy *) self), _message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, g_dbus_proxy_get_default_timeout ((GDBusProxy *) self), NULL, NULL, _vala_g_async_ready_callback, g_simple_async_result_new ((GObject *) self, _callback_, _user_data_, NULL));
	g_object_unref (_message);
}


static void budgie_budgie_osd_proxy_ShowOSD_finish (BudgieBudgieOSD* self, GAsyncResult* _res_, GError** error) {
	GDBusMessage *_reply_message;
	_reply_message = g_dbus_connection_send_message_with_reply_finish (g_dbus_proxy_get_connection ((GDBusProxy *) self), g_simple_async_result_get_op_res_gpointer ((GSimpleAsyncResult *) _res_), error);
	if (!_reply_message) {
		return;
	}
	if (g_dbus_message_to_gerror (_reply_message, error)) {
		g_object_unref (_reply_message);
		return;
	}
	g_object_unref (_reply_message);
}


static void budgie_budgie_osd_proxy_budgie_budgie_osd_interface_init (BudgieBudgieOSDIface* iface) {
	iface->ShowOSD = budgie_budgie_osd_proxy_ShowOSD_async;
	iface->ShowOSD_finish = budgie_budgie_osd_proxy_ShowOSD_finish;
}


static void _dbus_budgie_budgie_osd_ShowOSD (BudgieBudgieOSD* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GVariantIter _arguments_iter;
	GHashTable* params = NULL;
	GVariant* _tmp21_;
	GHashTable* _tmp22_;
	GVariantIter _tmp23_;
	GVariant* _tmp24_;
	GVariant* _tmp25_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp21_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp22_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp23_, _tmp21_);
	while (g_variant_iter_loop (&_tmp23_, "{?*}", &_tmp24_, &_tmp25_)) {
		g_hash_table_insert (_tmp22_, g_variant_dup_string (_tmp24_, NULL), g_variant_get_variant (_tmp25_));
	}
	params = _tmp22_;
	g_variant_unref (_tmp21_);
	budgie_budgie_osd_ShowOSD (self, params, (GAsyncReadyCallback) _dbus_budgie_budgie_osd_ShowOSD_ready, invocation);
	_g_hash_table_unref0 (params);
}


static void _dbus_budgie_budgie_osd_ShowOSD_ready (GObject * source_object, GAsyncResult * _res_, gpointer _user_data_) {
	GDBusMethodInvocation * invocation;
	GError* error = NULL;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	invocation = _user_data_;
	budgie_budgie_osd_ShowOSD_finish ((BudgieBudgieOSD*) source_object, _res_, &error);
	if (error) {
		g_dbus_method_invocation_return_gerror (invocation, error);
		return;
	}
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void budgie_budgie_osd_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "ShowOSD") == 0) {
		_dbus_budgie_budgie_osd_ShowOSD (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* budgie_budgie_osd_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean budgie_budgie_osd_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


guint budgie_budgie_osd_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_budgie_osd_dbus_interface_info), &_budgie_budgie_osd_dbus_interface_vtable, data, _budgie_budgie_osd_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _budgie_budgie_osd_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _g_free0_ (gpointer var) {
	var = (g_free (var), NULL);
}


static void _budgie_shell_shim_on_accelerator_activated_meta_display_accelerator_activated (MetaDisplay* _sender, guint object, guint p0, guint p1, gpointer self) {
	budgie_shell_shim_on_accelerator_activated ((BudgieShellShim*) self, object, p0);
}


static void _budgie_shell_shim_has_osd_proxy_gbus_name_appeared_callback (GDBusConnection* connection, const gchar* name, const gchar* name_owner, gpointer self) {
	budgie_shell_shim_has_osd_proxy ((BudgieShellShim*) self);
}


static void _budgie_shell_shim_lost_osd_proxy_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	budgie_shell_shim_lost_osd_proxy ((BudgieShellShim*) self);
}


BudgieShellShim* budgie_shell_shim_construct (GType object_type, BudgieBudgieWM* wm) {
	BudgieShellShim * self = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	GHashFunc _tmp3_ = NULL;
	GEqualFunc _tmp4_ = NULL;
	GHashTable* _tmp5_ = NULL;
	BudgieBudgieWM* _tmp6_ = NULL;
	MetaScreen* _tmp7_ = NULL;
	MetaDisplay* _tmp8_ = NULL;
	MetaDisplay* _tmp9_ = NULL;
	BudgieSessionHandler* _tmp10_ = NULL;
	self = (BudgieShellShim*) g_object_new (object_type, NULL);
	_tmp0_ = g_direct_hash;
	_tmp1_ = g_direct_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, NULL, _g_free0_);
	_g_hash_table_unref0 (self->priv->grabs);
	self->priv->grabs = _tmp2_;
	_tmp3_ = g_str_hash;
	_tmp4_ = g_str_equal;
	_tmp5_ = g_hash_table_new_full (_tmp3_, _tmp4_, _g_free0_, NULL);
	_g_hash_table_unref0 (self->priv->watches);
	self->priv->watches = _tmp5_;
	_tmp6_ = wm;
	_tmp7_ = meta_plugin_get_screen ((MetaPlugin*) _tmp6_);
	_tmp8_ = meta_screen_get_display (_tmp7_);
	self->priv->display = _tmp8_;
	_tmp9_ = self->priv->display;
	g_signal_connect_object (_tmp9_, "accelerator-activated", (GCallback) _budgie_shell_shim_on_accelerator_activated_meta_display_accelerator_activated, self, 0);
	_tmp10_ = budgie_session_handler_new ();
	_g_object_unref0 (self->priv->handler);
	self->priv->handler = _tmp10_;
	g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, "com.solus_project.BudgieOSD", G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((_budgie_shell_shim_has_osd_proxy_gbus_name_appeared_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_shell_shim_has_osd_proxy_gbus_name_appeared_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((_budgie_shell_shim_lost_osd_proxy_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_shell_shim_lost_osd_proxy_gbus_name_vanished_callback, g_object_ref (self), g_object_unref)));
	return self;
}


BudgieShellShim* budgie_shell_shim_new (BudgieBudgieWM* wm) {
	return budgie_shell_shim_construct (BUDGIE_TYPE_SHELL_SHIM, wm);
}


/**
     * BudgieOSD known to be present, now try to get the proxy
     */
static void budgie_shell_shim_on_osd_proxy_get (BudgieShellShim* self, GObject* o, GAsyncResult* res) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		BudgieBudgieOSD* _tmp0_ = NULL;
		GAsyncResult* _tmp1_ = NULL;
		BudgieBudgieOSD* _tmp2_ = NULL;
		BudgieBudgieOSD* _tmp3_ = NULL;
		BudgieBudgieOSD* _tmp4_ = NULL;
		_tmp1_ = res;
		_tmp2_ = g_async_result_get_source_object (_tmp1_);
		_tmp3_ = g_async_initable_new_finish (_tmp2_, _tmp1_, &_inner_error_);
		g_object_unref (_tmp2_);
		_tmp0_ = (BudgieBudgieOSD*) _tmp3_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch7_g_error;
		}
		_tmp4_ = _tmp0_;
		_tmp0_ = NULL;
		_g_object_unref0 (self->priv->osd_proxy);
		self->priv->osd_proxy = _tmp4_;
		_g_object_unref0 (_tmp0_);
	}
	goto __finally7;
	__catch7_g_error:
	{
		GError* e = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_g_object_unref0 (self->priv->osd_proxy);
		self->priv->osd_proxy = NULL;
		_g_error_free0 (e);
	}
	__finally7:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


/**
     * BudgieOSD appeared, schedule a proxy-get
     */
static void _budgie_shell_shim_on_osd_proxy_get_gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	budgie_shell_shim_on_osd_proxy_get ((BudgieShellShim*) self, source_object, res);
	g_object_unref (self);
}


static void budgie_shell_shim_has_osd_proxy (BudgieShellShim* self) {
	BudgieBudgieOSD* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->osd_proxy;
	if (_tmp0_ != NULL) {
		return;
	}
	g_async_initable_new_async (BUDGIE_TYPE_BUDGIE_OSD_PROXY, 0, NULL, _budgie_shell_shim_on_osd_proxy_get_gasync_ready_callback, g_object_ref (self), "g-flags", 0, "g-name", "com.solus_project.BudgieOSD", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/com/solus_project/BudgieOSD", "g-interface-name", "com.solus_project.BudgieOSD", "g-interface-info", g_type_get_qdata (BUDGIE_TYPE_BUDGIE_OSD, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
}


/**
     * BudgieOSD disappeared, drop the reference
     */
static void budgie_shell_shim_lost_osd_proxy (BudgieShellShim* self) {
	g_return_if_fail (self != NULL);
	_g_object_unref0 (self->priv->osd_proxy);
	self->priv->osd_proxy = NULL;
}


static void _g_variant_unref0_ (gpointer var) {
	(var == NULL) ? NULL : (var = (g_variant_unref (var), NULL));
}


static GVariant* _variant_new1 (guint value) {
	return g_variant_ref_sink (g_variant_new_uint32 (value));
}


static void budgie_shell_shim_on_accelerator_activated (BudgieShellShim* self, guint action, guint device_id) {
	GHashTable* params = NULL;
	GHashFunc _tmp0_ = NULL;
	GEqualFunc _tmp1_ = NULL;
	GHashTable* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	guint _tmp4_ = 0U;
	GVariant* _tmp5_ = NULL;
	gchar* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	gchar* _tmp8_ = NULL;
	GVariant* _tmp9_ = NULL;
	guint _tmp10_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_str_hash;
	_tmp1_ = g_str_equal;
	_tmp2_ = g_hash_table_new_full (_tmp0_, _tmp1_, _g_free0_, _g_variant_unref0_);
	params = _tmp2_;
	_tmp3_ = g_strdup ("device-id");
	_tmp4_ = device_id;
	_tmp5_ = _variant_new1 (_tmp4_);
	g_hash_table_insert (params, _tmp3_, _tmp5_);
	_tmp6_ = g_strdup ("timestamp");
	_tmp7_ = g_variant_new_uint32 ((guint32) 0);
	g_variant_ref_sink (_tmp7_);
	g_hash_table_insert (params, _tmp6_, _tmp7_);
	_tmp8_ = g_strdup ("action-mode");
	_tmp9_ = g_variant_new_uint32 ((guint32) 0);
	g_variant_ref_sink (_tmp9_);
	g_hash_table_insert (params, _tmp8_, _tmp9_);
	_tmp10_ = action;
	g_signal_emit_by_name (self, "accelerator-activated", _tmp10_, params);
	_g_hash_table_unref0 (params);
}


static void budgie_shell_shim_on_disappeared (BudgieShellShim* self, GDBusConnection* conn, const gchar* name) {
	const gchar* val = NULL;
	guint key = 0U;
	GHashTable* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	guint id = 0U;
	GHashTable* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gconstpointer _tmp5_ = NULL;
	guint _tmp6_ = 0U;
	GHashTableIter iter = {0};
	GHashTable* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	g_return_if_fail (name != NULL);
	_tmp0_ = self->priv->watches;
	_tmp1_ = name;
	_tmp2_ = g_hash_table_contains (_tmp0_, _tmp1_);
	if (!_tmp2_) {
		return;
	}
	_tmp3_ = self->priv->watches;
	_tmp4_ = name;
	_tmp5_ = g_hash_table_lookup (_tmp3_, _tmp4_);
	id = (guint) ((guintptr) _tmp5_);
	_tmp6_ = id;
	g_bus_unwatch_name (_tmp6_);
	_tmp7_ = self->priv->grabs;
	g_hash_table_iter_init (&iter, _tmp7_);
	while (TRUE) {
		gconstpointer _tmp8_ = NULL;
		gconstpointer _tmp9_ = NULL;
		gboolean _tmp10_ = FALSE;
		const gchar* _tmp11_ = NULL;
		const gchar* _tmp12_ = NULL;
		MetaDisplay* _tmp13_ = NULL;
		guint _tmp14_ = 0U;
		GHashTable* _tmp15_ = NULL;
		guint _tmp16_ = 0U;
		_tmp10_ = g_hash_table_iter_next (&iter, (gpointer*) (&_tmp8_), (gpointer*) (&_tmp9_));
		key = _tmp8_;
		val = _tmp9_;
		if (!_tmp10_) {
			break;
		}
		_tmp11_ = val;
		_tmp12_ = name;
		if (g_strcmp0 (_tmp11_, _tmp12_) != 0) {
			continue;
		}
		_tmp13_ = self->priv->display;
		_tmp14_ = key;
		meta_display_ungrab_accelerator (_tmp13_, _tmp14_);
		_tmp15_ = self->priv->grabs;
		_tmp16_ = key;
		g_hash_table_remove (_tmp15_, (gpointer) ((guintptr) _tmp16_));
	}
}


static void _budgie_shell_shim_on_disappeared_gbus_name_vanished_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	budgie_shell_shim_on_disappeared ((BudgieShellShim*) self, connection, name);
}


static guint _budgie_shell_shim_grab (BudgieShellShim* self, const gchar* sender, const gchar* seq, guint flag) {
	guint result = 0U;
	guint ret = 0U;
	MetaDisplay* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	GHashTable* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	const gchar* _tmp6_ = NULL;
	gchar* _tmp7_ = NULL;
	GHashTable* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (sender != NULL, 0U);
	g_return_val_if_fail (seq != NULL, 0U);
	_tmp0_ = self->priv->display;
	_tmp1_ = seq;
	_tmp2_ = meta_display_grab_accelerator (_tmp0_, _tmp1_);
	ret = _tmp2_;
	_tmp3_ = ret;
	if (_tmp3_ == ((guint) META_KEYBINDING_ACTION_NONE)) {
		result = ret;
		return result;
	}
	_tmp4_ = self->priv->grabs;
	_tmp5_ = ret;
	_tmp6_ = sender;
	_tmp7_ = g_strdup (_tmp6_);
	g_hash_table_insert (_tmp4_, (gpointer) ((guintptr) _tmp5_), _tmp7_);
	_tmp8_ = self->priv->watches;
	_tmp9_ = sender;
	_tmp10_ = g_hash_table_contains (_tmp8_, _tmp9_);
	if (!_tmp10_) {
		guint id = 0U;
		const gchar* _tmp11_ = NULL;
		guint _tmp12_ = 0U;
		GHashTable* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		guint _tmp16_ = 0U;
		_tmp11_ = sender;
		_tmp12_ = g_bus_watch_name_with_closures (G_BUS_TYPE_SESSION, _tmp11_, G_BUS_NAME_WATCHER_FLAGS_NONE, (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((_budgie_shell_shim_on_disappeared_gbus_name_vanished_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_shell_shim_on_disappeared_gbus_name_vanished_callback, g_object_ref (self), g_object_unref)));
		id = _tmp12_;
		_tmp13_ = self->priv->watches;
		_tmp14_ = sender;
		_tmp15_ = g_strdup (_tmp14_);
		_tmp16_ = id;
		g_hash_table_insert (_tmp13_, _tmp15_, (gpointer) ((guintptr) _tmp16_));
	}
	result = ret;
	return result;
}


static void budgie_shell_shim_on_bus_acquired (BudgieShellShim* self, GDBusConnection* conn) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (conn != NULL);
	{
		GDBusConnection* _tmp0_ = NULL;
		GDBusConnection* _tmp1_ = NULL;
		BudgieSessionHandler* _tmp2_ = NULL;
		_tmp0_ = conn;
		budgie_shell_shim_register_object (self, _tmp0_, "/org/gnome/Shell", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
		_tmp1_ = conn;
		_tmp2_ = self->priv->handler;
		budgie_session_handler_register_object (_tmp2_, _tmp1_, "/org/gnome/SessionManager/EndSessionDialog", &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch8_g_error;
		}
	}
	goto __finally8;
	__catch8_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_message ("shim.vala:252: Unable to register ShellShim: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally8:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void _budgie_shell_shim_on_bus_acquired_gbus_acquired_callback (GDBusConnection* connection, const gchar* name, gpointer self) {
	budgie_shell_shim_on_bus_acquired ((BudgieShellShim*) self, connection);
}


void budgie_shell_shim_serve (BudgieShellShim* self) {
	g_return_if_fail (self != NULL);
	g_bus_own_name_with_closures (G_BUS_TYPE_SESSION, "org.gnome.Shell", G_BUS_NAME_OWNER_FLAGS_ALLOW_REPLACEMENT | G_BUS_NAME_OWNER_FLAGS_REPLACE, (GClosure*) ((_budgie_shell_shim_on_bus_acquired_gbus_acquired_callback == NULL) ? NULL : g_cclosure_new ((GCallback) _budgie_shell_shim_on_bus_acquired_gbus_acquired_callback, g_object_ref (self), g_object_unref)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)), (GClosure*) ((NULL == NULL) ? NULL : g_cclosure_new ((GCallback) NULL, NULL, NULL)));
}


guint budgie_shell_shim_GrabAccelerator (BudgieShellShim* self, const char* sender, const gchar* accelerator, guint flags) {
	guint result = 0U;
	const char* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	g_return_val_if_fail (self != NULL, 0U);
	g_return_val_if_fail (sender != NULL, 0U);
	g_return_val_if_fail (accelerator != NULL, 0U);
	_tmp0_ = sender;
	_tmp1_ = accelerator;
	_tmp2_ = flags;
	_tmp3_ = _budgie_shell_shim_grab (self, (const gchar*) _tmp0_, _tmp1_, _tmp2_);
	result = _tmp3_;
	return result;
}


static void _vala_array_add3 (guint** array, int* length, int* size, guint value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (guint, *array, *size);
	}
	(*array)[(*length)++] = value;
}


guint* budgie_shell_shim_GrabAccelerators (BudgieShellShim* self, const char* sender, BudgieGsdAccel* accelerators, int accelerators_length1, int* result_length1) {
	guint* result = NULL;
	guint* t = NULL;
	guint* _tmp0_ = NULL;
	gint t_length1 = 0;
	gint _t_size_ = 0;
	BudgieGsdAccel* _tmp1_ = NULL;
	gint _tmp1__length1 = 0;
	guint* _tmp10_ = NULL;
	gint _tmp10__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	g_return_val_if_fail (sender != NULL, NULL);
	_tmp0_ = g_new0 (guint, 0);
	t = _tmp0_;
	t_length1 = 0;
	_t_size_ = t_length1;
	_tmp1_ = accelerators;
	_tmp1__length1 = accelerators_length1;
	{
		BudgieGsdAccel* a_collection = NULL;
		gint a_collection_length1 = 0;
		gint _a_collection_size_ = 0;
		gint a_it = 0;
		a_collection = _tmp1_;
		a_collection_length1 = _tmp1__length1;
		for (a_it = 0; a_it < _tmp1__length1; a_it = a_it + 1) {
			BudgieGsdAccel _tmp2_ = {0};
			BudgieGsdAccel a = {0};
			budgie_gsd_accel_copy (&a_collection[a_it], &_tmp2_);
			a = _tmp2_;
			{
				guint* _tmp3_ = NULL;
				gint _tmp3__length1 = 0;
				const char* _tmp4_ = NULL;
				BudgieGsdAccel _tmp5_ = {0};
				const gchar* _tmp6_ = NULL;
				BudgieGsdAccel _tmp7_ = {0};
				guint _tmp8_ = 0U;
				guint _tmp9_ = 0U;
				_tmp3_ = t;
				_tmp3__length1 = t_length1;
				_tmp4_ = sender;
				_tmp5_ = a;
				_tmp6_ = _tmp5_.accelerator;
				_tmp7_ = a;
				_tmp8_ = _tmp7_.flags;
				_tmp9_ = _budgie_shell_shim_grab (self, (const gchar*) _tmp4_, _tmp6_, _tmp8_);
				_vala_array_add3 (&t, &t_length1, &_t_size_, _tmp9_);
				budgie_gsd_accel_destroy (&a);
			}
		}
	}
	_tmp10_ = t;
	_tmp10__length1 = t_length1;
	if (result_length1) {
		*result_length1 = _tmp10__length1;
	}
	result = _tmp10_;
	return result;
}


gboolean budgie_shell_shim_ungrab_accelerator (BudgieShellShim* self, const char* sender, guint action) {
	gboolean result = FALSE;
	MetaDisplay* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (sender != NULL, FALSE);
	_tmp0_ = self->priv->display;
	_tmp1_ = action;
	_tmp2_ = meta_display_ungrab_accelerator (_tmp0_, _tmp1_);
	if (_tmp2_) {
		GHashTable* _tmp3_ = NULL;
		guint _tmp4_ = 0U;
		_tmp3_ = self->priv->grabs;
		_tmp4_ = action;
		g_hash_table_remove (_tmp3_, (gpointer) ((guintptr) _tmp4_));
		result = TRUE;
		return result;
	}
	result = FALSE;
	return result;
}


/**
     * Show the OSD when requested.
     */
void budgie_shell_shim_ShowOSD (BudgieShellShim* self, GHashTable* params) {
	BudgieBudgieOSD* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (params != NULL);
	_tmp0_ = self->priv->osd_proxy;
	if (_tmp0_ != NULL) {
		BudgieBudgieOSD* _tmp1_ = NULL;
		GHashTable* _tmp2_ = NULL;
		_tmp1_ = self->priv->osd_proxy;
		_tmp2_ = params;
		budgie_budgie_osd_ShowOSD (_tmp1_, _tmp2_, NULL, NULL);
	}
}


static void g_cclosure_user_marshal_VOID__UINT_BOXED (GClosure * closure, GValue * return_value, guint n_param_values, const GValue * param_values, gpointer invocation_hint, gpointer marshal_data) {
	typedef void (*GMarshalFunc_VOID__UINT_BOXED) (gpointer data1, guint arg_1, gpointer arg_2, gpointer data2);
	register GMarshalFunc_VOID__UINT_BOXED callback;
	register GCClosure * cc;
	register gpointer data1;
	register gpointer data2;
	cc = (GCClosure *) closure;
	g_return_if_fail (n_param_values == 3);
	if (G_CCLOSURE_SWAP_DATA (closure)) {
		data1 = closure->data;
		data2 = param_values->data[0].v_pointer;
	} else {
		data1 = param_values->data[0].v_pointer;
		data2 = closure->data;
	}
	callback = (GMarshalFunc_VOID__UINT_BOXED) (marshal_data ? marshal_data : cc->callback);
	callback (data1, g_value_get_uint (param_values + 1), g_value_get_boxed (param_values + 2), data2);
}


static void budgie_shell_shim_class_init (BudgieShellShimClass * klass) {
	budgie_shell_shim_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieShellShimPrivate));
	G_OBJECT_CLASS (klass)->finalize = budgie_shell_shim_finalize;
	g_signal_new ("accelerator_activated", BUDGIE_TYPE_SHELL_SHIM, G_SIGNAL_RUN_LAST, 0, NULL, NULL, g_cclosure_user_marshal_VOID__UINT_BOXED, G_TYPE_NONE, 2, G_TYPE_UINT, G_TYPE_HASH_TABLE);
}


static void budgie_shell_shim_instance_init (BudgieShellShim * self) {
	self->priv = BUDGIE_SHELL_SHIM_GET_PRIVATE (self);
	self->priv->handler = NULL;
	self->priv->osd_proxy = NULL;
}


static void budgie_shell_shim_finalize (GObject* obj) {
	BudgieShellShim * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_SHELL_SHIM, BudgieShellShim);
	_g_hash_table_unref0 (self->priv->grabs);
	_g_hash_table_unref0 (self->priv->watches);
	_g_object_unref0 (self->priv->handler);
	_g_object_unref0 (self->priv->osd_proxy);
	G_OBJECT_CLASS (budgie_shell_shim_parent_class)->finalize (obj);
}


GType budgie_shell_shim_get_type (void) {
	static volatile gsize budgie_shell_shim_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_shell_shim_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieShellShimClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_shell_shim_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieShellShim), 0, (GInstanceInitFunc) budgie_shell_shim_instance_init, NULL };
		GType budgie_shell_shim_type_id;
		budgie_shell_shim_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieShellShim", &g_define_type_info, 0);
		g_type_set_qdata (budgie_shell_shim_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) budgie_shell_shim_register_object);
		g_once_init_leave (&budgie_shell_shim_type_id__volatile, budgie_shell_shim_type_id);
	}
	return budgie_shell_shim_type_id__volatile;
}


static void _dbus_budgie_shell_shim_GrabAccelerator (BudgieShellShim* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	gchar* accelerator = NULL;
	GVariant* _tmp26_;
	guint flags = 0U;
	GVariant* _tmp27_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp26_ = g_variant_iter_next_value (&_arguments_iter);
	accelerator = g_variant_dup_string (_tmp26_, NULL);
	g_variant_unref (_tmp26_);
	_tmp27_ = g_variant_iter_next_value (&_arguments_iter);
	flags = g_variant_get_uint32 (_tmp27_);
	g_variant_unref (_tmp27_);
	result = budgie_shell_shim_GrabAccelerator (self, g_dbus_method_invocation_get_sender (invocation), accelerator, flags);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_uint32 (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_free0 (accelerator);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _vala_BudgieGsdAccel_array_free (BudgieGsdAccel* array, gint array_length) {
	if (array != NULL) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			budgie_gsd_accel_destroy (&array[i]);
		}
	}
	g_free (array);
}


static void _dbus_budgie_shell_shim_GrabAccelerators (BudgieShellShim* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	BudgieGsdAccel* accelerators = NULL;
	int accelerators_length1 = 0;
	GVariant* _tmp28_;
	BudgieGsdAccel* _tmp29_;
	int _tmp29__length;
	int _tmp29__size;
	int _tmp29__length1;
	GVariantIter _tmp30_;
	GVariant* _tmp31_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	guint* result;
	int result_length1 = 0;
	guint* _tmp36_;
	GVariantBuilder _tmp37_;
	int _tmp38_;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp28_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp29_ = g_new (BudgieGsdAccel, 5);
	_tmp29__length = 0;
	_tmp29__size = 4;
	_tmp29__length1 = 0;
	g_variant_iter_init (&_tmp30_, _tmp28_);
	for (; (_tmp31_ = g_variant_iter_next_value (&_tmp30_)) != NULL; _tmp29__length1++) {
		BudgieGsdAccel _tmp32_;
		GVariantIter _tmp33_;
		GVariant* _tmp34_;
		GVariant* _tmp35_;
		if (_tmp29__size == _tmp29__length) {
			_tmp29__size = 2 * _tmp29__size;
			_tmp29_ = g_renew (BudgieGsdAccel, _tmp29_, _tmp29__size + 1);
		}
		g_variant_iter_init (&_tmp33_, _tmp31_);
		_tmp34_ = g_variant_iter_next_value (&_tmp33_);
		_tmp32_.accelerator = g_variant_dup_string (_tmp34_, NULL);
		g_variant_unref (_tmp34_);
		_tmp35_ = g_variant_iter_next_value (&_tmp33_);
		_tmp32_.flags = g_variant_get_uint32 (_tmp35_);
		g_variant_unref (_tmp35_);
		_tmp29_[_tmp29__length++] = _tmp32_;
		g_variant_unref (_tmp31_);
	}
	accelerators_length1 = _tmp29__length1;
	accelerators = _tmp29_;
	g_variant_unref (_tmp28_);
	result = budgie_shell_shim_GrabAccelerators (self, g_dbus_method_invocation_get_sender (invocation), accelerators, accelerators_length1, &result_length1);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_tmp36_ = result;
	g_variant_builder_init (&_tmp37_, G_VARIANT_TYPE ("au"));
	for (_tmp38_ = 0; _tmp38_ < result_length1; _tmp38_++) {
		g_variant_builder_add_value (&_tmp37_, g_variant_new_uint32 (*_tmp36_));
		_tmp36_++;
	}
	g_variant_builder_add_value (&_reply_builder, g_variant_builder_end (&_tmp37_));
	result = (g_free (result), NULL);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	accelerators = (_vala_BudgieGsdAccel_array_free (accelerators, accelerators_length1), NULL);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_budgie_shell_shim_ungrab_accelerator (BudgieShellShim* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	guint action = 0U;
	GVariant* _tmp39_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	gboolean result;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp39_ = g_variant_iter_next_value (&_arguments_iter);
	action = g_variant_get_uint32 (_tmp39_);
	g_variant_unref (_tmp39_);
	result = budgie_shell_shim_ungrab_accelerator (self, g_dbus_method_invocation_get_sender (invocation), action);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_reply_builder, g_variant_new_boolean (result));
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void _dbus_budgie_shell_shim_ShowOSD (BudgieShellShim* self, GVariant* _parameters_, GDBusMethodInvocation* invocation) {
	GError* error = NULL;
	GVariantIter _arguments_iter;
	GHashTable* params = NULL;
	GVariant* _tmp40_;
	GHashTable* _tmp41_;
	GVariantIter _tmp42_;
	GVariant* _tmp43_;
	GVariant* _tmp44_;
	GDBusMessage* _reply_message;
	GVariant* _reply;
	GVariantBuilder _reply_builder;
	g_variant_iter_init (&_arguments_iter, _parameters_);
	_tmp40_ = g_variant_iter_next_value (&_arguments_iter);
	_tmp41_ = g_hash_table_new_full (g_str_hash, g_str_equal, g_free, (GDestroyNotify) g_variant_unref);
	g_variant_iter_init (&_tmp42_, _tmp40_);
	while (g_variant_iter_loop (&_tmp42_, "{?*}", &_tmp43_, &_tmp44_)) {
		g_hash_table_insert (_tmp41_, g_variant_dup_string (_tmp43_, NULL), g_variant_get_variant (_tmp44_));
	}
	params = _tmp41_;
	g_variant_unref (_tmp40_);
	budgie_shell_shim_ShowOSD (self, params);
	_reply_message = g_dbus_message_new_method_reply (g_dbus_method_invocation_get_message (invocation));
	g_variant_builder_init (&_reply_builder, G_VARIANT_TYPE_TUPLE);
	_reply = g_variant_builder_end (&_reply_builder);
	g_dbus_message_set_body (_reply_message, _reply);
	_g_hash_table_unref0 (params);
	g_dbus_connection_send_message (g_dbus_method_invocation_get_connection (invocation), _reply_message, G_DBUS_SEND_MESSAGE_FLAGS_NONE, NULL, NULL);
	g_object_unref (invocation);
	g_object_unref (_reply_message);
}


static void budgie_shell_shim_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (method_name, "GrabAccelerator") == 0) {
		_dbus_budgie_shell_shim_GrabAccelerator (object, parameters, invocation);
	} else if (strcmp (method_name, "GrabAccelerators") == 0) {
		_dbus_budgie_shell_shim_GrabAccelerators (object, parameters, invocation);
	} else if (strcmp (method_name, "UngrabAccelerator") == 0) {
		_dbus_budgie_shell_shim_ungrab_accelerator (object, parameters, invocation);
	} else if (strcmp (method_name, "ShowOSD") == 0) {
		_dbus_budgie_shell_shim_ShowOSD (object, parameters, invocation);
	} else {
		g_object_unref (invocation);
	}
}


static GVariant* budgie_shell_shim_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return NULL;
}


static gboolean budgie_shell_shim_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	return FALSE;
}


static void _dbus_budgie_shell_shim_accelerator_activated (GObject* _sender, guint action, GHashTable* parameters, gpointer* _data) {
	GDBusConnection * _connection;
	const gchar * _path;
	GVariant *_arguments;
	GVariantBuilder _arguments_builder;
	GVariantBuilder _tmp45_;
	GHashTableIter _tmp46_;
	gpointer _tmp47_;
	gpointer _tmp48_;
	_connection = _data[1];
	_path = _data[2];
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_uint32 (action));
	g_hash_table_iter_init (&_tmp46_, parameters);
	g_variant_builder_init (&_tmp45_, G_VARIANT_TYPE ("a{sv}"));
	while (g_hash_table_iter_next (&_tmp46_, &_tmp47_, &_tmp48_)) {
		gchar* _key;
		GVariant* _value;
		_key = (gchar*) _tmp47_;
		_value = (GVariant*) _tmp48_;
		g_variant_builder_add (&_tmp45_, "{?*}", g_variant_new_string (_key), g_variant_new_variant (_value));
	}
	g_variant_builder_add_value (&_arguments_builder, g_variant_builder_end (&_tmp45_));
	_arguments = g_variant_builder_end (&_arguments_builder);
	g_dbus_connection_emit_signal (_connection, NULL, _path, "org.gnome.Shell", "AcceleratorActivated", _arguments, NULL);
}


guint budgie_shell_shim_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_budgie_shell_shim_dbus_interface_info), &_budgie_shell_shim_dbus_interface_vtable, data, _budgie_shell_shim_unregister_object, error);
	if (!result) {
		return 0;
	}
	g_signal_connect (object, "accelerator-activated", (GCallback) _dbus_budgie_shell_shim_accelerator_activated, data);
	return result;
}


static void _budgie_shell_shim_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_signal_handlers_disconnect_by_func (data[0], _dbus_budgie_shell_shim_accelerator_activated, data);
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}



