/* keyboard.c generated by valac 0.32.1, the Vala compiler
 * generated from keyboard.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * Copyright (C) GNOME Shell Developers (Heavy inspiration, logic theft)
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <ibus.h>
#include <meta/meta-plugin.h>
#include <libgnome-desktop/gnome-bg-crossfade.h>
#include <libgnome-desktop/gnome-bg-slide-show.h>
#include <libgnome-desktop/gnome-bg.h>
#include <libgnome-desktop/gnome-desktop-thumbnail.h>
#include <libgnome-desktop/gnome-idle-monitor.h>
#include <libgnome-desktop/gnome-languages.h>
#include <libgnome-desktop/gnome-pnp-ids.h>
#include <libgnome-desktop/gnome-rr-config.h>
#include <libgnome-desktop/gnome-rr.h>
#include <libgnome-desktop/gnome-wall-clock.h>
#include <libgnome-desktop/gnome-xkb-info.h>
#include <gio/gio.h>
#include <meta/display.h>
#include <meta/screen.h>
#include <meta/window.h>
#include <clutter/clutter.h>
#include <meta/keybindings.h>
#include <meta/prefs.h>
#include <meta/meta-backend.h>
#include <meta/main.h>
#include <gobject/gvaluecollector.h>


#define BUDGIE_TYPE_INPUT_SOURCE (budgie_input_source_get_type ())
#define BUDGIE_INPUT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_INPUT_SOURCE, BudgieInputSource))
#define BUDGIE_INPUT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_INPUT_SOURCE, BudgieInputSourceClass))
#define BUDGIE_IS_INPUT_SOURCE(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_INPUT_SOURCE))
#define BUDGIE_IS_INPUT_SOURCE_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_INPUT_SOURCE))
#define BUDGIE_INPUT_SOURCE_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_INPUT_SOURCE, BudgieInputSourceClass))

typedef struct _BudgieInputSource BudgieInputSource;
typedef struct _BudgieInputSourceClass BudgieInputSourceClass;
typedef struct _BudgieInputSourcePrivate BudgieInputSourcePrivate;
#define _g_free0(var) (var = (g_free (var), NULL))

#define BUDGIE_TYPE_IBUS_MANAGER (budgie_ibus_manager_get_type ())
#define BUDGIE_IBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManager))
#define BUDGIE_IBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManagerClass))
#define BUDGIE_IS_IBUS_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_IBUS_MANAGER))
#define BUDGIE_IS_IBUS_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_IBUS_MANAGER))
#define BUDGIE_IBUS_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_IBUS_MANAGER, BudgieIBusManagerClass))

typedef struct _BudgieIBusManager BudgieIBusManager;
typedef struct _BudgieIBusManagerClass BudgieIBusManagerClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _budgie_input_source_unref0(var) ((var == NULL) ? NULL : (var = (budgie_input_source_unref (var), NULL)))
typedef struct _BudgieParamSpecInputSource BudgieParamSpecInputSource;

#define BUDGIE_TYPE_KEYBOARD_MANAGER (budgie_keyboard_manager_get_type ())
#define BUDGIE_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManager))
#define BUDGIE_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManagerClass))
#define BUDGIE_IS_KEYBOARD_MANAGER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER))
#define BUDGIE_IS_KEYBOARD_MANAGER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_KEYBOARD_MANAGER))
#define BUDGIE_KEYBOARD_MANAGER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManagerClass))

typedef struct _BudgieKeyboardManager BudgieKeyboardManager;
typedef struct _BudgieKeyboardManagerClass BudgieKeyboardManagerClass;
typedef struct _BudgieKeyboardManagerPrivate BudgieKeyboardManagerPrivate;

#define BUDGIE_TYPE_BUDGIE_WM (budgie_budgie_wm_get_type ())
#define BUDGIE_BUDGIE_WM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWM))
#define BUDGIE_BUDGIE_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWMClass))
#define BUDGIE_IS_BUDGIE_WM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), BUDGIE_TYPE_BUDGIE_WM))
#define BUDGIE_IS_BUDGIE_WM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), BUDGIE_TYPE_BUDGIE_WM))
#define BUDGIE_BUDGIE_WM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), BUDGIE_TYPE_BUDGIE_WM, BudgieBudgieWMClass))

typedef struct _BudgieBudgieWM BudgieBudgieWM;
typedef struct _BudgieBudgieWMClass BudgieBudgieWMClass;
#define _g_array_unref0(var) ((var == NULL) ? NULL : (var = (g_array_unref (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

typedef enum  {
	BUDGIE_INPUT_METHOD_ERROR_UNKNOWN_IME
} BudgieInputMethodError;
#define BUDGIE_INPUT_METHOD_ERROR budgie_input_method_error_quark ()
struct _BudgieInputSource {
	GTypeInstance parent_instance;
	volatile int ref_count;
	BudgieInputSourcePrivate * priv;
	gboolean xkb;
	gchar* layout;
	gchar* variant;
	guint idx;
	gchar* ibus_engine;
};

struct _BudgieInputSourceClass {
	GTypeClass parent_class;
	void (*finalize) (BudgieInputSource *self);
};

struct _BudgieParamSpecInputSource {
	GParamSpec parent_instance;
};

struct _BudgieKeyboardManager {
	GObject parent_instance;
	BudgieKeyboardManagerPrivate * priv;
};

struct _BudgieKeyboardManagerClass {
	GObjectClass parent_class;
};

struct _BudgieKeyboardManagerPrivate {
	BudgieBudgieWM* _wm;
	GnomeXkbInfo* xkb;
	gchar** options;
	gint options_length1;
	gint _options_size_;
	GSettings* settings;
	GArray* sources;
	BudgieInputSource* fallback;
	guint current_source;
	gulong sig_id;
	BudgieIBusManager* ibus_manager;
	gboolean is_keyboard_held;
};

typedef void (*BudgieKeyboardManagerKeyHandlerFunc) (MetaDisplay* display, MetaScreen* screen, MetaWindow* window, ClutterKeyEvent* event, MetaKeyBinding* binding, void* user_data);

static gpointer budgie_input_source_parent_class = NULL;
static gpointer budgie_keyboard_manager_parent_class = NULL;

#define BUDGIE_DEFAULT_LOCALE "en_US"
#define BUDGIE_DEFAULT_LAYOUT "us"
#define BUDGIE_DEFAULT_VARIANT ""
#define BUDGIE_DEFAULT_ENGINE "xkb:us::eng"
GQuark budgie_input_method_error_quark (void);
gpointer budgie_input_source_ref (gpointer instance);
void budgie_input_source_unref (gpointer instance);
GParamSpec* budgie_param_spec_input_source (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags);
void budgie_value_set_input_source (GValue* value, gpointer v_object);
void budgie_value_take_input_source (GValue* value, gpointer v_object);
gpointer budgie_value_get_input_source (const GValue* value);
GType budgie_input_source_get_type (void) G_GNUC_CONST;
enum  {
	BUDGIE_INPUT_SOURCE_DUMMY_PROPERTY
};
GType budgie_ibus_manager_get_type (void) G_GNUC_CONST;
BudgieInputSource* budgie_input_source_new (BudgieIBusManager* iman, const gchar* id, guint idx, const gchar* layout, const gchar* variant, gboolean xkb, GError** error);
BudgieInputSource* budgie_input_source_construct (GType object_type, BudgieIBusManager* iman, const gchar* id, guint idx, const gchar* layout, const gchar* variant, gboolean xkb, GError** error);
IBusEngineDesc* budgie_ibus_manager_get_engine (BudgieIBusManager* self, const gchar* name);
static void budgie_input_source_finalize (BudgieInputSource* obj);
GType budgie_keyboard_manager_get_type (void) G_GNUC_CONST;
GType budgie_budgie_wm_get_type (void) G_GNUC_CONST;
#define BUDGIE_KEYBOARD_MANAGER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManagerPrivate))
enum  {
	BUDGIE_KEYBOARD_MANAGER_DUMMY_PROPERTY,
	BUDGIE_KEYBOARD_MANAGER_WM
};
BudgieKeyboardManager* budgie_keyboard_manager_new (BudgieBudgieWM* wm);
BudgieKeyboardManager* budgie_keyboard_manager_construct (GType object_type, BudgieBudgieWM* wm);
BudgieIBusManager* budgie_ibus_manager_new (BudgieKeyboardManager* kbm);
BudgieIBusManager* budgie_ibus_manager_construct (GType object_type, BudgieKeyboardManager* kbm);
static void budgie_keyboard_manager_on_ibus_ready (BudgieKeyboardManager* self);
static void _budgie_keyboard_manager_on_ibus_ready_budgie_ibus_manager_ready (BudgieIBusManager* _sender, gpointer self);
void budgie_ibus_manager_do_init (BudgieIBusManager* self);
static void budgie_keyboard_manager_on_current_source_changed (BudgieKeyboardManager* self);
static void _budgie_keyboard_manager_on_current_source_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void budgie_keyboard_manager_on_settings_changed (BudgieKeyboardManager* self, const gchar* key);
static void _budgie_keyboard_manager_on_settings_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self);
static void budgie_keyboard_manager_update_fallback (BudgieKeyboardManager* self);
static void budgie_keyboard_manager_switch_input_source (BudgieKeyboardManager* self, MetaDisplay* display, MetaScreen* screen, MetaWindow* window, ClutterKeyEvent* event, MetaKeyBinding* binding);
void budgie_keyboard_manager_hold_keyboard (BudgieKeyboardManager* self);
static void budgie_keyboard_manager_apply_layout (BudgieKeyboardManager* self, guint idx);
static void budgie_keyboard_manager_apply_ibus (BudgieKeyboardManager* self);
static void budgie_keyboard_manager_switch_input_source_backward (BudgieKeyboardManager* self, MetaDisplay* display, MetaScreen* screen, MetaWindow* window, ClutterKeyEvent* event, MetaKeyBinding* binding);
void budgie_keyboard_manager_hook_extra (BudgieKeyboardManager* self);
BudgieBudgieWM* budgie_keyboard_manager_get_wm (BudgieKeyboardManager* self);
static void _budgie_keyboard_manager_switch_input_source_meta_key_handler_func (MetaDisplay* display, MetaScreen* screen, MetaWindow* window, ClutterKeyEvent* event, MetaKeyBinding* binding, gpointer self);
static void _budgie_keyboard_manager_switch_input_source_backward_meta_key_handler_func (MetaDisplay* display, MetaScreen* screen, MetaWindow* window, ClutterKeyEvent* event, MetaKeyBinding* binding, gpointer self);
static void budgie_keyboard_manager_update_sources (BudgieKeyboardManager* self);
static void budgie_keyboard_manager_apply_layout_group (BudgieKeyboardManager* self);
static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value);
static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value);
static void budgie_keyboard_manager_write_source_index (BudgieKeyboardManager* self, guint index);
void budgie_ibus_manager_set_engine (BudgieIBusManager* self, const gchar* name);
void budgie_keyboard_manager_release_keyboard (BudgieKeyboardManager* self);
void budgie_keyboard_manager_set_wm (BudgieKeyboardManager* self, BudgieBudgieWM* value);
static void budgie_keyboard_manager_finalize (GObject* obj);
static void _vala_budgie_keyboard_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec);
static void _vala_budgie_keyboard_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec);
static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func);
static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func);
static gint _vala_array_length (gpointer array);


GQuark budgie_input_method_error_quark (void) {
	return g_quark_from_static_string ("budgie_input_method_error-quark");
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


BudgieInputSource* budgie_input_source_construct (GType object_type, BudgieIBusManager* iman, const gchar* id, guint idx, const gchar* layout, const gchar* variant, gboolean xkb, GError** error) {
	BudgieInputSource* self = NULL;
	guint _tmp0_ = 0U;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	IBusEngineDesc* engine = NULL;
	BudgieIBusManager* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	IBusEngineDesc* _tmp8_ = NULL;
	IBusEngineDesc* _tmp9_ = NULL;
	IBusEngineDesc* _tmp10_ = NULL;
	gchar* e_variant = NULL;
	IBusEngineDesc* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	const gchar* _tmp15_ = NULL;
	gchar* _tmp16_ = NULL;
	gboolean _tmp17_ = FALSE;
	const gchar* _tmp18_ = NULL;
	IBusEngineDesc* _tmp24_ = NULL;
	const gchar* _tmp25_ = NULL;
	const gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	const gchar* _tmp28_ = NULL;
	gchar* _tmp29_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_val_if_fail (id != NULL, NULL);
	self = (BudgieInputSource*) g_type_create_instance (object_type);
	_tmp0_ = idx;
	self->idx = _tmp0_;
	_tmp1_ = layout;
	_tmp2_ = g_strdup (_tmp1_);
	_g_free0 (self->layout);
	self->layout = _tmp2_;
	_tmp3_ = variant;
	_tmp4_ = g_strdup (_tmp3_);
	_g_free0 (self->variant);
	self->variant = _tmp4_;
	_tmp5_ = xkb;
	self->xkb = _tmp5_;
	_tmp6_ = iman;
	_tmp7_ = id;
	_tmp8_ = budgie_ibus_manager_get_engine (_tmp6_, _tmp7_);
	_tmp9_ = _g_object_ref0 (_tmp8_);
	engine = _tmp9_;
	_tmp10_ = engine;
	if (_tmp10_ == NULL) {
		gboolean _tmp11_ = FALSE;
		_tmp11_ = xkb;
		if (!_tmp11_) {
			GError* _tmp12_ = NULL;
			_tmp12_ = g_error_new_literal (BUDGIE_INPUT_METHOD_ERROR, BUDGIE_INPUT_METHOD_ERROR_UNKNOWN_IME, "Unknown input method: id");
			_inner_error_ = _tmp12_;
			g_propagate_error (error, _inner_error_);
			_g_object_unref0 (engine);
			_budgie_input_source_unref0 (self);
			return NULL;
		}
		_g_object_unref0 (engine);
		return self;
	}
	_tmp13_ = engine;
	_tmp14_ = ibus_engine_desc_get_layout_variant (_tmp13_);
	_tmp15_ = _tmp14_;
	_tmp16_ = g_strdup (_tmp15_);
	e_variant = _tmp16_;
	_tmp18_ = e_variant;
	if (_tmp18_ != NULL) {
		const gchar* _tmp19_ = NULL;
		gint _tmp20_ = 0;
		gint _tmp21_ = 0;
		_tmp19_ = e_variant;
		_tmp20_ = strlen (_tmp19_);
		_tmp21_ = _tmp20_;
		_tmp17_ = _tmp21_ > 0;
	} else {
		_tmp17_ = FALSE;
	}
	if (_tmp17_) {
		const gchar* _tmp22_ = NULL;
		gchar* _tmp23_ = NULL;
		_tmp22_ = e_variant;
		_tmp23_ = g_strdup (_tmp22_);
		_g_free0 (self->variant);
		self->variant = _tmp23_;
	}
	_tmp24_ = engine;
	_tmp25_ = ibus_engine_desc_get_layout (_tmp24_);
	_tmp26_ = _tmp25_;
	_tmp27_ = g_strdup (_tmp26_);
	_g_free0 (self->layout);
	self->layout = _tmp27_;
	_tmp28_ = id;
	_tmp29_ = g_strdup (_tmp28_);
	_g_free0 (self->ibus_engine);
	self->ibus_engine = _tmp29_;
	_g_free0 (e_variant);
	_g_object_unref0 (engine);
	return self;
}


BudgieInputSource* budgie_input_source_new (BudgieIBusManager* iman, const gchar* id, guint idx, const gchar* layout, const gchar* variant, gboolean xkb, GError** error) {
	return budgie_input_source_construct (BUDGIE_TYPE_INPUT_SOURCE, iman, id, idx, layout, variant, xkb, error);
}


static void budgie_value_input_source_init (GValue* value) {
	value->data[0].v_pointer = NULL;
}


static void budgie_value_input_source_free_value (GValue* value) {
	if (value->data[0].v_pointer) {
		budgie_input_source_unref (value->data[0].v_pointer);
	}
}


static void budgie_value_input_source_copy_value (const GValue* src_value, GValue* dest_value) {
	if (src_value->data[0].v_pointer) {
		dest_value->data[0].v_pointer = budgie_input_source_ref (src_value->data[0].v_pointer);
	} else {
		dest_value->data[0].v_pointer = NULL;
	}
}


static gpointer budgie_value_input_source_peek_pointer (const GValue* value) {
	return value->data[0].v_pointer;
}


static gchar* budgie_value_input_source_collect_value (GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	if (collect_values[0].v_pointer) {
		BudgieInputSource* object;
		object = collect_values[0].v_pointer;
		if (object->parent_instance.g_class == NULL) {
			return g_strconcat ("invalid unclassed object pointer for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		} else if (!g_value_type_compatible (G_TYPE_FROM_INSTANCE (object), G_VALUE_TYPE (value))) {
			return g_strconcat ("invalid object type `", g_type_name (G_TYPE_FROM_INSTANCE (object)), "' for value type `", G_VALUE_TYPE_NAME (value), "'", NULL);
		}
		value->data[0].v_pointer = budgie_input_source_ref (object);
	} else {
		value->data[0].v_pointer = NULL;
	}
	return NULL;
}


static gchar* budgie_value_input_source_lcopy_value (const GValue* value, guint n_collect_values, GTypeCValue* collect_values, guint collect_flags) {
	BudgieInputSource** object_p;
	object_p = collect_values[0].v_pointer;
	if (!object_p) {
		return g_strdup_printf ("value location for `%s' passed as NULL", G_VALUE_TYPE_NAME (value));
	}
	if (!value->data[0].v_pointer) {
		*object_p = NULL;
	} else if (collect_flags & G_VALUE_NOCOPY_CONTENTS) {
		*object_p = value->data[0].v_pointer;
	} else {
		*object_p = budgie_input_source_ref (value->data[0].v_pointer);
	}
	return NULL;
}


GParamSpec* budgie_param_spec_input_source (const gchar* name, const gchar* nick, const gchar* blurb, GType object_type, GParamFlags flags) {
	BudgieParamSpecInputSource* spec;
	g_return_val_if_fail (g_type_is_a (object_type, BUDGIE_TYPE_INPUT_SOURCE), NULL);
	spec = g_param_spec_internal (G_TYPE_PARAM_OBJECT, name, nick, blurb, flags);
	G_PARAM_SPEC (spec)->value_type = object_type;
	return G_PARAM_SPEC (spec);
}


gpointer budgie_value_get_input_source (const GValue* value) {
	g_return_val_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_INPUT_SOURCE), NULL);
	return value->data[0].v_pointer;
}


void budgie_value_set_input_source (GValue* value, gpointer v_object) {
	BudgieInputSource* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_INPUT_SOURCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_INPUT_SOURCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
		budgie_input_source_ref (value->data[0].v_pointer);
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_input_source_unref (old);
	}
}


void budgie_value_take_input_source (GValue* value, gpointer v_object) {
	BudgieInputSource* old;
	g_return_if_fail (G_TYPE_CHECK_VALUE_TYPE (value, BUDGIE_TYPE_INPUT_SOURCE));
	old = value->data[0].v_pointer;
	if (v_object) {
		g_return_if_fail (G_TYPE_CHECK_INSTANCE_TYPE (v_object, BUDGIE_TYPE_INPUT_SOURCE));
		g_return_if_fail (g_value_type_compatible (G_TYPE_FROM_INSTANCE (v_object), G_VALUE_TYPE (value)));
		value->data[0].v_pointer = v_object;
	} else {
		value->data[0].v_pointer = NULL;
	}
	if (old) {
		budgie_input_source_unref (old);
	}
}


static void budgie_input_source_class_init (BudgieInputSourceClass * klass) {
	budgie_input_source_parent_class = g_type_class_peek_parent (klass);
	((BudgieInputSourceClass *) klass)->finalize = budgie_input_source_finalize;
}


static void budgie_input_source_instance_init (BudgieInputSource * self) {
	self->xkb = FALSE;
	self->layout = NULL;
	self->variant = NULL;
	self->idx = (guint) 0;
	self->ibus_engine = NULL;
	self->ref_count = 1;
}


static void budgie_input_source_finalize (BudgieInputSource* obj) {
	BudgieInputSource * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_INPUT_SOURCE, BudgieInputSource);
	g_signal_handlers_destroy (self);
	_g_free0 (self->layout);
	_g_free0 (self->variant);
	_g_free0 (self->ibus_engine);
}


GType budgie_input_source_get_type (void) {
	static volatile gsize budgie_input_source_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_input_source_type_id__volatile)) {
		static const GTypeValueTable g_define_type_value_table = { budgie_value_input_source_init, budgie_value_input_source_free_value, budgie_value_input_source_copy_value, budgie_value_input_source_peek_pointer, "p", budgie_value_input_source_collect_value, "p", budgie_value_input_source_lcopy_value };
		static const GTypeInfo g_define_type_info = { sizeof (BudgieInputSourceClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_input_source_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieInputSource), 0, (GInstanceInitFunc) budgie_input_source_instance_init, &g_define_type_value_table };
		static const GTypeFundamentalInfo g_define_type_fundamental_info = { (G_TYPE_FLAG_CLASSED | G_TYPE_FLAG_INSTANTIATABLE | G_TYPE_FLAG_DERIVABLE | G_TYPE_FLAG_DEEP_DERIVABLE) };
		GType budgie_input_source_type_id;
		budgie_input_source_type_id = g_type_register_fundamental (g_type_fundamental_next (), "BudgieInputSource", &g_define_type_info, &g_define_type_fundamental_info, 0);
		g_once_init_leave (&budgie_input_source_type_id__volatile, budgie_input_source_type_id);
	}
	return budgie_input_source_type_id__volatile;
}


gpointer budgie_input_source_ref (gpointer instance) {
	BudgieInputSource* self;
	self = instance;
	g_atomic_int_inc (&self->ref_count);
	return instance;
}


void budgie_input_source_unref (gpointer instance) {
	BudgieInputSource* self;
	self = instance;
	if (g_atomic_int_dec_and_test (&self->ref_count)) {
		BUDGIE_INPUT_SOURCE_GET_CLASS (self)->finalize (self);
		g_type_free_instance ((GTypeInstance *) self);
	}
}


static void _budgie_keyboard_manager_on_ibus_ready_budgie_ibus_manager_ready (BudgieIBusManager* _sender, gpointer self) {
	budgie_keyboard_manager_on_ibus_ready ((BudgieKeyboardManager*) self);
}


BudgieKeyboardManager* budgie_keyboard_manager_construct (GType object_type, BudgieBudgieWM* wm) {
	BudgieKeyboardManager * self = NULL;
	BudgieBudgieWM* _tmp0_ = NULL;
	GnomeXkbInfo* _tmp1_ = NULL;
	BudgieIBusManager* _tmp2_ = NULL;
	BudgieIBusManager* _tmp3_ = NULL;
	BudgieIBusManager* _tmp4_ = NULL;
	_tmp0_ = wm;
	self = (BudgieKeyboardManager*) g_object_new (object_type, "wm", _tmp0_, NULL);
	_tmp1_ = gnome_xkb_info_new ();
	_g_object_unref0 (self->priv->xkb);
	self->priv->xkb = _tmp1_;
	_tmp2_ = budgie_ibus_manager_new (self);
	_g_object_unref0 (self->priv->ibus_manager);
	self->priv->ibus_manager = _tmp2_;
	_tmp3_ = self->priv->ibus_manager;
	g_signal_connect_object (_tmp3_, "ready", (GCallback) _budgie_keyboard_manager_on_ibus_ready_budgie_ibus_manager_ready, self, 0);
	_tmp4_ = self->priv->ibus_manager;
	budgie_ibus_manager_do_init (_tmp4_);
	return self;
}


BudgieKeyboardManager* budgie_keyboard_manager_new (BudgieBudgieWM* wm) {
	return budgie_keyboard_manager_construct (BUDGIE_TYPE_KEYBOARD_MANAGER, wm);
}


static void _budgie_keyboard_manager_on_current_source_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	budgie_keyboard_manager_on_current_source_changed ((BudgieKeyboardManager*) self);
}


static void _budgie_keyboard_manager_on_settings_changed_g_settings_changed (GSettings* _sender, const gchar* key, gpointer self) {
	budgie_keyboard_manager_on_settings_changed ((BudgieKeyboardManager*) self, key);
}


static void budgie_keyboard_manager_on_ibus_ready (BudgieKeyboardManager* self) {
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	gulong _tmp2_ = 0UL;
	GSettings* _tmp3_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_settings_new ("org.gnome.desktop.input-sources");
	_g_object_unref0 (self->priv->settings);
	self->priv->settings = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_signal_connect_object (_tmp1_, "changed::current", (GCallback) _budgie_keyboard_manager_on_current_source_changed_g_settings_changed, self, 0);
	self->priv->sig_id = _tmp2_;
	_tmp3_ = self->priv->settings;
	g_signal_connect_object (_tmp3_, "changed", (GCallback) _budgie_keyboard_manager_on_settings_changed_g_settings_changed, self, 0);
	budgie_keyboard_manager_update_fallback (self);
	budgie_keyboard_manager_on_settings_changed (self, "xkb-options");
	budgie_keyboard_manager_on_settings_changed (self, "sources");
}


static void budgie_keyboard_manager_switch_input_source (BudgieKeyboardManager* self, MetaDisplay* display, MetaScreen* screen, MetaWindow* window, ClutterKeyEvent* event, MetaKeyBinding* binding) {
	guint _tmp0_ = 0U;
	GArray* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (screen != NULL);
	g_return_if_fail (binding != NULL);
	_tmp0_ = self->priv->current_source;
	_tmp1_ = self->priv->sources;
	_tmp2_ = _tmp1_->len;
	self->priv->current_source = (_tmp0_ + 1) % _tmp2_;
	budgie_keyboard_manager_hold_keyboard (self);
	_tmp3_ = self->priv->current_source;
	budgie_keyboard_manager_apply_layout (self, _tmp3_);
	budgie_keyboard_manager_apply_ibus (self);
}


static void budgie_keyboard_manager_switch_input_source_backward (BudgieKeyboardManager* self, MetaDisplay* display, MetaScreen* screen, MetaWindow* window, ClutterKeyEvent* event, MetaKeyBinding* binding) {
	guint _tmp0_ = 0U;
	GArray* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	g_return_if_fail (self != NULL);
	g_return_if_fail (display != NULL);
	g_return_if_fail (screen != NULL);
	g_return_if_fail (binding != NULL);
	_tmp0_ = self->priv->current_source;
	_tmp1_ = self->priv->sources;
	_tmp2_ = _tmp1_->len;
	self->priv->current_source = (_tmp0_ - 1) % _tmp2_;
	budgie_keyboard_manager_hold_keyboard (self);
	_tmp3_ = self->priv->current_source;
	budgie_keyboard_manager_apply_layout (self, _tmp3_);
	budgie_keyboard_manager_apply_ibus (self);
}


static void _budgie_keyboard_manager_switch_input_source_meta_key_handler_func (MetaDisplay* display, MetaScreen* screen, MetaWindow* window, ClutterKeyEvent* event, MetaKeyBinding* binding, gpointer self) {
	budgie_keyboard_manager_switch_input_source ((BudgieKeyboardManager*) self, display, screen, window, event, binding);
}


static void _budgie_keyboard_manager_switch_input_source_backward_meta_key_handler_func (MetaDisplay* display, MetaScreen* screen, MetaWindow* window, ClutterKeyEvent* event, MetaKeyBinding* binding, gpointer self) {
	budgie_keyboard_manager_switch_input_source_backward ((BudgieKeyboardManager*) self, display, screen, window, event, binding);
}


void budgie_keyboard_manager_hook_extra (BudgieKeyboardManager* self) {
	MetaScreen* screen = NULL;
	BudgieBudgieWM* _tmp0_ = NULL;
	MetaScreen* _tmp1_ = NULL;
	MetaScreen* _tmp2_ = NULL;
	MetaDisplay* display = NULL;
	MetaDisplay* _tmp3_ = NULL;
	MetaDisplay* _tmp4_ = NULL;
	GSettings* schema = NULL;
	GSettings* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->_wm;
	_tmp1_ = meta_plugin_get_screen ((MetaPlugin*) _tmp0_);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	screen = _tmp2_;
	_tmp3_ = meta_screen_get_display (screen);
	_tmp4_ = _g_object_ref0 (_tmp3_);
	display = _tmp4_;
	_tmp5_ = g_settings_new ("org.gnome.desktop.wm.keybindings");
	schema = _tmp5_;
	meta_display_add_keybinding (display, "switch-input-source", schema, META_KEY_BINDING_NONE, _budgie_keyboard_manager_switch_input_source_meta_key_handler_func, g_object_ref (self), g_object_unref);
	meta_display_add_keybinding (display, "switch-input-source-backward", schema, META_KEY_BINDING_NONE, _budgie_keyboard_manager_switch_input_source_backward_meta_key_handler_func, g_object_ref (self), g_object_unref);
	_g_object_unref0 (schema);
	_g_object_unref0 (display);
	_g_object_unref0 (screen);
}


static void budgie_keyboard_manager_on_settings_changed (BudgieKeyboardManager* self, const gchar* key) {
	const gchar* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	GQuark _tmp3_ = 0U;
	static GQuark _tmp2_label0 = 0;
	static GQuark _tmp2_label1 = 0;
	g_return_if_fail (self != NULL);
	g_return_if_fail (key != NULL);
	_tmp0_ = key;
	_tmp1_ = _tmp0_;
	_tmp3_ = (NULL == _tmp1_) ? 0 : g_quark_from_string (_tmp1_);
	if (_tmp3_ == ((0 != _tmp2_label0) ? _tmp2_label0 : (_tmp2_label0 = g_quark_from_static_string ("sources")))) {
		switch (0) {
			default:
			{
				budgie_keyboard_manager_update_sources (self);
				break;
			}
		}
	} else if (_tmp3_ == ((0 != _tmp2_label1) ? _tmp2_label1 : (_tmp2_label1 = g_quark_from_static_string ("xkb-options")))) {
		switch (0) {
			default:
			{
				GSettings* _tmp4_ = NULL;
				const gchar* _tmp5_ = NULL;
				gchar** _tmp6_ = NULL;
				gchar** _tmp7_ = NULL;
				_tmp4_ = self->priv->settings;
				_tmp5_ = key;
				_tmp7_ = _tmp6_ = g_settings_get_strv (_tmp4_, _tmp5_);
				self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
				self->priv->options = _tmp7_;
				self->priv->options_length1 = _vala_array_length (_tmp6_);
				self->priv->_options_size_ = self->priv->options_length1;
				break;
			}
		}
	} else {
		switch (0) {
			default:
			{
				return;
			}
		}
	}
}


static gpointer _budgie_input_source_ref0 (gpointer self) {
	return self ? budgie_input_source_ref (self) : NULL;
}


static void budgie_keyboard_manager_update_sources (BudgieKeyboardManager* self) {
	GArray* _tmp0_ = NULL;
	GVariant* val = NULL;
	GSettings* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	GArray* _tmp44_ = NULL;
	guint _tmp45_ = 0U;
	guint default_idx = 0U;
	GSettings* _tmp52_ = NULL;
	guint _tmp53_ = 0U;
	guint _tmp54_ = 0U;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_array_new (TRUE, TRUE, sizeof (BudgieInputSource*));
	_g_array_unref0 (self->priv->sources);
	self->priv->sources = _tmp0_;
	_tmp1_ = self->priv->settings;
	_tmp2_ = g_settings_get_value (_tmp1_, "sources");
	val = _tmp2_;
	{
		gsize i = 0UL;
		i = (gsize) 0;
		{
			gboolean _tmp3_ = FALSE;
			_tmp3_ = TRUE;
			while (TRUE) {
				gsize _tmp5_ = 0UL;
				GVariant* _tmp6_ = NULL;
				gsize _tmp7_ = 0UL;
				BudgieInputSource* source = NULL;
				gchar* id = NULL;
				gchar* type = NULL;
				GVariant* _tmp8_ = NULL;
				gsize _tmp9_ = 0UL;
				const gchar* _tmp10_ = NULL;
				if (!_tmp3_) {
					gsize _tmp4_ = 0UL;
					_tmp4_ = i;
					i = _tmp4_ + 1;
				}
				_tmp3_ = FALSE;
				_tmp5_ = i;
				_tmp6_ = val;
				_tmp7_ = g_variant_n_children (_tmp6_);
				if (!(_tmp5_ < _tmp7_)) {
					break;
				}
				source = NULL;
				id = NULL;
				type = NULL;
				_tmp8_ = val;
				_tmp9_ = i;
				g_variant_get_child (_tmp8_, _tmp9_, "(ss)", &id, &type, NULL);
				_tmp10_ = id;
				if (g_strcmp0 (_tmp10_, "xkb") == 0) {
					gchar** spl = NULL;
					const gchar* _tmp11_ = NULL;
					gchar** _tmp12_ = NULL;
					gchar** _tmp13_ = NULL;
					gint spl_length1 = 0;
					gint _spl_size_ = 0;
					gchar* variant = NULL;
					gchar* _tmp14_ = NULL;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					BudgieInputSource* _tmp19_ = NULL;
					BudgieIBusManager* _tmp20_ = NULL;
					const gchar* _tmp21_ = NULL;
					gsize _tmp22_ = 0UL;
					gchar** _tmp23_ = NULL;
					gint _tmp23__length1 = 0;
					const gchar* _tmp24_ = NULL;
					const gchar* _tmp25_ = NULL;
					BudgieInputSource* _tmp26_ = NULL;
					BudgieInputSource* _tmp27_ = NULL;
					GArray* _tmp28_ = NULL;
					BudgieInputSource* _tmp29_ = NULL;
					BudgieInputSource* _tmp30_ = NULL;
					_tmp11_ = type;
					_tmp13_ = _tmp12_ = g_strsplit (_tmp11_, "+", 0);
					spl = _tmp13_;
					spl_length1 = _vala_array_length (_tmp12_);
					_spl_size_ = spl_length1;
					_tmp14_ = g_strdup ("");
					variant = _tmp14_;
					_tmp15_ = spl;
					_tmp15__length1 = spl_length1;
					if (_tmp15__length1 > 1) {
						gchar** _tmp16_ = NULL;
						gint _tmp16__length1 = 0;
						const gchar* _tmp17_ = NULL;
						gchar* _tmp18_ = NULL;
						_tmp16_ = spl;
						_tmp16__length1 = spl_length1;
						_tmp17_ = _tmp16_[1];
						_tmp18_ = g_strdup (_tmp17_);
						_g_free0 (variant);
						variant = _tmp18_;
					}
					_tmp20_ = self->priv->ibus_manager;
					_tmp21_ = type;
					_tmp22_ = i;
					_tmp23_ = spl;
					_tmp23__length1 = spl_length1;
					_tmp24_ = _tmp23_[0];
					_tmp25_ = variant;
					_tmp26_ = budgie_input_source_new (_tmp20_, _tmp21_, (guint) _tmp22_, _tmp24_, _tmp25_, TRUE, &_inner_error_);
					_tmp19_ = _tmp26_;
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (variant);
						spl = (_vala_array_free (spl, spl_length1, (GDestroyNotify) g_free), NULL);
						_g_free0 (type);
						_g_free0 (id);
						_budgie_input_source_unref0 (source);
						_g_variant_unref0 (val);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
					_tmp27_ = _tmp19_;
					_tmp19_ = NULL;
					_budgie_input_source_unref0 (source);
					source = _tmp27_;
					_tmp28_ = self->priv->sources;
					_tmp29_ = source;
					_tmp30_ = _budgie_input_source_ref0 (_tmp29_);
					g_array_append_val (_tmp28_, _tmp30_);
					_budgie_input_source_unref0 (_tmp19_);
					_g_free0 (variant);
					spl = (_vala_array_free (spl, spl_length1, (GDestroyNotify) g_free), NULL);
				} else {
					{
						BudgieInputSource* _tmp31_ = NULL;
						BudgieIBusManager* _tmp32_ = NULL;
						const gchar* _tmp33_ = NULL;
						gsize _tmp34_ = 0UL;
						BudgieInputSource* _tmp35_ = NULL;
						BudgieInputSource* _tmp36_ = NULL;
						GArray* _tmp37_ = NULL;
						BudgieInputSource* _tmp38_ = NULL;
						BudgieInputSource* _tmp39_ = NULL;
						_tmp32_ = self->priv->ibus_manager;
						_tmp33_ = type;
						_tmp34_ = i;
						_tmp35_ = budgie_input_source_new (_tmp32_, _tmp33_, (guint) _tmp34_, NULL, NULL, FALSE, &_inner_error_);
						_tmp31_ = _tmp35_;
						if (G_UNLIKELY (_inner_error_ != NULL)) {
							goto __catch1_g_error;
						}
						_tmp36_ = _tmp31_;
						_tmp31_ = NULL;
						_budgie_input_source_unref0 (source);
						source = _tmp36_;
						_tmp37_ = self->priv->sources;
						_tmp38_ = source;
						_tmp39_ = _budgie_input_source_ref0 (_tmp38_);
						g_array_append_val (_tmp37_, _tmp39_);
						_budgie_input_source_unref0 (_tmp31_);
					}
					goto __finally1;
					__catch1_g_error:
					{
						GError* e = NULL;
						const gchar* _tmp40_ = NULL;
						const gchar* _tmp41_ = NULL;
						GError* _tmp42_ = NULL;
						const gchar* _tmp43_ = NULL;
						e = _inner_error_;
						_inner_error_ = NULL;
						_tmp40_ = id;
						_tmp41_ = type;
						_tmp42_ = e;
						_tmp43_ = _tmp42_->message;
						g_message ("keyboard.vala:178: Error adding source %s|%s: %s", _tmp40_, _tmp41_, _tmp43_);
						_g_error_free0 (e);
					}
					__finally1:
					if (G_UNLIKELY (_inner_error_ != NULL)) {
						_g_free0 (type);
						_g_free0 (id);
						_budgie_input_source_unref0 (source);
						_g_variant_unref0 (val);
						g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
						g_clear_error (&_inner_error_);
						return;
					}
				}
				_g_free0 (type);
				_g_free0 (id);
				_budgie_input_source_unref0 (source);
			}
		}
	}
	_tmp44_ = self->priv->sources;
	_tmp45_ = _tmp44_->len;
	if (_tmp45_ == ((guint) 0)) {
		BudgieInputSource* _tmp46_ = NULL;
		GArray* _tmp47_ = NULL;
		guint _tmp48_ = 0U;
		GArray* _tmp49_ = NULL;
		BudgieInputSource* _tmp50_ = NULL;
		BudgieInputSource* _tmp51_ = NULL;
		_tmp46_ = self->priv->fallback;
		_tmp47_ = self->priv->sources;
		_tmp48_ = _tmp47_->len;
		_tmp46_->idx = _tmp48_;
		_tmp49_ = self->priv->sources;
		_tmp50_ = self->priv->fallback;
		_tmp51_ = _budgie_input_source_ref0 (_tmp50_);
		g_array_append_val (_tmp49_, _tmp51_);
	}
	budgie_keyboard_manager_hold_keyboard (self);
	budgie_keyboard_manager_apply_layout_group (self);
	_tmp52_ = self->priv->settings;
	_tmp53_ = g_settings_get_uint (_tmp52_, "current");
	default_idx = _tmp53_;
	_tmp54_ = default_idx;
	budgie_keyboard_manager_apply_layout (self, _tmp54_);
	budgie_keyboard_manager_apply_ibus (self);
	_g_variant_unref0 (val);
}


static void _vala_array_add1 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static void _vala_array_add2 (gchar*** array, int* length, int* size, gchar* value) {
	if ((*length) == (*size)) {
		*size = (*size) ? (2 * (*size)) : 4;
		*array = g_renew (gchar*, *array, (*size) + 1);
	}
	(*array)[(*length)++] = value;
	(*array)[*length] = NULL;
}


static gchar* _vala_g_strjoinv (const gchar* separator, gchar** str_array, int str_array_length1) {
	gchar* result = NULL;
	const gchar* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	gchar** _tmp3_ = NULL;
	gint _tmp3__length1 = 0;
	_tmp0_ = separator;
	if (_tmp0_ == NULL) {
		separator = "";
	}
	_tmp3_ = str_array;
	_tmp3__length1 = str_array_length1;
	if (_tmp3_ != NULL) {
		_tmp2_ = TRUE;
	} else {
		gchar** _tmp4_ = NULL;
		gint _tmp4__length1 = 0;
		_tmp4_ = str_array;
		_tmp4__length1 = str_array_length1;
		_tmp2_ = _tmp4__length1 > 0;
	}
	if (_tmp2_) {
		_tmp1_ = TRUE;
	} else {
		gboolean _tmp5_ = FALSE;
		gchar** _tmp6_ = NULL;
		gint _tmp6__length1 = 0;
		_tmp6_ = str_array;
		_tmp6__length1 = str_array_length1;
		if (_tmp6__length1 == -1) {
			gchar** _tmp7_ = NULL;
			gint _tmp7__length1 = 0;
			const gchar* _tmp8_ = NULL;
			_tmp7_ = str_array;
			_tmp7__length1 = str_array_length1;
			_tmp8_ = _tmp7_[0];
			_tmp5_ = _tmp8_ != NULL;
		} else {
			_tmp5_ = FALSE;
		}
		_tmp1_ = _tmp5_;
	}
	if (_tmp1_) {
		gint i = 0;
		gsize len = 0UL;
		gint _tmp31_ = 0;
		gint _tmp33_ = 0;
		gint _tmp34_ = 0;
		gsize _tmp35_ = 0UL;
		const gchar* _tmp36_ = NULL;
		gint _tmp37_ = 0;
		gint _tmp38_ = 0;
		gint _tmp39_ = 0;
		const gchar* res = NULL;
		gsize _tmp40_ = 0UL;
		void* _tmp41_ = NULL;
		void* ptr = NULL;
		const gchar* _tmp42_ = NULL;
		gchar** _tmp43_ = NULL;
		gint _tmp43__length1 = 0;
		const gchar* _tmp44_ = NULL;
		void* _tmp45_ = NULL;
		const gchar* _tmp62_ = NULL;
		len = (gsize) 1;
		{
			gboolean _tmp9_ = FALSE;
			i = 0;
			_tmp9_ = TRUE;
			while (TRUE) {
				gboolean _tmp11_ = FALSE;
				gboolean _tmp12_ = FALSE;
				gchar** _tmp13_ = NULL;
				gint _tmp13__length1 = 0;
				gint _tmp21_ = 0;
				gchar** _tmp22_ = NULL;
				gint _tmp22__length1 = 0;
				gint _tmp23_ = 0;
				const gchar* _tmp24_ = NULL;
				gsize _tmp30_ = 0UL;
				if (!_tmp9_) {
					gint _tmp10_ = 0;
					_tmp10_ = i;
					i = _tmp10_ + 1;
				}
				_tmp9_ = FALSE;
				_tmp13_ = str_array;
				_tmp13__length1 = str_array_length1;
				if (_tmp13__length1 != -1) {
					gint _tmp14_ = 0;
					gchar** _tmp15_ = NULL;
					gint _tmp15__length1 = 0;
					_tmp14_ = i;
					_tmp15_ = str_array;
					_tmp15__length1 = str_array_length1;
					_tmp12_ = _tmp14_ < _tmp15__length1;
				} else {
					_tmp12_ = FALSE;
				}
				if (_tmp12_) {
					_tmp11_ = TRUE;
				} else {
					gboolean _tmp16_ = FALSE;
					gchar** _tmp17_ = NULL;
					gint _tmp17__length1 = 0;
					_tmp17_ = str_array;
					_tmp17__length1 = str_array_length1;
					if (_tmp17__length1 == -1) {
						gchar** _tmp18_ = NULL;
						gint _tmp18__length1 = 0;
						gint _tmp19_ = 0;
						const gchar* _tmp20_ = NULL;
						_tmp18_ = str_array;
						_tmp18__length1 = str_array_length1;
						_tmp19_ = i;
						_tmp20_ = _tmp18_[_tmp19_];
						_tmp16_ = _tmp20_ != NULL;
					} else {
						_tmp16_ = FALSE;
					}
					_tmp11_ = _tmp16_;
				}
				if (!_tmp11_) {
					break;
				}
				_tmp22_ = str_array;
				_tmp22__length1 = str_array_length1;
				_tmp23_ = i;
				_tmp24_ = _tmp22_[_tmp23_];
				if (_tmp24_ != NULL) {
					gchar** _tmp25_ = NULL;
					gint _tmp25__length1 = 0;
					gint _tmp26_ = 0;
					const gchar* _tmp27_ = NULL;
					gint _tmp28_ = 0;
					gint _tmp29_ = 0;
					_tmp25_ = str_array;
					_tmp25__length1 = str_array_length1;
					_tmp26_ = i;
					_tmp27_ = _tmp25_[_tmp26_];
					_tmp28_ = strlen ((const gchar*) _tmp27_);
					_tmp29_ = _tmp28_;
					_tmp21_ = _tmp29_;
				} else {
					_tmp21_ = 0;
				}
				_tmp30_ = len;
				len = _tmp30_ + _tmp21_;
			}
		}
		_tmp31_ = i;
		if (_tmp31_ == 0) {
			gchar* _tmp32_ = NULL;
			_tmp32_ = g_strdup ("");
			result = _tmp32_;
			return result;
		}
		_tmp33_ = i;
		str_array_length1 = _tmp33_;
		_tmp34_ = str_array_length1;
		_tmp35_ = len;
		_tmp36_ = separator;
		_tmp37_ = strlen ((const gchar*) _tmp36_);
		_tmp38_ = _tmp37_;
		_tmp39_ = i;
		len = _tmp35_ + (_tmp38_ * (_tmp39_ - 1));
		_tmp40_ = len;
		_tmp41_ = g_malloc (_tmp40_);
		res = _tmp41_;
		_tmp42_ = res;
		_tmp43_ = str_array;
		_tmp43__length1 = str_array_length1;
		_tmp44_ = _tmp43_[0];
		_tmp45_ = g_stpcpy ((void*) _tmp42_, (const gchar*) _tmp44_);
		ptr = _tmp45_;
		{
			gboolean _tmp46_ = FALSE;
			i = 1;
			_tmp46_ = TRUE;
			while (TRUE) {
				gint _tmp48_ = 0;
				gchar** _tmp49_ = NULL;
				gint _tmp49__length1 = 0;
				void* _tmp50_ = NULL;
				const gchar* _tmp51_ = NULL;
				void* _tmp52_ = NULL;
				const gchar* _tmp53_ = NULL;
				gchar** _tmp54_ = NULL;
				gint _tmp54__length1 = 0;
				gint _tmp55_ = 0;
				const gchar* _tmp56_ = NULL;
				void* _tmp60_ = NULL;
				void* _tmp61_ = NULL;
				if (!_tmp46_) {
					gint _tmp47_ = 0;
					_tmp47_ = i;
					i = _tmp47_ + 1;
				}
				_tmp46_ = FALSE;
				_tmp48_ = i;
				_tmp49_ = str_array;
				_tmp49__length1 = str_array_length1;
				if (!(_tmp48_ < _tmp49__length1)) {
					break;
				}
				_tmp50_ = ptr;
				_tmp51_ = separator;
				_tmp52_ = g_stpcpy (_tmp50_, (const gchar*) _tmp51_);
				ptr = _tmp52_;
				_tmp54_ = str_array;
				_tmp54__length1 = str_array_length1;
				_tmp55_ = i;
				_tmp56_ = _tmp54_[_tmp55_];
				if (_tmp56_ != NULL) {
					gchar** _tmp57_ = NULL;
					gint _tmp57__length1 = 0;
					gint _tmp58_ = 0;
					const gchar* _tmp59_ = NULL;
					_tmp57_ = str_array;
					_tmp57__length1 = str_array_length1;
					_tmp58_ = i;
					_tmp59_ = _tmp57_[_tmp58_];
					_tmp53_ = (const gchar*) _tmp59_;
				} else {
					_tmp53_ = "";
				}
				_tmp60_ = ptr;
				_tmp61_ = g_stpcpy (_tmp60_, _tmp53_);
				ptr = _tmp61_;
			}
		}
		_tmp62_ = res;
		res = NULL;
		result = (gchar*) _tmp62_;
		return result;
	} else {
		gchar* _tmp63_ = NULL;
		_tmp63_ = g_strdup ("");
		result = _tmp63_;
		return result;
	}
}


static void budgie_keyboard_manager_apply_layout_group (BudgieKeyboardManager* self) {
	BudgieInputSource* source = NULL;
	gchar** layouts = NULL;
	gchar** _tmp0_ = NULL;
	gint layouts_length1 = 0;
	gint _layouts_size_ = 0;
	gchar** variants = NULL;
	gchar** _tmp1_ = NULL;
	gint variants_length1 = 0;
	gint _variants_size_ = 0;
	gchar* slayouts = NULL;
	gchar** _tmp18_ = NULL;
	gint _tmp18__length1 = 0;
	gchar* _tmp19_ = NULL;
	gchar* svariants = NULL;
	gchar** _tmp20_ = NULL;
	gint _tmp20__length1 = 0;
	gchar* _tmp21_ = NULL;
	gchar* options = NULL;
	gchar** _tmp22_ = NULL;
	gint _tmp22__length1 = 0;
	gchar* _tmp23_ = NULL;
	MetaBackend* _tmp24_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	layouts = _tmp0_;
	layouts_length1 = 0;
	_layouts_size_ = layouts_length1;
	_tmp1_ = g_new0 (gchar*, 0 + 1);
	variants = _tmp1_;
	variants_length1 = 0;
	_variants_size_ = variants_length1;
	{
		guint i = 0U;
		i = (guint) 0;
		{
			gboolean _tmp2_ = FALSE;
			_tmp2_ = TRUE;
			while (TRUE) {
				guint _tmp4_ = 0U;
				GArray* _tmp5_ = NULL;
				guint _tmp6_ = 0U;
				GArray* _tmp7_ = NULL;
				guint _tmp8_ = 0U;
				BudgieInputSource* _tmp9_ = NULL;
				gchar** _tmp10_ = NULL;
				gint _tmp10__length1 = 0;
				BudgieInputSource* _tmp11_ = NULL;
				const gchar* _tmp12_ = NULL;
				gchar* _tmp13_ = NULL;
				gchar** _tmp14_ = NULL;
				gint _tmp14__length1 = 0;
				BudgieInputSource* _tmp15_ = NULL;
				const gchar* _tmp16_ = NULL;
				gchar* _tmp17_ = NULL;
				if (!_tmp2_) {
					guint _tmp3_ = 0U;
					_tmp3_ = i;
					i = _tmp3_ + 1;
				}
				_tmp2_ = FALSE;
				_tmp4_ = i;
				_tmp5_ = self->priv->sources;
				_tmp6_ = _tmp5_->len;
				if (!(_tmp4_ < _tmp6_)) {
					break;
				}
				_tmp7_ = self->priv->sources;
				_tmp8_ = i;
				_tmp9_ = g_array_index (_tmp7_, BudgieInputSource*, _tmp8_);
				source = _tmp9_;
				_tmp10_ = layouts;
				_tmp10__length1 = layouts_length1;
				_tmp11_ = source;
				_tmp12_ = _tmp11_->layout;
				_tmp13_ = g_strdup (_tmp12_);
				_vala_array_add1 (&layouts, &layouts_length1, &_layouts_size_, _tmp13_);
				_tmp14_ = variants;
				_tmp14__length1 = variants_length1;
				_tmp15_ = source;
				_tmp16_ = _tmp15_->variant;
				_tmp17_ = g_strdup (_tmp16_);
				_vala_array_add2 (&variants, &variants_length1, &_variants_size_, _tmp17_);
			}
		}
	}
	_tmp18_ = layouts;
	_tmp18__length1 = layouts_length1;
	_tmp19_ = _vala_g_strjoinv (",", _tmp18_, _tmp18__length1);
	slayouts = _tmp19_;
	_tmp20_ = variants;
	_tmp20__length1 = variants_length1;
	_tmp21_ = _vala_g_strjoinv (",", _tmp20_, _tmp20__length1);
	svariants = _tmp21_;
	_tmp22_ = self->priv->options;
	_tmp22__length1 = self->priv->options_length1;
	_tmp23_ = _vala_g_strjoinv (",", _tmp22_, _tmp22__length1);
	options = _tmp23_;
	_tmp24_ = meta_get_backend ();
	meta_backend_set_keymap (_tmp24_, slayouts, svariants, options);
	_g_free0 (options);
	_g_free0 (svariants);
	_g_free0 (slayouts);
	variants = (_vala_array_free (variants, variants_length1, (GDestroyNotify) g_free), NULL);
	layouts = (_vala_array_free (layouts, layouts_length1, (GDestroyNotify) g_free), NULL);
}


static void budgie_keyboard_manager_apply_layout (BudgieKeyboardManager* self, guint idx) {
	guint _tmp0_ = 0U;
	GArray* _tmp1_ = NULL;
	guint _tmp2_ = 0U;
	guint _tmp3_ = 0U;
	MetaBackend* _tmp4_ = NULL;
	guint _tmp5_ = 0U;
	guint _tmp6_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = idx;
	_tmp1_ = self->priv->sources;
	_tmp2_ = _tmp1_->len;
	if (_tmp0_ > _tmp2_) {
		idx = (guint) 0;
	}
	_tmp3_ = idx;
	self->priv->current_source = _tmp3_;
	_tmp4_ = meta_get_backend ();
	_tmp5_ = idx;
	meta_backend_lock_layout_group (_tmp4_, _tmp5_);
	_tmp6_ = idx;
	budgie_keyboard_manager_write_source_index (self, _tmp6_);
}


static gboolean string_contains (const gchar* self, const gchar* needle) {
	gboolean result = FALSE;
	const gchar* _tmp0_ = NULL;
	gchar* _tmp1_ = NULL;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (needle != NULL, FALSE);
	_tmp0_ = needle;
	_tmp1_ = strstr ((gchar*) self, (gchar*) _tmp0_);
	result = _tmp1_ != NULL;
	return result;
}


static void budgie_keyboard_manager_update_fallback (BudgieKeyboardManager* self) {
	gchar* type = NULL;
	gchar* id = NULL;
	gchar* locale = NULL;
	gchar** _tmp0_ = NULL;
	gchar** _tmp1_ = NULL;
	const gchar* _tmp2_ = NULL;
	gchar* _tmp3_ = NULL;
	gchar* display_name = NULL;
	gchar* short_name = NULL;
	gchar* xkb_layout = NULL;
	gchar* xkb_variant = NULL;
	const gchar* _tmp4_ = NULL;
	gboolean _tmp5_ = FALSE;
	const gchar* _tmp7_ = NULL;
	const gchar* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	gchar* _tmp11_ = NULL;
	gchar* _tmp12_ = NULL;
	GnomeXkbInfo* _tmp17_ = NULL;
	const gchar* _tmp18_ = NULL;
	const gchar* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	const gchar* _tmp21_ = NULL;
	const gchar* _tmp22_ = NULL;
	gboolean _tmp23_ = FALSE;
	gchar* _tmp24_ = NULL;
	gchar* _tmp25_ = NULL;
	gchar* _tmp26_ = NULL;
	gchar* _tmp27_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	type = NULL;
	id = NULL;
	_tmp1_ = _tmp0_ = g_get_language_names ();
	_tmp2_ = _tmp1_[0];
	_tmp3_ = g_strdup (_tmp2_);
	locale = _tmp3_;
	display_name = NULL;
	short_name = NULL;
	xkb_layout = NULL;
	xkb_variant = NULL;
	_tmp4_ = locale;
	_tmp5_ = string_contains (_tmp4_, "_");
	if (!_tmp5_) {
		gchar* _tmp6_ = NULL;
		_tmp6_ = g_strdup (BUDGIE_DEFAULT_LOCALE);
		_g_free0 (locale);
		locale = _tmp6_;
	}
	_tmp7_ = locale;
	_tmp10_ = gnome_get_input_source_from_locale (_tmp7_, &_tmp8_, &_tmp9_);
	_g_free0 (type);
	_tmp11_ = g_strdup (_tmp8_);
	type = _tmp11_;
	_g_free0 (id);
	_tmp12_ = g_strdup (_tmp9_);
	id = _tmp12_;
	if (!_tmp10_) {
		const gchar* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		gchar* _tmp15_ = NULL;
		gchar* _tmp16_ = NULL;
		gnome_get_input_source_from_locale (BUDGIE_DEFAULT_LOCALE, &_tmp13_, &_tmp14_);
		_g_free0 (type);
		_tmp15_ = g_strdup (_tmp13_);
		type = _tmp15_;
		_g_free0 (id);
		_tmp16_ = g_strdup (_tmp14_);
		id = _tmp16_;
	}
	_tmp17_ = self->priv->xkb;
	_tmp18_ = id;
	_tmp23_ = gnome_xkb_info_get_layout_info (_tmp17_, _tmp18_, &_tmp19_, &_tmp20_, &_tmp21_, &_tmp22_);
	_g_free0 (display_name);
	_tmp24_ = g_strdup (_tmp19_);
	display_name = _tmp24_;
	_g_free0 (short_name);
	_tmp25_ = g_strdup (_tmp20_);
	short_name = _tmp25_;
	_g_free0 (xkb_layout);
	_tmp26_ = g_strdup (_tmp21_);
	xkb_layout = _tmp26_;
	_g_free0 (xkb_variant);
	_tmp27_ = g_strdup (_tmp22_);
	xkb_variant = _tmp27_;
	if (_tmp23_) {
		BudgieInputSource* _tmp28_ = NULL;
		BudgieIBusManager* _tmp29_ = NULL;
		const gchar* _tmp30_ = NULL;
		const gchar* _tmp31_ = NULL;
		const gchar* _tmp32_ = NULL;
		BudgieInputSource* _tmp33_ = NULL;
		BudgieInputSource* _tmp34_ = NULL;
		_tmp29_ = self->priv->ibus_manager;
		_tmp30_ = id;
		_tmp31_ = xkb_layout;
		_tmp32_ = xkb_variant;
		_tmp33_ = budgie_input_source_new (_tmp29_, _tmp30_, (guint) 0, _tmp31_, _tmp32_, TRUE, &_inner_error_);
		_tmp28_ = _tmp33_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (xkb_variant);
			_g_free0 (xkb_layout);
			_g_free0 (short_name);
			_g_free0 (display_name);
			_g_free0 (locale);
			_g_free0 (id);
			_g_free0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp34_ = _tmp28_;
		_tmp28_ = NULL;
		_budgie_input_source_unref0 (self->priv->fallback);
		self->priv->fallback = _tmp34_;
		_budgie_input_source_unref0 (_tmp28_);
	} else {
		BudgieInputSource* _tmp35_ = NULL;
		BudgieIBusManager* _tmp36_ = NULL;
		const gchar* _tmp37_ = NULL;
		BudgieInputSource* _tmp38_ = NULL;
		BudgieInputSource* _tmp39_ = NULL;
		_tmp36_ = self->priv->ibus_manager;
		_tmp37_ = id;
		_tmp38_ = budgie_input_source_new (_tmp36_, _tmp37_, (guint) 0, BUDGIE_DEFAULT_LAYOUT, BUDGIE_DEFAULT_VARIANT, TRUE, &_inner_error_);
		_tmp35_ = _tmp38_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_free0 (xkb_variant);
			_g_free0 (xkb_layout);
			_g_free0 (short_name);
			_g_free0 (display_name);
			_g_free0 (locale);
			_g_free0 (id);
			_g_free0 (type);
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return;
		}
		_tmp39_ = _tmp35_;
		_tmp35_ = NULL;
		_budgie_input_source_unref0 (self->priv->fallback);
		self->priv->fallback = _tmp39_;
		_budgie_input_source_unref0 (_tmp35_);
	}
	_g_free0 (xkb_variant);
	_g_free0 (xkb_layout);
	_g_free0 (short_name);
	_g_free0 (display_name);
	_g_free0 (locale);
	_g_free0 (id);
	_g_free0 (type);
}


/**
     * Update the index in gsettings so that clients know the current
     */
static void budgie_keyboard_manager_write_source_index (BudgieKeyboardManager* self, guint index) {
	GSettings* _tmp0_ = NULL;
	gulong _tmp1_ = 0UL;
	GSettings* _tmp2_ = NULL;
	guint _tmp3_ = 0U;
	GSettings* _tmp4_ = NULL;
	GSettings* _tmp5_ = NULL;
	gulong _tmp6_ = 0UL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->priv->sig_id;
	g_signal_handler_block (_tmp0_, _tmp1_);
	_tmp2_ = self->priv->settings;
	_tmp3_ = index;
	g_settings_set_uint (_tmp2_, "current", _tmp3_);
	_tmp4_ = self->priv->settings;
	g_settings_apply (_tmp4_);
	_tmp5_ = self->priv->settings;
	_tmp6_ = self->priv->sig_id;
	g_signal_handler_unblock (_tmp5_, _tmp6_);
}


/**
     * Someone else changed the current source, do somethin' about it
     */
static void budgie_keyboard_manager_on_current_source_changed (BudgieKeyboardManager* self) {
	guint new_source = 0U;
	GSettings* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->settings;
	_tmp1_ = g_settings_get_uint (_tmp0_, "current");
	new_source = _tmp1_;
	budgie_keyboard_manager_hold_keyboard (self);
	budgie_keyboard_manager_apply_layout (self, new_source);
	budgie_keyboard_manager_apply_ibus (self);
}


/**
     * Apply the ibus engine and then release the keyboard
     */
static void budgie_keyboard_manager_apply_ibus (BudgieKeyboardManager* self) {
	gchar* engine_name = NULL;
	BudgieInputSource* current = NULL;
	GArray* _tmp0_ = NULL;
	guint _tmp1_ = 0U;
	BudgieInputSource* _tmp2_ = NULL;
	BudgieInputSource* _tmp3_ = NULL;
	BudgieInputSource* _tmp4_ = NULL;
	const gchar* _tmp5_ = NULL;
	BudgieIBusManager* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->sources;
	_tmp1_ = self->priv->current_source;
	_tmp2_ = g_array_index (_tmp0_, BudgieInputSource*, _tmp1_);
	_tmp3_ = _budgie_input_source_ref0 (_tmp2_);
	current = _tmp3_;
	_tmp4_ = current;
	_tmp5_ = _tmp4_->ibus_engine;
	if (_tmp5_ != NULL) {
		BudgieInputSource* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		gchar* _tmp8_ = NULL;
		_tmp6_ = current;
		_tmp7_ = _tmp6_->ibus_engine;
		_tmp8_ = g_strdup (_tmp7_);
		_g_free0 (engine_name);
		engine_name = _tmp8_;
	} else {
		gchar* _tmp9_ = NULL;
		_tmp9_ = g_strdup (BUDGIE_DEFAULT_ENGINE);
		_g_free0 (engine_name);
		engine_name = _tmp9_;
	}
	_tmp10_ = self->priv->ibus_manager;
	_tmp11_ = engine_name;
	budgie_ibus_manager_set_engine (_tmp10_, _tmp11_);
	_budgie_input_source_unref0 (current);
	_g_free0 (engine_name);
}


/**
     * Unfreeze the keyboard
     */
void budgie_keyboard_manager_release_keyboard (BudgieKeyboardManager* self) {
	gboolean _tmp0_ = FALSE;
	BudgieBudgieWM* _tmp1_ = NULL;
	MetaScreen* _tmp2_ = NULL;
	MetaDisplay* _tmp3_ = NULL;
	BudgieBudgieWM* _tmp4_ = NULL;
	MetaScreen* _tmp5_ = NULL;
	MetaDisplay* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_keyboard_held;
	if (!_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_wm;
	_tmp2_ = meta_plugin_get_screen ((MetaPlugin*) _tmp1_);
	_tmp3_ = meta_screen_get_display (_tmp2_);
	_tmp4_ = self->priv->_wm;
	_tmp5_ = meta_plugin_get_screen ((MetaPlugin*) _tmp4_);
	_tmp6_ = meta_screen_get_display (_tmp5_);
	_tmp7_ = meta_display_get_current_time (_tmp6_);
	meta_display_ungrab_keyboard (_tmp3_, _tmp7_);
	self->priv->is_keyboard_held = FALSE;
}


/**
     * Freeze the keyboard so we don't loose input events
     */
void budgie_keyboard_manager_hold_keyboard (BudgieKeyboardManager* self) {
	gboolean _tmp0_ = FALSE;
	BudgieBudgieWM* _tmp1_ = NULL;
	MetaScreen* _tmp2_ = NULL;
	MetaDisplay* _tmp3_ = NULL;
	BudgieBudgieWM* _tmp4_ = NULL;
	MetaScreen* _tmp5_ = NULL;
	MetaDisplay* _tmp6_ = NULL;
	guint32 _tmp7_ = 0U;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->is_keyboard_held;
	if (_tmp0_) {
		return;
	}
	_tmp1_ = self->priv->_wm;
	_tmp2_ = meta_plugin_get_screen ((MetaPlugin*) _tmp1_);
	_tmp3_ = meta_screen_get_display (_tmp2_);
	_tmp4_ = self->priv->_wm;
	_tmp5_ = meta_plugin_get_screen ((MetaPlugin*) _tmp4_);
	_tmp6_ = meta_screen_get_display (_tmp5_);
	_tmp7_ = meta_display_get_current_time (_tmp6_);
	meta_display_freeze_keyboard (_tmp3_, _tmp7_);
	self->priv->is_keyboard_held = TRUE;
}


BudgieBudgieWM* budgie_keyboard_manager_get_wm (BudgieKeyboardManager* self) {
	BudgieBudgieWM* result;
	BudgieBudgieWM* _tmp0_ = NULL;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = self->priv->_wm;
	result = _tmp0_;
	return result;
}


void budgie_keyboard_manager_set_wm (BudgieKeyboardManager* self, BudgieBudgieWM* value) {
	BudgieBudgieWM* _tmp0_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = value;
	self->priv->_wm = _tmp0_;
	g_object_notify ((GObject *) self, "wm");
}


static void budgie_keyboard_manager_class_init (BudgieKeyboardManagerClass * klass) {
	budgie_keyboard_manager_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BudgieKeyboardManagerPrivate));
	G_OBJECT_CLASS (klass)->get_property = _vala_budgie_keyboard_manager_get_property;
	G_OBJECT_CLASS (klass)->set_property = _vala_budgie_keyboard_manager_set_property;
	G_OBJECT_CLASS (klass)->finalize = budgie_keyboard_manager_finalize;
	g_object_class_install_property (G_OBJECT_CLASS (klass), BUDGIE_KEYBOARD_MANAGER_WM, g_param_spec_object ("wm", "wm", "wm", BUDGIE_TYPE_BUDGIE_WM, G_PARAM_STATIC_NAME | G_PARAM_STATIC_NICK | G_PARAM_STATIC_BLURB | G_PARAM_READABLE | G_PARAM_WRITABLE | G_PARAM_CONSTRUCT));
}


static void budgie_keyboard_manager_instance_init (BudgieKeyboardManager * self) {
	gchar** _tmp0_ = NULL;
	self->priv = BUDGIE_KEYBOARD_MANAGER_GET_PRIVATE (self);
	_tmp0_ = g_new0 (gchar*, 0 + 1);
	self->priv->options = _tmp0_;
	self->priv->options_length1 = 0;
	self->priv->_options_size_ = self->priv->options_length1;
	self->priv->settings = NULL;
	self->priv->current_source = (guint) 0;
	self->priv->sig_id = (gulong) 0;
	self->priv->is_keyboard_held = FALSE;
}


static void budgie_keyboard_manager_finalize (GObject* obj) {
	BudgieKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManager);
	_g_object_unref0 (self->priv->xkb);
	self->priv->options = (_vala_array_free (self->priv->options, self->priv->options_length1, (GDestroyNotify) g_free), NULL);
	_g_object_unref0 (self->priv->settings);
	_g_array_unref0 (self->priv->sources);
	_budgie_input_source_unref0 (self->priv->fallback);
	_g_object_unref0 (self->priv->ibus_manager);
	G_OBJECT_CLASS (budgie_keyboard_manager_parent_class)->finalize (obj);
}


GType budgie_keyboard_manager_get_type (void) {
	static volatile gsize budgie_keyboard_manager_type_id__volatile = 0;
	if (g_once_init_enter (&budgie_keyboard_manager_type_id__volatile)) {
		static const GTypeInfo g_define_type_info = { sizeof (BudgieKeyboardManagerClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) budgie_keyboard_manager_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BudgieKeyboardManager), 0, (GInstanceInitFunc) budgie_keyboard_manager_instance_init, NULL };
		GType budgie_keyboard_manager_type_id;
		budgie_keyboard_manager_type_id = g_type_register_static (G_TYPE_OBJECT, "BudgieKeyboardManager", &g_define_type_info, 0);
		g_once_init_leave (&budgie_keyboard_manager_type_id__volatile, budgie_keyboard_manager_type_id);
	}
	return budgie_keyboard_manager_type_id__volatile;
}


static void _vala_budgie_keyboard_manager_get_property (GObject * object, guint property_id, GValue * value, GParamSpec * pspec) {
	BudgieKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManager);
	switch (property_id) {
		case BUDGIE_KEYBOARD_MANAGER_WM:
		g_value_set_object (value, budgie_keyboard_manager_get_wm (self));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_budgie_keyboard_manager_set_property (GObject * object, guint property_id, const GValue * value, GParamSpec * pspec) {
	BudgieKeyboardManager * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (object, BUDGIE_TYPE_KEYBOARD_MANAGER, BudgieKeyboardManager);
	switch (property_id) {
		case BUDGIE_KEYBOARD_MANAGER_WM:
		budgie_keyboard_manager_set_wm (self, g_value_get_object (value));
		break;
		default:
		G_OBJECT_WARN_INVALID_PROPERTY_ID (object, property_id, pspec);
		break;
	}
}


static void _vala_array_destroy (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	if ((array != NULL) && (destroy_func != NULL)) {
		int i;
		for (i = 0; i < array_length; i = i + 1) {
			if (((gpointer*) array)[i] != NULL) {
				destroy_func (((gpointer*) array)[i]);
			}
		}
	}
}


static void _vala_array_free (gpointer array, gint array_length, GDestroyNotify destroy_func) {
	_vala_array_destroy (array, array_length, destroy_func);
	g_free (array);
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



