/* BluetoothIndicator.c generated by valac 0.32.1, the Vala compiler
 * generated from BluetoothIndicator.vala, do not modify */

/*
 * This file is part of budgie-desktop
 *
 * Copyright (C) 2015-2016 Ikey Doherty <ikey@solus-project.com>
 * Copyright (C) 2015 Alberts Muktupāvels
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BluetoothIndicator is largely inspired by gnome-flashback.
 */

#include <glib.h>
#include <glib-object.h>
#include <gio/gio.h>
#include <string.h>
#include <gtk/gtk.h>
#include <bluetooth-client.h>
#include <bluetooth-enums.h>
#include <stdlib.h>
#include <glib/gi18n-lib.h>
#include <gio/gdesktopappinfo.h>


#define TYPE_RFKILL (rfkill_get_type ())
#define RFKILL(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_RFKILL, Rfkill))
#define IS_RFKILL(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_RFKILL))
#define RFKILL_GET_INTERFACE(obj) (G_TYPE_INSTANCE_GET_INTERFACE ((obj), TYPE_RFKILL, RfkillIface))

typedef struct _Rfkill Rfkill;
typedef struct _RfkillIface RfkillIface;

#define TYPE_RFKILL_PROXY (rfkill_proxy_get_type ())
typedef GDBusProxy RfkillProxy;
typedef GDBusProxyClass RfkillProxyClass;

#define TYPE_BLUETOOTH_INDICATOR (bluetooth_indicator_get_type ())
#define BLUETOOTH_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BLUETOOTH_INDICATOR, BluetoothIndicator))
#define BLUETOOTH_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BLUETOOTH_INDICATOR, BluetoothIndicatorClass))
#define IS_BLUETOOTH_INDICATOR(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BLUETOOTH_INDICATOR))
#define IS_BLUETOOTH_INDICATOR_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BLUETOOTH_INDICATOR))
#define BLUETOOTH_INDICATOR_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BLUETOOTH_INDICATOR, BluetoothIndicatorClass))

typedef struct _BluetoothIndicator BluetoothIndicator;
typedef struct _BluetoothIndicatorClass BluetoothIndicatorClass;
typedef struct _BluetoothIndicatorPrivate BluetoothIndicatorPrivate;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))
typedef struct _BluetoothIndicatorSetupDbusData BluetoothIndicatorSetupDbusData;
#define _g_free0(var) ((var == NULL) ? NULL : (var = (g_free (var), NULL)))
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))

struct _RfkillIface {
	GTypeInterface parent_iface;
	gboolean (*get_BluetoothAirplaneMode) (Rfkill* self);
	void (*set_BluetoothAirplaneMode) (Rfkill* self, gboolean value);
};

struct _BluetoothIndicator {
	GtkBin parent_instance;
	BluetoothIndicatorPrivate * priv;
	GtkImage* image;
	GtkEventBox* ebox;
	GtkPopover* popover;
};

struct _BluetoothIndicatorClass {
	GtkBinClass parent_class;
};

struct _BluetoothIndicatorPrivate {
	BluetoothClient* client;
	GtkTreeModel* model;
	GSimpleAction* send_to;
	GSimpleAction* airplane;
	Rfkill* killer;
};

struct _BluetoothIndicatorSetupDbusData {
	int _state_;
	GObject* _source_object_;
	GAsyncResult* _res_;
	GSimpleAsyncResult* _async_result;
	BluetoothIndicator* self;
	Rfkill* _tmp0_;
	Rfkill* _tmp1_;
	Rfkill* _tmp2_;
	GError* e;
	GError* _tmp3_;
	const gchar* _tmp4_;
	GError * _inner_error_;
};


static GType rfkill_type_id = 0;
static gpointer bluetooth_indicator_parent_class = NULL;
static GType bluetooth_indicator_type_id = 0;

GType rfkill_get_type (void) G_GNUC_CONST;
GType rfkill_register_type (GTypeModule * module);
GType rfkill_proxy_get_type (void) G_GNUC_CONST;
void rfkill_proxy_register_dynamic_type (GTypeModule* module);
guint rfkill_register_object (void* object, GDBusConnection* connection, const gchar* path, GError** error);
gboolean rfkill_get_BluetoothAirplaneMode (Rfkill* self);
void rfkill_set_BluetoothAirplaneMode (Rfkill* self, gboolean value);
static void rfkill_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters);
static gboolean rfkill_dbus_proxy_get_BluetoothAirplaneMode (Rfkill* self);
static void rfkill_dbus_proxy_set_BluetoothAirplaneMode (Rfkill* self, gboolean value);
static void rfkill_proxy_rfkill_interface_init (RfkillIface* iface);
static void rfkill_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data);
static GVariant* rfkill_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data);
static GVariant* _dbus_rfkill_get_BluetoothAirplaneMode (Rfkill* self);
static gboolean rfkill_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data);
static void _dbus_rfkill_set_BluetoothAirplaneMode (Rfkill* self, GVariant* _value);
static void _rfkill_unregister_object (gpointer user_data);
GType bluetooth_indicator_get_type (void) G_GNUC_CONST;
GType bluetooth_indicator_register_type (GTypeModule * module);
#define BLUETOOTH_INDICATOR_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BLUETOOTH_INDICATOR, BluetoothIndicatorPrivate))
enum  {
	BLUETOOTH_INDICATOR_DUMMY_PROPERTY
};
static void bluetooth_indicator_setup_dbus_data_free (gpointer _data);
static void bluetooth_indicator_setup_dbus (BluetoothIndicator* self, GAsyncReadyCallback _callback_, gpointer _user_data_);
static void bluetooth_indicator_setup_dbus_finish (BluetoothIndicator* self, GAsyncResult* _res_);
static gboolean bluetooth_indicator_setup_dbus_co (BluetoothIndicatorSetupDbusData* _data_);
static void bluetooth_indicator_setup_dbus_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_);
static gboolean bluetooth_indicator_get_default_adapter (BluetoothIndicator* self, GtkTreeIter* adapter);
static gint bluetooth_indicator_get_n_devices (BluetoothIndicator* self);
static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self);
static void bluetooth_indicator_resync (BluetoothIndicator* self);
static void bluetooth_indicator_on_settings_activate (BluetoothIndicator* self);
static void bluetooth_indicator_on_send_file (BluetoothIndicator* self);
BluetoothIndicator* bluetooth_indicator_new (void);
BluetoothIndicator* bluetooth_indicator_construct (GType object_type);
static void __lambda4_ (BluetoothIndicator* self);
static void ___lambda4__gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void __lambda5_ (BluetoothIndicator* self);
static void ___lambda5__gtk_tree_model_row_deleted (GtkTreeModel* _sender, GtkTreePath* path, gpointer self);
static void __lambda6_ (BluetoothIndicator* self);
static void ___lambda6__gtk_tree_model_row_inserted (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self);
static void _bluetooth_indicator_on_settings_activate_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void _bluetooth_indicator_on_send_file_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void bluetooth_indicator_on_set_airplane (BluetoothIndicator* self);
static void _bluetooth_indicator_on_set_airplane_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self);
static void __lambda7_ (BluetoothIndicator* self);
static void bluetooth_indicator_sync_rfkill (BluetoothIndicator* self);
static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self);
static void bluetooth_indicator_on_airplane_change (BluetoothIndicator* self);
static void _bluetooth_indicator_on_airplane_change_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self);
static void bluetooth_indicator_finalize (GObject* obj);

static const GDBusMethodInfo * const _rfkill_dbus_method_info[] = {NULL};
static const GDBusSignalInfo * const _rfkill_dbus_signal_info[] = {NULL};
static const GDBusPropertyInfo _rfkill_dbus_property_info_BluetoothAirplaneMode = {-1, "BluetoothAirplaneMode", "b", G_DBUS_PROPERTY_INFO_FLAGS_READABLE | G_DBUS_PROPERTY_INFO_FLAGS_WRITABLE};
static const GDBusPropertyInfo * const _rfkill_dbus_property_info[] = {&_rfkill_dbus_property_info_BluetoothAirplaneMode, NULL};
static const GDBusInterfaceInfo _rfkill_dbus_interface_info = {-1, "org.gnome.SettingsDaemon.Rfkill", (GDBusMethodInfo **) (&_rfkill_dbus_method_info), (GDBusSignalInfo **) (&_rfkill_dbus_signal_info), (GDBusPropertyInfo **) (&_rfkill_dbus_property_info)};
static const GDBusInterfaceVTable _rfkill_dbus_interface_vtable = {rfkill_dbus_interface_method_call, rfkill_dbus_interface_get_property, rfkill_dbus_interface_set_property};

gboolean rfkill_get_BluetoothAirplaneMode (Rfkill* self) {
	g_return_val_if_fail (self != NULL, FALSE);
	return RFKILL_GET_INTERFACE (self)->get_BluetoothAirplaneMode (self);
}


void rfkill_set_BluetoothAirplaneMode (Rfkill* self, gboolean value) {
	g_return_if_fail (self != NULL);
	RFKILL_GET_INTERFACE (self)->set_BluetoothAirplaneMode (self, value);
}


static void rfkill_base_init (RfkillIface * iface) {
	static gboolean initialized = FALSE;
	if (!initialized) {
		initialized = TRUE;
	}
}


GType rfkill_get_type (void) {
	return rfkill_type_id;
}


GType rfkill_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (RfkillIface), (GBaseInitFunc) rfkill_base_init, (GBaseFinalizeFunc) NULL, (GClassInitFunc) NULL, (GClassFinalizeFunc) NULL, NULL, 0, 0, (GInstanceInitFunc) NULL, NULL };
	rfkill_type_id = g_type_module_register_type (module, G_TYPE_INTERFACE, "Rfkill", &g_define_type_info, 0);
	g_type_interface_add_prerequisite (rfkill_type_id, G_TYPE_OBJECT);
	g_type_set_qdata (rfkill_type_id, g_quark_from_static_string ("vala-dbus-proxy-type"), (void*) rfkill_proxy_get_type);
	g_type_set_qdata (rfkill_type_id, g_quark_from_static_string ("vala-dbus-interface-name"), "org.gnome.SettingsDaemon.Rfkill");
	g_type_set_qdata (rfkill_type_id, g_quark_from_static_string ("vala-dbus-interface-info"), (void*) (&_rfkill_dbus_interface_info));
	g_type_set_qdata (rfkill_type_id, g_quark_from_static_string ("vala-dbus-register-object"), (void*) rfkill_register_object);
	return rfkill_type_id;
}


G_DEFINE_DYNAMIC_TYPE_EXTENDED (RfkillProxy, rfkill_proxy, G_TYPE_DBUS_PROXY, 0, G_IMPLEMENT_INTERFACE_DYNAMIC (TYPE_RFKILL, rfkill_proxy_rfkill_interface_init) )
static void rfkill_proxy_class_init (RfkillProxyClass* klass) {
	G_DBUS_PROXY_CLASS (klass)->g_signal = rfkill_proxy_g_signal;
}


static void rfkill_proxy_g_signal (GDBusProxy* proxy, const gchar* sender_name, const gchar* signal_name, GVariant* parameters) {
}


static void rfkill_proxy_class_finalize (RfkillProxyClass* klass) {
}


void rfkill_proxy_register_dynamic_type (GTypeModule* module) {
	rfkill_proxy_register_type (module);
}


static void rfkill_proxy_init (RfkillProxy* self) {
}


static gboolean rfkill_dbus_proxy_get_BluetoothAirplaneMode (Rfkill* self) {
	GVariant *_inner_reply;
	gboolean _result;
	_inner_reply = g_dbus_proxy_get_cached_property ((GDBusProxy *) self, "BluetoothAirplaneMode");
	if (!_inner_reply) {
		GVariant *_arguments;
		GVariant *_reply;
		GVariantBuilder _arguments_builder;
		g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Rfkill"));
		g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("BluetoothAirplaneMode"));
		_arguments = g_variant_builder_end (&_arguments_builder);
		_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Get", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
		if (!_reply) {
			return FALSE;
		}
		g_variant_get (_reply, "(v)", &_inner_reply);
		g_variant_unref (_reply);
	}
	_result = g_variant_get_boolean (_inner_reply);
	g_variant_unref (_inner_reply);
	return _result;
}


static void rfkill_dbus_proxy_set_BluetoothAirplaneMode (Rfkill* self, gboolean value) {
	GVariant *_arguments;
	GVariant *_reply;
	GVariantBuilder _arguments_builder;
	g_variant_builder_init (&_arguments_builder, G_VARIANT_TYPE_TUPLE);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("org.gnome.SettingsDaemon.Rfkill"));
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_string ("BluetoothAirplaneMode"));
	g_variant_builder_open (&_arguments_builder, G_VARIANT_TYPE_VARIANT);
	g_variant_builder_add_value (&_arguments_builder, g_variant_new_boolean (value));
	g_variant_builder_close (&_arguments_builder);
	_arguments = g_variant_builder_end (&_arguments_builder);
	_reply = g_dbus_proxy_call_sync ((GDBusProxy *) self, "org.freedesktop.DBus.Properties.Set", _arguments, G_DBUS_CALL_FLAGS_NONE, -1, NULL, NULL);
	if (!_reply) {
		return;
	}
	g_variant_unref (_reply);
}


static void rfkill_proxy_rfkill_interface_init (RfkillIface* iface) {
	iface->get_BluetoothAirplaneMode = rfkill_dbus_proxy_get_BluetoothAirplaneMode;
	iface->set_BluetoothAirplaneMode = rfkill_dbus_proxy_set_BluetoothAirplaneMode;
}


static void rfkill_dbus_interface_method_call (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* method_name, GVariant* parameters, GDBusMethodInvocation* invocation, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	g_object_unref (invocation);
}


static GVariant* _dbus_rfkill_get_BluetoothAirplaneMode (Rfkill* self) {
	gboolean result;
	GVariant* _reply;
	result = rfkill_get_BluetoothAirplaneMode (self);
	_reply = g_variant_new_boolean (result);
	return _reply;
}


static GVariant* rfkill_dbus_interface_get_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "BluetoothAirplaneMode") == 0) {
		return _dbus_rfkill_get_BluetoothAirplaneMode (object);
	}
	return NULL;
}


static void _dbus_rfkill_set_BluetoothAirplaneMode (Rfkill* self, GVariant* _value) {
	gboolean value = FALSE;
	value = g_variant_get_boolean (_value);
	rfkill_set_BluetoothAirplaneMode (self, value);
}


static gboolean rfkill_dbus_interface_set_property (GDBusConnection* connection, const gchar* sender, const gchar* object_path, const gchar* interface_name, const gchar* property_name, GVariant* value, GError** error, gpointer user_data) {
	gpointer* data;
	gpointer object;
	data = user_data;
	object = data[0];
	if (strcmp (property_name, "BluetoothAirplaneMode") == 0) {
		_dbus_rfkill_set_BluetoothAirplaneMode (object, value);
		return TRUE;
	}
	return FALSE;
}


guint rfkill_register_object (gpointer object, GDBusConnection* connection, const gchar* path, GError** error) {
	guint result;
	gpointer *data;
	data = g_new (gpointer, 3);
	data[0] = g_object_ref (object);
	data[1] = g_object_ref (connection);
	data[2] = g_strdup (path);
	result = g_dbus_connection_register_object (connection, path, (GDBusInterfaceInfo *) (&_rfkill_dbus_interface_info), &_rfkill_dbus_interface_vtable, data, _rfkill_unregister_object, error);
	if (!result) {
		return 0;
	}
	return result;
}


static void _rfkill_unregister_object (gpointer user_data) {
	gpointer* data;
	data = user_data;
	g_object_unref (data[0]);
	g_object_unref (data[1]);
	g_free (data[2]);
	g_free (data);
}


static void bluetooth_indicator_setup_dbus_data_free (gpointer _data) {
	BluetoothIndicatorSetupDbusData* _data_;
	_data_ = _data;
	_g_object_unref0 (_data_->self);
	g_slice_free (BluetoothIndicatorSetupDbusData, _data_);
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void bluetooth_indicator_setup_dbus (BluetoothIndicator* self, GAsyncReadyCallback _callback_, gpointer _user_data_) {
	BluetoothIndicatorSetupDbusData* _data_;
	BluetoothIndicator* _tmp0_ = NULL;
	_data_ = g_slice_new0 (BluetoothIndicatorSetupDbusData);
	_data_->_async_result = g_simple_async_result_new (G_OBJECT (self), _callback_, _user_data_, bluetooth_indicator_setup_dbus);
	g_simple_async_result_set_op_res_gpointer (_data_->_async_result, _data_, bluetooth_indicator_setup_dbus_data_free);
	_tmp0_ = _g_object_ref0 (self);
	_data_->self = _tmp0_;
	bluetooth_indicator_setup_dbus_co (_data_);
}


static void bluetooth_indicator_setup_dbus_finish (BluetoothIndicator* self, GAsyncResult* _res_) {
	BluetoothIndicatorSetupDbusData* _data_;
	_data_ = g_simple_async_result_get_op_res_gpointer (G_SIMPLE_ASYNC_RESULT (_res_));
}


static void bluetooth_indicator_setup_dbus_ready (GObject* source_object, GAsyncResult* _res_, gpointer _user_data_) {
	BluetoothIndicatorSetupDbusData* _data_;
	_data_ = _user_data_;
	_data_->_source_object_ = source_object;
	_data_->_res_ = _res_;
	bluetooth_indicator_setup_dbus_co (_data_);
}


static gboolean bluetooth_indicator_setup_dbus_co (BluetoothIndicatorSetupDbusData* _data_) {
	switch (_data_->_state_) {
		case 0:
		goto _state_0;
		case 1:
		goto _state_1;
		default:
		g_assert_not_reached ();
	}
	_state_0:
	{
		_data_->_state_ = 1;
		g_async_initable_new_async (TYPE_RFKILL_PROXY, 0, NULL, bluetooth_indicator_setup_dbus_ready, _data_, "g-flags", 0, "g-name", "org.gnome.SettingsDaemon.Rfkill", "g-bus-type", G_BUS_TYPE_SESSION, "g-object-path", "/org/gnome/SettingsDaemon/Rfkill", "g-interface-name", "org.gnome.SettingsDaemon.Rfkill", "g-interface-info", g_type_get_qdata (TYPE_RFKILL, g_quark_from_static_string ("vala-dbus-interface-info")), NULL);
		return FALSE;
		_state_1:
		_data_->_tmp1_ = NULL;
		_data_->_tmp1_ = g_async_initable_new_finish (_data_->_source_object_, _data_->_res_, &_data_->_inner_error_);
		_data_->_tmp0_ = (Rfkill*) _data_->_tmp1_;
		if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
			goto __catch0_g_error;
		}
		_data_->_tmp2_ = NULL;
		_data_->_tmp2_ = _data_->_tmp0_;
		_data_->_tmp0_ = NULL;
		_g_object_unref0 (_data_->self->priv->killer);
		_data_->self->priv->killer = _data_->_tmp2_;
		_g_object_unref0 (_data_->_tmp0_);
	}
	goto __finally0;
	__catch0_g_error:
	{
		_data_->e = _data_->_inner_error_;
		_data_->_inner_error_ = NULL;
		_data_->_tmp3_ = NULL;
		_data_->_tmp3_ = _data_->e;
		_data_->_tmp4_ = NULL;
		_data_->_tmp4_ = _data_->_tmp3_->message;
		g_warning ("BluetoothIndicator.vala:39: Unable to contact RfKill manager: %s", _data_->_tmp4_);
		_g_error_free0 (_data_->e);
		if (_data_->_state_ == 0) {
			g_simple_async_result_complete_in_idle (_data_->_async_result);
		} else {
			g_simple_async_result_complete (_data_->_async_result);
		}
		g_object_unref (_data_->_async_result);
		return FALSE;
	}
	__finally0:
	if (G_UNLIKELY (_data_->_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _data_->_inner_error_->message, g_quark_to_string (_data_->_inner_error_->domain), _data_->_inner_error_->code);
		g_clear_error (&_data_->_inner_error_);
		return FALSE;
	}
	if (_data_->_state_ == 0) {
		g_simple_async_result_complete_in_idle (_data_->_async_result);
	} else {
		g_simple_async_result_complete (_data_->_async_result);
	}
	g_object_unref (_data_->_async_result);
	return FALSE;
}


static gboolean bluetooth_indicator_get_default_adapter (BluetoothIndicator* self, GtkTreeIter* adapter) {
	GtkTreeIter _vala_adapter = {0};
	gboolean result = FALSE;
	GtkTreeIter iter = {0};
	GtkTreeModel* _tmp0_ = NULL;
	GtkTreeIter _tmp1_ = {0};
	gboolean _tmp2_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	_tmp0_ = self->priv->model;
	_tmp2_ = gtk_tree_model_get_iter_first (_tmp0_, &_tmp1_);
	iter = _tmp1_;
	if (!_tmp2_) {
		result = FALSE;
		if (adapter) {
			*adapter = _vala_adapter;
		}
		return result;
	}
	while (TRUE) {
		gboolean is_default = FALSE;
		GtkTreeModel* _tmp3_ = NULL;
		GtkTreeIter _tmp4_ = {0};
		gboolean _tmp5_ = FALSE;
		GtkTreeModel* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp3_ = self->priv->model;
		_tmp4_ = iter;
		gtk_tree_model_get (_tmp3_, &_tmp4_, BLUETOOTH_COLUMN_DEFAULT, &is_default, -1, -1);
		_tmp5_ = is_default;
		if (_tmp5_) {
			GtkTreeIter _tmp6_ = {0};
			_tmp6_ = iter;
			_vala_adapter = _tmp6_;
			result = TRUE;
			if (adapter) {
				*adapter = _vala_adapter;
			}
			return result;
		}
		_tmp7_ = self->priv->model;
		_tmp8_ = gtk_tree_model_iter_next (_tmp7_, &iter);
		if (!_tmp8_) {
			break;
		}
	}
	result = FALSE;
	if (adapter) {
		*adapter = _vala_adapter;
	}
	return result;
}


static GtkTreeIter* _gtk_tree_iter_dup (GtkTreeIter* self) {
	GtkTreeIter* dup;
	dup = g_new0 (GtkTreeIter, 1);
	memcpy (dup, self, sizeof (GtkTreeIter));
	return dup;
}


static gpointer __gtk_tree_iter_dup0 (gpointer self) {
	return self ? _gtk_tree_iter_dup (self) : NULL;
}


static gint bluetooth_indicator_get_n_devices (BluetoothIndicator* self) {
	gint result = 0;
	GtkTreeIter iter = {0};
	GtkTreeIter* adapter = NULL;
	gint n_devices = 0;
	GtkTreeIter _tmp0_ = {0};
	gboolean _tmp1_ = FALSE;
	GtkTreeIter _tmp2_ = {0};
	GtkTreeIter* _tmp3_ = NULL;
	GtkTreeModel* _tmp4_ = NULL;
	GtkTreeIter* _tmp5_ = NULL;
	GtkTreeIter _tmp6_ = {0};
	gboolean _tmp7_ = FALSE;
	g_return_val_if_fail (self != NULL, 0);
	n_devices = 0;
	_tmp1_ = bluetooth_indicator_get_default_adapter (self, &_tmp0_);
	_g_free0 (adapter);
	_tmp2_ = _tmp0_;
	_tmp3_ = __gtk_tree_iter_dup0 (&_tmp2_);
	adapter = _tmp3_;
	if (!_tmp1_) {
		result = -1;
		_g_free0 (adapter);
		return result;
	}
	_tmp4_ = self->priv->model;
	_tmp5_ = adapter;
	_tmp7_ = gtk_tree_model_iter_children (_tmp4_, &_tmp6_, _tmp5_);
	iter = _tmp6_;
	if (!_tmp7_) {
		result = 0;
		_g_free0 (adapter);
		return result;
	}
	while (TRUE) {
		gboolean con = FALSE;
		GtkTreeModel* _tmp8_ = NULL;
		GtkTreeIter _tmp9_ = {0};
		gboolean _tmp10_ = FALSE;
		GtkTreeModel* _tmp12_ = NULL;
		gboolean _tmp13_ = FALSE;
		_tmp8_ = self->priv->model;
		_tmp9_ = iter;
		gtk_tree_model_get (_tmp8_, &_tmp9_, BLUETOOTH_COLUMN_CONNECTED, &con, -1, -1);
		_tmp10_ = con;
		if (_tmp10_) {
			gint _tmp11_ = 0;
			_tmp11_ = n_devices;
			n_devices = _tmp11_ + 1;
		}
		_tmp12_ = self->priv->model;
		_tmp13_ = gtk_tree_model_iter_next (_tmp12_, &iter);
		if (!_tmp13_) {
			break;
		}
	}
	result = n_devices;
	_g_free0 (adapter);
	return result;
}


static void bluetooth_indicator_resync (BluetoothIndicator* self) {
	gint n_devices = 0;
	gint _tmp0_ = 0;
	gchar* lbl = NULL;
	Rfkill* _tmp1_ = NULL;
	gint _tmp11_ = 0;
	GtkImage* _tmp19_ = NULL;
	const gchar* _tmp20_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = bluetooth_indicator_get_n_devices (self);
	n_devices = _tmp0_;
	lbl = NULL;
	_tmp1_ = self->priv->killer;
	if (_tmp1_ != NULL) {
		Rfkill* _tmp2_ = NULL;
		gboolean _tmp3_ = FALSE;
		gboolean _tmp4_ = FALSE;
		_tmp2_ = self->priv->killer;
		_tmp3_ = rfkill_get_BluetoothAirplaneMode (_tmp2_);
		_tmp4_ = _tmp3_;
		if (_tmp4_) {
			GtkImage* _tmp5_ = NULL;
			const gchar* _tmp6_ = NULL;
			gchar* _tmp7_ = NULL;
			_tmp5_ = self->image;
			gtk_image_set_from_icon_name (_tmp5_, "bluetooth-disabled-symbolic", GTK_ICON_SIZE_MENU);
			_tmp6_ = _ ("Bluetooth is disabled");
			_tmp7_ = g_strdup (_tmp6_);
			_g_free0 (lbl);
			lbl = _tmp7_;
			n_devices = 0;
		} else {
			GtkImage* _tmp8_ = NULL;
			const gchar* _tmp9_ = NULL;
			gchar* _tmp10_ = NULL;
			_tmp8_ = self->image;
			gtk_image_set_from_icon_name (_tmp8_, "bluetooth-active-symbolic", GTK_ICON_SIZE_MENU);
			_tmp9_ = _ ("Bluetooth is active");
			_tmp10_ = g_strdup (_tmp9_);
			_g_free0 (lbl);
			lbl = _tmp10_;
		}
	}
	_tmp11_ = n_devices;
	if (_tmp11_ > 0) {
		gint _tmp12_ = 0;
		const gchar* _tmp13_ = NULL;
		gint _tmp14_ = 0;
		gchar* _tmp15_ = NULL;
		GSimpleAction* _tmp16_ = NULL;
		_tmp12_ = n_devices;
		_tmp13_ = ngettext ("Connected to %d device", "Connected to %d devices", (gulong) _tmp12_);
		_tmp14_ = n_devices;
		_tmp15_ = g_strdup_printf (_tmp13_, _tmp14_);
		_g_free0 (lbl);
		lbl = _tmp15_;
		_tmp16_ = self->priv->send_to;
		g_simple_action_set_enabled (_tmp16_, TRUE);
	} else {
		gint _tmp17_ = 0;
		_tmp17_ = n_devices;
		if (_tmp17_ < 0) {
			gtk_widget_hide ((GtkWidget*) self);
			_g_free0 (lbl);
			return;
		} else {
			GSimpleAction* _tmp18_ = NULL;
			_tmp18_ = self->priv->send_to;
			g_simple_action_set_enabled (_tmp18_, FALSE);
		}
	}
	gtk_widget_show ((GtkWidget*) self);
	_tmp19_ = self->image;
	_tmp20_ = lbl;
	gtk_widget_set_tooltip_text ((GtkWidget*) _tmp19_, _tmp20_);
	_g_free0 (lbl);
}


static void bluetooth_indicator_on_settings_activate (BluetoothIndicator* self) {
	GDesktopAppInfo* app_info = NULL;
	GDesktopAppInfo* _tmp0_ = NULL;
	GDesktopAppInfo* _tmp1_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = g_desktop_app_info_new ("gnome-bluetooth-panel.desktop");
	app_info = _tmp0_;
	_tmp1_ = app_info;
	if (_tmp1_ == NULL) {
		_g_object_unref0 (app_info);
		return;
	}
	{
		GDesktopAppInfo* _tmp2_ = NULL;
		_tmp2_ = app_info;
		g_app_info_launch ((GAppInfo*) _tmp2_, NULL, NULL, &_inner_error_);
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch1_g_error;
		}
	}
	goto __finally1;
	__catch1_g_error:
	{
		GError* e = NULL;
		GError* _tmp3_ = NULL;
		const gchar* _tmp4_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp3_ = e;
		_tmp4_ = _tmp3_->message;
		g_message ("BluetoothIndicator.vala:133: Unable to launch gnome-bluetooth-panel.de" \
"sktop: %s", _tmp4_);
		_g_error_free0 (e);
	}
	__finally1:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		_g_object_unref0 (app_info);
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_g_object_unref0 (app_info);
}


static void bluetooth_indicator_on_send_file (BluetoothIndicator* self) {
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	{
		GAppInfo* app_info = NULL;
		GAppInfo* _tmp0_ = NULL;
		GAppInfo* _tmp1_ = NULL;
		_tmp0_ = g_app_info_create_from_commandline ("bluetooth-sendto", "Bluetooth Transfer", G_APP_INFO_CREATE_NONE, &_inner_error_);
		app_info = _tmp0_;
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			goto __catch2_g_error;
		}
		_tmp1_ = app_info;
		if (_tmp1_ == NULL) {
			_g_object_unref0 (app_info);
			return;
		}
		{
			GAppInfo* _tmp2_ = NULL;
			_tmp2_ = app_info;
			g_app_info_launch (_tmp2_, NULL, NULL, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch3_g_error;
			}
		}
		goto __finally3;
		__catch3_g_error:
		{
			GError* e = NULL;
			GError* _tmp3_ = NULL;
			const gchar* _tmp4_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp3_ = e;
			_tmp4_ = _tmp3_->message;
			g_message ("BluetoothIndicator.vala:148: Unable to launch bluetooth-sendto: %s", _tmp4_);
			_g_error_free0 (e);
		}
		__finally3:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			_g_object_unref0 (app_info);
			goto __catch2_g_error;
		}
		_g_object_unref0 (app_info);
	}
	goto __finally2;
	__catch2_g_error:
	{
		GError* e = NULL;
		GError* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp5_ = e;
		_tmp6_ = _tmp5_->message;
		g_message ("BluetoothIndicator.vala:151: Unable to create bluetooth-sendto AppInfo" \
": %s", _tmp6_);
		_g_error_free0 (e);
	}
	__finally2:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
}


static void __lambda4_ (BluetoothIndicator* self) {
	bluetooth_indicator_resync (self);
}


static void ___lambda4__gtk_tree_model_row_changed (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	__lambda4_ ((BluetoothIndicator*) self);
}


static void __lambda5_ (BluetoothIndicator* self) {
	bluetooth_indicator_resync (self);
}


static void ___lambda5__gtk_tree_model_row_deleted (GtkTreeModel* _sender, GtkTreePath* path, gpointer self) {
	__lambda5_ ((BluetoothIndicator*) self);
}


static void __lambda6_ (BluetoothIndicator* self) {
	bluetooth_indicator_resync (self);
}


static void ___lambda6__gtk_tree_model_row_inserted (GtkTreeModel* _sender, GtkTreePath* path, GtkTreeIter* iter, gpointer self) {
	__lambda6_ ((BluetoothIndicator*) self);
}


static void _bluetooth_indicator_on_settings_activate_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	bluetooth_indicator_on_settings_activate ((BluetoothIndicator*) self);
}


static void _bluetooth_indicator_on_send_file_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	bluetooth_indicator_on_send_file ((BluetoothIndicator*) self);
}


static void _bluetooth_indicator_on_set_airplane_g_simple_action_activate (GSimpleAction* _sender, GVariant* parameter, gpointer self) {
	bluetooth_indicator_on_set_airplane ((BluetoothIndicator*) self);
}


static void __lambda7_ (BluetoothIndicator* self) {
	Rfkill* _tmp0_ = NULL;
	_tmp0_ = self->priv->killer;
	if (_tmp0_ == NULL) {
		return;
	}
	bluetooth_indicator_sync_rfkill (self);
}


static void ___lambda7__gasync_ready_callback (GObject* source_object, GAsyncResult* res, gpointer self) {
	__lambda7_ ((BluetoothIndicator*) self);
	g_object_unref (self);
}


BluetoothIndicator* bluetooth_indicator_construct (GType object_type) {
	BluetoothIndicator * self = NULL;
	GtkImage* _tmp0_ = NULL;
	GtkEventBox* _tmp1_ = NULL;
	GtkEventBox* _tmp2_ = NULL;
	GtkEventBox* _tmp3_ = NULL;
	GtkImage* _tmp4_ = NULL;
	BluetoothClient* _tmp5_ = NULL;
	BluetoothClient* _tmp6_ = NULL;
	GtkTreeModel* _tmp7_ = NULL;
	GtkTreeModel* _tmp8_ = NULL;
	GtkTreeModel* _tmp9_ = NULL;
	GtkTreeModel* _tmp10_ = NULL;
	GMenu* menu = NULL;
	GMenu* _tmp11_ = NULL;
	const gchar* _tmp12_ = NULL;
	const gchar* _tmp13_ = NULL;
	const gchar* _tmp14_ = NULL;
	GtkEventBox* _tmp15_ = NULL;
	GtkPopover* _tmp16_ = NULL;
	GSimpleActionGroup* group = NULL;
	GSimpleActionGroup* _tmp17_ = NULL;
	GSimpleAction* settings = NULL;
	GSimpleAction* _tmp18_ = NULL;
	GSimpleAction* _tmp19_ = NULL;
	GSimpleAction* _tmp20_ = NULL;
	GSimpleAction* _tmp21_ = NULL;
	GVariant* _tmp22_ = NULL;
	GVariant* _tmp23_ = NULL;
	GSimpleAction* _tmp24_ = NULL;
	GSimpleAction* _tmp25_ = NULL;
	GSimpleAction* _tmp26_ = NULL;
	self = (BluetoothIndicator*) g_object_new (object_type, NULL);
	_tmp0_ = (GtkImage*) gtk_image_new_from_icon_name ("bluetooth-active-symbolic", GTK_ICON_SIZE_MENU);
	g_object_ref_sink (_tmp0_);
	_g_object_unref0 (self->image);
	self->image = _tmp0_;
	_tmp1_ = (GtkEventBox*) gtk_event_box_new ();
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->ebox);
	self->ebox = _tmp1_;
	_tmp2_ = self->ebox;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp2_);
	_tmp3_ = self->ebox;
	_tmp4_ = self->image;
	gtk_container_add ((GtkContainer*) _tmp3_, (GtkWidget*) _tmp4_);
	_tmp5_ = bluetooth_client_new ();
	_g_object_unref0 (self->priv->client);
	self->priv->client = _tmp5_;
	_tmp6_ = self->priv->client;
	_tmp7_ = bluetooth_client_get_model (_tmp6_);
	_g_object_unref0 (self->priv->model);
	self->priv->model = _tmp7_;
	_tmp8_ = self->priv->model;
	g_signal_connect_object (_tmp8_, "row-changed", (GCallback) ___lambda4__gtk_tree_model_row_changed, self, 0);
	_tmp9_ = self->priv->model;
	g_signal_connect_object (_tmp9_, "row-deleted", (GCallback) ___lambda5__gtk_tree_model_row_deleted, self, 0);
	_tmp10_ = self->priv->model;
	g_signal_connect_object (_tmp10_, "row-inserted", (GCallback) ___lambda6__gtk_tree_model_row_inserted, self, 0);
	_tmp11_ = g_menu_new ();
	menu = _tmp11_;
	_tmp12_ = _ ("Bluetooth Settings");
	g_menu_append (menu, _tmp12_, "bluetooth.settings");
	_tmp13_ = _ ("Send Files");
	g_menu_append (menu, _tmp13_, "bluetooth.send-file");
	_tmp14_ = _ ("Bluetooth Airplane Mode");
	g_menu_append (menu, _tmp14_, "bluetooth.airplane-mode");
	_tmp15_ = self->ebox;
	_tmp16_ = (GtkPopover*) gtk_popover_new_from_model ((GtkWidget*) _tmp15_, (GMenuModel*) menu);
	g_object_ref_sink (_tmp16_);
	_g_object_unref0 (self->popover);
	self->popover = _tmp16_;
	_tmp17_ = g_simple_action_group_new ();
	group = _tmp17_;
	_tmp18_ = g_simple_action_new ("settings", NULL);
	settings = _tmp18_;
	g_signal_connect_object (settings, "activate", (GCallback) _bluetooth_indicator_on_settings_activate_g_simple_action_activate, self, 0);
	g_action_map_add_action ((GActionMap*) group, (GAction*) settings);
	_tmp19_ = g_simple_action_new ("send-file", NULL);
	_g_object_unref0 (self->priv->send_to);
	self->priv->send_to = _tmp19_;
	_tmp20_ = self->priv->send_to;
	g_signal_connect_object (_tmp20_, "activate", (GCallback) _bluetooth_indicator_on_send_file_g_simple_action_activate, self, 0);
	_tmp21_ = self->priv->send_to;
	g_action_map_add_action ((GActionMap*) group, (GAction*) _tmp21_);
	_tmp22_ = g_variant_new_boolean (TRUE);
	g_variant_ref_sink (_tmp22_);
	_tmp23_ = _tmp22_;
	_tmp24_ = g_simple_action_new_stateful ("airplane-mode", NULL, _tmp23_);
	_g_object_unref0 (self->priv->airplane);
	self->priv->airplane = _tmp24_;
	_g_variant_unref0 (_tmp23_);
	_tmp25_ = self->priv->airplane;
	g_signal_connect_object (_tmp25_, "activate", (GCallback) _bluetooth_indicator_on_set_airplane_g_simple_action_activate, self, 0);
	_tmp26_ = self->priv->airplane;
	g_action_map_add_action ((GActionMap*) group, (GAction*) _tmp26_);
	gtk_widget_insert_action_group ((GtkWidget*) self, "bluetooth", (GActionGroup*) group);
	bluetooth_indicator_resync (self);
	bluetooth_indicator_setup_dbus (self, ___lambda7__gasync_ready_callback, g_object_ref (self));
	gtk_widget_show_all ((GtkWidget*) self);
	_g_object_unref0 (settings);
	_g_object_unref0 (group);
	_g_object_unref0 (menu);
	return self;
}


BluetoothIndicator* bluetooth_indicator_new (void) {
	return bluetooth_indicator_construct (TYPE_BLUETOOTH_INDICATOR);
}


static void bluetooth_indicator_on_set_airplane (BluetoothIndicator* self) {
	gboolean s = FALSE;
	GSimpleAction* _tmp0_ = NULL;
	GVariant* _tmp1_ = NULL;
	GVariant* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	gboolean _tmp4_ = FALSE;
	GtkPopover* _tmp8_ = NULL;
	GError * _inner_error_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->airplane;
	_tmp1_ = g_action_get_state ((GAction*) _tmp0_);
	_tmp2_ = _tmp1_;
	_tmp3_ = g_variant_get_boolean (_tmp2_);
	_tmp4_ = !_tmp3_;
	_g_variant_unref0 (_tmp2_);
	s = _tmp4_;
	{
		Rfkill* _tmp5_ = NULL;
		_tmp5_ = self->priv->killer;
		rfkill_set_BluetoothAirplaneMode (_tmp5_, s);
	}
	goto __finally4;
	__catch4_g_error:
	{
		GError* e = NULL;
		GError* _tmp6_ = NULL;
		const gchar* _tmp7_ = NULL;
		e = _inner_error_;
		_inner_error_ = NULL;
		_tmp6_ = e;
		_tmp7_ = _tmp6_->message;
		g_message ("BluetoothIndicator.vala:209: Error setting airplane mode: %s", _tmp7_);
		_g_error_free0 (e);
	}
	__finally4:
	if (G_UNLIKELY (_inner_error_ != NULL)) {
		g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
		g_clear_error (&_inner_error_);
		return;
	}
	_tmp8_ = self->popover;
	gtk_widget_hide ((GtkWidget*) _tmp8_);
}


static void bluetooth_indicator_on_airplane_change (BluetoothIndicator* self) {
	gboolean b = FALSE;
	Rfkill* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GSimpleAction* _tmp3_ = NULL;
	GVariant* _tmp4_ = NULL;
	GVariant* _tmp5_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->killer;
	_tmp1_ = rfkill_get_BluetoothAirplaneMode (_tmp0_);
	_tmp2_ = _tmp1_;
	b = _tmp2_;
	_tmp3_ = self->priv->airplane;
	_tmp4_ = g_variant_new_boolean (b);
	g_variant_ref_sink (_tmp4_);
	_tmp5_ = _tmp4_;
	g_simple_action_set_state (_tmp3_, _tmp5_);
	_g_variant_unref0 (_tmp5_);
	bluetooth_indicator_resync (self);
}


static void _bluetooth_indicator_on_airplane_change_g_dbus_proxy_g_properties_changed (GDBusProxy* _sender, GVariant* changed_properties, gchar** invalidated_properties, gpointer self) {
	bluetooth_indicator_on_airplane_change ((BluetoothIndicator*) self);
}


static void bluetooth_indicator_sync_rfkill (BluetoothIndicator* self) {
	gboolean b = FALSE;
	Rfkill* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	GDBusProxy* db = NULL;
	Rfkill* _tmp3_ = NULL;
	GDBusProxy* _tmp4_ = NULL;
	GSimpleAction* _tmp5_ = NULL;
	GVariant* _tmp6_ = NULL;
	GVariant* _tmp7_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->priv->killer;
	_tmp1_ = rfkill_get_BluetoothAirplaneMode (_tmp0_);
	_tmp2_ = _tmp1_;
	b = _tmp2_;
	_tmp3_ = self->priv->killer;
	_tmp4_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (_tmp3_, G_TYPE_DBUS_PROXY) ? ((GDBusProxy*) _tmp3_) : NULL);
	db = _tmp4_;
	g_signal_connect_object (db, "g-properties-changed", (GCallback) _bluetooth_indicator_on_airplane_change_g_dbus_proxy_g_properties_changed, self, 0);
	_tmp5_ = self->priv->airplane;
	_tmp6_ = g_variant_new_boolean (b);
	g_variant_ref_sink (_tmp6_);
	_tmp7_ = _tmp6_;
	g_simple_action_set_state (_tmp5_, _tmp7_);
	_g_variant_unref0 (_tmp7_);
	bluetooth_indicator_resync (self);
	_g_object_unref0 (db);
}


static void bluetooth_indicator_class_init (BluetoothIndicatorClass * klass) {
	bluetooth_indicator_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (BluetoothIndicatorPrivate));
	G_OBJECT_CLASS (klass)->finalize = bluetooth_indicator_finalize;
}


static void bluetooth_indicator_instance_init (BluetoothIndicator * self) {
	self->priv = BLUETOOTH_INDICATOR_GET_PRIVATE (self);
	self->image = NULL;
	self->ebox = NULL;
	self->priv->client = NULL;
	self->priv->model = NULL;
	self->popover = NULL;
	self->priv->send_to = NULL;
	self->priv->airplane = NULL;
	self->priv->killer = NULL;
}


static void bluetooth_indicator_finalize (GObject* obj) {
	BluetoothIndicator * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BLUETOOTH_INDICATOR, BluetoothIndicator);
	_g_object_unref0 (self->image);
	_g_object_unref0 (self->ebox);
	_g_object_unref0 (self->priv->client);
	_g_object_unref0 (self->priv->model);
	_g_object_unref0 (self->popover);
	_g_object_unref0 (self->priv->send_to);
	_g_object_unref0 (self->priv->airplane);
	_g_object_unref0 (self->priv->killer);
	G_OBJECT_CLASS (bluetooth_indicator_parent_class)->finalize (obj);
}


GType bluetooth_indicator_get_type (void) {
	return bluetooth_indicator_type_id;
}


GType bluetooth_indicator_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (BluetoothIndicatorClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) bluetooth_indicator_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (BluetoothIndicator), 0, (GInstanceInitFunc) bluetooth_indicator_instance_init, NULL };
	bluetooth_indicator_type_id = g_type_module_register_type (module, gtk_bin_get_type (), "BluetoothIndicator", &g_define_type_info, 0);
	return bluetooth_indicator_type_id;
}



