/* Buttons.c generated by valac 0.32.1, the Vala compiler
 * generated from Buttons.vala, do not modify */

/*
 * This file is part of budgie-desktop
 * 
 * Copyright (C) 2014-2016 Ikey Doherty <ikey@solus-project.com>
 * 
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 */

#include <glib.h>
#include <glib-object.h>
#include <stdlib.h>
#include <string.h>
#include <float.h>
#include <math.h>
#include <gtk/gtk.h>
#include <gdk/gdk.h>
#include <libwnck/libwnck.h>
#include <gio/gdesktopappinfo.h>
#include <gio/gio.h>
#include <glib/gi18n-lib.h>
#include <cairo.h>


#define TYPE_BUTTON_WRAPPER (button_wrapper_get_type ())
#define BUTTON_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_BUTTON_WRAPPER, ButtonWrapper))
#define BUTTON_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_BUTTON_WRAPPER, ButtonWrapperClass))
#define IS_BUTTON_WRAPPER(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_BUTTON_WRAPPER))
#define IS_BUTTON_WRAPPER_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_BUTTON_WRAPPER))
#define BUTTON_WRAPPER_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_BUTTON_WRAPPER, ButtonWrapperClass))

typedef struct _ButtonWrapper ButtonWrapper;
typedef struct _ButtonWrapperClass ButtonWrapperClass;
typedef struct _ButtonWrapperPrivate ButtonWrapperPrivate;

#define TYPE_ICON_BUTTON (icon_button_get_type ())
#define ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_ICON_BUTTON, IconButton))
#define ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_ICON_BUTTON, IconButtonClass))
#define IS_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_ICON_BUTTON))
#define IS_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_ICON_BUTTON))
#define ICON_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_ICON_BUTTON, IconButtonClass))

typedef struct _IconButton IconButton;
typedef struct _IconButtonClass IconButtonClass;
typedef struct _IconButtonPrivate IconButtonPrivate;

#define TYPE_APP_SYSTEM (app_system_get_type ())
#define APP_SYSTEM(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_APP_SYSTEM, AppSystem))
#define APP_SYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_APP_SYSTEM, AppSystemClass))
#define IS_APP_SYSTEM(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_APP_SYSTEM))
#define IS_APP_SYSTEM_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_APP_SYSTEM))
#define APP_SYSTEM_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_APP_SYSTEM, AppSystemClass))

typedef struct _AppSystem AppSystem;
typedef struct _AppSystemClass AppSystemClass;
#define _g_object_unref0(var) ((var == NULL) ? NULL : (var = (g_object_unref (var), NULL)))
#define _g_free0(var) (var = (g_free (var), NULL))

#define TYPE_PINNED_ICON_BUTTON (pinned_icon_button_get_type ())
#define PINNED_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_CAST ((obj), TYPE_PINNED_ICON_BUTTON, PinnedIconButton))
#define PINNED_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_CAST ((klass), TYPE_PINNED_ICON_BUTTON, PinnedIconButtonClass))
#define IS_PINNED_ICON_BUTTON(obj) (G_TYPE_CHECK_INSTANCE_TYPE ((obj), TYPE_PINNED_ICON_BUTTON))
#define IS_PINNED_ICON_BUTTON_CLASS(klass) (G_TYPE_CHECK_CLASS_TYPE ((klass), TYPE_PINNED_ICON_BUTTON))
#define PINNED_ICON_BUTTON_GET_CLASS(obj) (G_TYPE_INSTANCE_GET_CLASS ((obj), TYPE_PINNED_ICON_BUTTON, PinnedIconButtonClass))

typedef struct _PinnedIconButton PinnedIconButton;
typedef struct _PinnedIconButtonClass PinnedIconButtonClass;
typedef struct _PinnedIconButtonPrivate PinnedIconButtonPrivate;
typedef struct _Block4Data Block4Data;
typedef struct _Block5Data Block5Data;
typedef struct _Block6Data Block6Data;
#define _g_variant_unref0(var) ((var == NULL) ? NULL : (var = (g_variant_unref (var), NULL)))
#define _g_variant_iter_free0(var) ((var == NULL) ? NULL : (var = (g_variant_iter_free (var), NULL)))
#define _g_error_free0(var) ((var == NULL) ? NULL : (var = (g_error_free (var), NULL)))

struct _ButtonWrapper {
	GtkRevealer parent_instance;
	ButtonWrapperPrivate * priv;
};

struct _ButtonWrapperClass {
	GtkRevealerClass parent_class;
};

struct _ButtonWrapperPrivate {
	IconButton* button;
};

struct _IconButton {
	GtkToggleButton parent_instance;
	IconButtonPrivate * priv;
	GtkImage* image;
	WnckWindow* window;
	WnckActionMenu* menu;
	gint icon_size;
	GDesktopAppInfo* ainfo;
	gboolean requested_pin;
	gboolean should_fade_in;
	GtkAllocation our_alloc;
	gint current_cycles;
	gint panel_size;
	GdkAppLaunchContext* launch_context;
};

struct _IconButtonClass {
	GtkToggleButtonClass parent_class;
	void (*update_icon) (IconButton* self);
	gboolean (*on_button_release) (IconButton* self, GdkEventButton* event);
};

struct _IconButtonPrivate {
	GtkMenuItem* pinnage;
	GtkMenuItem* unpinnage;
	GtkSeparatorMenuItem* sep_item;
	gboolean we_urgent;
	gdouble urg_opacity;
	guint source_id;
	GSettings* settings;
	gchar* wclass_name;
	gulong wclass_id;
	AppSystem* helper;
};

struct _PinnedIconButton {
	IconButton parent_instance;
	PinnedIconButtonPrivate * priv;
	GDesktopAppInfo* app_info;
	gchar* id;
};

struct _PinnedIconButtonClass {
	IconButtonClass parent_class;
};

struct _Block4Data {
	int _ref_count_;
	IconButton* self;
	GtkMenuItem* item;
};

struct _Block5Data {
	int _ref_count_;
	IconButton* self;
	AppSystem* helper;
};

struct _PinnedIconButtonPrivate {
	GtkMenu* alt_menu;
	GSettings* settings;
};

struct _Block6Data {
	int _ref_count_;
	PinnedIconButton* self;
	GSettings* settings;
};


static gpointer button_wrapper_parent_class = NULL;
static GType button_wrapper_type_id = 0;
static gpointer icon_button_parent_class = NULL;
static GType icon_button_type_id = 0;
static gpointer pinned_icon_button_parent_class = NULL;
static GType pinned_icon_button_type_id = 0;

#define BUDGIE_STYLE_CLASS_BUTTON "launcher"
#define MAX_CYCLES 12
#define DEFAULT_OPACITY 0.1
GType button_wrapper_get_type (void) G_GNUC_CONST;
GType button_wrapper_register_type (GTypeModule * module);
GType icon_button_get_type (void) G_GNUC_CONST;
GType icon_button_register_type (GTypeModule * module);
#define BUTTON_WRAPPER_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_BUTTON_WRAPPER, ButtonWrapperPrivate))
enum  {
	BUTTON_WRAPPER_DUMMY_PROPERTY
};
ButtonWrapper* button_wrapper_new (IconButton* button);
ButtonWrapper* button_wrapper_construct (GType object_type, IconButton* button);
void button_wrapper_gracefully_die (ButtonWrapper* self);
static void __lambda14_ (ButtonWrapper* self);
static void ___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self);
static void button_wrapper_finalize (GObject* obj);
GType app_system_get_type (void) G_GNUC_CONST;
GType app_system_register_type (GTypeModule * module);
#define ICON_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_ICON_BUTTON, IconButtonPrivate))
enum  {
	ICON_BUTTON_DUMMY_PROPERTY
};
static void icon_button_update_app_info (IconButton* self);
static void __lambda6_ (IconButton* self);
void desktop_helper_set_pinned (GSettings* settings, GDesktopAppInfo* app_info, gboolean pinned);
static void ___lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda7_ (IconButton* self);
GType pinned_icon_button_get_type (void) G_GNUC_CONST;
GType pinned_icon_button_register_type (GTypeModule * module);
static void ___lambda7__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static Block4Data* block4_data_ref (Block4Data* _data4_);
static void block4_data_unref (void * _userdata_);
static void _____lambda11_ (Block4Data* _data4_);
static void ______lambda11__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
void icon_button_update_icon (IconButton* self);
void icon_button_update_from_window (IconButton* self);
static void _icon_button_update_icon_wnck_window_icon_changed (WnckWindow* _sender, gpointer self);
static void __lambda12_ (IconButton* self);
static void ___lambda12__wnck_window_name_changed (WnckWindow* _sender, gpointer self);
void icon_button_on_state_changed (IconButton* self, WnckWindowState changed, WnckWindowState state);
static void _icon_button_on_state_changed_wnck_window_state_changed (WnckWindow* _sender, WnckWindowState changed_mask, WnckWindowState new_state, gpointer self);
gboolean icon_button_on_tick (IconButton* self, GtkWidget* widget, GdkFrameClock* clock);
static gboolean _icon_button_on_tick_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self);
static gboolean icon_button_real_draw (GtkWidget* base, cairo_t* cr);
IconButton* icon_button_new (GSettings* settings, WnckWindow* window, gint size, GDesktopAppInfo* ainfo, AppSystem* helper, gint panel_size);
IconButton* icon_button_construct (GType object_type, GSettings* settings, WnckWindow* window, gint size, GDesktopAppInfo* ainfo, AppSystem* helper, gint panel_size);
static Block5Data* block5_data_ref (Block5Data* _data5_);
static void block5_data_unref (void * _userdata_);
static void ___lambda13_ (Block5Data* _data5_);
GDesktopAppInfo* app_system_query_window (AppSystem* self, WnckWindow* window);
static void ____lambda13__wnck_window_class_changed (WnckWindow* _sender, gpointer self);
void icon_button_on_size_allocate (IconButton* self, GtkAllocation* alloc);
static void _icon_button_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self);
gboolean icon_button_on_button_release (IconButton* self, GdkEventButton* event);
static gboolean _icon_button_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self);
static void icon_button_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat);
void icon_button_icon_mapped (IconButton* self);
static void icon_button_real_update_icon (IconButton* self);
gboolean app_system_has_derpy_icon (AppSystem* self, WnckWindow* window);
static gboolean icon_button_real_on_button_release (IconButton* self, GdkEventButton* event);
static void icon_button_finalize (GObject* obj);
#define PINNED_ICON_BUTTON_GET_PRIVATE(o) (G_TYPE_INSTANCE_GET_PRIVATE ((o), TYPE_PINNED_ICON_BUTTON, PinnedIconButtonPrivate))
enum  {
	PINNED_ICON_BUTTON_DUMMY_PROPERTY
};
PinnedIconButton* pinned_icon_button_new (GSettings* settings, GDesktopAppInfo* info, gint size, AppSystem* helper, gint panel_size);
PinnedIconButton* pinned_icon_button_construct (GType object_type, GSettings* settings, GDesktopAppInfo* info, gint size, AppSystem* helper, gint panel_size);
static Block6Data* block6_data_ref (Block6Data* _data6_);
static void block6_data_unref (void * _userdata_);
static void __lambda8_ (Block6Data* _data6_);
static void ___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self);
static void __lambda9_ (PinnedIconButton* self, GdkDragContext* context);
static void ___lambda9__gtk_widget_drag_begin (GtkWidget* _sender, GdkDragContext* context, gpointer self);
static void pinned_icon_button_on_launched (PinnedIconButton* self, GAppInfo* info, GVariant* v);
static void _pinned_icon_button_on_launched_g_app_launch_context_launched (GAppLaunchContext* _sender, GAppInfo* info, GVariant* platform_data, gpointer self);
static void pinned_icon_button_on_launch_failed (PinnedIconButton* self, const gchar* id);
static void _pinned_icon_button_on_launch_failed_g_app_launch_context_launch_failed (GAppLaunchContext* _sender, const gchar* startup_notify_id, gpointer self);
static void __lambda10_ (PinnedIconButton* self, GtkWidget* widget, GdkDragContext* context, GtkSelectionData* selection_data, guint info, guint time);
static void ___lambda10__gtk_widget_drag_data_get (GtkWidget* _sender, GdkDragContext* context, GtkSelectionData* selection_data, guint info, guint time_, gpointer self);
static gboolean pinned_icon_button_real_on_button_release (IconButton* base, GdkEventButton* event);
static void pinned_icon_button_real_update_icon (IconButton* base);
void pinned_icon_button_reset (PinnedIconButton* self);
static void pinned_icon_button_finalize (GObject* obj);
static gint _vala_array_length (gpointer array);

extern const GtkTargetEntry DESKTOP_HELPER_targets[1];

ButtonWrapper* button_wrapper_construct (GType object_type, IconButton* button) {
	ButtonWrapper * self = NULL;
	IconButton* _tmp0_ = NULL;
	IconButton* _tmp1_ = NULL;
	self = (ButtonWrapper*) g_object_new (object_type, NULL);
	_tmp0_ = button;
	self->priv->button = _tmp0_;
	gtk_revealer_set_transition_type ((GtkRevealer*) self, GTK_REVEALER_TRANSITION_TYPE_SLIDE_RIGHT);
	_tmp1_ = button;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp1_);
	gtk_revealer_set_reveal_child ((GtkRevealer*) self, FALSE);
	gtk_widget_show_all ((GtkWidget*) self);
	return self;
}


ButtonWrapper* button_wrapper_new (IconButton* button) {
	return button_wrapper_construct (TYPE_BUTTON_WRAPPER, button);
}


static void __lambda14_ (ButtonWrapper* self) {
	gtk_widget_destroy ((GtkWidget*) self);
}


static void ___lambda14__g_object_notify (GObject* _sender, GParamSpec* pspec, gpointer self) {
	__lambda14_ ((ButtonWrapper*) self);
}


void button_wrapper_gracefully_die (ButtonWrapper* self) {
	GtkSettings* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp0_ = gtk_widget_get_settings ((GtkWidget*) self);
	g_object_get (_tmp0_, "gtk-enable-animations", &_tmp1_, NULL);
	_tmp2_ = _tmp1_;
	if (!_tmp2_) {
		gtk_widget_destroy ((GtkWidget*) self);
		return;
	}
	gtk_revealer_set_transition_type ((GtkRevealer*) self, GTK_REVEALER_TRANSITION_TYPE_SLIDE_LEFT);
	g_signal_connect_object ((GObject*) self, "notify::child-revealed", (GCallback) ___lambda14__g_object_notify, self, G_CONNECT_AFTER);
	gtk_revealer_set_reveal_child ((GtkRevealer*) self, FALSE);
}


static void button_wrapper_class_init (ButtonWrapperClass * klass) {
	button_wrapper_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (ButtonWrapperPrivate));
	G_OBJECT_CLASS (klass)->finalize = button_wrapper_finalize;
}


static void button_wrapper_instance_init (ButtonWrapper * self) {
	self->priv = BUTTON_WRAPPER_GET_PRIVATE (self);
}


static void button_wrapper_finalize (GObject* obj) {
	ButtonWrapper * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_BUTTON_WRAPPER, ButtonWrapper);
	G_OBJECT_CLASS (button_wrapper_parent_class)->finalize (obj);
}


GType button_wrapper_get_type (void) {
	return button_wrapper_type_id;
}


GType button_wrapper_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (ButtonWrapperClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) button_wrapper_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (ButtonWrapper), 0, (GInstanceInitFunc) button_wrapper_instance_init, NULL };
	button_wrapper_type_id = g_type_module_register_type (module, gtk_revealer_get_type (), "ButtonWrapper", &g_define_type_info, 0);
	return button_wrapper_type_id;
}


static gpointer _g_object_ref0 (gpointer self) {
	return self ? g_object_ref (self) : NULL;
}


static void __lambda6_ (IconButton* self) {
	GSettings* _tmp0_ = NULL;
	GDesktopAppInfo* _tmp1_ = NULL;
	self->requested_pin = TRUE;
	_tmp0_ = self->priv->settings;
	_tmp1_ = self->ainfo;
	desktop_helper_set_pinned (_tmp0_, _tmp1_, TRUE);
}


static void ___lambda6__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda6_ ((IconButton*) self);
}


static void __lambda7_ (IconButton* self) {
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, TYPE_PINNED_ICON_BUTTON)) {
		PinnedIconButton* p = NULL;
		PinnedIconButton* _tmp0_ = NULL;
		GSettings* _tmp1_ = NULL;
		PinnedIconButton* _tmp2_ = NULL;
		GDesktopAppInfo* _tmp3_ = NULL;
		_tmp0_ = _g_object_ref0 (G_TYPE_CHECK_INSTANCE_TYPE (self, TYPE_PINNED_ICON_BUTTON) ? ((PinnedIconButton*) self) : NULL);
		p = _tmp0_;
		_tmp1_ = self->priv->settings;
		_tmp2_ = p;
		_tmp3_ = _tmp2_->app_info;
		desktop_helper_set_pinned (_tmp1_, _tmp3_, FALSE);
		_g_object_unref0 (p);
	}
}


static void ___lambda7__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda7_ ((IconButton*) self);
}


static Block4Data* block4_data_ref (Block4Data* _data4_) {
	g_atomic_int_inc (&_data4_->_ref_count_);
	return _data4_;
}


static void block4_data_unref (void * _userdata_) {
	Block4Data* _data4_;
	_data4_ = (Block4Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data4_->_ref_count_)) {
		IconButton* self;
		self = _data4_->self;
		_g_object_unref0 (_data4_->item);
		_g_object_unref0 (self);
		g_slice_free (Block4Data, _data4_);
	}
}


static void _____lambda11_ (Block4Data* _data4_) {
	IconButton* self;
	gchar* act = NULL;
	GtkMenuItem* _tmp0_ = NULL;
	gconstpointer _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	const gchar* _tmp3_ = NULL;
	GDesktopAppInfo* _tmp4_ = NULL;
	GdkAppLaunchContext* _tmp5_ = NULL;
	GdkScreen* _tmp6_ = NULL;
	GdkAppLaunchContext* _tmp7_ = NULL;
	GDesktopAppInfo* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GdkAppLaunchContext* _tmp10_ = NULL;
	self = _data4_->self;
	_tmp0_ = _data4_->item;
	_tmp1_ = g_object_get_data ((GObject*) _tmp0_, "__aname");
	_tmp2_ = g_strdup ((const gchar*) _tmp1_);
	act = _tmp2_;
	_tmp3_ = act;
	if (_tmp3_ == NULL) {
		_g_free0 (act);
		return;
	}
	_tmp4_ = self->ainfo;
	if (_tmp4_ == NULL) {
		_g_free0 (act);
		return;
	}
	_tmp5_ = self->launch_context;
	_tmp6_ = gtk_widget_get_screen ((GtkWidget*) self);
	gdk_app_launch_context_set_screen (_tmp5_, _tmp6_);
	_tmp7_ = self->launch_context;
	gdk_app_launch_context_set_timestamp (_tmp7_, (guint32) GDK_CURRENT_TIME);
	_tmp8_ = self->ainfo;
	_tmp9_ = act;
	_tmp10_ = self->launch_context;
	g_desktop_app_info_launch_action (_tmp8_, _tmp9_, (GAppLaunchContext*) _tmp10_);
	_g_free0 (act);
}


static void ______lambda11__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	_____lambda11_ (self);
}


static void icon_button_update_app_info (IconButton* self) {
	WnckWindow* _tmp0_ = NULL;
	WnckActionMenu* _tmp1_ = NULL;
	GtkSeparatorMenuItem* sep = NULL;
	GtkSeparatorMenuItem* _tmp2_ = NULL;
	WnckActionMenu* _tmp3_ = NULL;
	GtkSeparatorMenuItem* _tmp4_ = NULL;
	GtkSeparatorMenuItem* _tmp5_ = NULL;
	GtkSeparatorMenuItem* _tmp6_ = NULL;
	const gchar* _tmp7_ = NULL;
	GtkMenuItem* _tmp8_ = NULL;
	const gchar* _tmp9_ = NULL;
	GtkMenuItem* _tmp10_ = NULL;
	GtkSeparatorMenuItem* _tmp11_ = NULL;
	WnckActionMenu* _tmp12_ = NULL;
	GtkMenuItem* _tmp13_ = NULL;
	WnckActionMenu* _tmp14_ = NULL;
	GtkMenuItem* _tmp15_ = NULL;
	GtkMenuItem* _tmp16_ = NULL;
	GtkMenuItem* _tmp17_ = NULL;
	GDesktopAppInfo* _tmp18_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->window;
	_tmp1_ = (WnckActionMenu*) wnck_action_menu_new (_tmp0_);
	g_object_ref_sink (_tmp1_);
	_g_object_unref0 (self->menu);
	self->menu = _tmp1_;
	_tmp2_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
	g_object_ref_sink (_tmp2_);
	sep = _tmp2_;
	_tmp3_ = self->menu;
	_tmp4_ = sep;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp3_, (GtkWidget*) ((GtkMenuItem*) _tmp4_));
	_tmp5_ = sep;
	_tmp6_ = _g_object_ref0 (_tmp5_);
	_g_object_unref0 (self->priv->sep_item);
	self->priv->sep_item = _tmp6_;
	_tmp7_ = _ ("Pin to panel");
	_tmp8_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp7_);
	g_object_ref_sink (_tmp8_);
	_g_object_unref0 (self->priv->pinnage);
	self->priv->pinnage = _tmp8_;
	_tmp9_ = _ ("Unpin from panel");
	_tmp10_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp9_);
	g_object_ref_sink (_tmp10_);
	_g_object_unref0 (self->priv->unpinnage);
	self->priv->unpinnage = _tmp10_;
	_tmp11_ = sep;
	gtk_widget_show ((GtkWidget*) _tmp11_);
	_tmp12_ = self->menu;
	_tmp13_ = self->priv->pinnage;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp12_, (GtkWidget*) _tmp13_);
	_tmp14_ = self->menu;
	_tmp15_ = self->priv->unpinnage;
	gtk_menu_shell_append ((GtkMenuShell*) _tmp14_, (GtkWidget*) _tmp15_);
	_tmp16_ = self->priv->pinnage;
	g_signal_connect_object (_tmp16_, "activate", (GCallback) ___lambda6__gtk_menu_item_activate, self, 0);
	_tmp17_ = self->priv->unpinnage;
	g_signal_connect_object (_tmp17_, "activate", (GCallback) ___lambda7__gtk_menu_item_activate, self, 0);
	_tmp18_ = self->ainfo;
	if (_tmp18_ != NULL) {
		gchar** actions = NULL;
		GDesktopAppInfo* _tmp19_ = NULL;
		gchar** _tmp20_ = NULL;
		gchar** _tmp21_ = NULL;
		gint actions_length1 = 0;
		gint _actions_size_ = 0;
		gchar** _tmp22_ = NULL;
		gint _tmp22__length1 = 0;
		GtkSeparatorMenuItem* _tmp23_ = NULL;
		WnckActionMenu* _tmp24_ = NULL;
		GtkSeparatorMenuItem* _tmp25_ = NULL;
		GtkSeparatorMenuItem* _tmp26_ = NULL;
		gchar** _tmp27_ = NULL;
		gint _tmp27__length1 = 0;
		_tmp19_ = self->ainfo;
		_tmp21_ = _tmp20_ = g_desktop_app_info_list_actions (_tmp19_);
		actions = _tmp21_;
		actions_length1 = _vala_array_length (_tmp20_);
		_actions_size_ = actions_length1;
		_tmp22_ = actions;
		_tmp22__length1 = actions_length1;
		if (_tmp22__length1 == 0) {
			_g_object_unref0 (sep);
			return;
		}
		_tmp23_ = (GtkSeparatorMenuItem*) gtk_separator_menu_item_new ();
		g_object_ref_sink (_tmp23_);
		_g_object_unref0 (sep);
		sep = _tmp23_;
		_tmp24_ = self->menu;
		_tmp25_ = sep;
		gtk_menu_shell_append ((GtkMenuShell*) _tmp24_, (GtkWidget*) ((GtkMenuItem*) _tmp25_));
		_tmp26_ = sep;
		gtk_widget_show_all ((GtkWidget*) _tmp26_);
		_tmp27_ = actions;
		_tmp27__length1 = actions_length1;
		{
			gchar** action_collection = NULL;
			gint action_collection_length1 = 0;
			gint _action_collection_size_ = 0;
			gint action_it = 0;
			action_collection = _tmp27_;
			action_collection_length1 = _tmp27__length1;
			for (action_it = 0; action_it < _tmp27__length1; action_it = action_it + 1) {
				gchar* _tmp28_ = NULL;
				gchar* action = NULL;
				_tmp28_ = g_strdup (action_collection[action_it]);
				action = _tmp28_;
				{
					Block4Data* _data4_;
					gchar* display_name = NULL;
					GDesktopAppInfo* _tmp29_ = NULL;
					const gchar* _tmp30_ = NULL;
					gchar* _tmp31_ = NULL;
					const gchar* _tmp32_ = NULL;
					GtkMenuItem* _tmp33_ = NULL;
					GtkMenuItem* _tmp34_ = NULL;
					const gchar* _tmp35_ = NULL;
					gchar* _tmp36_ = NULL;
					GtkMenuItem* _tmp37_ = NULL;
					GtkMenuItem* _tmp38_ = NULL;
					WnckActionMenu* _tmp39_ = NULL;
					GtkMenuItem* _tmp40_ = NULL;
					_data4_ = g_slice_new0 (Block4Data);
					_data4_->_ref_count_ = 1;
					_data4_->self = g_object_ref (self);
					_tmp29_ = self->ainfo;
					_tmp30_ = action;
					_tmp31_ = g_desktop_app_info_get_action_name (_tmp29_, _tmp30_);
					display_name = _tmp31_;
					_tmp32_ = display_name;
					_tmp33_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp32_);
					g_object_ref_sink (_tmp33_);
					_data4_->item = _tmp33_;
					_tmp34_ = _data4_->item;
					_tmp35_ = action;
					_tmp36_ = g_strdup (_tmp35_);
					g_object_set_data_full ((GObject*) _tmp34_, "__aname", _tmp36_, g_free);
					_tmp37_ = _data4_->item;
					g_signal_connect_data (_tmp37_, "activate", (GCallback) ______lambda11__gtk_menu_item_activate, block4_data_ref (_data4_), (GClosureNotify) block4_data_unref, 0);
					_tmp38_ = _data4_->item;
					gtk_widget_show_all ((GtkWidget*) _tmp38_);
					_tmp39_ = self->menu;
					_tmp40_ = _data4_->item;
					gtk_menu_shell_append ((GtkMenuShell*) _tmp39_, (GtkWidget*) _tmp40_);
					_g_free0 (display_name);
					_g_free0 (action);
					block4_data_unref (_data4_);
					_data4_ = NULL;
				}
			}
		}
	}
	icon_button_update_icon (self);
	_g_object_unref0 (sep);
}


static void _icon_button_update_icon_wnck_window_icon_changed (WnckWindow* _sender, gpointer self) {
	icon_button_update_icon ((IconButton*) self);
}


static void __lambda12_ (IconButton* self) {
	WnckWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	_tmp0_ = self->window;
	_tmp1_ = wnck_window_get_name (_tmp0_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp1_);
}


static void ___lambda12__wnck_window_name_changed (WnckWindow* _sender, gpointer self) {
	__lambda12_ ((IconButton*) self);
}


static void _icon_button_on_state_changed_wnck_window_state_changed (WnckWindow* _sender, WnckWindowState changed_mask, WnckWindowState new_state, gpointer self) {
	icon_button_on_state_changed ((IconButton*) self, changed_mask, new_state);
}


void icon_button_update_from_window (IconButton* self) {
	guint _tmp0_ = 0U;
	WnckWindow* _tmp2_ = NULL;
	WnckWindow* _tmp5_ = NULL;
	const gchar* _tmp6_ = NULL;
	WnckWindow* _tmp7_ = NULL;
	WnckWindow* _tmp8_ = NULL;
	WnckWindow* _tmp9_ = NULL;
	gboolean _tmp10_ = FALSE;
	WnckWindow* _tmp11_ = NULL;
	g_return_if_fail (self != NULL);
	self->priv->we_urgent = FALSE;
	_tmp0_ = self->priv->source_id;
	if (_tmp0_ > ((guint) 0)) {
		guint _tmp1_ = 0U;
		_tmp1_ = self->priv->source_id;
		gtk_widget_remove_tick_callback ((GtkWidget*) self, _tmp1_);
		self->priv->source_id = (guint) 0;
	}
	_tmp2_ = self->window;
	if (_tmp2_ == NULL) {
		if (G_TYPE_CHECK_INSTANCE_TYPE (self, TYPE_PINNED_ICON_BUTTON)) {
			GtkStyleContext* _tmp3_ = NULL;
			_tmp3_ = gtk_widget_get_style_context ((GtkWidget*) self);
			gtk_style_context_remove_class (_tmp3_, "running");
		}
		return;
	}
	if (G_TYPE_CHECK_INSTANCE_TYPE (self, TYPE_PINNED_ICON_BUTTON)) {
		GtkStyleContext* _tmp4_ = NULL;
		_tmp4_ = gtk_widget_get_style_context ((GtkWidget*) self);
		gtk_style_context_add_class (_tmp4_, "running");
	}
	_tmp5_ = self->window;
	_tmp6_ = wnck_window_get_name (_tmp5_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp6_);
	_tmp7_ = self->window;
	g_signal_connect_object (_tmp7_, "icon-changed", (GCallback) _icon_button_update_icon_wnck_window_icon_changed, self, 0);
	_tmp8_ = self->window;
	g_signal_connect_object (_tmp8_, "name-changed", (GCallback) ___lambda12__wnck_window_name_changed, self, 0);
	icon_button_update_icon (self);
	_tmp9_ = self->window;
	_tmp10_ = wnck_window_is_active (_tmp9_);
	gtk_toggle_button_set_active ((GtkToggleButton*) self, _tmp10_);
	_tmp11_ = self->window;
	g_signal_connect_object (_tmp11_, "state-changed", (GCallback) _icon_button_on_state_changed_wnck_window_state_changed, self, 0);
	icon_button_update_app_info (self);
	gtk_widget_queue_draw ((GtkWidget*) self);
}


static gboolean _icon_button_on_tick_gtk_tick_callback (GtkWidget* widget, GdkFrameClock* frame_clock, gpointer self) {
	gboolean result;
	result = icon_button_on_tick ((IconButton*) self, widget, frame_clock);
	return result;
}


void icon_button_on_state_changed (IconButton* self, WnckWindowState changed, WnckWindowState state) {
	gboolean _tmp0_ = FALSE;
	WnckWindow* _tmp1_ = NULL;
	gboolean _tmp2_ = FALSE;
	g_return_if_fail (self != NULL);
	_tmp1_ = self->window;
	_tmp2_ = wnck_window_needs_attention (_tmp1_);
	if (!_tmp2_) {
		gboolean _tmp3_ = FALSE;
		_tmp3_ = self->priv->we_urgent;
		_tmp0_ = _tmp3_;
	} else {
		_tmp0_ = FALSE;
	}
	if (_tmp0_) {
		guint _tmp4_ = 0U;
		self->priv->we_urgent = FALSE;
		_tmp4_ = self->priv->source_id;
		if (_tmp4_ > ((guint) 0)) {
			guint _tmp5_ = 0U;
			_tmp5_ = self->priv->source_id;
			gtk_widget_remove_tick_callback ((GtkWidget*) self, _tmp5_);
			self->priv->source_id = (guint) 0;
		}
		gtk_widget_queue_draw ((GtkWidget*) self);
		return;
	} else {
		gboolean _tmp6_ = FALSE;
		WnckWindow* _tmp7_ = NULL;
		gboolean _tmp8_ = FALSE;
		_tmp7_ = self->window;
		_tmp8_ = wnck_window_needs_attention (_tmp7_);
		if (_tmp8_) {
			gboolean _tmp9_ = FALSE;
			_tmp9_ = self->priv->we_urgent;
			_tmp6_ = !_tmp9_;
		} else {
			_tmp6_ = FALSE;
		}
		if (_tmp6_) {
			guint _tmp10_ = 0U;
			self->priv->we_urgent = TRUE;
			self->should_fade_in = TRUE;
			self->priv->urg_opacity = DEFAULT_OPACITY;
			self->current_cycles = 0;
			_tmp10_ = gtk_widget_add_tick_callback ((GtkWidget*) self, _icon_button_on_tick_gtk_tick_callback, g_object_ref (self), g_object_unref);
			self->priv->source_id = _tmp10_;
		}
	}
}


gboolean icon_button_on_tick (IconButton* self, GtkWidget* widget, GdkFrameClock* clock) {
	gboolean result = FALSE;
	gdouble increment = 0.0;
	WnckWindow* _tmp0_ = NULL;
	gboolean _tmp1_ = FALSE;
	gdouble _tmp6_ = 0.0;
	gboolean _tmp9_ = FALSE;
	gint _tmp10_ = 0;
	gboolean _tmp12_ = FALSE;
	g_return_val_if_fail (self != NULL, FALSE);
	g_return_val_if_fail (widget != NULL, FALSE);
	g_return_val_if_fail (clock != NULL, FALSE);
	increment = 0.01;
	_tmp0_ = self->window;
	if (_tmp0_ == NULL) {
		self->priv->urg_opacity = 0.0;
		self->priv->we_urgent = FALSE;
		result = FALSE;
		return result;
	}
	_tmp1_ = self->should_fade_in;
	if (_tmp1_) {
		gdouble _tmp2_ = 0.0;
		gdouble _tmp3_ = 0.0;
		_tmp2_ = self->priv->urg_opacity;
		_tmp3_ = increment;
		self->priv->urg_opacity = _tmp2_ + _tmp3_;
	} else {
		gdouble _tmp4_ = 0.0;
		gdouble _tmp5_ = 0.0;
		_tmp4_ = self->priv->urg_opacity;
		_tmp5_ = increment;
		self->priv->urg_opacity = _tmp4_ - _tmp5_;
	}
	_tmp6_ = self->priv->urg_opacity;
	if (_tmp6_ >= 1.0) {
		gint _tmp7_ = 0;
		self->should_fade_in = FALSE;
		self->priv->urg_opacity = 1.0;
		_tmp7_ = self->current_cycles;
		self->current_cycles = _tmp7_ + 1;
	} else {
		gdouble _tmp8_ = 0.0;
		_tmp8_ = self->priv->urg_opacity;
		if (_tmp8_ <= 0.0) {
			self->should_fade_in = TRUE;
			self->priv->urg_opacity = 0.0;
		}
	}
	gtk_widget_queue_draw ((GtkWidget*) self);
	_tmp10_ = self->current_cycles;
	if (_tmp10_ >= MAX_CYCLES) {
		gdouble _tmp11_ = 0.0;
		_tmp11_ = self->priv->urg_opacity;
		_tmp9_ = _tmp11_ >= 1.0;
	} else {
		_tmp9_ = FALSE;
	}
	if (_tmp9_) {
		result = FALSE;
		return result;
	}
	_tmp12_ = self->priv->we_urgent;
	result = _tmp12_;
	return result;
}


static gboolean icon_button_real_draw (GtkWidget* base, cairo_t* cr) {
	IconButton * self;
	gboolean result = FALSE;
	gboolean _tmp0_ = FALSE;
	gint x = 0;
	GtkAllocation _tmp3_ = {0};
	gint _tmp4_ = 0;
	gint y = 0;
	GtkAllocation _tmp5_ = {0};
	gint _tmp6_ = 0;
	gint width = 0;
	GtkAllocation _tmp7_ = {0};
	gint _tmp8_ = 0;
	gint height = 0;
	GtkAllocation _tmp9_ = {0};
	gint _tmp10_ = 0;
	GdkRGBA col = {0};
	GdkRGBA _tmp11_ = {0};
	cairo_t* _tmp12_ = NULL;
	GdkRGBA _tmp13_ = {0};
	gdouble _tmp14_ = 0.0;
	GdkRGBA _tmp15_ = {0};
	gdouble _tmp16_ = 0.0;
	GdkRGBA _tmp17_ = {0};
	gdouble _tmp18_ = 0.0;
	gdouble _tmp19_ = 0.0;
	cairo_t* _tmp20_ = NULL;
	gint _tmp21_ = 0;
	gint _tmp22_ = 0;
	gint _tmp23_ = 0;
	gint _tmp24_ = 0;
	cairo_t* _tmp25_ = NULL;
	cairo_t* _tmp26_ = NULL;
	gboolean _tmp27_ = FALSE;
	self = (IconButton*) base;
	g_return_val_if_fail (cr != NULL, FALSE);
	_tmp0_ = self->priv->we_urgent;
	if (!_tmp0_) {
		cairo_t* _tmp1_ = NULL;
		gboolean _tmp2_ = FALSE;
		_tmp1_ = cr;
		_tmp2_ = GTK_WIDGET_CLASS (icon_button_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), _tmp1_);
		result = _tmp2_;
		return result;
	}
	_tmp3_ = self->our_alloc;
	_tmp4_ = _tmp3_.x;
	x = _tmp4_;
	_tmp5_ = self->our_alloc;
	_tmp6_ = _tmp5_.y;
	y = _tmp6_;
	_tmp7_ = self->our_alloc;
	_tmp8_ = _tmp7_.width;
	width = _tmp8_;
	_tmp9_ = self->our_alloc;
	_tmp10_ = _tmp9_.height;
	height = _tmp10_;
	col = _tmp11_;
	gdk_rgba_parse (&col, "#36689E");
	_tmp12_ = cr;
	_tmp13_ = col;
	_tmp14_ = _tmp13_.red;
	_tmp15_ = col;
	_tmp16_ = _tmp15_.green;
	_tmp17_ = col;
	_tmp18_ = _tmp17_.blue;
	_tmp19_ = self->priv->urg_opacity;
	cairo_set_source_rgba (_tmp12_, _tmp14_, _tmp16_, _tmp18_, _tmp19_);
	_tmp20_ = cr;
	_tmp21_ = x;
	_tmp22_ = y;
	_tmp23_ = width;
	_tmp24_ = height;
	cairo_rectangle (_tmp20_, (gdouble) _tmp21_, (gdouble) _tmp22_, (gdouble) _tmp23_, (gdouble) _tmp24_);
	_tmp25_ = cr;
	cairo_paint (_tmp25_);
	_tmp26_ = cr;
	_tmp27_ = GTK_WIDGET_CLASS (icon_button_parent_class)->draw ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), _tmp26_);
	result = _tmp27_;
	return result;
}


static Block5Data* block5_data_ref (Block5Data* _data5_) {
	g_atomic_int_inc (&_data5_->_ref_count_);
	return _data5_;
}


static void block5_data_unref (void * _userdata_) {
	Block5Data* _data5_;
	_data5_ = (Block5Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data5_->_ref_count_)) {
		IconButton* self;
		self = _data5_->self;
		_g_object_unref0 (_data5_->helper);
		_g_object_unref0 (self);
		g_slice_free (Block5Data, _data5_);
	}
}


static void ___lambda13_ (Block5Data* _data5_) {
	IconButton* self;
	gchar* nclass_name = NULL;
	WnckWindow* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	gchar* _tmp2_ = NULL;
	gboolean _tmp3_ = FALSE;
	const gchar* _tmp4_ = NULL;
	self = _data5_->self;
	_tmp0_ = self->window;
	_tmp1_ = wnck_window_get_class_instance_name (_tmp0_);
	_tmp2_ = g_strdup (_tmp1_);
	nclass_name = _tmp2_;
	_tmp4_ = nclass_name;
	if (_tmp4_ != NULL) {
		const gchar* _tmp5_ = NULL;
		_tmp5_ = self->priv->wclass_name;
		_tmp3_ = _tmp5_ == NULL;
	} else {
		_tmp3_ = FALSE;
	}
	if (_tmp3_) {
		WnckWindow* _tmp6_ = NULL;
		gulong _tmp7_ = 0UL;
		const gchar* _tmp8_ = NULL;
		gchar* _tmp9_ = NULL;
		AppSystem* _tmp10_ = NULL;
		WnckWindow* _tmp11_ = NULL;
		GDesktopAppInfo* _tmp12_ = NULL;
		_tmp6_ = self->window;
		_tmp7_ = self->priv->wclass_id;
		g_signal_handler_disconnect ((GObject*) _tmp6_, _tmp7_);
		self->priv->wclass_id = (gulong) 0;
		_tmp8_ = nclass_name;
		_tmp9_ = g_strdup (_tmp8_);
		_g_free0 (self->priv->wclass_name);
		self->priv->wclass_name = _tmp9_;
		_tmp10_ = _data5_->helper;
		_tmp11_ = self->window;
		_tmp12_ = app_system_query_window (_tmp10_, _tmp11_);
		_g_object_unref0 (self->ainfo);
		self->ainfo = _tmp12_;
		icon_button_update_app_info (self);
	}
	_g_free0 (nclass_name);
}


static void ____lambda13__wnck_window_class_changed (WnckWindow* _sender, gpointer self) {
	___lambda13_ (self);
}


static void _icon_button_on_size_allocate_gtk_widget_size_allocate (GtkWidget* _sender, GtkAllocation* allocation, gpointer self) {
	icon_button_on_size_allocate ((IconButton*) self, allocation);
}


static gboolean _icon_button_on_button_release_gtk_widget_button_release_event (GtkWidget* _sender, GdkEventButton* event, gpointer self) {
	gboolean result;
	result = icon_button_on_button_release ((IconButton*) self, event);
	return result;
}


IconButton* icon_button_construct (GType object_type, GSettings* settings, WnckWindow* window, gint size, GDesktopAppInfo* ainfo, AppSystem* helper, gint panel_size) {
	IconButton * self = NULL;
	Block5Data* _data5_;
	AppSystem* _tmp0_ = NULL;
	AppSystem* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	AppSystem* _tmp3_ = NULL;
	GdkDisplay* _tmp4_ = NULL;
	GdkAppLaunchContext* _tmp5_ = NULL;
	GtkImage* _tmp6_ = NULL;
	GtkImage* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	GtkImage* _tmp11_ = NULL;
	WnckWindow* _tmp12_ = NULL;
	GDesktopAppInfo* _tmp13_ = NULL;
	GDesktopAppInfo* _tmp14_ = NULL;
	WnckWindow* _tmp15_ = NULL;
	gboolean _tmp19_ = FALSE;
	const gchar* _tmp20_ = NULL;
	GtkStyleContext* st = NULL;
	GtkStyleContext* _tmp24_ = NULL;
	GtkStyleContext* _tmp25_ = NULL;
	_data5_ = g_slice_new0 (Block5Data);
	_data5_->_ref_count_ = 1;
	_tmp0_ = helper;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data5_->helper);
	_data5_->helper = _tmp1_;
	self = (IconButton*) g_object_new (object_type, NULL);
	_data5_->self = g_object_ref (self);
	_tmp2_ = settings;
	self->priv->settings = _tmp2_;
	_tmp3_ = _data5_->helper;
	self->priv->helper = _tmp3_;
	_tmp4_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp5_ = gdk_display_get_app_launch_context (_tmp4_);
	_g_object_unref0 (self->launch_context);
	self->launch_context = _tmp5_;
	_tmp6_ = (GtkImage*) gtk_image_new ();
	g_object_ref_sink (_tmp6_);
	_g_object_unref0 (self->image);
	self->image = _tmp6_;
	_tmp7_ = self->image;
	_tmp8_ = size;
	gtk_image_set_pixel_size (_tmp7_, _tmp8_);
	_tmp9_ = size;
	self->icon_size = _tmp9_;
	_tmp10_ = panel_size;
	self->panel_size = _tmp10_;
	_tmp11_ = self->image;
	gtk_container_add ((GtkContainer*) self, (GtkWidget*) _tmp11_);
	_tmp12_ = window;
	self->window = _tmp12_;
	gtk_button_set_relief ((GtkButton*) self, GTK_RELIEF_NONE);
	_tmp13_ = ainfo;
	_tmp14_ = _g_object_ref0 (_tmp13_);
	_g_object_unref0 (self->ainfo);
	self->ainfo = _tmp14_;
	_tmp15_ = self->window;
	if (_tmp15_ != NULL) {
		WnckWindow* _tmp16_ = NULL;
		const gchar* _tmp17_ = NULL;
		gchar* _tmp18_ = NULL;
		_tmp16_ = self->window;
		_tmp17_ = wnck_window_get_class_instance_name (_tmp16_);
		_tmp18_ = g_strdup (_tmp17_);
		_g_free0 (self->priv->wclass_name);
		self->priv->wclass_name = _tmp18_;
	}
	_tmp20_ = self->priv->wclass_name;
	if (_tmp20_ == NULL) {
		GDesktopAppInfo* _tmp21_ = NULL;
		_tmp21_ = self->ainfo;
		_tmp19_ = _tmp21_ == NULL;
	} else {
		_tmp19_ = FALSE;
	}
	if (_tmp19_) {
		WnckWindow* _tmp22_ = NULL;
		gulong _tmp23_ = 0UL;
		_tmp22_ = self->window;
		_tmp23_ = g_signal_connect_data (_tmp22_, "class-changed", (GCallback) ____lambda13__wnck_window_class_changed, block5_data_ref (_data5_), (GClosureNotify) block5_data_unref, 0);
		self->priv->wclass_id = _tmp23_;
	}
	_tmp24_ = gtk_widget_get_style_context ((GtkWidget*) self);
	_tmp25_ = _g_object_ref0 (_tmp24_);
	st = _tmp25_;
	gtk_style_context_remove_class (st, GTK_STYLE_CLASS_BUTTON);
	gtk_style_context_add_class (st, BUDGIE_STYLE_CLASS_BUTTON);
	g_signal_connect_object ((GtkWidget*) self, "size-allocate", (GCallback) _icon_button_on_size_allocate_gtk_widget_size_allocate, self, 0);
	icon_button_update_from_window (self);
	g_signal_connect_object ((GtkWidget*) self, "button-release-event", (GCallback) _icon_button_on_button_release_gtk_widget_button_release_event, self, 0);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	_g_object_unref0 (st);
	block5_data_unref (_data5_);
	_data5_ = NULL;
	return self;
}


IconButton* icon_button_new (GSettings* settings, WnckWindow* window, gint size, GDesktopAppInfo* ainfo, AppSystem* helper, gint panel_size) {
	return icon_button_construct (TYPE_ICON_BUTTON, settings, window, size, ainfo, helper, panel_size);
}


/**
     * Enforce a 1:1.1 aspect ratio
     */
static void icon_button_real_get_preferred_width (GtkWidget* base, gint* min, gint* nat) {
	IconButton * self;
	gint _vala_min = 0;
	gint _vala_nat = 0;
	GtkAllocation alloc = {0};
	gint norm = 0;
	gint _tmp0_ = 0;
	self = (IconButton*) base;
	_tmp0_ = self->panel_size;
	norm = (gint) (((gdouble) _tmp0_) * 1.1);
	_vala_min = norm;
	_vala_nat = norm;
	if (min) {
		*min = _vala_min;
	}
	if (nat) {
		*nat = _vala_nat;
	}
}


/**
     * After allocation to ensure we go to the right place
     */
void icon_button_icon_mapped (IconButton* self) {
	WnckWindow* _tmp0_ = NULL;
	gint x = 0;
	gint y = 0;
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkWidget* _tmp6_ = NULL;
	GdkWindow* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	WnckWindow* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GtkAllocation _tmp15_ = {0};
	gint _tmp16_ = 0;
	GtkAllocation _tmp17_ = {0};
	gint _tmp18_ = 0;
	g_return_if_fail (self != NULL);
	_tmp0_ = self->window;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	toplevel = _tmp2_;
	_tmp3_ = toplevel;
	gtk_widget_translate_coordinates ((GtkWidget*) self, _tmp3_, 0, 0, &_tmp4_, &_tmp5_);
	x = _tmp4_;
	y = _tmp5_;
	_tmp6_ = toplevel;
	_tmp7_ = gtk_widget_get_window (_tmp6_);
	_tmp8_ = x;
	_tmp9_ = y;
	gdk_window_get_root_coords (_tmp7_, _tmp8_, _tmp9_, &_tmp10_, &_tmp11_);
	x = _tmp10_;
	y = _tmp11_;
	_tmp12_ = self->window;
	_tmp13_ = x;
	_tmp14_ = y;
	_tmp15_ = self->our_alloc;
	_tmp16_ = _tmp15_.width;
	_tmp17_ = self->our_alloc;
	_tmp18_ = _tmp17_.height;
	wnck_window_set_icon_geometry (_tmp12_, _tmp13_, _tmp14_, _tmp16_, _tmp18_);
	_g_object_unref0 (toplevel);
}


/**
     * This is for minimize animations, etc.
     */
void icon_button_on_size_allocate (IconButton* self, GtkAllocation* alloc) {
	WnckWindow* _tmp0_ = NULL;
	gint x = 0;
	gint y = 0;
	GtkWidget* toplevel = NULL;
	GtkWidget* _tmp1_ = NULL;
	GtkWidget* _tmp2_ = NULL;
	GtkWidget* _tmp3_ = NULL;
	gint _tmp4_ = 0;
	gint _tmp5_ = 0;
	GtkWidget* _tmp6_ = NULL;
	GdkWindow* _tmp7_ = NULL;
	gint _tmp8_ = 0;
	gint _tmp9_ = 0;
	gint _tmp10_ = 0;
	gint _tmp11_ = 0;
	WnckWindow* _tmp12_ = NULL;
	gint _tmp13_ = 0;
	gint _tmp14_ = 0;
	GtkAllocation _tmp15_ = {0};
	gint _tmp16_ = 0;
	GtkAllocation _tmp17_ = {0};
	gint _tmp18_ = 0;
	GtkAllocation _tmp19_ = {0};
	g_return_if_fail (self != NULL);
	g_return_if_fail (alloc != NULL);
	_tmp0_ = self->window;
	if (_tmp0_ == NULL) {
		return;
	}
	_tmp1_ = gtk_widget_get_toplevel ((GtkWidget*) self);
	_tmp2_ = _g_object_ref0 (_tmp1_);
	toplevel = _tmp2_;
	_tmp3_ = toplevel;
	gtk_widget_translate_coordinates ((GtkWidget*) self, _tmp3_, 0, 0, &_tmp4_, &_tmp5_);
	x = _tmp4_;
	y = _tmp5_;
	_tmp6_ = toplevel;
	_tmp7_ = gtk_widget_get_window (_tmp6_);
	_tmp8_ = x;
	_tmp9_ = y;
	gdk_window_get_root_coords (_tmp7_, _tmp8_, _tmp9_, &_tmp10_, &_tmp11_);
	x = _tmp10_;
	y = _tmp11_;
	_tmp12_ = self->window;
	_tmp13_ = x;
	_tmp14_ = y;
	_tmp15_ = *alloc;
	_tmp16_ = _tmp15_.width;
	_tmp17_ = *alloc;
	_tmp18_ = _tmp17_.height;
	wnck_window_set_icon_geometry (_tmp12_, _tmp13_, _tmp14_, _tmp16_, _tmp18_);
	_tmp19_ = *alloc;
	self->our_alloc = _tmp19_;
	_g_object_unref0 (toplevel);
}


/**
     * Update the icon
     */
static void icon_button_real_update_icon (IconButton* self) {
	WnckWindow* _tmp0_ = NULL;
	GIcon* aicon = NULL;
	GDesktopAppInfo* _tmp1_ = NULL;
	gboolean _tmp4_ = FALSE;
	AppSystem* _tmp5_ = NULL;
	WnckWindow* _tmp6_ = NULL;
	gboolean _tmp7_ = FALSE;
	GtkImage* _tmp26_ = NULL;
	gint _tmp27_ = 0;
	_tmp0_ = self->window;
	if (_tmp0_ == NULL) {
		return;
	}
	aicon = NULL;
	_tmp1_ = self->ainfo;
	if (_tmp1_ != NULL) {
		GDesktopAppInfo* _tmp2_ = NULL;
		GIcon* _tmp3_ = NULL;
		_tmp2_ = self->ainfo;
		_tmp3_ = g_app_info_get_icon ((GAppInfo*) _tmp2_);
		aicon = _tmp3_;
	}
	_tmp5_ = self->priv->helper;
	_tmp6_ = self->window;
	_tmp7_ = app_system_has_derpy_icon (_tmp5_, _tmp6_);
	if (_tmp7_) {
		GIcon* _tmp8_ = NULL;
		_tmp8_ = aicon;
		_tmp4_ = _tmp8_ != NULL;
	} else {
		_tmp4_ = FALSE;
	}
	if (_tmp4_) {
		GtkImage* _tmp9_ = NULL;
		GIcon* _tmp10_ = NULL;
		_tmp9_ = self->image;
		_tmp10_ = aicon;
		gtk_image_set_from_gicon (_tmp9_, _tmp10_, GTK_ICON_SIZE_INVALID);
	} else {
		WnckWindow* _tmp11_ = NULL;
		gboolean _tmp12_ = FALSE;
		_tmp11_ = self->window;
		_tmp12_ = wnck_window_get_icon_is_fallback (_tmp11_);
		if (_tmp12_) {
			gboolean _tmp13_ = FALSE;
			GDesktopAppInfo* _tmp14_ = NULL;
			_tmp14_ = self->ainfo;
			if (_tmp14_ != NULL) {
				GDesktopAppInfo* _tmp15_ = NULL;
				GIcon* _tmp16_ = NULL;
				_tmp15_ = self->ainfo;
				_tmp16_ = g_app_info_get_icon ((GAppInfo*) _tmp15_);
				_tmp13_ = _tmp16_ != NULL;
			} else {
				_tmp13_ = FALSE;
			}
			if (_tmp13_) {
				GtkImage* _tmp17_ = NULL;
				GDesktopAppInfo* _tmp18_ = NULL;
				GIcon* _tmp19_ = NULL;
				_tmp17_ = self->image;
				_tmp18_ = self->ainfo;
				_tmp19_ = g_app_info_get_icon ((GAppInfo*) _tmp18_);
				gtk_image_set_from_gicon (_tmp17_, _tmp19_, GTK_ICON_SIZE_INVALID);
			} else {
				GtkImage* _tmp20_ = NULL;
				WnckWindow* _tmp21_ = NULL;
				GdkPixbuf* _tmp22_ = NULL;
				_tmp20_ = self->image;
				_tmp21_ = self->window;
				_tmp22_ = wnck_window_get_icon (_tmp21_);
				gtk_image_set_from_pixbuf (_tmp20_, _tmp22_);
			}
		} else {
			GtkImage* _tmp23_ = NULL;
			WnckWindow* _tmp24_ = NULL;
			GdkPixbuf* _tmp25_ = NULL;
			_tmp23_ = self->image;
			_tmp24_ = self->window;
			_tmp25_ = wnck_window_get_icon (_tmp24_);
			gtk_image_set_from_pixbuf (_tmp23_, _tmp25_);
		}
	}
	_tmp26_ = self->image;
	_tmp27_ = self->icon_size;
	gtk_image_set_pixel_size (_tmp26_, _tmp27_);
	gtk_widget_queue_resize ((GtkWidget*) self);
}


void icon_button_update_icon (IconButton* self) {
	g_return_if_fail (self != NULL);
	ICON_BUTTON_GET_CLASS (self)->update_icon (self);
}


/**
     * Either show the actions menu, or activate our window
     */
static gboolean icon_button_real_on_button_release (IconButton* self, GdkEventButton* event) {
	gboolean result = FALSE;
	guint32 timestamp = 0U;
	guint32 _tmp0_ = 0U;
	WnckWindow* _tmp1_ = NULL;
	GDesktopAppInfo* _tmp6_ = NULL;
	GdkEventButton* _tmp12_ = NULL;
	guint _tmp13_ = 0U;
	WnckWindow* _tmp18_ = NULL;
	WnckWindow* _tmp21_ = NULL;
	gboolean _tmp22_ = FALSE;
	GdkEventButton* _tmp32_ = NULL;
	gboolean _tmp33_ = FALSE;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = gtk_get_current_event_time ();
	timestamp = _tmp0_;
	_tmp1_ = self->window;
	if (_tmp1_ != NULL) {
		if (G_TYPE_CHECK_INSTANCE_TYPE (self, TYPE_PINNED_ICON_BUTTON)) {
			GtkMenuItem* _tmp2_ = NULL;
			GtkMenuItem* _tmp3_ = NULL;
			_tmp2_ = self->priv->unpinnage;
			gtk_widget_show ((GtkWidget*) _tmp2_);
			_tmp3_ = self->priv->pinnage;
			gtk_widget_hide ((GtkWidget*) _tmp3_);
		} else {
			GtkMenuItem* _tmp4_ = NULL;
			GtkMenuItem* _tmp5_ = NULL;
			_tmp4_ = self->priv->unpinnage;
			gtk_widget_hide ((GtkWidget*) _tmp4_);
			_tmp5_ = self->priv->pinnage;
			gtk_widget_show ((GtkWidget*) _tmp5_);
		}
	}
	_tmp6_ = self->ainfo;
	if (_tmp6_ == NULL) {
		GtkMenuItem* _tmp7_ = NULL;
		GtkMenuItem* _tmp8_ = NULL;
		GtkSeparatorMenuItem* _tmp9_ = NULL;
		_tmp7_ = self->priv->unpinnage;
		gtk_widget_hide ((GtkWidget*) _tmp7_);
		_tmp8_ = self->priv->pinnage;
		gtk_widget_hide ((GtkWidget*) _tmp8_);
		_tmp9_ = self->priv->sep_item;
		gtk_widget_hide ((GtkWidget*) _tmp9_);
	} else {
		GtkSeparatorMenuItem* _tmp10_ = NULL;
		_tmp10_ = self->priv->sep_item;
		if (_tmp10_ != NULL) {
			GtkSeparatorMenuItem* _tmp11_ = NULL;
			_tmp11_ = self->priv->sep_item;
			gtk_widget_show ((GtkWidget*) _tmp11_);
		}
	}
	_tmp12_ = event;
	_tmp13_ = _tmp12_->button;
	if (_tmp13_ == ((guint) 3)) {
		WnckActionMenu* _tmp14_ = NULL;
		GdkEventButton* _tmp15_ = NULL;
		guint _tmp16_ = 0U;
		guint32 _tmp17_ = 0U;
		_tmp14_ = self->menu;
		_tmp15_ = event;
		_tmp16_ = _tmp15_->button;
		_tmp17_ = timestamp;
		gtk_menu_popup ((GtkMenu*) _tmp14_, NULL, NULL, NULL, NULL, _tmp16_, _tmp17_);
		result = TRUE;
		return result;
	}
	_tmp18_ = self->window;
	if (_tmp18_ == NULL) {
		GdkEventButton* _tmp19_ = NULL;
		gboolean _tmp20_ = FALSE;
		_tmp19_ = event;
		_tmp20_ = GTK_WIDGET_CLASS (icon_button_parent_class)->button_release_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), _tmp19_);
		result = _tmp20_;
		return result;
	}
	_tmp21_ = self->window;
	_tmp22_ = wnck_window_is_minimized (_tmp21_);
	if (_tmp22_) {
		WnckWindow* _tmp23_ = NULL;
		guint32 _tmp24_ = 0U;
		WnckWindow* _tmp25_ = NULL;
		guint32 _tmp26_ = 0U;
		_tmp23_ = self->window;
		_tmp24_ = timestamp;
		wnck_window_unminimize (_tmp23_, _tmp24_);
		_tmp25_ = self->window;
		_tmp26_ = timestamp;
		wnck_window_activate (_tmp25_, _tmp26_);
	} else {
		WnckWindow* _tmp27_ = NULL;
		gboolean _tmp28_ = FALSE;
		_tmp27_ = self->window;
		_tmp28_ = wnck_window_is_active (_tmp27_);
		if (_tmp28_) {
			WnckWindow* _tmp29_ = NULL;
			_tmp29_ = self->window;
			wnck_window_minimize (_tmp29_);
		} else {
			WnckWindow* _tmp30_ = NULL;
			guint32 _tmp31_ = 0U;
			_tmp30_ = self->window;
			_tmp31_ = timestamp;
			wnck_window_activate (_tmp30_, _tmp31_);
		}
	}
	_tmp32_ = event;
	_tmp33_ = GTK_WIDGET_CLASS (icon_button_parent_class)->button_release_event ((GtkWidget*) G_TYPE_CHECK_INSTANCE_CAST (self, gtk_toggle_button_get_type (), GtkToggleButton), _tmp32_);
	result = _tmp33_;
	return result;
}


gboolean icon_button_on_button_release (IconButton* self, GdkEventButton* event) {
	g_return_val_if_fail (self != NULL, FALSE);
	return ICON_BUTTON_GET_CLASS (self)->on_button_release (self, event);
}


static void icon_button_class_init (IconButtonClass * klass) {
	icon_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (IconButtonPrivate));
	((GtkWidgetClass *) klass)->draw = icon_button_real_draw;
	((GtkWidgetClass *) klass)->get_preferred_width = icon_button_real_get_preferred_width;
	((IconButtonClass *) klass)->update_icon = icon_button_real_update_icon;
	((IconButtonClass *) klass)->on_button_release = icon_button_real_on_button_release;
	G_OBJECT_CLASS (klass)->finalize = icon_button_finalize;
}


static void icon_button_instance_init (IconButton * self) {
	self->priv = ICON_BUTTON_GET_PRIVATE (self);
	self->requested_pin = FALSE;
	self->priv->we_urgent = FALSE;
	self->priv->urg_opacity = DEFAULT_OPACITY;
	self->should_fade_in = TRUE;
	self->current_cycles = 0;
	self->panel_size = 10;
	self->priv->wclass_name = NULL;
	self->priv->wclass_id = (gulong) 0;
	self->priv->helper = NULL;
}


static void icon_button_finalize (GObject* obj) {
	IconButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_ICON_BUTTON, IconButton);
	_g_object_unref0 (self->image);
	_g_object_unref0 (self->menu);
	_g_object_unref0 (self->ainfo);
	_g_object_unref0 (self->priv->pinnage);
	_g_object_unref0 (self->priv->unpinnage);
	_g_object_unref0 (self->priv->sep_item);
	_g_object_unref0 (self->launch_context);
	_g_free0 (self->priv->wclass_name);
	G_OBJECT_CLASS (icon_button_parent_class)->finalize (obj);
}


GType icon_button_get_type (void) {
	return icon_button_type_id;
}


GType icon_button_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (IconButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) icon_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (IconButton), 0, (GInstanceInitFunc) icon_button_instance_init, NULL };
	icon_button_type_id = g_type_module_register_type (module, gtk_toggle_button_get_type (), "IconButton", &g_define_type_info, 0);
	return icon_button_type_id;
}


static Block6Data* block6_data_ref (Block6Data* _data6_) {
	g_atomic_int_inc (&_data6_->_ref_count_);
	return _data6_;
}


static void block6_data_unref (void * _userdata_) {
	Block6Data* _data6_;
	_data6_ = (Block6Data*) _userdata_;
	if (g_atomic_int_dec_and_test (&_data6_->_ref_count_)) {
		PinnedIconButton* self;
		self = _data6_->self;
		_g_object_unref0 (_data6_->settings);
		_g_object_unref0 (self);
		g_slice_free (Block6Data, _data6_);
	}
}


static void __lambda8_ (Block6Data* _data6_) {
	PinnedIconButton* self;
	GSettings* _tmp0_ = NULL;
	GDesktopAppInfo* _tmp1_ = NULL;
	self = _data6_->self;
	_tmp0_ = _data6_->settings;
	_tmp1_ = self->app_info;
	desktop_helper_set_pinned (_tmp0_, _tmp1_, FALSE);
}


static void ___lambda8__gtk_menu_item_activate (GtkMenuItem* _sender, gpointer self) {
	__lambda8_ (self);
}


static void __lambda9_ (PinnedIconButton* self, GdkDragContext* context) {
	GDesktopAppInfo* _tmp0_ = NULL;
	g_return_if_fail (context != NULL);
	_tmp0_ = ((IconButton*) self)->ainfo;
	if (_tmp0_ != NULL) {
		GdkDragContext* _tmp1_ = NULL;
		GDesktopAppInfo* _tmp2_ = NULL;
		GIcon* _tmp3_ = NULL;
		_tmp1_ = context;
		_tmp2_ = self->app_info;
		_tmp3_ = g_app_info_get_icon ((GAppInfo*) _tmp2_);
		gtk_drag_set_icon_gicon (_tmp1_, _tmp3_, 0, 0);
	} else {
		GdkDragContext* _tmp4_ = NULL;
		_tmp4_ = context;
		gtk_drag_set_icon_default (_tmp4_);
	}
}


static void ___lambda9__gtk_widget_drag_begin (GtkWidget* _sender, GdkDragContext* context, gpointer self) {
	__lambda9_ ((PinnedIconButton*) self, context);
}


static void _pinned_icon_button_on_launched_g_app_launch_context_launched (GAppLaunchContext* _sender, GAppInfo* info, GVariant* platform_data, gpointer self) {
	pinned_icon_button_on_launched ((PinnedIconButton*) self, info, platform_data);
}


static void _pinned_icon_button_on_launch_failed_g_app_launch_context_launch_failed (GAppLaunchContext* _sender, const gchar* startup_notify_id, gpointer self) {
	pinned_icon_button_on_launch_failed ((PinnedIconButton*) self, startup_notify_id);
}


static gchar* string_to_utf8 (const gchar* self, int* result_length1) {
	gchar* result = NULL;
	gchar* _result_ = NULL;
	gint _tmp0_ = 0;
	gint _tmp1_ = 0;
	gchar* _tmp2_ = NULL;
	gint _result__length1 = 0;
	gint __result__size_ = 0;
	gint _tmp3_ = 0;
	gchar* _tmp4_ = NULL;
	gint _tmp4__length1 = 0;
	gint _tmp5_ = 0;
	gint _tmp6_ = 0;
	gchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_val_if_fail (self != NULL, NULL);
	_tmp0_ = strlen (self);
	_tmp1_ = _tmp0_;
	_tmp2_ = g_new0 (gchar, _tmp1_ + 1);
	_result_ = _tmp2_;
	_result__length1 = _tmp1_ + 1;
	__result__size_ = _result__length1;
	_tmp3_ = _result__length1;
	_result__length1 = _tmp3_ - 1;
	_tmp4_ = _result_;
	_tmp4__length1 = _result__length1;
	_tmp5_ = strlen (self);
	_tmp6_ = _tmp5_;
	memcpy (_tmp4_, self, (gsize) _tmp6_);
	_tmp7_ = _result_;
	_tmp7__length1 = _result__length1;
	if (result_length1) {
		*result_length1 = _tmp7__length1;
	}
	result = _tmp7_;
	return result;
}


static void __lambda10_ (PinnedIconButton* self, GtkWidget* widget, GdkDragContext* context, GtkSelectionData* selection_data, guint info, guint time) {
	GtkSelectionData* _tmp0_ = NULL;
	GtkSelectionData* _tmp1_ = NULL;
	GdkAtom _tmp2_ = 0U;
	GDesktopAppInfo* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	gint _tmp5_ = 0;
	gchar* _tmp6_ = NULL;
	guchar* _tmp7_ = NULL;
	gint _tmp7__length1 = 0;
	g_return_if_fail (widget != NULL);
	g_return_if_fail (context != NULL);
	g_return_if_fail (selection_data != NULL);
	_tmp0_ = selection_data;
	_tmp1_ = selection_data;
	_tmp2_ = gtk_selection_data_get_target (_tmp1_);
	_tmp3_ = self->app_info;
	_tmp4_ = g_app_info_get_id ((GAppInfo*) _tmp3_);
	_tmp6_ = string_to_utf8 (_tmp4_, &_tmp5_);
	_tmp7_ = (guchar*) _tmp6_;
	_tmp7__length1 = (_tmp5_ * sizeof (gchar)) / sizeof (guchar);
	gtk_selection_data_set (_tmp0_, _tmp2_, 8, _tmp7_, (_tmp5_ * sizeof (gchar)) / sizeof (guchar));
	_tmp7_ = (g_free (_tmp7_), NULL);
}


static void ___lambda10__gtk_widget_drag_data_get (GtkWidget* _sender, GdkDragContext* context, GtkSelectionData* selection_data, guint info, guint time_, gpointer self) {
	__lambda10_ ((PinnedIconButton*) self, _sender, context, selection_data, info, time_);
}


PinnedIconButton* pinned_icon_button_construct (GType object_type, GSettings* settings, GDesktopAppInfo* info, gint size, AppSystem* helper, gint panel_size) {
	PinnedIconButton * self = NULL;
	Block6Data* _data6_;
	GSettings* _tmp0_ = NULL;
	GSettings* _tmp1_ = NULL;
	GSettings* _tmp2_ = NULL;
	gint _tmp3_ = 0;
	GDesktopAppInfo* _tmp4_ = NULL;
	AppSystem* _tmp5_ = NULL;
	gint _tmp6_ = 0;
	GDesktopAppInfo* _tmp7_ = NULL;
	GDesktopAppInfo* _tmp8_ = NULL;
	GSettings* _tmp9_ = NULL;
	GDesktopAppInfo* _tmp10_ = NULL;
	const gchar* _tmp11_ = NULL;
	GtkImage* _tmp12_ = NULL;
	GDesktopAppInfo* _tmp13_ = NULL;
	GIcon* _tmp14_ = NULL;
	GtkMenu* _tmp15_ = NULL;
	GtkMenuItem* item = NULL;
	const gchar* _tmp16_ = NULL;
	GtkMenuItem* _tmp17_ = NULL;
	GtkMenu* _tmp18_ = NULL;
	GdkAppLaunchContext* _tmp19_ = NULL;
	GdkAppLaunchContext* _tmp20_ = NULL;
	g_return_val_if_fail (settings != NULL, NULL);
	g_return_val_if_fail (info != NULL, NULL);
	_data6_ = g_slice_new0 (Block6Data);
	_data6_->_ref_count_ = 1;
	_tmp0_ = settings;
	_tmp1_ = _g_object_ref0 (_tmp0_);
	_g_object_unref0 (_data6_->settings);
	_data6_->settings = _tmp1_;
	_tmp2_ = _data6_->settings;
	_tmp3_ = size;
	_tmp4_ = info;
	_tmp5_ = helper;
	_tmp6_ = panel_size;
	self = (PinnedIconButton*) icon_button_construct (object_type, _tmp2_, NULL, _tmp3_, _tmp4_, _tmp5_, _tmp6_);
	_data6_->self = g_object_ref (self);
	_tmp7_ = info;
	_tmp8_ = _g_object_ref0 (_tmp7_);
	_g_object_unref0 (self->app_info);
	self->app_info = _tmp8_;
	_tmp9_ = _data6_->settings;
	self->priv->settings = _tmp9_;
	_tmp10_ = info;
	_tmp11_ = g_app_info_get_display_name ((GAppInfo*) _tmp10_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp11_);
	_tmp12_ = ((IconButton*) self)->image;
	_tmp13_ = info;
	_tmp14_ = g_app_info_get_icon ((GAppInfo*) _tmp13_);
	gtk_image_set_from_gicon (_tmp12_, _tmp14_, GTK_ICON_SIZE_INVALID);
	_tmp15_ = (GtkMenu*) gtk_menu_new ();
	g_object_ref_sink (_tmp15_);
	_g_object_unref0 (self->priv->alt_menu);
	self->priv->alt_menu = _tmp15_;
	_tmp16_ = _ ("Unpin from panel");
	_tmp17_ = (GtkMenuItem*) gtk_menu_item_new_with_label (_tmp16_);
	g_object_ref_sink (_tmp17_);
	item = _tmp17_;
	_tmp18_ = self->priv->alt_menu;
	gtk_container_add ((GtkContainer*) _tmp18_, (GtkWidget*) item);
	gtk_widget_show_all ((GtkWidget*) item);
	g_signal_connect_data (item, "activate", (GCallback) ___lambda8__gtk_menu_item_activate, block6_data_ref (_data6_), (GClosureNotify) block6_data_unref, 0);
	gtk_widget_set_can_focus ((GtkWidget*) self, FALSE);
	gtk_drag_source_set ((GtkWidget*) self, GDK_BUTTON1_MASK, DESKTOP_HELPER_targets, G_N_ELEMENTS (DESKTOP_HELPER_targets), GDK_ACTION_MOVE);
	g_signal_connect_object ((GtkWidget*) self, "drag-begin", (GCallback) ___lambda9__gtk_widget_drag_begin, self, 0);
	_tmp19_ = ((IconButton*) self)->launch_context;
	g_signal_connect_object ((GAppLaunchContext*) _tmp19_, "launched", (GCallback) _pinned_icon_button_on_launched_g_app_launch_context_launched, self, 0);
	_tmp20_ = ((IconButton*) self)->launch_context;
	g_signal_connect_object ((GAppLaunchContext*) _tmp20_, "launch-failed", (GCallback) _pinned_icon_button_on_launch_failed_g_app_launch_context_launch_failed, self, 0);
	g_signal_connect_object ((GtkWidget*) self, "drag-data-get", (GCallback) ___lambda10__gtk_widget_drag_data_get, self, 0);
	_g_object_unref0 (item);
	block6_data_unref (_data6_);
	_data6_ = NULL;
	return self;
}


PinnedIconButton* pinned_icon_button_new (GSettings* settings, GDesktopAppInfo* info, gint size, AppSystem* helper, gint panel_size) {
	return pinned_icon_button_construct (TYPE_PINNED_ICON_BUTTON, settings, info, size, helper, panel_size);
}


/**
     * Handle startup notification, set our own ID to the ID selected
     */
static void pinned_icon_button_on_launched (PinnedIconButton* self, GAppInfo* info, GVariant* v) {
	GVariant* elem = NULL;
	GVariantIter* iter = NULL;
	GVariant* _tmp0_ = NULL;
	GVariantIter* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (info != NULL);
	g_return_if_fail (v != NULL);
	_tmp0_ = v;
	_tmp1_ = g_variant_iter_new (_tmp0_);
	iter = _tmp1_;
	while (TRUE) {
		GVariantIter* _tmp2_ = NULL;
		GVariant* _tmp3_ = NULL;
		GVariant* _tmp4_ = NULL;
		gchar* key = NULL;
		GVariant* val = NULL;
		GVariant* _tmp5_ = NULL;
		const gchar* _tmp6_ = NULL;
		GVariant* _tmp7_ = NULL;
		const GVariantType* _tmp8_ = NULL;
		gboolean _tmp9_ = FALSE;
		const gchar* _tmp10_ = NULL;
		GVariant* _tmp11_ = NULL;
		gchar* _tmp12_ = NULL;
		GdkDisplay* _tmp13_ = NULL;
		const gchar* _tmp14_ = NULL;
		_tmp2_ = iter;
		_tmp3_ = g_variant_iter_next_value (_tmp2_);
		_g_variant_unref0 (elem);
		elem = _tmp3_;
		_tmp4_ = elem;
		if (!(_tmp4_ != NULL)) {
			break;
		}
		key = NULL;
		val = NULL;
		_tmp5_ = elem;
		g_variant_get (_tmp5_, "{sv}", &key, &val, NULL);
		_tmp6_ = key;
		if (_tmp6_ == NULL) {
			_g_variant_unref0 (val);
			_g_free0 (key);
			continue;
		}
		_tmp7_ = val;
		_tmp8_ = G_VARIANT_TYPE_STRING;
		_tmp9_ = g_variant_is_of_type (_tmp7_, _tmp8_);
		if (!_tmp9_) {
			_g_variant_unref0 (val);
			_g_free0 (key);
			continue;
		}
		_tmp10_ = key;
		if (g_strcmp0 (_tmp10_, "startup-notification-id") != 0) {
			_g_variant_unref0 (val);
			_g_free0 (key);
			continue;
		}
		_tmp11_ = val;
		_tmp12_ = g_variant_dup_string (_tmp11_, NULL);
		_g_free0 (self->id);
		self->id = _tmp12_;
		_tmp13_ = gtk_widget_get_display ((GtkWidget*) self);
		_tmp14_ = self->id;
		gdk_display_notify_startup_complete (_tmp13_, _tmp14_);
		_g_variant_unref0 (val);
		_g_free0 (key);
	}
	_g_variant_iter_free0 (iter);
	_g_variant_unref0 (elem);
}


/**
     * Not much to do just set our ID to null
     */
static void pinned_icon_button_on_launch_failed (PinnedIconButton* self, const gchar* id) {
	GdkDisplay* _tmp0_ = NULL;
	const gchar* _tmp1_ = NULL;
	g_return_if_fail (self != NULL);
	g_return_if_fail (id != NULL);
	_tmp0_ = gtk_widget_get_display ((GtkWidget*) self);
	_tmp1_ = id;
	gdk_display_notify_startup_complete (_tmp0_, _tmp1_);
	_g_free0 (self->id);
	self->id = NULL;
}


static gboolean pinned_icon_button_real_on_button_release (IconButton* base, GdkEventButton* event) {
	PinnedIconButton * self;
	gboolean result = FALSE;
	WnckWindow* _tmp0_ = NULL;
	GError * _inner_error_ = NULL;
	self = (PinnedIconButton*) base;
	g_return_val_if_fail (event != NULL, FALSE);
	_tmp0_ = ((IconButton*) self)->window;
	if (_tmp0_ == NULL) {
		GdkEventButton* _tmp1_ = NULL;
		guint _tmp2_ = 0U;
		GdkEventButton* _tmp7_ = NULL;
		guint _tmp8_ = 0U;
		GdkEventButton* _tmp18_ = NULL;
		gboolean _tmp19_ = FALSE;
		_tmp1_ = event;
		_tmp2_ = _tmp1_->button;
		if (_tmp2_ == ((guint) 3)) {
			GtkMenu* _tmp3_ = NULL;
			GdkEventButton* _tmp4_ = NULL;
			guint _tmp5_ = 0U;
			guint32 _tmp6_ = 0U;
			_tmp3_ = self->priv->alt_menu;
			_tmp4_ = event;
			_tmp5_ = _tmp4_->button;
			_tmp6_ = gtk_get_current_event_time ();
			gtk_menu_popup (_tmp3_, NULL, NULL, NULL, NULL, _tmp5_, _tmp6_);
			result = TRUE;
			return result;
		}
		_tmp7_ = event;
		_tmp8_ = _tmp7_->button;
		if (_tmp8_ != ((guint) 1)) {
			result = TRUE;
			return result;
		}
		{
			GdkAppLaunchContext* _tmp9_ = NULL;
			GdkScreen* _tmp10_ = NULL;
			GdkAppLaunchContext* _tmp11_ = NULL;
			GdkEventButton* _tmp12_ = NULL;
			guint32 _tmp13_ = 0U;
			GDesktopAppInfo* _tmp14_ = NULL;
			GdkAppLaunchContext* _tmp15_ = NULL;
			_tmp9_ = ((IconButton*) self)->launch_context;
			_tmp10_ = gtk_widget_get_screen ((GtkWidget*) self);
			gdk_app_launch_context_set_screen (_tmp9_, _tmp10_);
			_tmp11_ = ((IconButton*) self)->launch_context;
			_tmp12_ = event;
			_tmp13_ = _tmp12_->time;
			gdk_app_launch_context_set_timestamp (_tmp11_, _tmp13_);
			_tmp14_ = self->app_info;
			_tmp15_ = ((IconButton*) self)->launch_context;
			g_app_info_launch ((GAppInfo*) _tmp14_, NULL, (GAppLaunchContext*) _tmp15_, &_inner_error_);
			if (G_UNLIKELY (_inner_error_ != NULL)) {
				goto __catch2_g_error;
			}
		}
		goto __finally2;
		__catch2_g_error:
		{
			GError* e = NULL;
			GError* _tmp16_ = NULL;
			const gchar* _tmp17_ = NULL;
			e = _inner_error_;
			_inner_error_ = NULL;
			_tmp16_ = e;
			_tmp17_ = _tmp16_->message;
			g_message ("Buttons.vala:544: %s", _tmp17_);
			_g_error_free0 (e);
		}
		__finally2:
		if (G_UNLIKELY (_inner_error_ != NULL)) {
			g_critical ("file %s: line %d: uncaught error: %s (%s, %d)", __FILE__, __LINE__, _inner_error_->message, g_quark_to_string (_inner_error_->domain), _inner_error_->code);
			g_clear_error (&_inner_error_);
			return FALSE;
		}
		_tmp18_ = event;
		_tmp19_ = ICON_BUTTON_CLASS (pinned_icon_button_parent_class)->on_button_release (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ICON_BUTTON, IconButton), _tmp18_);
		result = _tmp19_;
		return result;
	} else {
		GdkEventButton* _tmp20_ = NULL;
		gboolean _tmp21_ = FALSE;
		_tmp20_ = event;
		_tmp21_ = ICON_BUTTON_CLASS (pinned_icon_button_parent_class)->on_button_release (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ICON_BUTTON, IconButton), _tmp20_);
		result = _tmp21_;
		return result;
	}
}


static void pinned_icon_button_real_update_icon (IconButton* base) {
	PinnedIconButton * self;
	WnckWindow* _tmp0_ = NULL;
	GtkImage* _tmp1_ = NULL;
	gint _tmp2_ = 0;
	self = (PinnedIconButton*) base;
	_tmp0_ = ((IconButton*) self)->window;
	if (_tmp0_ != NULL) {
		ICON_BUTTON_CLASS (pinned_icon_button_parent_class)->update_icon (G_TYPE_CHECK_INSTANCE_CAST (self, TYPE_ICON_BUTTON, IconButton));
		return;
	}
	_tmp1_ = ((IconButton*) self)->image;
	_tmp2_ = ((IconButton*) self)->icon_size;
	gtk_image_set_pixel_size (_tmp1_, _tmp2_);
	gtk_widget_queue_resize ((GtkWidget*) self);
}


void pinned_icon_button_reset (PinnedIconButton* self) {
	GtkImage* _tmp0_ = NULL;
	GDesktopAppInfo* _tmp1_ = NULL;
	GIcon* _tmp2_ = NULL;
	GDesktopAppInfo* _tmp3_ = NULL;
	const gchar* _tmp4_ = NULL;
	GtkStyleContext* _tmp5_ = NULL;
	WnckActionMenu* _tmp6_ = NULL;
	g_return_if_fail (self != NULL);
	_tmp0_ = ((IconButton*) self)->image;
	_tmp1_ = self->app_info;
	_tmp2_ = g_app_info_get_icon ((GAppInfo*) _tmp1_);
	gtk_image_set_from_gicon (_tmp0_, _tmp2_, GTK_ICON_SIZE_INVALID);
	_tmp3_ = self->app_info;
	_tmp4_ = g_app_info_get_display_name ((GAppInfo*) _tmp3_);
	gtk_widget_set_tooltip_text ((GtkWidget*) self, _tmp4_);
	_tmp5_ = gtk_widget_get_style_context ((GtkWidget*) self);
	gtk_style_context_remove_class (_tmp5_, "running");
	gtk_toggle_button_set_active ((GtkToggleButton*) self, FALSE);
	_tmp6_ = ((IconButton*) self)->menu;
	gtk_widget_destroy ((GtkWidget*) _tmp6_);
	_g_object_unref0 (((IconButton*) self)->menu);
	((IconButton*) self)->menu = NULL;
	((IconButton*) self)->window = NULL;
	_g_free0 (self->id);
	self->id = NULL;
}


static void pinned_icon_button_class_init (PinnedIconButtonClass * klass) {
	pinned_icon_button_parent_class = g_type_class_peek_parent (klass);
	g_type_class_add_private (klass, sizeof (PinnedIconButtonPrivate));
	((IconButtonClass *) klass)->on_button_release = pinned_icon_button_real_on_button_release;
	((IconButtonClass *) klass)->update_icon = pinned_icon_button_real_update_icon;
	G_OBJECT_CLASS (klass)->finalize = pinned_icon_button_finalize;
}


static void pinned_icon_button_instance_init (PinnedIconButton * self) {
	self->priv = PINNED_ICON_BUTTON_GET_PRIVATE (self);
	self->id = NULL;
}


static void pinned_icon_button_finalize (GObject* obj) {
	PinnedIconButton * self;
	self = G_TYPE_CHECK_INSTANCE_CAST (obj, TYPE_PINNED_ICON_BUTTON, PinnedIconButton);
	_g_object_unref0 (self->app_info);
	_g_free0 (self->id);
	_g_object_unref0 (self->priv->alt_menu);
	G_OBJECT_CLASS (pinned_icon_button_parent_class)->finalize (obj);
}


GType pinned_icon_button_get_type (void) {
	return pinned_icon_button_type_id;
}


GType pinned_icon_button_register_type (GTypeModule * module) {
	static const GTypeInfo g_define_type_info = { sizeof (PinnedIconButtonClass), (GBaseInitFunc) NULL, (GBaseFinalizeFunc) NULL, (GClassInitFunc) pinned_icon_button_class_init, (GClassFinalizeFunc) NULL, NULL, sizeof (PinnedIconButton), 0, (GInstanceInitFunc) pinned_icon_button_instance_init, NULL };
	pinned_icon_button_type_id = g_type_module_register_type (module, TYPE_ICON_BUTTON, "PinnedIconButton", &g_define_type_info, 0);
	return pinned_icon_button_type_id;
}


static gint _vala_array_length (gpointer array) {
	int length;
	length = 0;
	if (array) {
		while (((gpointer*) array)[length]) {
			length++;
		}
	}
	return length;
}



