/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *-------------------------------------------------------------------
 * Project: Beesoft Commander
 * Author : Piotr Pszczolkowski
 * Contact: piotr@beesoft.org
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "ViewGeneric.h"
#include "Settings.h"
#include "Config.h"
#include "Workspace.h"
#include <qlayout.h>
#include <qtabbar.h>
#include <qapplication.h>

//*******************************************************************
// ViewGeneric                                  
//*******************************************************************
ViewGeneric::ViewGeneric( QWidget* const in_parent, Workspace* const in_workspace )
: QFrame        ( in_parent )
, d_workspace   ( in_workspace )
, d_main_layout ( new QVBoxLayout( this ))
, d_tab_bar     ( new QTabBar( this ))
, d_widget_stack( new QWidgetStack( this ))
{
	d_tab_bar->setFont( Config::instance()->lfs_font() );
	d_tab_bar->setFocusPolicy( ClickFocus );
	d_main_layout->addWidget( d_tab_bar );
	d_main_layout->addWidget( d_widget_stack );
	d_main_layout->setStretchFactor( d_widget_stack, Shared::OverStretch );
}
// end of ViewGeneric

//*******************************************************************
// has_focus                                                  PUBLIC
//*******************************************************************
bool ViewGeneric::has_focus()
{
	const ViewWindow* const view = current_view();
	return ( view ? view->has_focus() : FALSE );
}
// end of has_focus

//*******************************************************************
// set_tab                                                 PROTECTED
//-------------------------------------------------------------------
// Zmiana zakladki.
//*******************************************************************
void ViewGeneric::set_tab( const int in_id )
{
	ViewWindow* const prv_view = current_view();
	if( prv_view ) prv_view->disconnect();
	
	d_widget_stack->raiseWidget( in_id );
	d_tab_bar->setCurrentTab( in_id );
}
// end of set_tab

//*******************************************************************
// new_tab                                                 PROTECTED
//*******************************************************************
ViewWindow* ViewGeneric::new_tab( const QString& in_dir, int& out_id )
{
	ViewWindow* const view = new ViewWindow( this );
	if( view ) {
		out_id = d_tab_bar->insertTab( new QTab( in_dir ) );
		d_widget_stack->addWidget( view, out_id );
		d_tab_bar->update();
		d_widget_stack->update();
	}
	return view;
}
// end of new_tab

//*******************************************************************
// remove_tab                                              PROTECTED
//*******************************************************************
int ViewGeneric::remove_tab()
{
	int index = -1;
	
	if( d_tab_bar->count() > 1 ) {
		const int id = d_widget_stack->id( d_widget_stack->visibleWidget() );
		if( id != -1 ) {
			index = d_tab_bar->indexOf( id );
			d_tab_bar->removeTab( d_tab_bar->tab( id ) );
			d_widget_stack->removeWidget( d_widget_stack->widget( id ) );
			d_tab_bar->update();
			d_widget_stack->update();
		}
	}
	
	return index;
}
// end of remove_tab

//*******************************************************************
// slot_tab_update                                      PRIVATE slot
//-------------------------------------------------------------------
// Slot wykorzystywamy przez widok 'view' w celu uaktualnienia 
// nazwy katalogu wyswietlanego na tabie.
//*******************************************************************
void ViewGeneric::slot_tab_update( const QString& in_path )
{
	const int id = d_widget_stack->id( d_widget_stack->visibleWidget() );
	if( id != -1 ) {
		d_tab_bar->tab( id )->setText( in_path );
	}
}
// end of slot_tab_update

//*******************************************************************
// slot_looks_refresh                                   PRIVATE slot
//*******************************************************************
void ViewGeneric::slot_looks_refresh()
{
	for ( int i = 0; i < d_tab_bar->count(); ++i ) {
		ViewWindow* const view =
		dynamic_cast<ViewWindow*>( d_widget_stack->widget( d_tab_bar->tabAt( i )->identifier() ));
		if( view ) view->looks_refresh();
    }
}
// end of slot_looks_refresh

//*******************************************************************
// slot_update_lang                                     PRIVATE slot
//*******************************************************************
void ViewGeneric::slot_update_lang()
{
	for ( int i = 0; i < d_tab_bar->count(); ++i ) {
		ViewWindow* const view =
		dynamic_cast<ViewWindow*>( d_widget_stack->widget( d_tab_bar->tabAt( i )->identifier() ));
		if( view ) view->lang_changed();
	}
}
// end of slot_update_lang
