/******************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_TREE_H
#define INCLUDED_TREE_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_QFILEINFO_H
#include <qfileinfo.h>
#define INCLUDED_QFILEINFO_H
#endif // INCLUDED_QFILEINFO_H

#ifndef INCLUDED_QLISTVIEW_H
#include <qlistview.h>
#define INCLUDED_QLISTVIEW_H
#endif // INCLUDED_QLISTVIEW_H

#ifndef INCLUDED_QPIXMAP_H
#include <qpixmap.h>
#define INCLUDED_QPIXMAP_H
#endif // INCLUDED_QPIXMAP_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QListView;
class QListViewItem;
class QPushButton;
class QLabel;

/*------- class declaration:
-------------------------------------------------------------------*/
class Tree : public QDialog
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	Tree( QWidget*, const QString& = QString::null );
private:
	Tree( const Tree& );
	Tree& operator=( const Tree& );

// ******* TYPES *******
private:
	class ViewItem : public QListViewItem
	{
	public:
		ViewItem( QListView* const in_parent, const QFileInfo* const in_finfo )
		: QListViewItem( in_parent, ( "/" == in_finfo->absFilePath() ) ? "/" : in_finfo->fileName() )
		, d_info( *in_finfo )
		{
			add_icon();
		}
		ViewItem( ViewItem* const in_parent, const QFileInfo* const in_finfo )
		: QListViewItem( in_parent, in_finfo->fileName() )
		, d_info( *in_finfo )
		{
			add_icon();
		}
	private:
		ViewItem( const ViewItem& );
		ViewItem& operator=( const ViewItem& );
	public:
		const QFileInfo d_info;
	private:
		void add_icon();
	};

// ******* CONSTANTS *******
private:
	static const QString Caption;
	static const QString Dirs;
	static const QString CantReadDir;
	static const QString DirNotValid;
	static const QString DirNotFound;

// ******* MEMBERS *******
private:
	QString      d_from_dir;
	const QString      d_current_dir;
	QListView*   const d_view;
	QPushButton* const d_select_btn;
	QPushButton* const d_return_btn;
	bool               d_break;
	bool               d_finished;
	QFileInfo          d_finfo;
	QLabel*      const d_counter_lb;
	int                d_counter;

// ******* METHODS *******
private:
	void show ();
	void polish();
	void keyPressEvent( QKeyEvent* e );
	void parse( ViewItem*, const QString&, const int );
	void select();
	void update_counter();
public:
	QString get_dir();
private slots:
	void slot_select();
	void slot_return();
};

//*******************************************************************
// add_icon                                           PRIVATE inline
//*******************************************************************
inline void Tree::ViewItem::add_icon()
{
	if( d_info.isExecutable() && d_info.isReadable() ) {
		setPixmap( 0, QPixmap::fromMimeSource( "folder.png" ));
	}
	else {
		setPixmap( 0, QPixmap::fromMimeSource( "ifolder.png" ));
	}
}
// end of add_icon

//*******************************************************************
// get_dir                                            PRIVATE inline
//*******************************************************************
inline QString Tree::get_dir()
{
	const ViewItem* const item = dynamic_cast<ViewItem*>( d_view->selectedItem() );
	if( item ) return item->d_info.absFilePath();
	else       return QString::null;
}
// end of get_dir

#endif // INCLUDED_TREE_H
