/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_FTPSERVERSLIST_H
#define INCLUDED_FTPSERVERSLIST_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_FTPSERVERINFO_H
#include "FtpServerInfo.h"
#endif // INCLUDED_FTPSERVERINFO_H

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif // INCLUDED_VECTOR

/*------- forward declarations:
-------------------------------------------------------------------*/
class QPushButton;
class QListView;
class QListViewItem;
class QHBoxLayout;
class QVBoxLayout;

/*------- class declaration:
-------------------------------------------------------------------*/
class FtpServersList : public QDialog
{
	Q_OBJECT
	
// ******* CONSTRUCTION *******
public:
	FtpServersList( QWidget* const in_widget );
private:
	FtpServersList( const FtpServersList& );
	FtpServersList& operator=( const FtpServersList& );

// ******* CONSTANTS *******
private:
	static const QString CAPTION;
	static const QString FTP_GROUP;
	static const QString FTP_ITEMS;
	static const QString FTP_CURRENT_ITEM;
	static const int     OVER_STRETCH;
	static const int     SPACING_WIDTH;
	static const int     MARGIN_WIDTH;
	static const QString HDR_NAME;
	static const QString HDR_SSL;
	static const QString HDR_ADDR;
	static const QString HDR_PORT;
	static const QString HDR_DIR;
	static const QString HDR_USER;
	static const QString BTN_DELETE;
	static const QString BTN_EDIT;
	static const QString BTN_NEW;
	static const QString BTN_CONNECT;
	static const QString BTN_EXIT;
	static const QString BTN_CANCEL;
	static const QChar   ITEM_SEPARATOR;

// ******* MEMBERS *******
private:
	QHBoxLayout* const d_main_layout;
	QVBoxLayout* const d_btn_layout;
	QListView*   const d_table_lv;
	QPushButton* const d_delete_btn;
	QPushButton* const d_edit_btn;
	QPushButton* const d_new_btn;
	QPushButton* const d_connect_btn;
	QPushButton* const d_exit_btn;
	QPushButton* const d_cancel_btn;
	std::vector<FtpServerInfo> d_items;
	int                d_selected_idx;
	QString            d_item_on_start;
	
// ******* METHODS *******
public:
	const FtpServerInfo& get_fsi() const { return d_items[d_selected_idx]; }
private:
	void polish         ();
	void showEvent      ( QShowEvent* );
	void select_on_start();
	void adjust         ();
	void add_item       ( const FtpServerInfo& );
	void select_item    ( const QString& );
	void change_item    ( const QString&, const FtpServerInfo& );
	int  search_data    ( const QString& );
	void read           ();
	void save           ();
private slots:
	void slot_delete    ();
	void slot_edit      ();
	void slot_new       ();
	void slot_connect   ();
	void slot_exit      ();
	void slot_cancel    ();
};

#endif // INCLUDED_FTPSERVERSLIST_H
