/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_FTPCOPIER_H
#define INCLUDED_FTPCOPIER_H

/*------- include files:
-------------------------------------------------------------------*/

#include "FTPCopyDialog.h"

#ifndef INCLUDED_FTPSERVER_INFO
#include "FtpServerInfo.h"
#endif // INCLUDED_FTPSERVER_INFO

#ifndef INCLUDED_VIEWTABLE_H
#include "ViewTable.h"
#endif // INCLUDED_VIEWTABLE_H

#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_QFILE_H
#include <qfile.h>
#define INCLUDED_QFILE_H
#endif // INCLUDED_QFILE_H

#ifndef INCLUDED_QFONTMETRICS_H
#include <qfontmetrics.h>
#define INCLUDED_QFONTMETRICS_H
#endif // INCLUDED_QFONTMETRICS_H

#ifndef INCLUDED_QFTP_H
#include <qftp.h>
#define INCLUDED_QFTP_H
#endif // INCLUDED_QFTP_H

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif // INCLUDED_VECTOR


/*------- class declaration:
-------------------------------------------------------------------*/
class FtpCopier : public FTPCopyDialog
{
	Q_OBJECT

// ******* TYPES *******
private:
	typedef enum {
		FTP_CMD_NONE = 0,
		FTP_CMD_LOGIN,
		FTP_CMD_CLOSE,
		FTP_CMD_CD,
		FTP_CMD_LIST,
		FTP_CMD_PUT,
		FTP_CMD_GET,
		FTP_CMD_ABORT
	} FTP_CMD;
	
// ******* CONSTRUCTION *******
public:
	FtpCopier(	QWidget* const in_parent,
					const FtpServerInfo& in_fsi, 
					const ViewTable::SelectedItems& in_items,
					const QString& in_dir,
					const bool in_src_is_ftp );
private:
	FtpCopier( const FtpCopier& );
	FtpCopier& operator=( const FtpCopier& );

// ******* CONSTANTS *******
private:
	static const QString OpenReadError;
	static const QString OpenWriteError;
	static const QString CantCopyDir;

// ******* MEMBERS *******
private:
	//..............................................
	const FtpServerInfo         d_fsi;
	const QString               d_dir;
	const ViewTable::SelectedItems& d_items;
	const bool                  d_src_is_ftp;
	const QFontMetrics          d_fm;
	QFtp                        d_ftp;
	unsigned int                d_idx;
	FTP_CMD                     d_ftp_cmd;
	QFile                       d_current_file;
	
// ******* METHODS *******
private:
	bool     get_lfs_info       ( const QString&, int&, bool& );
	bool     next_file          ( QString&, QString& );
	void     ftp_connect        ();
	void     ftp_cd             ( const QString& );
	void     ftp_get            ();
	void     ftp_put            ();
	void     ftp_abort          ();
	void     ftp_close          ();
private slots:
	void state_changed 			 ( int );
	void transfer_progress      ( int, int );
	void done                   ( bool );
signals:
	void start();
};

#endif // INCLUDED_FTPCOPIER_H
