/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_DISPLAYCONFIG_H
#define INCLUDED_DISPLAYCONFIG_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_SHARED_H
#include "Shared.h"
#endif // INCLUDED_SHARED_H

#ifndef INCLUDED_QFRAME_H
#include <qframe.h>
#define INCLUDED_QFRAME_H
#endif // INCLUDED_QFRAME_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class QListView;
class QPushButton;
class QRadioButton;
class QHBoxLayout;
class QVBoxLayout;
class QGroupBox;
class QCheckBox;

/*------- class declaration:
-------------------------------------------------------------------*/
class DisplayConfig : public QFrame
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	DisplayConfig( QWidget* );
private:
	DisplayConfig( const DisplayConfig& );
	DisplayConfig& operator=( const DisplayConfig& );

// ******* CONSTANTS *******
private:
	static const QString FontIcon;
	static const QString ColorIcon;
	static const QString FontBtnLabel;
	static const QString ColorBtnLabel;
	static const QString LfsLabel;
	static const QString FtpLabel;

// ******* MEMBERS ******* 
private:
	enum { LfsIdx = 0, FtpIdx };
	QHBoxLayout*  const d_main_layout;
	QVBoxLayout*  const d_wrk_layout;
	QVBoxLayout*  const d_btn_layout;
	QListView*    const d_view;
	QGroupBox*    const d_cols_grpbox;
	QCheckBox*    const d_resize_cbox;
	QPushButton*  const d_font_btn;
	QPushButton*  const d_color_btn;
	QPushButton*  const d_reset_btn;
	QPushButton*  const d_apply_btn;
	QRadioButton*       d_lfs_rb;
	QRadioButton*       d_ftp_rb;
	int                 d_selected;
	//..............................................
	QFont              d_lfs_org_font;
	QFont              d_ftp_org_font;
	QColor             d_lfs_org_color;
	QColor             d_ftp_org_color;
	//..............................................
	QFont              d_lfs_selected_font;
	QFont              d_ftp_selected_font;
	QColor             d_lfs_selected_color;
	QColor             d_ftp_selected_color;

// ******* METHODS *******
private:
	void read_config();
	void update_view();
private slots:
	void slot_font();
	void slot_color();
	void slot_reset();
	void slot_apply();
	void slot_clicked( int );
signals:
	void looks_refresh();
};

#endif // INCLUDED_DISPLAYCONFIG_H
