/******************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BSCommander is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BSCommander is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/

/*------- include files:
-------------------------------------------------------------------*/
#include "DeleteQuestion.h"
#include "Shared.h"
#include "Config.h"
#include <qlayout.h>
#include <qheader.h>
#include <qlistview.h>
#include <qpushbutton.h>
using namespace std;

/*------- local constants:
-------------------------------------------------------------------*/
const QString DeleteQuestion::Caption   = QT_TR_NOOP( "Delete files/directories" );
const QString DeleteQuestion::WipeFiles = QT_TR_NOOP( "&Wipe files" );


//*******************************************************************
// DeleteQuestion                                        CONSTRUCTOR
//*******************************************************************
DeleteQuestion::DeleteQuestion( QWidget* const in_parent, const ViewTable::SelectedItems& in_items, const bool in_islfs )
: QDialog       ( in_parent )
, d_main_layout ( new QHBoxLayout( this ))
, d_tbl_layout  ( new QVBoxLayout )
, d_btn_layout  ( new QVBoxLayout )
, d_table       ( new QListView( this ))
, d_wipe_cb     ( new QCheckBox( tr( WipeFiles ), this ))
, d_accept_btn  ( new QPushButton( tr( Shared::AcceptBtnLabel ), this ))
, d_cancel_btn  ( new QPushButton( tr( Shared::CancelBtnLabel ), this ))
{
    setCaption( tr( Caption ));
	setFont( Config::instance()->lfs_default_font() );
	
	d_main_layout->setMargin( Shared::LayoutMargin  );
	d_main_layout->setSpacing( Shared::LayoutSpacing );
	if( FALSE == in_islfs ) d_wipe_cb->hide();
	
	d_table->setPaletteBackgroundColor( Config::instance()->lfs_bkg_color() );
	d_table->setSelectionMode( QListView::Single );
	d_table->setAllColumnsShowFocus( TRUE );
	d_table->setSorting( -1, FALSE );
    d_table->addColumn( "" );
	d_table->header()->hide();
		
    ViewTable::SelectedItems::const_iterator it = in_items.begin();
    while( it != in_items.end() ) {
        new ListViewItem( d_table, (*it)->name() );
        ++it;
    }
    d_tbl_layout->addWidget( d_table );
    d_tbl_layout->addWidget( d_wipe_cb );
    d_main_layout->addLayout( d_tbl_layout );
    
    d_btn_layout->addStretch( Shared::OverStretch );
    d_btn_layout->addWidget( d_accept_btn );
    d_btn_layout->addWidget( d_cancel_btn );
    d_main_layout->addLayout( d_btn_layout );
    
   	connect( d_accept_btn, SIGNAL( clicked() ), this, SLOT( accept() ));
	connect( d_cancel_btn, SIGNAL( clicked() ), this, SLOT( reject() ));
}
// end of DeleteQuestion

//*******************************************************************
// show                                            PRIVATE inherited
//*******************************************************************
void DeleteQuestion::show()
{
    Shared::polish( this, 20, 30 );
    QDialog::show();
    // dopasowanie szerokosci kolumny
    if( d_table->columnWidth( 0 ) < d_table->visibleWidth() ) {
        d_table->setColumnWidth( 0, d_table->visibleWidth() );
    }
    // pierwsza pozycja jako aktualna
	QListViewItem* const item = d_table->firstChild();
	if( item ) {
		d_table->setCurrentItem( item );
		d_table->ensureItemVisible( item );
	}
    d_table->setFocus();
}
// end of show

//*******************************************************************
// QListViewItem::paintCell                        PRIVATE inherited
//*******************************************************************
void DeleteQuestion::ListViewItem::paintCell(  QPainter* p,
                                                const QColorGroup& cg,
                                                const int col,
                                                const int width,
                                                const int align )
{
    bool color = FALSE;
    QListViewItemIterator it( listView() );
    while( it.current() ) {
        if( it.current() == this ) break;
        color = !color;
        ++it;
    }

    QColorGroup ncg( cg );
    if( color ) ncg.setColor( QColorGroup::Base, qRgb( 211, 211, 191 ) );
    QListViewItem::paintCell( p, ncg, col, width, align );
}
// end of paintCell
