/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_DATETIME_H
#define INCLUDED_DATETIME_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QDIALOG_H
#include <qdialog.h>
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_CANOVERWRITE_H

#ifndef INCLUDED_QSTRING_H
#include <qstring.h>
#define INCLUDED_QSTRING_H
#endif // INCLUDED_QSTRING_H

#ifndef INCLUDED_VIEWTABLE_H
#include "ViewTable.h"
#endif // INCLUDED_VIEWTABLE_H

/*------- forward declarations:
-------------------------------------------------------------------*/
class ViewTableItem;
class QPushButton;
class QCheckBox;
class QDateTimeEdit;
class InfoField;
class QDateTime;

class DateTime : public QDialog
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	DateTime( QWidget* const, const ViewTable::SelectedItems& , const ViewTableItem* const );
private:
	DateTime( const DateTime& );
	DateTime& operator=( const DateTime& );

// ******* CONSTANTS *******
private:
	static const QString CAPTION;
	static const QString BTN_ACCEPT_LABEL;
	static const QString CB_MUSTER_LABEL;
	static const QString GBOX_EDIT_CAPTION;
	static const QString GBOX_MUSTER_CAPTION;
	static const QString DATE_TIME_FORMAT;
	static const QString TOUCH_CMD;
	static const QString TOUCH_FORMAT;
		
// ******* MEMBERS *******
private:
	const ViewTable::SelectedItems& d_items;
	const ViewTableItem* const d_muster;
	QPushButton* const d_accept_btn;
	QPushButton* const d_cancel_btn;
	QCheckBox*   const d_muster_cb;
	QDateTimeEdit*     d_edit_dt;
	InfoField*         d_muster_if;
	
// ******* METHODS *******
private:
	QWidget* make_edit_area();
	QWidget* make_muster_area();
private slots:
	void accept();
	void cancel();
	void use_muster( bool );
	void no_muster( const QDateTime& );
};

#endif // INCLUDED_DATETIME_H
