/********************************************************************
 * Copyright (C) 2005, 2006 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BSCommander (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_COPIER_H
#define INCLUDED_COPIER_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_VIEWTABLE_H
#include "ViewTable.h"
#endif // INCLUDED_VIEWTABLE_H

#ifndef INCLUDED_COPYDIALOG_H
#include "CopyDialog.h"
#define INCLUDED_QDIALOG_H
#endif // INCLUDED_QDIALOG_H

#ifndef INCLUDED_QFILE_H
#include <qfile.h>
#define INCLUDED_QFILE_H
#endif // INCLUDED_QFILE_H

#ifndef INCLUDED_QFILEINFO_H
#include <qfileinfo.h>
#define INCLUDED_QFILEINFO_H
#endif // INCLUDED_QFILEINFO_H

#ifndef INCLUDED_VECTOR
#include <vector>
#define INCLUDED_VECTOR
#endif // INCLUDED_VECTOR

/*------- forward declarations:
-------------------------------------------------------------------*/

/*------- class declaration:
-------------------------------------------------------------------*/
class Copier : public CopyDialog
{
	Q_OBJECT

// ******* CONSTRUCTION *******
public:
	Copier( QWidget* const in_parent, const ViewTable::SelectedItems& in_items, const QString& in_dst_dir );
private:
	Copier( const Copier& );
	Copier& operator=( const Copier& );

// ******* MEMBERS *******
private:
	enum { BufferSize = 8192 /*4096*/ };
	//....................................
	static const char* const MkdirError;
	static const char* const Rename;
	static const char* const NewFileName;
	static const char* const NotReadableFile;
	static const char* const NotWriteableDir;
	
	//....................................
	const ViewTable::SelectedItems& d_items;
	const QString       d_dst_dir;
	int                  d_block_size;
	char                 d_buffer[BufferSize];
	bool                 d_ask_again;
	bool                 d_running;
	bool                 d_break;

// ******* METHODS *******
private:
    void copy_next   ( const QFileInfo&, const QString& );
    void copy_subdir ( const QString&, const QString& );
    bool can_copy    ( const QString&, QString& );
    bool can_update  ( const QString&, const QString& );
    void copy_file   ( const QString&, const QString& );
    void rename      ( QString& );
private slots:
	void     run     ();
	void     cancel  ();
signals:
	void     start   ();
};

#endif // INCLUDED_COPIER_H
