/********************************************************************
 * Copyright (C) 2005 Piotr Pszczolkowski
 *-------------------------------------------------------------------
 * This file is part of BsC (Beesoft Commander).
 *
 * BsC is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * BsC is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with BsC; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 *******************************************************************/
#ifndef INCLUDED_CONSOLECONFIG_H
#define INCLUDED_CONSOLECONFIG_H

/*------- include files:
-------------------------------------------------------------------*/
#ifndef INCLUDED_QFRAME_H
#include <qframe.h>
#define INCLUDED_QFRAME_H
#endif // INCLUDED_QFRAME_H


/*------- forward declarations:
-------------------------------------------------------------------*/
class QVBoxLayout;
class QHBoxLayout;
class QCheckBox;
class QGroupBox;
class QPushButton;
class QLabel;
class QLineEdit;

/*------- class declaration:
-------------------------------------------------------------------*/
class ConsoleConfig : public QFrame
{
	Q_OBJECT
public:
	ConsoleConfig( QWidget* );
private:
	ConsoleConfig( const ConsoleConfig& );
	ConsoleConfig& operator=( const ConsoleConfig& );

// ******* members *******
private:
	QVBoxLayout* const d_main_layout;
	QGroupBox*   const d_konsole_grpbox;
	QLabel*      const d_konsole_name;
	QLineEdit*   const d_konsole_call;
	QGroupBox*   const d_other_grpbox;
	QCheckBox*   const d_other_cbox;
	QLineEdit*   const d_other_call;
	QHBoxLayout* const d_button_layout;
	QPushButton* const d_apply_button;
	
	static const QString OtherTerminal;
	static const QString KonsoleName;

// ******* methods *******
private:
	void show();
private slots:
	void other_toggled( bool );
	void apply_clicked();
};

#endif // INCLUDED_CONSOLECONFIG_H
