// Brutal Chess
//
// File : chessplayer.h
// Date : 05/03/2005
// Authors : Maxwell Lazaroff and Michael Cook, fixed by Joe Flint
//
// Description : Implements how a player works

#ifndef __CHESSPLAYER_H_IS_INCLUDED__
#define __CHESSPLAYER_H_IS_INCLUDED__

#include "boardmove.h"
#include "board.h"
#include <string>
#include <vector>

using namespace std;

typedef unsigned int uint;

class ChessPlayer {

public :
    ChessPlayer();
    ChessPlayer( const string & name ) { _name = name; };
    virtual ~ChessPlayer() {};
    
    static bool is_in(const BoardMove & move, const Board & board);
    static bool is_valid(const BoardMove & move, const Board & board, bool is_white);
    static bool inCheckmate(const Board &board, bool is_white);
    static bool inStalemate(const Board &board, bool is_white);
    
	virtual bool requiresInput() { return true; }
    virtual BoardMove decide_move(const Board & board, bool & white) = 0;
	virtual void opponent_move(const BoardMove & move, bool white ) {};
	static bool check_move(const BoardMove & move, const Board &board, bool white);
    
    static ChessPlayer* get_player(const string& player_name);
    
    static void add_player(ChessPlayer* player);
    
    virtual ChessPlayer* dup() const = 0;
    
    static ChessPlayer* lookup(const string& player_name);

    static vector<string> names();
		
	string getName() { return _name; }
	
	void append_name(string appender) { _name += appender; }

protected :
    string _name;
    static vector<ChessPlayer*> _players;
};

#endif
