/*
 * BRLTTY - A background process providing access to the console screen (when in
 *          text mode) for a blind person using a refreshable braille display.
 *
 * Copyright (C) 1995-2016 by The BRLTTY Developers.
 *
 * BRLTTY comes with ABSOLUTELY NO WARRANTY.
 *
 * This is free software, placed under the terms of the
 * GNU General Public License, as published by the Free Software
 * Foundation; either version 2 of the License, or (at your option) any
 * later version. Please see the file LICENSE-GPL for details.
 *
 * Web Page: http://brltty.com/
 *
 * This software is maintained by Dave Mielke <dave@mielke.cc>.
 */

#ifndef BRLTTY_INCLUDED_DYNLD
#define BRLTTY_INCLUDED_DYNLD

#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */

extern void *loadSharedObject (const char *path);
extern void unloadSharedObject (void *object);

extern int findSharedSymbol (void *object, const char *symbol, void *pointerAddress);
extern const char *getSharedSymbolName (void *address, ptrdiff_t *offset);

#ifdef __cplusplus
}
#endif /* __cplusplus */

#endif /* BRLTTY_INCLUDED_DYNLD */
