
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include <stdlib.h> /* only for init library */

#include "bristol.h"

void *
bristolmalloc(size)
{
	char *mem;

	mem = malloc(size);

#ifdef DEBUG
	printf("bristolmalloc: %x, %i\n", mem, size);
#endif

	return(mem);
}

void *
bristolmalloc0(size)
{
	char *mem;

	mem = bristolmalloc(size);

#ifdef DEBUG
	printf("bristolmalloc0: %x, %i\n", mem, size);
#endif
	bzero(mem, size);

	return(mem);
}

bristolfree(char *mem)
{
#ifdef DEBUG
	printf("bristolfree: %x\n", mem);
#endif

	free(mem);
}

bristolbzero(char *mem, int count)
{
#ifdef DEBUG
	printf("bristolzero: %x\n", mem);
#endif

	bzero(mem, count);
}

