
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#include "brightonX11internals.h"

int command[BLASTEvent] = {
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_KEYPRESS,
    BRIGHTON_KEYRELEASE,
    BRIGHTON_BUTTONPRESS,
    BRIGHTON_BUTTONRELEASE,
    BRIGHTON_MOTION,
    BRIGHTON_ENTER,
    BRIGHTON_LEAVE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_EXPOSE,
    BRIGHTON_GEXPOSE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_CONFIGURE,
    BRIGHTON_CONFIGURE_REQ,
    BRIGHTON_NONE,
    BRIGHTON_RESIZE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE,
    BRIGHTON_NONE
};

int
BNextEvent(brightonDisplay *display, brightonEvent *event)
{
	bdisplay *bd = (bdisplay *) display->display; 
	XEvent xevent;

	XNextEvent(bd->display, &xevent);

	event->type = xevent.xany.type;
	event->wid = (int) xevent.xany.window;
	event->command = command[xevent.xany.type];

	switch (xevent.xany.type) {
		case KeyPress:
		case KeyRelease:
			event->x = xevent.xkey.x;
			event->y = xevent.xkey.y;
			event->key = xevent.xkey.keycode;
			break;
		case ButtonPress:
		case ButtonRelease:
			event->x = xevent.xbutton.x;
			event->y = xevent.xbutton.y;
			event->key = xevent.xbutton.button;
			break;
		case MotionNotify:
			event->x = xevent.xmotion.x;
			event->y = xevent.xmotion.y;
			break;
		case ConfigureNotify:
			event->x = xevent.xconfigure.x;
			event->y = xevent.xconfigure.y;
			event->w = xevent.xconfigure.width;
			event->h = xevent.xconfigure.height;
			break;
		case ResizeRequest:
			event->w = xevent.xresizerequest.width;
			event->h = xevent.xresizerequest.height;
			break;
		case Expose:
			event->x = xevent.xexpose.x;
			event->y = xevent.xexpose.y;
			event->w = xevent.xexpose.width;
			event->h = xevent.xexpose.height;
			break;
		default:
			break;
	}

	return(0);
}

