
/*
 *  Diverse Bristol audio routines.
 *  Copyright (c) by Nick Copeland <nick.copeland@ntlworld.com> 1996,2002
 *
 *
 *   This program is free software; you can redistribute it and/or modify
 *   it under the terms of the GNU General Public License as published by
 *   the Free Software Foundation; either version 2 of the License, or
 *   (at your option) any later version.
 *
 *   This program is distributed in the hope that it will be useful,
 *   but WITHOUT ANY WARRANTY; without even the implied warranty of
 *   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *   GNU General Public License for more details.
 *
 *   You should have received a copy of the GNU General Public License
 *   along with this program; if not, write to the Free Software
 *   Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */

#ifndef BRIGHTON_H
#define BRIGHTON_H

#include "brightondevflags.h"
#include "brightonevents.h"

typedef int (*brightonCallback)(void *, int, int, float);
typedef int (*brightonRoutine)();

typedef struct BrightonLocations {
	char *name;
	int device;
	float x, y;
	float width, height;
	float from, to;
	brightonCallback callback;
	char *image;
	char *image2;
	unsigned int flags;
} brightonLocations;

typedef struct brightonResource {
	char *name;
	char *image;
	char *surface;
	unsigned int flags;
	brightonRoutine init;
	brightonRoutine configure;
	brightonCallback callback;
	int x, y, width, height;
	int ndevices;
	brightonLocations *devlocn;
} brightonResource;

#define RESOURCE_COUNT 32

typedef struct BrightonApp {
	char *name;
	char *image;
	char *surface;
	unsigned int flags;
	brightonRoutine init;
	brightonRoutine configure;
	brightonCallback callback;
	brightonRoutine destroy;
	int width, height;
	int nresources;
	brightonResource resources[RESOURCE_COUNT];
} brightonApp;

extern int brightonParamChange(void *, int, int, brightonEvent *);
extern void *brightonInterface(brightonApp *);

#endif /* BRIGHTON_H */

