#ifndef _MIDIEVENT_H_
#define _MIDIEVENT_H_

#include "event.h"

/**
 * Instances of this class are midievents. They do not need a (graphical) presentation of their own. They can be displayed
 * graphically within the presentation of the parts, they belong to.
 **/

class MidiEvent : public Event
{
 private:
  int _codechan;
  int _value1;
  int _value2;

 public:
  /**
   * Default Constructor
   **/
  MidiEvent( );

  /**
   * Copy Constructor
   **/
  MidiEvent(const MidiEvent&);

  /**
   * Constructor defining a midievent cc with values value1 and value2 at position pos. The integer cc contains
   * the command within the higher nibble and the channel within the lower nibble. The value2 parameter is optional.
   **/
  MidiEvent(Position pos, int cc, int value1, int value2=0);

  /**
   * Returns the 4 bit value of the command
   **/
  int code() const { return int((_codechan&240)/16); }

  /**
   * Returns the midi channel
   **/
  int channel() const { return int(_codechan&15); }

  /**
   * Returns both the command and the midi channel
   **/
  int codeAndChannel() const { return _codechan; }

  /**
   * Returns the first value
   **/
  int value1() const { return _value1; }

  /**
   * Returns the second value
   **/
  int value2() const { return _value2; }

  /**
   * Sets the command and the midi channel
   **/
  void setCodeAndChannel(int);

  /**
   * Sets the first value
   **/
  void setValue1(int);

  /**
   * Sets the second value
   **/
  void setValue2(int);

  /**
   * Implementation of the print method
   **/
  virtual ostream & print(int,ostream&) const;

  /**
   * Implementation of the flush method
   **/
  virtual void flush(const char*) const;

  /**
   * Implementation of the copy method
   **/
  virtual Element * copy() const;

  /**
   * Implementation of the load method
   **/
  static Element * load(char*,ifstream*&,Element*);
};


#endif
