#ifndef _SAMPLECONTENT_H_
#define _SAMPLECONTENT_H_

#include <qframe.h>
#include <qpixmap.h>
#include <qbitmap.h>

class QPaintEvent;
class QKeyEvent;
class QCursor;
class QPopupMenu;
class KdeSampleEditor;
class KdeEditorToolBar;
class KdeEditorNoteBar;
class KdeEditorButtonBar;
class Note;
class PositionCursor;

class KdeSampleContent : public QFrame
{

  Q_OBJECT

 private:
  KdeSampleEditor * _editor;
  KdeEditorToolBar * _toolbar;
  KdeEditorNoteBar * _notebar;
  KdeEditorButtonBar * _buttonbar;
  QPopupMenu * rbmenu;
  int _ybottom;
  int _yscale;
  int _yoffset;
  int _mousey;
  int _xoffset;
  bool _edit_length;
  QCursor * prcursor;
  QWidget * moveWidget;
  PositionCursor * _position_cursor;
  Note * _grab;
  Note * _edit;
  int _pressX;
  int _pressY;
  int _moveX;
  int _moveY;
  long _grabX;
  int _grabY;
  int _grabW;
  bool shftFlag;
  bool ctrlFlag;
  bool suprFlag;

 public:

  KdeSampleContent( QFrame * , KdeSampleEditor * , KdeEditorToolBar * , KdeEditorNoteBar *, KdeEditorButtonBar * );

  int Pitch(int);

  /** returns the y position to draw the key, depending on the mouses y-position */
  int mouseY(int pitch = -1);

  /** returns the shape of the key on the keyboard, the mouse moves over. */
  int mouseKeyShape();
  void moveCursor(int ticks);
  

 public slots:
  void paintEvent( QPaintEvent * );
  void mousePressEvent( QMouseEvent * );
  void mouseMoveEvent( QMouseEvent * );
  void mouseReleaseEvent( QMouseEvent * );
  void keyPressEvent( QKeyEvent * );
  void keyReleaseEvent( QKeyEvent * );
  void glueNote();
  void splitNote();
  void deleteNote();
};



#endif
