#ifndef _KDEEDITORSCROLLBAR_CPP_
#define _KDEEDITORSCROLLBAR_CPP_

#include <iostream.h>

#include <kiconloader.h>
#include <kmenubar.h>
#include <klocale.h>

#include <qlabel.h>
#include <qlineedit.h>
#include <qscrollbar.h>
#include <qlineedit.h>

#include "part.h"
#include "prPartEditor.h"
#include "song.h"

#include "brahmsResources.h"
#include "kdeEditorScrollBar.h"
#include "kdePianoRollEditor.h"

extern Song * sonG;


KdeEditorScrollBar::KdeEditorScrollBar(QWidget * parent, PrPartEditor * ed)
  : KToolBar(parent), _editor(ed)
{
  insertWidget(1,10,new QLabel("",this));
  setFixedHeight(18);
  show();

  int initvalue = _editor->left().bar() - 1;
  _scrollbar = new QScrollBar(0,3200,1,8,initvalue,Qt::Horizontal,this);
  _scrollbar->setGeometry(0,1,width(),16);
  _scrollbar->show();
  connect(_scrollbar,SIGNAL(valueChanged(int)),SLOT(slotSliderChanged(int)));
}

void KdeEditorScrollBar::resizeEvent( QResizeEvent * re ) {
  KToolBar::resizeEvent(re);
  _scrollbar->setGeometry(0,1,width(),16);
}

Part * KdeEditorScrollBar::part() {
  return _editor->part();
}


void KdeEditorScrollBar::slotSliderChanged(int i) {
  _editor->wind(i);
  _editor->update();
}

#endif
#include "kdeEditorScrollBar.moc"
