#ifndef _KDEEDITORMENUBAR_CPP_
#define _KDEEDITORMENUBAR_CPP_

#include "kdeEditorMenuBar.h"
#include "brahmsResources.h"

#include <qpopupmenu.h>
#include <qaccel.h>
#include <qkeycode.h>

#include <klocale.h>


void KdeEditorMenuBar::createMenuBar(KMenuBar * menu, QPopupMenu * file, QPopupMenu * edit, QPopupMenu * snap, QPopupMenu * veloc, QPopupMenu * view, QPopupMenu * res) {

  file->insertItem( i18n("Settings"), ID_FILE_SETTINGS);
  file->insertItem( i18n("Print"), ID_EDIT_PRINT);
  file->insertSeparator();
  file->insertItem( i18n("Close"), ID_FILE_CLOSE);
  file->setAccel(ALT+Key_P,ID_EDIT_PRINT);
  file->setAccel(ALT+Key_W,ID_FILE_CLOSE);

  if (edit) {
    edit->insertItem( i18n("Undo"), ID_EDIT_UNDO );
    edit->insertItem( i18n("Redo"), ID_EDIT_REDO );
    edit->insertSeparator();
    edit->insertItem( i18n("Cut"), ID_EDIT_CUT);
    edit->insertItem( i18n("Copy"), ID_EDIT_COPY);
    edit->insertItem( i18n("Paste"), ID_EDIT_PASTE);
    edit->insertSeparator();
    edit->insertItem( i18n("Transpose"), ID_EDIT_TRANSPOSE);
    edit->insertSeparator();
    edit->insertItem( i18n("Unmark"), ID_EDIT_UNMARK);
    edit->insertSeparator();
    edit->insertItem( i18n("Erase"), ID_EDIT_CLEAR);

    edit->setAccel(CTRL+Key_Z, ID_EDIT_UNDO);
    edit->setAccel(SHIFT+CTRL+Key_Z, ID_EDIT_REDO);
    edit->setAccel(ALT+Key_X,ID_EDIT_CUT);
    edit->setAccel(ALT+Key_C,ID_EDIT_COPY);
    edit->setAccel(ALT+Key_V,ID_EDIT_PASTE);
    edit->setAccel(Key_Escape,ID_EDIT_UNMARK);
    edit->setAccel(ALT+Key_Exclam,ID_EDIT_TRANSPOSE);
    edit->setAccel(ALT+Key_Backspace,ID_EDIT_CLEAR);
    edit->setAccel(Key_Delete,ID_EDIT_CLEAR);

    edit->setItemEnabled(ID_EDIT_CUT,FALSE);
    edit->setItemEnabled(ID_EDIT_COPY,FALSE);
    edit->setItemEnabled(ID_EDIT_PASTE,FALSE);
    edit->setItemEnabled(ID_EDIT_UNMARK,FALSE);
    edit->setItemEnabled(ID_EDIT_TRANSPOSE,FALSE);
  }

  if (snap) {
    snap->insertItem( i18n("1/1"), ID_GRID_1);
    snap->insertItem( i18n("1/2"), ID_GRID_2);
    snap->insertItem( i18n("1/4"), ID_GRID_4);
    snap->insertItem( i18n("1/8"), ID_GRID_8);
    snap->insertItem( i18n("1/16"), ID_GRID_16);
    snap->insertItem( i18n("1/32"), ID_GRID_32);
    snap->insertItem( i18n("1/64"), ID_GRID_64);
    snap->insertItem( i18n("Off"), ID_GRID_OFF);
    snap->setCheckable(TRUE);
    snap->setAccel(ALT + CTRL + Key_1, ID_GRID_1);
    snap->setAccel(ALT + CTRL + Key_2, ID_GRID_2);
    snap->setAccel(ALT + CTRL + Key_3, ID_GRID_4);
    snap->setAccel(ALT + CTRL + Key_4, ID_GRID_8);
    snap->setAccel(ALT + CTRL + Key_5, ID_GRID_16);
    snap->setAccel(ALT + CTRL + Key_6, ID_GRID_32);
    snap->setAccel(ALT + CTRL + Key_7, ID_GRID_64);
    snap->setAccel(ALT + CTRL + Key_0, ID_GRID_OFF);
  }

  if (res) {
    res->insertItem( i18n("1/1"), ID_RES_1);
    res->insertItem( i18n("1/2"), ID_RES_2);
    res->insertItem( i18n("1/4"), ID_RES_4);
    res->insertItem( i18n("1/8"), ID_RES_8);
    res->insertItem( i18n("1/16"), ID_RES_16);
    res->insertItem( i18n("1/32"), ID_RES_32);
    res->insertItem( i18n("1/64"), ID_RES_64);
    res->insertItem( i18n("Off"), ID_RES_OFF);
    res->setCheckable(TRUE);
  }

  if (veloc) {
    veloc->insertItem( i18n("Off "), ID_DYN_OFF);
    veloc->insertItem( i18n("ppp "), ID_DYN_PPP);
    veloc->insertItem( i18n("pp "), ID_DYN_PP);
    veloc->insertItem( i18n("p "), ID_DYN_P);
    veloc->insertItem( i18n("mp "), ID_DYN_MP);
    veloc->insertItem( i18n("mf "), ID_DYN_MF);
    veloc->insertItem( i18n("f "), ID_DYN_F);
    veloc->insertItem( i18n("ff "), ID_DYN_FF);
    veloc->insertItem( i18n("fff "), ID_DYN_FFF);
    veloc->setCheckable(true);
  }

  if (view) {
    view->setCheckable(true);
    view->insertItem(i18n("&Toolbar"), ID_VIEW_TOOLBAR);
    view->insertItem(i18n("&Notebar"), ID_VIEW_NOTEBAR);
    view->insertItem(i18n("&Buttonbar"), ID_VIEW_BUTTONBAR);
    view->insertItem(i18n("&Slider"), ID_VIEW_SLIDER);

    view->setAccel(ALT+Key_E,ID_VIEW_NOTEBAR);
  }

  // menu = new KMenuBar( this );
  // CHECK_PTR( menu );
  menu->insertItem(i18n("File"),file);
  if (edit) menu->insertItem(i18n("Edit"),edit);
  if (snap) menu->insertItem(i18n("Grid"),snap);
  if (res) menu->insertItem(i18n("Resolution"),res);
  if (veloc) menu->insertItem(i18n("Dynamics"),veloc);
  if (view) menu->insertItem(i18n("View"),view);
  menu->show();



}


#endif
