#ifndef _STRING_H_
#define _STRING_H_

#include "atom.h"

class String : public Atoma
{
 private:
  const char * _value;

 public:
  String();
  String(const String&);
  String(const char*);
  ~String();

  const char * getValue() const { return _value; }

  bool operator==(const String & s);
  bool operator==(const char*);
  String operator+(const String & s);

  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
  virtual bool isEvent() const { return false; }

};

#endif
