#ifndef _PRFACTORY_CPP_
#define _PRFACTORY_CPP_

#include "prFactory.h"
#include "mupPrinter.h"

PrFactory * PrFactory::_factory = 0;

PrScorePainter * PrFactory::scorePainter = 0;

ScorePrinter * PrFactory::scorePrinter = 0;


PrFactory::PrFactory()
{}

PrFactory::~PrFactory()
{}

void PrFactory::setFactory(PrFactory * f) { PrFactory::_factory = f; }

PrFactory * PrFactory::factory() { return PrFactory::_factory; }

ScorePrinter * PrFactory::getScorePrinter() {
  if (scorePrinter==0) scorePrinter = new MupPrinter();
  return scorePrinter;

}


#endif
