#ifndef _TEX_C_
#define _TEX_C_

#include "tex.h"
#include "../kbPart.h"
#include "../kbNote.h"

#include "../qtScore.h"
#include "../qtScoreAddons.h"
#include "../qtKeyChooser.h"
#include "../kbPart.h"
#include "../kbNote.h"
#include "../kbLyrics.h"
#include "../kbTrack.h"
#include "../kbScoreTrack.h"
#include "../kbExp.h"
#include "../kbBow.h"
#include "../kbStem.h"
#include "../kbAuxElement.h"
#include <math.h>
#include <iostream.h>

extern int scrSigns[8];
extern int allSigns[15][7];
extern void createBreakGroups(ScoreGroup *& grp, ScoreGroup *& grp1, KbPosition pos, int length, KbPosition pOffset, KbPart * master, int met0, int met1);

/**
 *  This writes a tex-file, to work with MusixTex
 */

Tex::Tex()
  : KbPartExtension("Tex")
{}

/**
 * This defines the algorithm that shall act on a part.
 */
void Tex::act(KbPart * part) {
  KbMain * main = part->gTrack()->gMain();
  master = main->Master();
  met0 = main->gMeter(0);
  met1 = main->gMeter(1);


  ScoreGroup * firstGroup = 0;
  ScoreGroup * tmp = 0;
  KbScoreTrack * scTrack;
  ScoreBar * firstBar = 0;
  ScoreBar * myBar;
  
  cout << "\\ifx\\documentclass\\undefined
\\documentstyle[twoside,11pt,musixdoc,multicol,backgrnd]{report}
\\else
\\documentclass[twoside,11pt]{report}
\\usepackage{multicol}
\\usepackage{musixdoc}
\\usepackage{backgrnd}
\\fi
\\def\\musictex{Music\\TeX{}}
\\startmuflex\\makeindex
\\begin{document}
\\begin{music}
\\parindent10mm
\\instrumentnumber{1}
\\generalmeter{\\meterfrac{" << part->gTime1() << "}{" << part->gTime2() << "}}
\\generalsignature{" << part->gKey() << "}";


  scTrack = (KbScoreTrack*) part->gTrack();

  cout << "\\setname1{" << scTrack->gName() << "}
\\setstaffs1{1}";
  
  

  cout << "\\startpiece" << endl;
  
  KbPosition relPos = 0;
  KbPosition lpos = 0; //posLeft;

  int i=0;
  for (i=0;i<7;i++) scrSigns[i]=allSigns[part->gKey()+7][i];
    
  ScoreGroup * myGroup = 0;
  // lpos = 0;
  KbAtom* atom = part->gFirstAtom();
  while (atom!=0) {
    if (atom->isNote()) {
      KbNote * note = (KbNote*) atom;
      if (myGroup == 0) {
	relPos = lpos - part->gOffset();
	myGroup = new NoteGroup(note,part->gOffset());
	if (note->gPos()-relPos > 0) {
	  createBreakGroups(firstGroup, tmp, relPos, note->gPos()-relPos.gPosTicks(), part->gOffset(), master, met0, met1);
	  tmp->sNext(myGroup);
	} else {
	  firstGroup = myGroup;
	}
      } else {
	myGroup = myGroup->append(note,part->gOffset(),master,met0,met1);
      }
    }
    
    atom = atom->gNext();
    
    
  }
  
  
  // now everything is packed up in groups, lets pack the
  // groups into bars:
  
  
  if (firstGroup) {
    firstBar = new ScoreBar(firstGroup);
    ScoreBar * curBar = firstBar;
    for (myGroup = firstGroup->Next(); myGroup!=0; myGroup = myGroup->Next()) {
      curBar = curBar->append(myGroup,master,met0,met1);
    }
    
  }
  

  
  
  // for (int i=0;i<parts;i++) myBar[i] = firstBar[i];
  myBar = firstBar;
  int loop = 1;
  while (loop) {
    cout << "\\Notes";
    relPos = part->gOffset() - lpos;
    myBar->tex(relPos,part->gClef(),master,met0,met1);
    cout << "\\en" << endl << "\\bar" << endl;
    
    for (i=0;i<7;i++) scrSigns[i]=allSigns[part->gKey()+7][i];
    myBar = myBar->Next();
    if (myBar==0) loop = 0;
  }

  /*
    ScoreGroup * tmp;
    KbPosition curPos;
    
    for (myGroup = firstGroup; myGroup!=0;) {
    // myGroup->print();
    oldTimeBar = curBar;
    relPos = part->gOffset() - lpos;
    curPos = myGroup->start() + relPos;
    curMet0 = met0; curMet1 = met1; curPos.gBBT(curBar,curBeat,curTick,master,curMet0,curMet1,true);
    if (oldTimeBar!=curBar) {
    for (i=0;i<7;i++) scrSigns[i]=allSigns[scrKey+7][i];
    //for (i=0;i<curBar-oldTimeBar;i++)
    //	cout << "\\bar" << endl;
    }
    myGroup->tex(relPos,pixPerTick,xoffset,yoffset,scrClef,master,met0,met1);
    tmp = myGroup->Next();
    delete myGroup;
    myGroup = tmp;
    }
  */
  // DOIT: remove bars and groups, etc !!!
  
  cout << "\\endpiece
\\end{music}
\\endmuflex
\\end{document}" << endl;
  
}



#endif
