#ifndef _QTSCORESYMBOLS_C_
#define _QTSCORESYMBOLS_C_

#include <qpushbutton.h>

#include "qtScoreSymbols.h"
#include "kdeScoreEditor.h"
#include "kdeScoreEditor2.h"
#include "part.h"
#include "prPartEditor.h"


QtSymbols::QtSymbols( PrScoreEditor * s, QPixmap * symbs, int& e, int ttl, int cls, const char * name, int tl )
  : QWidget(0,"Symbols",WStyle_Customize | WStyle_DialogBorder),
    score(s), symbols(symbs), pressed(0), element(&e), total(ttl), cols(cls), tool(tl)
{
  rows = int(total/cols);
  if (cols*rows<total) rows++;
  
  button = new (QPushButton *) [total];
  setCaption(name);

  // KIconLoader *loader = KGlobal::iconLoader();

  setBackgroundMode( PaletteLight );

  setFixedSize(cols*SYMBOL_WIDTH,rows*SYMBOL_WIDTH);
  
  int x = 0; int y = 0;
  for (int i=0;i<total;i++) {
    button[i] = new QPushButton(this);
    button[i]->setPixmap(symbols[i]);
    x = i % cols;
    y = int((i-x)/cols);
    button[i]->setGeometry(x*SYMBOL_WIDTH,y*SYMBOL_WIDTH,SYMBOL_WIDTH,SYMBOL_WIDTH);
    button[i]->setToggleButton(TRUE);
    connect(button[i],SIGNAL(released()),SLOT(update()));
  }
  button[pressed]->setOn(TRUE);
  hide();
}


void QtSymbols::update() {
  button[pressed]->setOn(FALSE);
  for (int i=0;i<total;i++)
    if (button[i]->isOn()) pressed = i;
  *element = pressed;
  ((KdeScoreEditor2*)score)->setTool(tool);
}

#endif
#include "qtScoreSymbols.moc"
