#ifndef _KDEEVENTEDITOR_CPP_
#define _KDEEVENTEDITOR_CPP_

#include <stdlib.h>
#include <stdio.h>
#include <iostream.h>
#include <math.h>

#include <qsplitter.h>
#include <qpushbutton.h>
#include <qscrollview.h>
#include <qframe.h>
#include <qlistview.h>

#include "part.h"
#include "vector.h"
#include "str.h"
#include "event.h"
#include "song.h"
#include "note.h"
#include "symbol.h"
#include "position.h"
#include "addElement.h"
#include "lyrics.h"
#include "iterator.h"

#include "kdeEventEditor.h"
#include "kdeEventFrame.h"
#include "kdeProgress.h"
#include "kdeEditorToolBar.h"
#include "kdeEditorScrollBar.h"
#include "brahmsResources.h"
#include "kdeEditorMenuBar.h"

extern Song * sonG;


KdeEventEditor::KdeEventEditor() : KMainWindow(0L, "EventEditor"), PrPartEditor(EVENTEDITOR), itemh(16) {

}

KdeEventEditor::KdeEventEditor(Part * p) : KMainWindow(0L, "EventEditor"), PrPartEditor(p), itemh(16) {
  run();
}

KdeEventEditor::KdeEventEditor(Track * t) : KMainWindow(0L, "EventEditor"), PrPartEditor(t), itemh(16) {
  run();
}

KdeEventEditor::~KdeEventEditor() {

}

void KdeEventEditor::run() {

  setCaption("Event Editor"); // TODO: part name
  
  _grid_id = ID_GRID_4;
  _dyn_id = 86;
  _toolbarstate = true;
  _notebarstate = false;
  _buttonbarstate = false;
  _sliderstate = true;

  //
  // Toolbars:
  // =========

  _toolbar = new KdeEditorToolBar(this,this);
  _scrollbar = new KdeEditorScrollBar(this,this);

  addToolBar( _toolbar ); _toolbar->setBarPos(KToolBar::Top);
  addToolBar( _scrollbar ); _scrollbar->setBarPos(KToolBar::Bottom); if (_sliderstate) _scrollbar->show(); else _scrollbar->hide();

  //
  // Menubar:
  // ========
  //

  _filemenu = new QPopupMenu( this );
  _editmenu = new QPopupMenu( this );
  _gridmenu = new QPopupMenu( this );
  _dynamicsmenu = new QPopupMenu( this );
  _viewmenu = new QPopupMenu( this );
  KdeEditorMenuBar::createMenuBar(menuBar(), _filemenu, _editmenu, _gridmenu, _dynamicsmenu, _viewmenu);
  _gridmenu->setItemChecked(_grid_id,TRUE);
  _dynamicsmenu->setItemChecked(_dyn_id,TRUE);
  _viewmenu->setItemChecked(ID_VIEW_TOOLBAR, _toolbarstate);
  _viewmenu->setItemChecked(ID_VIEW_NOTEBAR , _notebarstate);
  _viewmenu->setItemChecked(ID_VIEW_BUTTONBAR, _buttonbarstate);
  _viewmenu->setItemChecked(ID_VIEW_SLIDER, _sliderstate);
  connect(_filemenu,SIGNAL(activated(int)),SLOT(slotMenu(int)));
  connect(_editmenu,SIGNAL(activated(int)),SLOT(slotMenu(int)));
  connect(_gridmenu,SIGNAL(activated(int)),SLOT(slotGridMenu(int)));
  connect(_dynamicsmenu,SIGNAL(activated(int)),SLOT(slotDynMenu(int)));
  connect(_viewmenu,SIGNAL(activated(int)),SLOT(slotViewMenu(int)));

  _viewmenu->setItemEnabled(ID_VIEW_NOTEBAR, false);
  _viewmenu->setItemEnabled(ID_VIEW_BUTTONBAR, false);


  //
  // Contents:
  // =========
  
  setMinimumWidth(720);
  
  splitter = new QSplitter(this);
  splitter->setOpaqueResize(TRUE);
  
  lw = new KdeEventContent(this,part(),splitter);
  lw->setBackgroundMode( PaletteLight );
  lw->show();
  

  lw->addColumn( " Position  " );
  lw->addColumn( " Type  " );
  lw->addColumn( " A (pitch) " );
  lw->addColumn( " B (vel) " );
  lw->addColumn( " C (len) " );
  lw->addColumn( " D (enh) " );
  lw->addColumn( " E (chn) " );
  lw->addColumn( "    Text " );
  lw->setTreeStepSize( 20 );


  ew = new KdeEventFrame( this,part(),splitter );
  ew->setFrameStyle( QFrame::Panel | QFrame::Raised );
  // ew->setLineWidth(2);
  ew->setBackgroundMode( PaletteMidlight );
  ew->show();
  setCentralWidget( splitter );
  splitter->show();
  update();
  sonG->updateGui();

}

void KdeEventEditor::resizeEvent( QResizeEvent * ) {
  //ntent->setGeometry(0,0,width()-20, _ybottom);
  //splitter->setMaximumHeight(_ybottom);
}

void KdeEventEditor::update() {
/*
  QPainter p;
  p.begin(ew);

  int barlen = int(ew->width()*0.25);
  int barnum = 4;
  int yScale = 16; // ee->itemHeight();
  int posi;
  int line = 1;
  int len = 0;
  int indent = 18;
  unsigned long xoff = 0;
  */

  lw->clear();
  // JAN rewind();
  char * txt;
  // char * typ;
  Note * nt = 0;
  Vector * vec = 0;
  // Ornament * orn = 0;
  NoteItem * ni = 0;
  SymbolItem * si = 0;
  // MasterEventItem * ma = 0;
  // MidiEventItem * mi = 0;
  QListViewItem * item = 0;
  Position pos;
  int bars; int beats; int ticks;
  int va = 0;
  int vb = 0;
  int vc = 0;
  int vd = 0;
  int ve = 0;
  const char * vf = 0;
  txt = new char[96];
  Part * _part = part();

  for (Iterator i = Iterator(_part); !i.done(); i++) {

    // JAN while (ok) {
    va = 0; vb = 0; vc = 0; vd = 0; ve = 0;
    Event * ev = (Event*) *i;
    if (ev!=0) {
      
      pos = ev->internalStart();
      vc = ev->duration();
      sonG->bbt(bars,beats,ticks,pos);
      sprintf(txt," %3d .%2d .%4d ",bars,beats,ticks);
      //
      switch (ev->isA()) {
      case NOTE:
	nt = (Note*) ev;
	va = nt->pitch(); vb = nt->vel(); vd = nt->enh(); ve = nt->chan(); if (nt->lyrics() != 0) vf = nt->lyrics()->get(); else vf = 0;
	ni = new NoteItem(lw,txt,ev->ctype(), QString::number(va), QString::number(vb), QString::number(vc), QString::number(vd), QString::number(ve), QString(vf) );
	vec = nt->ornament();
	for (Ornament * orn = (Ornament*) vec->first(); orn != 0; orn = (Ornament*) vec->next(orn)) {
	  if (orn->isA()==EXPRESSION) {
	    ni->insertItem(new OrnamentItem(lw,QString(),QString("expression "),QString::number(((Expression*)orn)->expression()),QString::number(((Expression*)orn)->displacement()),QString(),QString(),QString()));
	  } else if (orn->isA()==LYRICS) {
	    ni->insertItem(new OrnamentItem(lw,QString(),QString("lyrics "),QString(((Lyrics*)orn)->get()),QString(),QString(),QString(),QString()));
	  }
	}
	item = ni;
	break;
      case SYMBOL:
	va = ((Symbol*) ev)->symbol(); vb = ((Symbol*) ev)->displacement(); vc = ((Symbol*) ev)->parameter(); 
	vf = ((Symbol*) ev)->text();
	si = new SymbolItem(lw,txt,ev->ctype(), QString::number(va), QString::number(vb), QString::number(vc), QString(), vf);
	item = si;
	break;
      case MASTEREVENT:
	// TODO:
	break;
      case MIDIEVENT:
	// TODO:
	break;
      default:
	break;
      }
      lw->insertItem(item);

    }
    // JAN ok = currentInc();
  }
  delete[] txt;

  ew->repaint();
}

KdeEventContent * KdeEventEditor::content() { return lw; }

KdeEventFrame * KdeEventEditor::frame() { return ew; }

void KdeEventEditor::gui(GuiEvents ev, bool flag) {
  switch (ev) {
  case CHANGES:
    break;
  case UNDO:
    _toolbar->setItemEnabled( ID_EDIT_UNDO, flag );
    _editmenu->setItemEnabled( ID_EDIT_UNDO, flag );
    break;
  case REDO:
    _toolbar->setItemEnabled( ID_EDIT_REDO, flag );
    _editmenu->setItemEnabled( ID_EDIT_REDO, flag );
    break;
  case SELECTIONS:
    _toolbar->setItemEnabled( ID_EDIT_CUT, flag );
    _toolbar->setItemEnabled( ID_EDIT_COPY, flag );
    _toolbar->setItemEnabled( ID_EDIT_CLEAR, flag );
    _toolbar->setItemEnabled( ID_EDIT_TRANSPOSE, flag );
    //_toolbar->setItemEnabled( ID_EDIT_QUANTIZE_ALL, flag );
    //_toolbar->setItemEnabled( ID_EDIT_QUANTIZE_LENGTH, flag );
    //_toolbar->setItemEnabled( ID_EDIT_FIXED_LENGTH, flag );
    _editmenu->setItemEnabled( ID_EDIT_CUT, flag );
    _editmenu->setItemEnabled( ID_EDIT_COPY, flag );
    _editmenu->setItemEnabled( ID_EDIT_CLEAR, flag );
    _editmenu->setItemEnabled( ID_EDIT_TRANSPOSE, flag );
    _editmenu->setItemEnabled( ID_EDIT_QUANTIZE_ALL, flag );
    _editmenu->setItemEnabled( ID_EDIT_QUANTIZE_LENGTH, flag );
    _editmenu->setItemEnabled( ID_EDIT_FIXED_LENGTH, flag );
    break;
  case MEMORY:
    _toolbar->setItemEnabled( ID_EDIT_PASTE, flag );
    _editmenu->setItemEnabled( ID_EDIT_PASTE, flag );

    break;
  }
}

void KdeEventEditor::print() {

}

void KdeEventEditor::settings() {
  // _content->settings();
}


void KdeEventEditor::exit() { delete this; }


int KdeEventEditor::getTop() { return top; }

void KdeEventEditor::setTop(int i) { top = i; }

void KdeEventEditor::updateEW() { ew->repaint(); }

int KdeEventEditor::itemHeight() { return itemh; }

void KdeEventEditor::setItemHeight(int i) { itemh = i; }

int KdeEventEditor::Pitch(int i) { return i; } // TODO

void KdeEventEditor::slotMenu(int i) {
  // cout << i << endl;
  _toolbar->commandCallback(i);
}

void KdeEventEditor::slotGridMenu(int i) {
  _gridmenu->setItemChecked(_grid_id,false);
  _grid_id = i;
  _gridmenu->setItemChecked(_grid_id,true);
  switch (i) {
  case ID_GRID_1: setGrid(1536); break;
  case ID_GRID_2: setGrid(768); break;
  case ID_GRID_4: setGrid(384); break;
  case ID_GRID_8: setGrid(192); break;
  case ID_GRID_16: setGrid(96); break;
  case ID_GRID_32: setGrid(48); break;
  case ID_GRID_64: setGrid(24); break;
  case ID_GRID_OFF: setGrid(0); break;
  }
}

void KdeEventEditor::slotDynMenu(int i) {
  _dynamicsmenu->setItemChecked(_dyn_id,false);
  _dyn_id = i;
  _dynamicsmenu->setItemChecked(_dyn_id,true);
}

void KdeEventEditor::slotViewMenu(int i) {
  bool ch = _viewmenu->isItemChecked(i);
  ch = !ch;
  _viewmenu->setItemChecked(i,ch);
  switch(i) {
  case ID_VIEW_TOOLBAR:
    if (ch) _toolbar->show(); else _toolbar->hide();
    break;
  case ID_VIEW_NOTEBAR:
    //if (ch) _notebar->show(); else _notebar->hide();
    break;
  case ID_VIEW_BUTTONBAR:
    //if (ch) _buttonbar->show(); else _buttonbar->hide();
    break;
  case ID_VIEW_SLIDER:
    if (ch) _scrollbar->show(); else _scrollbar->hide();
    break;
  }
}

void KdeEventEditor::keyPressEvent ( QKeyEvent * ) {
  // _content->keyPressEvent(key);
}

void KdeEventEditor::keyReleaseEvent ( QKeyEvent * ) {
  // _content->keyReleaseEvent(key);
}

// *****************************************************************************
//
// PAINT EVENT
// ===========
//

void KdeEventEditor::paintEvent( QPaintEvent * ) {
  //_content->repaint(FALSE);
  //_info->repaint(FALSE);

}

void KdeEventEditor::setCursorPosition(long ticks) {}



#endif
#include "kdeEventEditor.moc"
