#ifndef _SCOREOBJECT_H_
#define _SCOREOBJECT_H_

#include "atom.h"
#include "position.h"

class PrScoreEditor;

class ScoreObject : public Element
{
 private:

 public:
  ScoreObject() {}

  virtual const Position & start() const = 0;

  virtual long end() const = 0;

  virtual long duration() const = 0;

  virtual int display() const = 0;

  virtual void paint(PrScoreEditor * ed, int x=0, int y=0, int style=0)=0;

  virtual void print(PrScoreEditor * ed, int x=0, int y=0)=0;

  virtual bool isEvent() const { return false; }

  virtual bool isTrack() const { return false; }

  /** print has to be implemented */
  virtual ostream & print(int,ostream&) const = 0;

  /** flush has to be implemented */
  virtual void flush(const char*) const = 0;

  /** copy has to be implemented */
  virtual Element * copy() const = 0;

};

#endif
