#ifndef _RIEMANNFUNCTION_CPP_
#define _RIEMANNFUNCTION_CPP_

#include <string.h>
#include <iostream.h>
#include <stdlib.h>
#include <fstream.h>
#include "note.h"
#include "riemannFunction.h"
#include "part.h"
#include "loader.h"
#include "table.h"
#include "str.h"

extern char * getcmd(char*);

RiemannFunction::RiemannFunction() : _text(0) { _type = RIEMANNFUNCTION; }

RiemannFunction::RiemannFunction(Note * n, char * txt) : _text(txt) {
  _type = RIEMANNFUNCTION;
}

RiemannFunction::RiemannFunction(const RiemannFunction& o) : Ornament(o) {
  _type = RIEMANNFUNCTION;
  _text = strdup(o.get());
}

void RiemannFunction::set(const char * c) { _text = c; }



// virtuals:


ostream & RiemannFunction::print(int dep, ostream & s) const {
  s << spc(dep) << "<RIEMANNFUNCTION value=\"" << _text << "\" />" << endl;
  return s;
}

void RiemannFunction::flush(const char * c) const {
  cout << c << "RIEMANNFUNCTION " << _text << endl;

}

Element * RiemannFunction::copy() const {
  return new RiemannFunction(*this);
}


Element * RiemannFunction::load(char * aline, ifstream *& , Element *) { // inPtr, parent
    RiemannFunction * lyr = new RiemannFunction();

  Table * attr = Loader::getAttributes("RIEMANNFUNCTION",aline);
  if (attr!=0) {
    char * word = 0;

    if (attr->getEntry("value")) word = strdup(((String*) attr->getEntry("value"))->getValue());

    lyr->set(word);

    attr->scratch();
    delete attr;
  }
  return lyr;
}

#endif
