#ifndef _MOVEPART_H_
#define _MOVEPART_H_

#include "operation.h"
#include "position.h"

class Element;
class Compound;
class Track;
class Part;

/** This operation moves a part to the position p
 */
class MovePart : public Operation
{
 private:
  Part * _part;
  Track * _src;
  Track * _tgt;
  Position _old;
  Position _new;

 public:
  MovePart(Position p, Part * pt, Track * src, Track * tgt);
  MovePart(const MovePart&);
  ~MovePart();

  void undo();
  void redo();


  virtual ostream & print(int,ostream&) const;
  virtual void flush(const char*) const;
  virtual Element * copy() const;
};



#endif
