#ifndef _CONVERTTRACK_CPP_
#define _CONVERTTRACK_CPP_

#include <iostream.h>

#include "convertTrack.h"
#include "element.h"
#include "track.h"
#include "song.h"
#include "prFactory.h"
#include "prTrack.h"
#include "scoreTrack.h"
#include "drumTrack.h"
#include "masterTrack.h"
#include "audioTrack.h"
#include "commentTrack.h"
#include "prMainEditor.h"


extern PrFactory * factory;
extern PrMainEditor * mainEditor;

ConvertTrack::ConvertTrack(int i, Track * tr, Song * s) : Operation(), _song(s), _old(tr) {
  _type = CONVERTTRACK;
  _description = "convert track";
  _to_be_undone = true;

  cout << "i: " << i << endl;

  if ((_song!=0)&&(_old!=0)) {

    // _old->presentation()->erase();
    // _old->_pr = 0;
    _old->hide();

    if (i<5) _new = s->createTrack(i, 0);
    else     _new = s->createTrack(5, mainEditor->description(i-5));
    
    _new->setContent(_old->content());
    _old->setContent(0);
    _song->replace(_old,_new);
    _delete = _old;
  }
}

ConvertTrack::ConvertTrack(const ConvertTrack& el) : Operation(el) {
  _type = CONVERTTRACK;
  _old = el._old;
  _new = el._new;
  _song = el._song;
  _delete = el._delete;
}

ConvertTrack::~ConvertTrack() {
  delete _delete;
}

void ConvertTrack::undo() {
  if ((_song!=0)&&(_new!=0)&&(_old!=0)) {
    _old->setContent(_new->content());
    _new->setContent(0);

    // _new->presentation()->erase();
    // _new->_pr = 0;
    _new->hide();

    /* switch (_old->isA()) {
    case SCORETRACK   : _old->_pr = factory->createScoreTrack(_old); break;
    case DRUMTRACK    : _old->_pr = factory->createDrumTrack(_old); break;
    case MASTERTRACK  : _old->_pr = factory->createMasterTrack(_old); break;
    case AUDIOTRACK   : _old->_pr = factory->createAudioTrack(_old); break;
    case COMMENTTRACK : _old->_pr = factory->createCommentTrack(_old); break;
    }*/
    _old->show();

    _song->replace(_new,_old);
    _delete = _new;
  }
}

void ConvertTrack::redo() {
  if ((_song!=0)&&(_new!=0)&&(_old!=0)) {
    _new->setContent(_old->content());
    _old->setContent(0);

    // _old->presentation()->erase();
    // _old->_pr = 0;
    _old->hide();

    /*
    switch (_new->isA()) {
    case SCORETRACK   : _new->_pr = factory->createScoreTrack(_old); break;
    case DRUMTRACK    : _new->_pr = factory->createDrumTrack(_old); break;
    case MASTERTRACK  : _new->_pr = factory->createMasterTrack(_old); break;
    case AUDIOTRACK   : _new->_pr = factory->createAudioTrack(_old); break;
    case COMMENTTRACK : _new->_pr = factory->createCommentTrack(_old); break;
    }*/
    _new->show();

    _song->replace(_old,_new);
    _delete = _old;

  }
}



// ---------------
// virtuals:
//

ostream & ConvertTrack::print(int dep, ostream & s) const {
  s << spc(dep) << "<CONVERTTRACK song=\"" << _song->ctype() << " old=\"" << _old->ctype() << "\" new=\"" << _new->ctype() << "\" />" << endl;
  return s;
}

void ConvertTrack::flush(const char * c) const {
  cout << c << "CONVERTTRACK" << endl;
}

Element * ConvertTrack::copy() const {
  return new ConvertTrack(*this);
}


#endif
