#ifndef _CHORD_H_
#define _CHORD_H_

#include <event.h>
#include <position.h>

#include "globals.h"

class Chord : public Event
{
  class Iterator;
  friend class Chord::Iterator;

 private:
  int _dim;
  Key * _key;
  int * _mult;

 public:
  Chord();
  Chord(Position pos, int * step, int * enh, int * mult, int dim);
  Chord(const Chord &);
  ~Chord();
  void operator=(const Chord &);

  /**
   * Implementation of the print method
   **/
  virtual ostream & print(int,ostream&) const;

  /**
   * Implementation of the flush method
   **/
  virtual void flush(const char*) const;

  /**
   * Implementation of the copy method
   **/
  virtual Element * copy() const;


  /**
   * Inner class iterator
   **/
  class Iterator
    {
      friend class Chord;

    private:
      const Chord * _chord;
      int     _dim;
      Key     _key;
      int     _mult;
      int     _index;

    public:
      Iterator() {}

      Iterator(const Iterator& i);

      Iterator(const Chord & c);

      virtual ~Iterator();

      bool operator!=(const Iterator& i) const;

      bool operator==(const Iterator& i) const;

      virtual bool done() const;

      Key key();

      int mult();
      
      Iterator& operator++();

      Iterator operator++(int);
    };
  
};


#endif
