#ifndef _OPERATION_H_
#define _OPERATION_H_

#include "atom.h"

/**
 * All operations are derived from the abstract class Operation. For user defined operations there exists another abstract class - Addon - which itself
 * inherits from Operation (read the information about Addon and the sample addon - Dump - if you are interested in writing addons).
 *
 * And if you write your own addon: Don't forget to implement the destructor to clean up memory and avoid memory leaks !!
 *
 * The following operations exist so far:
 * ADDELEMENT, REMOVEELEMENT, CONVERTTRACK, MOVEPART, COPYPART, COPYGHOSTPART, MOVEEVENT, COPYEVENT, CHANGENOTE,
 * GLUENOTE, SPLITNOTE, ADDORNAMENT, REMOVEORNAMENT, ADDSYMBOL,
 * ADDTOSELECTION, REMOVEFROMSELECTION, NEWSELECTION, SELECTLEFT, SELECTRIGHT, UNSELECT, SPLITPART, GLUEPARTS,
 * COPYSELECTION, CUTSELECTION, PASTESELECTION, DELETESELECTION
 **/
class Operation : public Atoma
{
 protected:
  const char * _description;
  bool _to_be_undone;

 public:

  /**
   * Default Constructor
   **/
  Operation();
  
  /**
   * The destructor has definitely to be implemented:
   * I.e. deleted notes, parts, tracks(!) have to be remembered in order
   * to be able to undo the operation. Deleting the operation-object
   * means to free the memory!
   **/
  virtual ~Operation();
  
  /**
   * Implemented for undoable operations
   **/
  virtual void undo()=0;
  
  /**
   * Implemented for undoable operations
   **/
  virtual void redo()=0;

  /**
   * Returns the description of an operation
   **/
  const char * description();

  /**
   * Returns true if the operation is undoable
   **/
  bool isToBeUndone();

  /**
   * Sets the undoable flag to true
   **/
  void toBeUndone();

  /**
   * Always returns false, since operations never are events
   **/
  virtual bool isEvent() const { return false; }
};

#endif

