#ifndef _TIMEBAR_CPP_
#define _TIMEBAR_CPP_

#include <stdio.h>
#include <iostream.h>

#include <qpainter.h>
#include <qcursor.h>

#include "song.h"
#include "part.h"
#include "prMainEditor.h"

#include "timeBar.h"
#include "kdeMainEditor.h"

#include <kdebug.h>

extern Song * sonG;
extern PrMainEditor * mainEditor;

#define ME ((KdeMainEditor*)mainEditor)


TimeBar::TimeBar( QWidget *parent, const char *name )
  : QLabel( parent, name, Qt::WResizeNoErase | Qt::WRepaintNoErase ),
  _offset( 0 ),
  _cursorpos( 0 ),
  _pixpertick( 1.0/24 )
{
  setBackgroundMode( PaletteMidlight );
  setCursor(QCursor(2));
}

/*QtPartCanvas * TimeBar::gPartCanvas() {
  return pcanvas;
  }*/

void TimeBar::setOffset( int value ) {
  _offset = value;
  update();
}

void TimeBar::setCursorPosition( long ticks ) {
  int oldx = int(_cursorpos * _pixpertick + 20 - _offset);
  _cursorpos = ticks;
  int x = int(_cursorpos * _pixpertick + 20 - _offset);
  if( x != oldx ) {
    update(oldx, 0, 1, height());
    update(x, 0, 1, height());
  }
}

void TimeBar::setPixPerTick( double pixPerTick ) {
  _pixpertick = pixPerTick;
  update();
}

void TimeBar::paintEvent( QPaintEvent *ev ) {
  if(ev->rect().width() <= 0 || ev->rect().height() <= 0)
  {
    kdDebug() << "TimeBar::paintEvent() with non-positive size?" << endl;
    return;
  }

  master = sonG->master();
  met0 = sonG->meter0();
  met1 = sonG->meter1();

  QPixmap pix( ev->rect().width(), height() );    // for smooth display
  pix.fill( this, 2, 2 );             // paint in pixmap !
  QPainter painter( &pix );

  painter.setPen(black);
  int beat;
  int bar;
  int tick;
  int xoffset = 20 - _offset - ev->rect().x();
  int tickOffset = (int)((_offset - 20)/_pixpertick);
  if( tickOffset < 0 )
    tickOffset = 0;
  Position pos = Position(1,1,0);
  Position add = ( _pixpertick > 0.015625 ) ? Position(1,2,0) : Position(2,1,0); // one beat!
  char * txt = new char[12];
  bool showNum;
  int xx = xoffset;
  int end = ev->rect().width();
  for (unsigned long curtick = pos.ticks(); xx < end; pos += add, curtick = pos.ticks(), xx = int(curtick * _pixpertick) + xoffset) {
    if( xx > -25 ) //some arbitrary number smaller than 0 so that numbers get drawn
    {
      pos.gBBT(bar,beat,tick,master,met0,met1);

      if (beat==1) {
	if (_pixpertick>0.0008) {
	  painter.drawLine(xx,16,xx,22);
	}
	sprintf(txt,"%d ",bar);
	showNum = false;
	if (_pixpertick>0.015625) showNum = true;
	else if ((_pixpertick>0.0039) && ( (bar&3)==1 )) showNum = true;
	else if ((_pixpertick>0.0008) &&( (bar&15)==1 )) showNum = true;
	else if ((bar&127)==1) showNum = true;
	if (showNum) painter.drawText(xx+1,12,txt);
	if ((bar&7)==1) painter.drawLine(xx,12,xx,23);
      } else {
	if (_pixpertick>0.015625) painter.drawLine(xx,20,xx,22);
      }
    } 
  }
  
  //draw Cursor
  xx = (int)(_cursorpos * _pixpertick + xoffset);
  painter.drawLine(xx, 0, xx, height());
  
  Position leftSel = sonG->left();
  Position rightSel = sonG->right();
  painter.setPen(red);
  xx = (int)(leftSel*_pixpertick+xoffset);
  painter.drawLine(xx,1,xx,22);
  painter.fillRect(xx,1,4,3,red);
  xx = (int)(rightSel*_pixpertick+xoffset);
  painter.drawLine(xx,1,xx,22);
  painter.fillRect(xx-4,1,4,3,red);

  painter.end();
  bitBlt( this, ev->rect().x(), 0, &pix );
  delete[] txt;
}

void TimeBar::mousePressEvent( QMouseEvent * me ) {
  _xpos = me->x();
  _old_xticks = sonG->left().ticks();
  _old_xticks2 = sonG->right().ticks();

  int tickOffset = (long)(_offset/_pixpertick);
  Position pos = Position(1,1,0) + tickOffset;
  pos += (long)((_xpos-20)*1.0/_pixpertick);
  pos.snap(ME->snap());
  sonG->setCurrent(pos);
  ME->displaySongProperties();
  ME->setCursorPosition(pos.ticks());
  _xticks = pos.ticks();
}

void TimeBar::mouseMoveEvent( QMouseEvent * me ) {
  _xpos2 = me->x();
  int tickOffset = (long)(_offset/_pixpertick);
  Position pos = Position(1,1,0) + tickOffset;
  pos += (long)((_xpos2-20)*1.0/_pixpertick);
  pos.snap(ME->snap());
  _xticks2 = pos.ticks();
  if (_xticks2-_xticks > 768) {
    sonG->setLeft(_xticks);
    sonG->setRight(_xticks2);
  } else {
    sonG->setLeft(_old_xticks);
    sonG->setRight(_old_xticks2);
  }
  repaint(FALSE);
}

void TimeBar::mouseReleaseEvent( QMouseEvent * ) {
  /*
  _xpos2 = me->x();
  int tickOffset = (long)(_offset/_pixpertick);
  Position pos = Position(1,1,0,master,met0,met1) + tickOffset;
  pos += (_xpos2-20)*1.0/_pixpertick;
  pos.snap(ME->snap());
  _xticks2 = pos.ticks();
  if (_xticks2-_xticks > 768) {
    sonG->setLeft(_xticks);
    sonG->setRight(_xticks2);
    }*/
  ME->displaySongProperties();
  _xpos = 0;
  _xpos2 = 0;
}

// vim:sw=2:ts=8:ai

#endif
#include "timeBar.moc"
