/*  This file is part of the Brahms project
    Copyright (C) 2001 Matthias Kretz <kretz@kde.org>

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

*/

/* $Id: klineeditaction.cpp,v 1.1 2001/07/23 08:16:59 mkretz Exp $ */

#include "klineeditaction.h"

#include <qwhatsthis.h>
#include <qfont.h>

#include <klineedit.h>
#include <ktoolbar.h>

KLineEditAction::KLineEditAction( const QString& text, QObject* parent, const char* name )
	: KAction( text, 0, parent, name ),
	m_lined( 0 ),
	m_fontset( false )
{
}

KLineEditAction::~KLineEditAction()
{
}

int KLineEditAction::plug( QWidget *w, int index )
{
	if( !w->inherits( "KToolBar" ) )
		return -1;

	KToolBar *toolBar = (KToolBar *)w;
	
	int id = KAction::getToolButtonID();

	KLineEdit *lined = new KLineEdit( toolBar, "ToolBar Lineedit" );
	if( m_fontset )
		lined->setFont( m_font );
	lined->setText( m_text );
	toolBar->insertWidget( id, 70, lined, index );

	addContainer( toolBar, id );

	connect( lined, SIGNAL( returnPressed() ), SIGNAL( returnPressed() ) );
	connect( toolBar, SIGNAL( destroyed() ), this, SLOT( slotDestroyed() ) );

	toolBar->setItemAutoSized( id, true );

	m_lined = lined;

	emit plugged();

	QWhatsThis::add( lined, whatsThis() );

	return containerCount() - 1;
}

void KLineEditAction::unplug( QWidget *w )
{
	if ( !w->inherits( "KToolBar" ) )
		return;

	KToolBar *toolBar = (KToolBar *)w;

	int idx = findContainer( w );

	toolBar->removeItem( menuId( idx ) );

	removeContainer( idx );
	m_lined = 0L;
}

void KLineEditAction::setFont( const QFont & font )
{
	m_font = font;
	if( m_lined )
		m_lined->setFont( m_font );
	m_fontset = true;
}

void KLineEditAction::setText( const QString & text )
{
	m_text = text;
	if( m_lined )
		m_lined->setText( m_text );
}

#include "klineeditaction.moc"

// vim:tw=4:sw=4
