#ifndef _KDESCORECONTENT_CPP_
#define _KDESCORECONTENT_CPP_

#include <stdio.h>
#include <iostream.h>
#include <stdlib.h>
#include <math.h>

#include <kiconloader.h>
#include <klocale.h>
#include <kmenubar.h>

#include <qbitmap.h>
#include <qpopupmenu.h>
#include <qpainter.h>
#include <qlineedit.h>
#include <fstream.h>

#include "part.h"
#include "track.h"
#include "song.h"
#include "player.h"
#include "str.h"
#include "expression.h"
#include "lyrics.h"
#include "symbol.h"
#include "addToSelection.h"
#include "newSelection.h"
#include "removeFromSelection.h"
#include "moveEvent.h"
#include "copyEvent.h"
#include "addElement.h"
#include "removeElement.h"
#include "addOrnament.h"
#include "removeOrnament.h"
#include "changeNote.h"
#include "glueNote.h"
#include "splitNote.h"
#include "unselect.h"
#include "reference.h"
#include "scoreTrack.h"
#include "iterator.h"

#include "kdeScoreContent.h"
#include "kdeScoreEditor.h"
#include "kdeMainEditor.h"
#include "kdeEditorToolBar.h"
#include "kdeEditorNoteBar.h"
#include "kdeEditorButtonBar.h"
#include "kdeEditorScrollBar.h"
#include "kdeEditInfo.h"
#include "kdeEditorMenuBar.h"
#include "kdeKeyChooser.h"
#include "kdeSPD.h"
#include "positionCursor.h"
// #include "curHand.h"
#include "brahmsResources.h"

#include "qtScoreAddons.h"

#define ME ((KdeMainEditor*)mainEditor)
#define YTOP 12

extern Song * sonG;
extern PrMainEditor * mainEditor;
extern Table * selectioN;

extern const char * gmNames[];
extern int sharpTab[];
extern int flatTab[];
extern int signShift[];
extern int scrSigns[];
extern int allSigns[15][7];
extern int freqTab[];
extern int yClef[];

extern void createBreakGroups(QtScoreGroup *& grp, QtScoreGroup *& grp1, Position pos, int length, Position off, Part * master, int met0, int met1);

extern const char * bClef2mClef[];
extern const char * extNoteNames[];
extern const char * auxScoreNames[];


int globalStaffCounter;

enum { ID_TOOL_IN, ID_TOOL_ANS, ID_TOOL_AOS, ID_TOOL_LYR };
enum { ID_OPTIONS_NOTEBAR, ID_OPTIONS_AUTHOR, ID_OPTIONS_AUX, ID_OPTIONS_NEXT, ID_OPTIONS_STN, ID_OPTIONS_SIN, ID_OPTIONS_LYRICS, ID_OPTIONS_VOLUMES };

extern QPixmap * imgNotePtr;
extern QPixmap * imgSignPtr;
extern QPixmap * imgFlagPtr;
extern QPixmap * imgBreakPtr;
extern QPixmap * imgNoteAccentPtr;
extern QPixmap * imgScoreSymbolPtr;

static unsigned char xsymbolc1[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,
 0x24,0x00,0x4e,0x00,0x5d,0x80,0x3e,0x40,0x1f,0xa0,0x0f,0xd0,0x07,0xe8,0x03,
 0xf4,0x01,0xfa,0x00,0x79,0x00,0x3f,0x00,0x1f,0x00,0x0f,0x00};
				
static unsigned char xsymbolc2[] = {
 0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x00,0x18,0x00,
 0x24,0x00,0x4e,0x00,0x59,0x80,0x30,0x40,0x18,0x20,0x0c,0x10,0x06,0x08,0x03,
 0x84,0x01,0xc2,0x00,0x61,0x00,0x37,0x00,0x1f,0x00,0x0f,0x00};
				
static unsigned char xlyricsc1[] = {
 0x00,0x00,0x00,0x00,0x6c,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x18,0x10,
 0x24,0x6c,0x4e,0x00,0x5d,0x80,0x3e,0x40,0x1f,0xa0,0x0f,0xd0,0x07,0xe8,0x03,
 0xf4,0x01,0xfa,0x00,0x79,0x00,0x3f,0x00,0x1f,0x00,0x0f,0x00};
				
static unsigned char xlyricsc2[] = {
 0x00,0x00,0x00,0x00,0x6c,0x00,0x10,0x00,0x10,0x00,0x10,0x00,0x10,0x18,0x10,
 0x24,0x6c,0x4e,0x00,0x59,0x80,0x30,0x40,0x18,0x20,0x0c,0x10,0x06,0x08,0x03,
 0x84,0x01,0xc2,0x00,0x61,0x00,0x37,0x00,0x1f,0x00,0x0f,0x00};
				

enum { BowUp, BowDown };

// KbText * textElement = 0;


KdeScoreContent::KdeScoreContent(QFrame * parent, KdeScoreEditor * ed , KdeEditorToolBar * tb, KdeEditorNoteBar * nb, KdeEditorButtonBar * bb)
  : QFrame(parent,"content",QFrame::Sunken), _editor(ed), _notebar(nb), _toolbar(tb), _buttonbar(bb),
    _grab(0), _grabX(-1), shftFlag(false), ctrlFlag(false), suprFlag(false)
{

  _position_cursor = new PositionCursor(this,0); // offset has to be set when calling move, because it depends on the key of the staff

  // setBackgroundMode( PaletteLight );
  /*  QBitmap cb1( curHandCopy_width, curHandCopy_height, curHandCopy_bits, TRUE );
  QBitmap cm1( curHandCopyM_width, curHandCopyM_height, curHandCopyM_bits, TRUE );
  symbolcursor1 = new QCursor( cb1, cm1, 0, 19);*/

  QBitmap cb1( 15, 21, xsymbolc1, TRUE );
  QBitmap cm1( 15, 21, xsymbolc1, TRUE );
  symbolcursor1 = new QCursor( cb1, cm1, 0, 19);
  QBitmap cb2( 15, 21, xsymbolc2, TRUE );
  QBitmap cm2( 15, 21, xsymbolc2, TRUE );
  symbolcursor2 = new QCursor( cb2, cm2, 0, 19);

  QBitmap lb1( 15, 21, xlyricsc1, TRUE );
  QBitmap lm1( 15, 21, xlyricsc1, TRUE );
  lyricscursor1 = new QCursor( lb1, lm1, 0, 19);
  QBitmap lb2( 15, 21, xlyricsc2, TRUE );
  QBitmap lm2( 15, 21, xlyricsc2, TRUE );
  lyricscursor2 = new QCursor( lb2, lm2, 0, 19);


  yAux = 0;
  firstGroup = 0;
  showVOL = false;
  showLYR = false;

  txtLine = new QLineEdit(this,"text");
  txtLine->hide();
  lyrLine = new LyricsEdit(this);
  lyrLine->hide();
  connect(lyrLine,SIGNAL(returnPressed()),SLOT(setLyrics()));

  KIconLoader * loader = KGlobal::iconLoader();
  QBitmap maske;

  // QPixmap paper = loader->loadIcon( "paper02", KIcon::Desktop );
  // setBackgroundPixmap(paper);

  cursorPM = loader->loadIcon( "cnote0",KIcon::Toolbar ); cursorBM[0] = cursorPM; cursor[0] = new QCursor( cursorBM[0], cursorBM[0],5,18);
  cursorPM = loader->loadIcon( "cnote1",KIcon::Toolbar ); cursorBM[1] = cursorPM; cursor[1] = new QCursor( cursorBM[1], cursorBM[1],5,18);
  cursorPM = loader->loadIcon( "cnote2",KIcon::Toolbar ); cursorBM[2] = cursorPM; cursor[2] = new QCursor( cursorBM[2], cursorBM[2],5,18);
  cursorPM = loader->loadIcon( "cnote3",KIcon::Toolbar ); cursorBM[3] = cursorPM; cursor[3] = new QCursor( cursorBM[3], cursorBM[3],5,18);
  cursorPM = loader->loadIcon( "cnote4",KIcon::Toolbar ); cursorBM[4] = cursorPM; cursor[4] = new QCursor( cursorBM[4], cursorBM[4],5,18);
  cursorPM = loader->loadIcon( "cnote5",KIcon::Toolbar ); cursorBM[5] = cursorPM; cursor[5] = new QCursor( cursorBM[5], cursorBM[5],5,18);
  cursorPM = loader->loadIcon( "cnote6",KIcon::Toolbar ); cursorBM[6] = cursorPM; cursor[6] = new QCursor( cursorBM[6], cursorBM[6],5,18);
  cursorPM = loader->loadIcon( "caddns",KIcon::Toolbar ); cursorBM[7] = cursorPM;
  cursorPM = loader->loadIcon( "caddns1",KIcon::Toolbar ); maske = cursorPM; cursor[7] = new QCursor( cursorBM[7], maske,7,10);
  cursorPM = loader->loadIcon( "caddos",KIcon::Toolbar ); cursorBM[8] = cursorPM;
  cursorPM = loader->loadIcon( "caddos1",KIcon::Toolbar ); maske = cursorPM; cursor[8] = new QCursor( cursorBM[8], maske,7,10);

  imgNote[0] = loader->loadIcon( "note0",KIcon::Toolbar ); maske = imgNote[0]; imgNote[0].setMask( maske );
  imgNote[1] = loader->loadIcon( "note1",KIcon::Toolbar ); maske = imgNote[1]; imgNote[1].setMask( maske );

  imgSign[0] = loader->loadIcon( "sgnFlat2",KIcon::Toolbar ); maske = imgSign[0]; imgSign[0].setMask( maske );
  imgSign[1] = loader->loadIcon( "sgnFlat",KIcon::Toolbar ); maske = imgSign[1]; imgSign[1].setMask( maske );
  imgSign[2] = loader->loadIcon( "note1",KIcon::Toolbar );
  imgSign[3] = loader->loadIcon( "sgnSharp",KIcon::Toolbar );  maske = imgSign[3]; imgSign[3].setMask( maske );
  imgSign[4] = loader->loadIcon( "sgnSharp2",KIcon::Toolbar );  maske = imgSign[4]; imgSign[4].setMask( maske );
  imgSign[5] = loader->loadIcon( "sgnNat",KIcon::Toolbar );  maske = imgSign[5]; imgSign[5].setMask( maske );

  imgClef[0] = loader->loadIcon( "key0",KIcon::Toolbar ); maske = imgClef[0]; imgClef[0].setMask( maske );
  imgClef[1] = loader->loadIcon( "key1",KIcon::Toolbar ); maske = imgClef[1]; imgClef[1].setMask( maske );
  imgClef[2] = loader->loadIcon( "key2",KIcon::Toolbar ); maske = imgClef[2]; imgClef[2].setMask( maske );
  imgClef[3] = loader->loadIcon( "key3",KIcon::Toolbar ); maske = imgClef[3]; imgClef[3].setMask( maske );
  imgClef[4] = loader->loadIcon( "key4",KIcon::Toolbar ); maske = imgClef[4]; imgClef[4].setMask( maske );
  imgClef[5] = loader->loadIcon( "key5",KIcon::Toolbar ); maske = imgClef[5]; imgClef[5].setMask( maske );
  imgClef[6] = loader->loadIcon( "key6",KIcon::Toolbar ); maske = imgClef[6]; imgClef[6].setMask( maske );
  imgClef[7] = loader->loadIcon( "key7",KIcon::Toolbar ); maske = imgClef[7]; imgClef[7].setMask( maske );
  imgClef[8] = loader->loadIcon( "key8",KIcon::Toolbar ); maske = imgClef[8]; imgClef[8].setMask( maske );
  imgClef[9] = loader->loadIcon( "key9",KIcon::Toolbar ); maske = imgClef[9]; imgClef[9].setMask( maske );
  imgClef[10] = loader->loadIcon( "key10",KIcon::Toolbar ); maske = imgClef[10]; imgClef[10].setMask( maske );
  imgClef[11] = loader->loadIcon( "key11",KIcon::Toolbar ); maske = imgClef[11]; imgClef[11].setMask( maske );
  imgClef[12] = loader->loadIcon( "key12",KIcon::Toolbar ); maske = imgClef[12]; imgClef[12].setMask( maske );
  imgClef[13] = loader->loadIcon( "key13",KIcon::Toolbar ); maske = imgClef[13]; imgClef[13].setMask( maske );

  imgFlat  = loader->loadIcon( "sgnFlat",KIcon::Toolbar );  maske = imgFlat; imgFlat.setMask( maske );
  imgSharp = loader->loadIcon( "sgnSharp",KIcon::Toolbar ); maske = imgSharp; imgSharp.setMask( maske );

  imgFlag[0] = loader->loadIcon( "flagX",KIcon::Toolbar ); QBitmap BMflag; BMflag = imgFlag[0]; imgFlag[0].setMask( BMflag );
  imgFlag[1] = loader->loadIcon( "flagI",KIcon::Toolbar ); QBitmap BMflag1; BMflag1 = imgFlag[1]; imgFlag[1].setMask( BMflag1 );

  arrBreak[9] = loader->loadIcon( "b1",KIcon::Toolbar ); maske = arrBreak[9]; arrBreak[9].setMask( maske );
  arrBreak[8] = loader->loadIcon( "b2",KIcon::Toolbar ); maske = arrBreak[8]; arrBreak[8].setMask( maske );
  arrBreak[7] = loader->loadIcon( "b4",KIcon::Toolbar ); maske = arrBreak[7]; arrBreak[7].setMask( maske );
  arrBreak[6] = loader->loadIcon( "b8",KIcon::Toolbar ); maske = arrBreak[6]; arrBreak[6].setMask( maske );
  arrBreak[5] = loader->loadIcon( "b16",KIcon::Toolbar ); maske = arrBreak[5]; arrBreak[5].setMask( maske );
  arrBreak[4] = loader->loadIcon( "b32",KIcon::Toolbar ); maske = arrBreak[4]; arrBreak[4].setMask( maske );

  for (int i=0;i<21;i++) {
    noteAccent[i] = loader->loadIcon( extNoteNames[i],KIcon::Toolbar );
  }
  noteExt = new QtSymbols(_editor,noteAccent,extNoteElement,21,7,"Note Symbols",ID_TOOL_ANS);

  for (int i=0;i<33;i++) {
    scoreSymbol[i] = loader->loadIcon( auxScoreNames[i],KIcon::Toolbar );
  }
  scoreAux = new QtSymbols(_editor,scoreSymbol,auxScoreElement,33,11,"Score Symbols",ID_TOOL_AOS);

  updateCursor();

  imgNotePtr = imgNote;
  imgSignPtr = imgSign;
  imgFlagPtr = imgFlag;
  imgBreakPtr = arrBreak;
  imgNoteAccentPtr = noteAccent;
  imgScoreSymbolPtr = scoreSymbol;

  _part = _editor->part();

  rbmenu = new QPopupMenu();
  /* rbmenu->connectItem( rbmenu->insertItem(i18n("flip stem")), this, SLOT(flipStem()) );
     rbmenu->connectItem( rbmenu->insertItem(i18n("flip bow")), this, SLOT(flipBow()) );
     rbmenu->insertSeparator();*/
  rbmenu->connectItem( rbmenu->insertItem(i18n("glue to next note")), this, SLOT(glueNote()) );
  rbmenu->connectItem( rbmenu->insertItem(i18n("split note")), this, SLOT(splitNote()) );
  rbmenu->insertSeparator();
  rbmenu->connectItem( rbmenu->insertItem(i18n("remove symbols")), this, SLOT(removeSymbols()) );
  rbmenu->connectItem( rbmenu->insertItem(i18n("remove bow")), this, SLOT(removeBow()) );
  rbmenu->insertSeparator();
  rbmenu->connectItem( rbmenu->insertItem(i18n("delete note")), this, SLOT(deleteNote()) );
  show();
}

KdeScoreContent::~KdeScoreContent() {
  delete noteExt;
  delete scoreAux;
  if (keyChooser) delete myKeyChooser;
}

void KdeScoreContent::glueNote() {
  if (_grab!=0) {
    sonG->doo(new GlueNote(_grab, _editor->part()));
    _grab = 0;
    _grabX = -1;
    repaint(FALSE);
  }
}

void KdeScoreContent::splitNote() {
  if (_grab!=0) {
    sonG->doo(new SplitNote(_grab, _editor->part(), _editor->grid()));
    _grab = 0;
    _grabX = -1;
    repaint(FALSE);
  }
}

void KdeScoreContent::deleteNote() {
  if (_grab!=0) {
    sonG->doo(new RemoveElement(_grab, _editor->part()));
    _grab = 0;
    _grabX = -1;
    repaint(FALSE);
  }
}

void KdeScoreContent::removeSymbols() {
  if (_grab!=0) {
    sonG->doo(new RemoveOrnament(_grab,EXPRESSION));
    // _grab->removeExp();
    _grab = 0;
    _grabX = -1;
    repaint(FALSE);
  }
}

void KdeScoreContent::removeBow() {
  if (_grab!=0) {
    sonG->doo(new RemoveOrnament(_grab,BOW));
    // _grab->removeBow();
    _grab = 0;
    _grabX = -1;
    repaint(FALSE);
  }
}

void KdeScoreContent::flipStem() {
  /* TODO: if (selNote) ((KbNote*)selNote)->flipStem();
     selNote = 0; showNoteInfoOff();*/
}

void KdeScoreContent::flipBow() {
  /* TODO: if (selNote) ((KbNote*)selNote)->flipBow();
     selNote = 0; showNoteInfoOff();*/
}

void KdeScoreContent::paintEvent( QPaintEvent * ) {
  setMouseTracking(TRUE);

  QPixmap pix( width(), height() );
  pix.fill( this, 10,10 );
  QPainter score;
  score.begin( &pix );


  master = sonG->master();
  met0 = sonG->meter0();
  met1 = sonG->meter1();

  int parts = _editor->parts();
  int curPart = -1;

  for (N=0;N<parts;N++) {
    if (_editor->part(N)==_part) curPart = N;
  }

  for (N=0;N<parts;N++) {
    _editor->setPart(N);
    Part * part = _editor->part();
    if (_part==part) {
      score.setPen(red);
      score.drawRect(8,YTOP+N*(100+yAux)+38,4,29);
      score.setPen(black);
      _active_system = N;
    }


    scrKey = part->key();
    clef = part->clef();
    ScoreTrack * _track = (ScoreTrack*) part->track();

    int y = 0;

    yoffset = N*(100+yAux) + YTOP;
    nKey     = abs(scrKey);
    xoffset  = 60+6*abs(scrKey);
    xofftime = xoffset-10;

    pixPerTick = (width()-xoffset-4.0)/(_editor->right().ticks()-_editor->left().ticks());


    sprintf(t1, "%d", part->meter0()); // DOIT: if master, get masters time1/time2...
    sprintf(t2, "%d", part->meter1());

    for (int i=0;i<5;i++) {
      y = 40+i*6+yoffset;
      score.drawLine(10,y,width()-6,y);
    }
    score.drawLine(10,yoffset+40,10,yoffset+65);
    score.drawLine(width(),yoffset+40,width(),yoffset+65);
    score.drawPixmap(26-12,40-8+yoffset,imgClef[clef]); // draw Clef


    yytext = 0;
    if (_editor->showTrackName()==TRUE) { score.drawText(10,yoffset-1,_track->name()->getValue()); yytext = 10; }
    if (_editor->showInstrumentName()==TRUE) {
      if (_track->program()==128) // track inst = "individual", i.e. delegated to parts
	score.drawText(10,yoffset+yytext-1,gmNames[part->program()]);
      else
	score.drawText(10,yoffset+yytext-1,gmNames[_track->program()]);
    }



    score.setFont(QFont("Helvetica",12,QFont::Normal,TRUE));
    score.drawText(xoffset-8,yoffset+18,_editor->cLeft()); // draw bar
    score.setFont(QFont("Helvetica",12,QFont::Bold));
    score.drawText(xofftime,yoffset+51,t1); yytext = 10; // draw measurement
    score.drawText(xofftime,yoffset+63,t2); yytext = 10;
    score.setFont(QFont("Helvetica",12));

    for (int i=0; i<nKey; i++) {
      if (scrKey>0) { score.drawPixmap(45+i*6-8,yoffset+40+sharpTab[i]+signShift[clef]-12,imgSharp); // draw sharps
      } else { score.drawPixmap(45+i*6-8,yoffset+40+flatTab[i]+signShift[clef]-2-9,imgFlat);         // draw flats
      }
    }

    for (Position pos = _editor->left(); pos<_editor->right();) {
      pos.nextBar();
      int xxline = int(xoffset+(pos.ticks()-_editor->left().ticks())*pixPerTick-2);
      score.drawLine(xxline,yoffset+40,xxline,yoffset+64);
    }

    // draw notes:

    freePos = draw(_editor->left(), _editor->right(), &score, part);


  }


  //
  // selection frame
  //
  if ((_grabX > -1) && (symbol==0)) {
    score.setPen(Qt::DashLine);
    if (_grab==0)
      score.drawRect(_pressX,_pressY,_moveX-_pressX,_moveY-_pressY);
    score.setPen(Qt::SolidLine);
  }


  //  score.setPen(red);
  //  score.drawRect(8,YTOP+_editor->currentIndex()*(100+yAux)+38,4,29);


  score.end();

  bitBlt( this, 0, 0, &pix );

  _editor->setPart(curPart);

  _notebar->update();
}





/////////////////////////////////////////////////////////////////////
//                                                                 //
//                          draw notes                             //
//                                                                 //
/////////////////////////////////////////////////////////////////////



int KdeScoreContent::draw(Position lpos, Position rpos, QPainter * score, Part * part) {
  // DOIT: posCoef = 1.0*time2/(1536*time1);
  posCoef = 1.0/1536;


  // oldTimeBar = 1;
  // curBar = 1;
  curMet0 = met0; curMet1 = met1; _editor->left().gBBT(curBar,curBeat,curTick,master,curMet0,curMet1,true);

  freePos = 0;
  n = 0;
  scrClef = clef;

  for (i=0;i<7;i++) scrSigns[i]=allSigns[scrKey+7][i];

  yyOld = 0; xxOld = 0; xxCol = 0;
  yFlag1 = 0;
  nFlag1 = 0;
  nnFlag1 = 0;
  xFlag[0] = 0;
  yFlagMax[0] = 0;
  yFlagMin[0] = 0;
  triX0 = -1;
  Part * ptchn = 0;

  Position relPos = 0;

  xoffset = 60+6*abs(scrKey);

  QtScoreGroup * myGroup = 0;
  QtScoreGroup * tmp = 0;

  relPos = _editor->left() - part->start();
  // if (relPos.negative()>0) relPos = part->start() - lpos;

  /*
  KbAtom* atom = part->gFirstAtom();
  while (atom!=0 && atom->start()+part->start() < lpos) atom = atom->gNext();
  while (atom!=0 && atom->start()+part->start() < rpos) {
  */

  for (Iterator ii = Iterator(_editor); !ii.done(); ii++) {
    Event * event = (Event*) *ii;

    ptchn = ii.change();
    part = ptchn==0?part:ptchn;
    relPos = _editor->left() - part->start();

  /* JAN   bool ok = true;
  while (ok) {
  Event * event = _part->current(); */

    if (event!=0) {
      // JAN: TODO: Part * newpt = ii.change(); if (newpt) { newkey, newprogram, etc... } !!!
      if (event->isA()==NOTE) {
	Note * note = (Note*) event;
	if (myGroup == 0) {
	  // cout << "soieses" << endl;
	  myGroup = new NoteGroup(note,part->start());
	  if (note->internalStart()-relPos > 0) {
	    createBreakGroups(firstGroup, tmp, lpos, note->internalStart()-relPos.ticks(), part->start(), master, met0, met1);
	    tmp->sNext(myGroup);
	  } else {
	    firstGroup = myGroup;
	  }
	} else {
	  myGroup = myGroup->append(note,part->start(),master,met0,met1);
	}
      } else if (event->isA()==SYMBOL) {
	Position pos = part->start(event);
	Position myLeftBar = _editor->left(); // Position(xmOffset+1,1,0,master,met0,met1);
	xx = int( (pos-myLeftBar)*pixPerTick ) +  xoffset + 2;
	if (((Symbol*)event)->isText()) score->drawText(xx, yoffset + ((Symbol*)event)->displacement(), ((Symbol*)event)->text());
	else if (!((Symbol*)event)->isParameterized())
	  score->drawPixmap(xx, yoffset + ((Symbol*)event)->displacement() - 9, scoreSymbol[((Symbol*)event)->symbol()]);
	else { // parameterized score symbol!
	  Symbol * sym = (Symbol*) event;
	  int yy = yoffset + sym->displacement();
	  int par = int( sym->parameter()*pixPerTick );
	  switch (sym->symbol()) {
	  case AS_DECRESCENDO:
	    score->drawLine(xx,yy-4,xx+par,yy);
	    score->drawLine(xx,yy+4,xx+par,yy);
	    break;
	  case AS_CRESCENDO:
	    score->drawLine(xx,yy,xx+par,yy-4);
	    score->drawLine(xx,yy,xx+par,yy+4);
	    break;
	  case AS_8VA:
	    score->drawPixmap(xx, yy - 9, scoreSymbol[sym->symbol()]);
	    if (par>20) { score->setPen(DotLine); score->drawLine(xx+20, yy-5, xx+par, yy-5); score->setPen(SolidLine); }
	    break;
	  case AS_15VA:
	    score->drawPixmap(xx, yy - 9, scoreSymbol[sym->symbol()]);
	    if (par>20) { score->setPen(DotLine); score->drawLine(xx+20, yy-5, xx+par, yy-5); score->setPen(SolidLine); }
	    break;
	  case AS_TRILLX:
	    score->drawPixmap(xx, yy - 9, scoreSymbol[sym->symbol()]);
	    if (par>20) {
	      for (int i=0;int(i/20)<int(par/20);i += 20)
		score->drawPixmap(xx+20+i, yy - 10, scoreSymbol[AS_TRILLX2]);
	    }
	    break;
	  case AS_TRILLX2:
	    score->drawPixmap(xx, yy - 9, scoreSymbol[AS_TRILLX2]);
	    for (int i=0;int(i/20)<int(par/20);i += 20)
	      score->drawPixmap(xx+20+i, yy - 9, scoreSymbol[AS_TRILLX2]);
	    break;
	  }
	}
      }
    }
    // JAN ok = _editor->currentInc(_part);
  }


  // cout << "--------------------------------" << endl << endl;


  if (firstGroup) {

  Position curPos;

  relPos = part->start() - lpos;
  Position myEnd = myGroup->end() + relPos;
  curPos = myEnd;
  myEnd.nextBar();
  // curPos.gBBT(curBar,curBeat,curTick,master,met0,met1); curBar--; curBeat--;
  int ldiff = myEnd - curPos.ticks();
  if (ldiff>2) {
    // createBreakGroups(myGroup, tmp, curPos, ldiff, master, met0, met1);
    myGroup->sNext(new BreakGroup(myGroup->end(),ldiff,part->start()));
  }



    QtScoreGroup * tmp;
    for (myGroup = firstGroup; myGroup!=0;) {
      // myGroup->print();
      oldTimeBar = curBar;
      relPos = part->start() - lpos;
      curPos = myGroup->start() + relPos;
      curMet0 = met0; curMet1 = met1; curPos.gBBT(curBar,curBeat,curTick,master,curMet0,curMet1,true);
      if (oldTimeBar!=curBar)
	for (i=0;i<7;i++) scrSigns[i]=allSigns[scrKey+7][i];
      /*
      if (N==selSystem) myGroup->draw(score,relPos,pixPerTick,xoffset,yoffset,scrClef,master,met0,met1,selNote,selX1,selX2,showVOL,showLYR);
      else              myGroup->draw(score,relPos,pixPerTick,xoffset,yoffset,scrClef,master,met0,met1,selNote,-1,0,showVOL,showLYR);
      */

      myGroup->draw(score,relPos,pixPerTick,xoffset,yoffset,scrClef,master,met0,met1,0,-1,0,showVOL,showLYR);
      tmp = myGroup->Next();
      delete myGroup;
      myGroup = tmp;
    }
    firstGroup = 0;
  }


  return freePos.ticks();
}


int KdeScoreContent::DOT( int l ) {

  x0 = int(1.000000001 * log(l/3)/log(2)); l = l-3*int(pow(2,x0));
  if (l<3) l = 3;
  x1 = int(1.000000001 * log(l/3)/log(2)); l = l-3*int(pow(2,x1));
  if (l<3) l = 3;
  x2 = int(1.000000001 * log(l/3)/log(2)); l = l-3*int(pow(2,x2));
  return (x0-x1==1)+(x1-x2==1);

}




void KdeScoreContent::updateCursor() {
  if (tool()==ID_TOOL_IN) {
    setCursor(*cursor[_editor->lengthOrd()-1]);
    if (!noteExt->isHidden()) noteExt->hide();
    if (!scoreAux->isHidden()) scoreAux->hide();
    setFocus();
  } else if (tool()==ID_TOOL_ANS) {
    if (noteExt->isHidden()) { setCursor(*symbolcursor1); noteExt->show(); }
    if (!scoreAux->isHidden()) scoreAux->hide();
  } else if (tool()==ID_TOOL_AOS) {
    if (!noteExt->isHidden()) noteExt->hide();
    if (scoreAux->isHidden()) { scoreAux->show(); setCursor(*symbolcursor1); }
  } else if (tool()==ID_TOOL_LYR) {
    if (!noteExt->isHidden()) noteExt->hide();
    if (!scoreAux->isHidden()) scoreAux->hide();
  }
}

void KdeScoreContent::setTool(int i) {
  _editor->setTool(i);
}

int KdeScoreContent::tool() {
  return _editor->tool();
}



void KdeScoreContent::settings() {
  if (keyChooser==false) myKeyChooser = new KdeKeyChooser(_editor);
  myKeyChooser->show();
  keyChooser = true;
}

void KdeScoreContent::clearKeyChooser() { keyChooser = false; }

/*
void KdeScoreContent::optionsMenu(int n) {
  switch(n) {
  case ID_OPTIONS_AUX:
    //if (showAUX) { showAUX = false; options->setItemChecked(ID_OPTIONS_AUX,false); scoreAux->hide(); }
    //else { showAUX = true; options->setItemChecked(ID_OPTIONS_AUX,true); scoreAux->show(); }
    break;
  case ID_OPTIONS_NEXT:
    //if (showNEXT) { showNEXT = false; options->setItemChecked(ID_OPTIONS_NEXT,false); noteExt->hide(); }
    //else { showNEXT = true; options->setItemChecked(ID_OPTIONS_NEXT,true); noteExt->show(); }
    break;
  case ID_OPTIONS_STN:
    if (showTN==TRUE) showTN=FALSE;
    else showTN=TRUE;
    //options->setItemChecked(ID_OPTIONS_STN,showTN);
    break;
  case ID_OPTIONS_SIN:
    if (showIN==TRUE) showIN=FALSE;
    else showIN=TRUE;
    //options->setItemChecked(ID_OPTIONS_SIN,showIN);
    break;
  case ID_OPTIONS_LYRICS:
    if (showLYR==true) { showLYR=false; yAux = 0; volGrabX1 = 0; }
    else { showLYR = true; showVOL = false; yAux = 20; volGrabX1 = 0; }
    //options->setItemChecked(ID_OPTIONS_LYRICS,showLYR);
    //options->setItemChecked(ID_OPTIONS_VOLUMES,showVOL);
    // TODO: setFixedHeight(parts*(100+yAux)+YTOP);
    break;
  case ID_OPTIONS_VOLUMES:
    if (showVOL==true) { showVOL=false; yAux = 0; volGrabX1 = 0; }
    else { showVOL = true; showLYR = false; yAux = 64; volGrabX1 = 0; }
    //options->setItemChecked(ID_OPTIONS_LYRICS,showLYR);
    //options->setItemChecked(ID_OPTIONS_VOLUMES,showVOL);
    // TODO:setFixedHeight(parts*(100+yAux)+YTOP);
    break;
  }
}
*/

int KdeScoreContent::gEnhValue() {
  return enhValue;
}

void KdeScoreContent::sEnhValue(int e) {
  enhValue = e;
}

// *****************************************************************************
//
// SLOTS
// =====
//


void KdeScoreContent::mousePressEvent ( QMouseEvent * me ) {
  _pressX = me->x();
  _pressY = me->y();
  double pixPerTick = (width()-xoffset-4.0)/(_editor->right().ticks()-_editor->left().ticks());
  long pos = _editor->snap((_pressX-xoffset)/pixPerTick) + _editor->left().ticks();
  int pitch = Pitch(_pressY);
  bool tail = false;
  _grab = _editor->getGrabNote(pos,pitch,tail);
  if (int((_moveY-YTOP)/100)!=_active_system) _grab = 0;
  _grabY = _pressY;
  _grabX = int((_pressX-xoffset)/pixPerTick + _editor->left().ticks()); // without snap!
  int tol = tool();

  if (me->button()==RightButton) {
    if (_grab) rbmenu->popup( mapToGlobal(me->pos()), 0 );
  } else {
    if (_grab==0) {
    } else {
      if (tol == ID_TOOL_IN) {
	//
	// NOTE TOOL
	//
	setCursor(imgNote[1]);
	_grabW = int(_grab->duration()*pixPerTick);
      } else if (tol == ID_TOOL_ANS) {
	//
	// NOTE SYMBOL
	//
	if (_grab) {
	  if ((extNoteElement==NS_BOWDOWN)||(extNoteElement==NS_BOWUP)) { // Bow
	    // cout << "BOW" << endl;
	    int blen = 0;
	    Note * n = _grab;
	    while ((blen==0)&&(_part->next(n)!=0)) {
	      n = (Note*) _part->next(n);
	      blen = int(n->internalStart().ticks() - _grab->internalStart().ticks());
	    }
	    if (blen==0) blen = 384;
	    int dir = BowUp; if (extNoteElement==NS_BOWDOWN) dir = BowDown;
	    int delta = 0;
	    if (n) delta = (n->pitch() - ((Note*)_grab)->pitch())*3;
	    if (_grab&&_grab->isA()==NOTE) noteBow = ((Note*)_grab)->setBow(blen,dir,-delta);
	  } else { // ACCENT
	    noteExp = _grab->setExpression(extNoteElement); // returns this element, or create new if it does not exist
	    int scoreY = (_pressY-YTOP)%(100+yAux);
	    noteExp->setDisplacement( (scoreY<=48) ? -6 : 6 );
	  }
	}
      } else if (tol == ID_TOOL_LYR) {
	//
	// LYRICS
	//
	int selSystem = (_pressY-YTOP) - ((_pressY-YTOP)%(100+yAux));
	createLyrics(_grab,xoffset+(_part->start(_grab)-_editor->left().ticks())*pixPerTick,YTOP+(selSystem+1)*(100+yAux)-18);
      }
    }
    if (tol == ID_TOOL_AOS) {
      //
      // SYSTEM SYMBOL
      //
      symbol = 0;

      Position pos = _grabX; // _pressX - (_pressX%grid()) - _part->start();
      int scoreY = ((_pressY-YTOP) % (100+yAux));
      int scoreTopLine = 12;
      int scoreBottomLine = 84;
      // int offset = 0;
      switch (auxScoreElement) {
      case AS_LABEL1: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_LABEL2: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_LABEL3: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_CASE1: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_CASE2: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_PEDAL1: symbol = _part->setSymbol(pos,auxScoreElement,scoreBottomLine); break;
      case AS_PEDAL2: symbol = _part->setSymbol(pos,auxScoreElement,scoreBottomLine); break;
      case AS_NOTEDOT: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_NOTE3: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_NOTE6: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine); break;
      case AS_NOTEXX: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine,0); break;
      case AS_8VA: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine,0); break;
      case AS_15VA: symbol = _part->setSymbol(pos,auxScoreElement,scoreTopLine,0); break;
      case AS_TRILLX: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,384); break;
      case AS_TRILLX2: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,384); break;
      case AS_DECRESCENDO: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,192); break;
      case AS_CRESCENDO: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,192); break;
      case AS_BRACKETUP: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,768); break;
      case AS_BRACKETDOWN: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,768); break;
      case AS_ARPEGGIO: symbol = _part->setSymbol(pos,auxScoreElement,scoreY,32); break;
      case AS_TEXT: symbol = _part->setSymbol(pos,auxScoreElement,scoreBottomLine,-2);
	createText(symbol,xoffset+(pos.ticks()-_editor->left().ticks()+_part->start().ticks())*pixPerTick,_pressY);
	// createText(symbol,mouseX,mouseY);
	break;
      case DYN_PPP: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_PP: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_P: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_MP: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_MF: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_F: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_FF: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_FFF: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_SFZ: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_SF: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_SFF: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
      case DYN_FP: symbol = _part->setSymbol(pos,auxScoreElement,scoreY); break;
	
	_grab = 0;
	_grabX = -1;
      }

    }
  }
}

void KdeScoreContent::createText(Symbol * sym, int x, int y) {
  textElement = sym;
  // txtLine = new QLineEdit(this,"text");
  txtLine->setGeometry(x,y,30,14);
  txtLine->setText(textElement->text());
  txtLine->show();
  txtLine->setActiveWindow();
  txtLine->setFocus();
  connect(txtLine,SIGNAL(returnPressed()),SLOT(setText()));
}

void KdeScoreContent::setText() {
  if (textElement!=0) {
    textElement->setText(strdup(txtLine->text().ascii()));
  }
  textElement = 0;
  txtLine->hide();
  /* if (txtLine!=0) delete txtLine;
  txtLine = 0;*/
}

void KdeScoreContent::mouseMoveEvent  ( QMouseEvent * me ) {
  _moveX = me->x();
  _moveY = me->y();
  double pixPerTick = (width()-xoffset-4.0)/(_editor->right().ticks()-_editor->left().ticks());
  long pos = _editor->snap((_moveX-xoffset)/pixPerTick) + _editor->left().ticks();
  int pitch = Pitch(_moveY);
  bool tail = false;
  Note * over = _editor->getGrabNote(pos,pitch,tail);
  // cout << int((_moveY-YTOP)/100) << ", " << _active_system << endl;
  if (int((_moveY-YTOP)/100)!=_active_system) over = 0;

  int tol = tool();

  if (_grab!=0) { // NOTE GRABBED
    // TODO: int y = mouseY()-2;
    // if (shftFlag) y = _grabY-2;
    // TODO: moveWidget->move(_moveX-2, y);
    // TODO: if (!moveWidget->isVisible()) moveWidget->show();
    if (tol == ID_TOOL_IN) {
      //
      // NOTE TOOL
      //
      if (shftFlag) QCursor::setPos(QWidget::mapToGlobal(QPoint(_moveX, _grabY)));
    } else if (tol == ID_TOOL_ANS) {
      if (noteBow) {
	noteBow->setLength((_moveX-_pressX)*1.0/pixPerTick);
	noteBow->setDelta(_moveY - _pressY);
      }
      if (noteExp) noteExp->setDisplacement(_moveY - _pressY);
      repaint(FALSE);
    }
  } else {        // FREE
    if (tol == ID_TOOL_IN) {
      //
      // NOTE TOOL
      //
      if (_moveX > xoffset) {
	if (_grabX > -1) {
	  setCursor(QCursor(2));              // CURSOR crosshair
	  repaint(FALSE);
	} else {
	  if (over) {
	    if (tail) setCursor(QCursor(6));  // CURSOR horizontal resize
	    else      setCursor(QCursor(13)); // CURSOR pointing hand
	  }
	  else updateCursor();                // CURSOR note or pen
	}
      } else { setCursor(QCursor(1)); }       // CURSOR arrow up
    } else if (tol == ID_TOOL_ANS) {
      //
      // NOTE SYMBOL
      //
      if (over) setCursor(*symbolcursor1);    // CURSOR filled pen
      else setCursor(*symbolcursor2);         // CURSOR open pen
    } else if (tol == ID_TOOL_LYR) {
      //
      // LYRICS
      //
      if (over) setCursor(*lyricscursor1);    // CURSOR filled text pen
      else setCursor(*lyricscursor2);         // CURSOR open text pen
    } else if (tol == ID_TOOL_AOS) {
      //
      // SYSTEM SYMBOL
      //
      int scoreY = ((_moveY-YTOP) % (100+yAux));
      if (symbol) {
	symbol->setDisplacement(scoreY);
	if (symbol->isParameterized()) {
	  symbol->setParameter((_moveX-_pressX)*1.0/pixPerTick);
	}
	repaint(FALSE);
      }
    }
  }
  if (_moveX > xoffset) {
    int bar=0; int beat=0; int tick=0;
    sonG->bbt(bar,beat,tick,Position(pos));
    _buttonbar->setPos(bar,beat,tick);
  }
  _buttonbar->setPitch(pitch,shftFlag,ctrlFlag);

  /*
  // cout << grabX1 << endl;

  if ((mouseY>YTOP+(1+selSystem)*(100+yAux)-yAux)&&(mouseY<YTOP+(1+selSystem)*(100+yAux))) {
    if (showLYR) setCursor(QCursor(4));
    if (showVOL) { setCursor(QCursor(2)); if (volGrabX1!=0) { volGrabX2 = mouseX; volGrabY2 = mouseY; repaint(false); } }
  } else {
    part = partList[selSystem];
    pos = mousePos.gPosTicks() - (mousePos.gPosTicks()%SnapValue()) - part->gOffset();

    scrKey = part->gKey();
    xoffset  = 60+6*abs(scrKey);
    if (mouseX<=20) setCursor(QCursor(1));
    else if ((mouseX>20) && (mouseX<=xoffset)) setCursor(QCursor(0));
    else {
      // cout << pos.negative() << endl;
      if (pos.negative()==0) buttonbar->setPos(pos.gBar(master,met0,met1),pos.gBeat(master,met0,met1),pos.gTicks(master,met0,met1));
      showFreq();
      updateCursor();
      if (grabNote) {
	grabNote->sPos(pos);
	repaint(FALSE);
      }
    }

    if (tool==ID_TOOL_IN) {
      if (grabX1!=0) repaint(FALSE);

    } else if (tool==ID_TOOL_ANS) {
      // int scoreY = ((mouseY-YTOP) % (100+yAux));

      if (noteExp) noteExp->sOffset(mouseY-mouseDownY);
      if (noteBow) {
	noteBow->sDuration((mouseX-mouseDownX)*1.0/pixPerTick);
	noteBow->sDelta(mouseY-mouseDownY);
      }
      grabX1 = 0;
      repaint(FALSE);

    } else if (tool==ID_TOOL_AOS) {
      int scoreY = ((mouseY-YTOP) % (100+yAux));

      if (auxEl) {
	if (auxEl->isAuxSymbol()) ((KbSymbol*)auxEl)->sOffset(scoreY);
	else if (auxEl->isAuxParSymbol()) {
	  ((KbParSymbol*)auxEl)->sOffset(scoreY);
	  ((KbParSymbol*)auxEl)->sParameter((mouseX-mouseDownX)*1.0/pixPerTick);
	}
      }
      grabX1 = 0;
      repaint(FALSE);
    }

    }*/
}


void KdeScoreContent::mouseReleaseEvent ( QMouseEvent * me ) {
  // TODO: setCursor(QCursor(*prcursor));
  int ind = int((me->y()-YTOP)/100);
  _editor->setPart(ind);
  double pixPerTick = (width()-xoffset-4.0)/(_editor->right().ticks()-_editor->left().ticks());
  long pos = _editor->snap((me->x()-xoffset)/pixPerTick) + _editor->left().ticks();
  int pitch = Pitch(me->y());
  int _grabY2 = me->y();
  long _grabX2 = long((_moveX-xoffset)/pixPerTick + _editor->left().ticks()); // without snap!

  int tol = tool();
  Part * pt = _editor->part();
  ScoreTrack * tr = (ScoreTrack*) pt->track();
  // cout << _grab << ":" << _grabY << ":" << _grabY2 << ":" << _grabX << ":" << _grabX2 << " - " << pitch << endl;
  if (tol == ID_TOOL_IN) {
    //
    // NOTE TOOL
    //
    if (_grab!=0) { // GRABBED NOTE
      if ((_grabY == _grabY2)&&(_grabX == _grabX2)) { // select
	if (shftFlag) {
	  if (selectioN->hasEntry(_grab)) sonG->doo(new RemoveFromSelection(new Reference(_grab)));
	  else                            sonG->doo(new AddToSelection(new Reference(_grab)));
	} else                            sonG->doo(new NewSelection(new Reference(_grab)));
      } else {
	if (ctrlFlag) { // copy event
	  if (shftFlag) sonG->doo(new CopyEvent(Position(pos), _grab, pt));
	  else          sonG->doo(new CopyEvent(Position(pos), _grab, pt, pitch));
	} else {        // move event
	  if (shftFlag) sonG->doo(new MoveEvent(Position(pos), _grab, pt));
	  else          sonG->doo(new MoveEvent(Position(pos), _grab, pt, pitch));
	}
      }
      // TODO: moveWidget->hide();
    } else {      // FREE SPACE
      if ( me->x() < xoffset ) {
	if (keyChooser==false) myKeyChooser = new KdeKeyChooser(_editor);
	myKeyChooser->show();
	keyChooser = true;
      } else if ((_grabY == _grabY2)&&(_grabX == _grabX2)) { // new Note
	if (pitch>0) {
	  if (_editor->speaker()) sonG->player()->hit(tr->output(), tr->channel(), pitch, _editor->velocity());
	  int enh = _editor->enharmonicShift();
	  if (shftFlag) enh++;
	  if (ctrlFlag) enh--;
	  sonG->doo(new AddElement(new Note(pitch,_editor->velocity(),_editor->totalLength(),pos-pt->start(),enh),pt));
	}
      } else { // selection
	if (shftFlag) sonG->doo(new AddToSelection(pt->makeRefs(Pitch(_grabY), Pitch(_grabY2), _grabX, _grabX2)));
	else          sonG->doo(new NewSelection(pt->makeRefs(Pitch(_grabY), Pitch(_grabY2), _grabX, _grabX2)));
      }
    }
  }
  noteExp = 0;
  noteBow = 0;
  symbol = 0;
  _grab = 0;
  _grabX = -1;
  // _editor->update();

  /*
  int yOff = mouseRelY-YTOP;
  int ySys = (yOff % (100+yAux));
  int system = (yOff-ySys)/(100+yAux);

  selSystem = system; if (selSystem>=parts) selSystem = 0;
  part = partList[selSystem];
  freq = Pitch(mouseRelY);

  if (mouseRelX < xoffset) {
    if (mouseRelX > 15) {
      // QtChooser * ch = new QtChooser(part,this);
      // ch->show();
      settings();
    }
  } else {
    pos = mouseRelPos.gPosTicks() - (mouseRelPos.gPosTicks()%SnapValue()) - part->gOffset();

    if (tool==ID_TOOL_IN) {

      if (grabNote) {
	
      } else {
	if (createNote) {
	  if ((mouseRelY>YTOP+(1+selSystem)*(100+yAux)-yAux)&&(mouseY<YTOP+(1+selSystem)*(100+yAux))) {
	    if (showLYR) { // LYRICS
	      part = partList[selSystem];
	      KbNote * n = 0;
	      for (n = part->gFirstNote(); n!=0 && (n->gPos()!=pos); n = (KbNote*)n->gNextNote()) { }
	      if (n!=0) { // ok
		createLyrics(n,xoffset+(n->gPos()-posLeft.gPosTicks()+part->gOffset())*pixPerTick,YTOP+(selSystem+1)*(100+yAux)-18);
	      }
	    }
	  } else {
	    int llen = ticksOfLen(lenValue);
	    if (mouse->button()==LeftButton) {
	      if (freq!=0) {
		int myEnh = enhValue;
		if (shftFlag && (!ctrlFlag) && myEnh<2) myEnh++; // if SHIFT is pressed, increase enh-mode by one only for this note to create...
		if (ctrlFlag && (!shftFlag) && myEnh>-2) myEnh--;
		part->addNote(new KbNote(freq,velocValue,llen,pos,myEnh));
		grabX1=0; // if a note is created, no selection-frame should be displayed
		if (speaker) main->hit(((KbScoreTrack*)part->gTrack())->gOutput(),((KbScoreTrack*)part->gTrack())->gChannel(),freq,velocValue);
	      }
	    }
	  }
	} else { // SELECTION

	}
	
	if ((mouseRelY>YTOP+(1+selSystem)*(100+yAux)-yAux)&&(mouseY<YTOP+(1+selSystem)*(100+yAux))) {
	
	  if (showVOL) {// VOLUME
	    // int ybottom = YTOP+(1+selSystem)*(100+yAux)-yAux;
	    int yAux = 60;
	    KbNote * n = 0;
	    KbNote * m = 0;
	    KbPosition p = KbPosition((volGrabX1-xoffset)*1.0/pixPerTick) + posLeft;
	    for (n = part->gFirstNote(); n!=0 && (n->gPos()+part->gOffset()<p); n = (KbNote*)n->gNextNote()) {}
	    if (n!=0) {
	      p = KbPosition((volGrabX2-xoffset)*1.0/pixPerTick) + posLeft;
	      for (m = n; m!=0 && (m->gPos()+part->gOffset()<p); m = (KbNote*)m->gNextNote()) {}
	      if (m!=0) { // range is now: [n,m]
		//cout << *n << endl << *m << endl;
		int ry1 = 100+yAux-ySysGrab;
		int ry2 = 100+yAux- ((mouseRelY-YTOP) % (100+yAux));
		int deltax = (m->gPos().gPosTicks()-n->gPos().gPosTicks());
		int deltay = int((ry2-ry1)*3.0);
		// cout << "yGrab: " << ySysGrab << " : " << ry1 << ", " << ry2 << endl;
		double slope = deltay*1.0/deltax;
		//cout << "slope: " << slope << endl;
		for (KbNote * note = n; note!=m; note = note->gNextNote())
		  note->sVel(3*ry1+int(slope*(note->gPos().gPosTicks()-n->gPos().gPosTicks())));
	      }
	    }
	    volGrabX1 = 0;
	    }
	}
	
      }
    } else if (tool==ID_TOOL_ANS) {
      // extNoteElement
      grabX1 = 0;
      noteExp = 0;
      noteBow = 0;
      grabNote = 0;
      selX1 = -1;
      enableSelItems(false);
    } else if (tool==ID_TOOL_AOS) {
      // auxScoreElement
      grabX1 = 0;
      auxEl = 0;
      selX1 = -1;
      enableSelItems(false);
    }
  }

  if (mouse->button()==RightButton) {
    mouseDownX = 0;
    grabX1 = 0;
  }
  volGrabX1 = 0;
  repaint( FALSE );
  */
}

void KdeScoreContent::showFreq() {
}

int KdeScoreContent::Pitch(int y) {
  scrKey = _editor->part()->key();
  clef = _editor->part()->clef();
  int ind = int(((y-YTOP)%100)/3);
  if (clef!=0) ind -= yClef[clef];
  int pi = freqTab[ind];
  if (shftFlag && (!ctrlFlag)) pi++;
  if (ctrlFlag && (!shftFlag)) pi--;
  return pi;
}


void KdeScoreContent::createLyrics(Note * note, int x, int y) {
  // lyrLine = new QLineEdit(this,"-");
  lyrX = x;
  lyrY = y;
  lyrLine->setGeometry(x,y,30,14);
  // cout << "lyr: " << x << ", " << y << " : " << pos << endl << *note << endl;
  lyricsNote = note;
  // lyricsPart = part;
  oldLyr = note->lyrics();
  if (oldLyr) lyrLine->setText(oldLyr->get());
  else lyrLine->setText("");
  lyrLine->show();
  lyrLine->setActiveWindow();
  lyrLine->setFocus();
}

void KdeScoreContent::setLyrics() {
  setLyrics(false);
}

void KdeScoreContent::setLyrics(bool cont) {
  if (lyricsNote!=0) {
    if (lyrLine->text().length()>0) {
      if (oldLyr)
	oldLyr->set(strdup(lyrLine->text().stripWhiteSpace().ascii()));
      else
	sonG->doo(new AddOrnament( new Lyrics(lyricsNote,(strdup(lyrLine->text().stripWhiteSpace().ascii()))), lyricsNote ));
    }
    Note * nx = (Note*) _editor->part()->next(lyricsNote);
    lyrLine->hide();
    repaint(FALSE);
    if (cont && (nx!=0)&&(lyrLine->text().length()>0)) {
      int x = int(xoffset+(_part->start(nx)-_editor->left().ticks())*pixPerTick);
      createLyrics(nx,x,lyrY);
    } else {
      setFocus();
    }
  }
  //if (lyrLine!=0) delete lyrLine;
  //lyrLine = 0;
}

void KdeScoreContent::keyPressEvent ( QKeyEvent * key ) {
  Reference * ref = (Reference*)selectioN->first();
  Event * ev = ref==0 ? 0 : (Event*) ref->getValue();

  switch( key->key() ) {
  case Key_Space:
    if (key->state()==AltButton) {
      double pixPerTick = (width()-xoffset-4.0)/(_editor->right().ticks()-_editor->left().ticks());
      long pos = _editor->snap((_moveX-xoffset)/pixPerTick) + _editor->left().ticks();
      _toolbar->setInsertPoint(pos);
    }
    break;
  case Key_Super_L:
    suprFlag = TRUE;
    break;
  case Key_Shift:
    shftFlag = TRUE;
    _buttonbar->setPitch(Pitch(_moveY),shftFlag,ctrlFlag);
    break;
  case Key_Control:
    ctrlFlag = TRUE;
    _buttonbar->setPitch(Pitch(_moveY),shftFlag,ctrlFlag);
    break;
  case Key_Left:
    _editor->moveselleft();
    break;
  case Key_Right:
    _editor->moveselright();
  break;

  case Key_PageUp:
    _part = _editor->moveUp();
    if (selectioN->first()!=0) sonG->doo(new Unselect());
    update();
    break;

  case Key_PageDown:
    _part = _editor->moveDown();
    if (selectioN->first()!=0) sonG->doo(new Unselect());
    update();
    break;

  case Key_Up:
    if (ev && (ev->isA()==NOTE)) {
      Note * note = (Note*) ev;
      sonG->doo(new ChangeNote(note, _editor->part(), note->pitch() + 1));
    }
    break;
  case Key_Down:
    if (ev && (ev->isA()==NOTE)) {
      Note * note = (Note*) ev;
      sonG->doo(new ChangeNote(note, _editor->part(), note->pitch() - 1));
    }
    break;
  case Key_Enter:
    if (_editor->part()!=0) {
      // sonG->play(0,_editor->part(),_editor->left().ticks(),_editor->right().ticks());
      sonG->play(0,_editor->part(),_editor->left().ticks(),sonG->right().ticks());
    }
    break;
  case Key_Insert:
  case Key_0:
    ME->slotStop();
    break;
  default:
    key->ignore();
  }
  // repaint( FALSE );
}


void KdeScoreContent::keyReleaseEvent ( QKeyEvent * key ) {
  switch( key->key() ) {
  case Key_Escape:
    // this is here, because keyPressEvent is not thrown for esc without shift, alt or meta...
    if (selectioN->first()!=0) sonG->doo(new Unselect());
    repaint(FALSE);
    break;
  case Key_Space:
    if (key->state()==AltButton) {
    }
    break;
  case Key_Shift:
    shftFlag = FALSE;
    _buttonbar->setPitch(Pitch(_moveY),shftFlag,ctrlFlag);
    break;
  case Key_Control:
    ctrlFlag = FALSE;
    _buttonbar->setPitch(Pitch(_moveY),shftFlag,ctrlFlag);
    break;
  case Key_Super_L:
    suprFlag = FALSE;
    break;
  default:
    key->ignore();
  }
}




void KdeScoreContent::print() {
  myPrintDialog = new KdeSPD(this,"Print Dialog",_editor);
}

void KdeScoreContent::printIt() {
  // char * filename = mainEditor->filename();
  const char * filename = mainEditor->filename();
  // cout << ":" << filename << ":" << endl;
  int parts = _editor->parts();
  if ((filename!=0)&&(strlen(filename)>0)) {
    char * fname = (char*) strdup(filename); // new char[strlen(filename)+8];
    // sprintf(fname,"%s.mup",filename);
    int flen = strlen(fname);
    fname[flen-3] = 'm'; fname[flen-2] = 'u'; fname[flen-1] = 'p';
    ofstream out(fname);
    // TODO: ((QtMain*)main->gInterface())->msg("Printing Brahms Song");

    ScoreTrack * scTrack;
    NoteBar * firstBar[parts];
    NoteBar * myBar[parts];
    Part * part = 0;
    int absKey = 0;
    char keyChar = 0;

    // systems:
    int systems = 0;
    int psystem = 0;
    int totalsystems = 0;
    if (mainEditor->PP()) { // partiture
      for (N=0;N<parts;N++)
	if (((ScoreTrack*)_editor->part(N)->track())->PiP()==TRUE) systems++;
    }
    totalsystems = systems;
    if (mainEditor->PPS()) { totalsystems += 2; psystem = 1; } // pianosystem

    cout << "systems: " << systems << ", ts: " << totalsystems << endl;
    if (totalsystems>0) {
      out << "header
\ttitle (18) \"" << sonG->title() << "\"
\ttitle (14) \"" << sonG->comment() << "\"
\ttitle \"\"   \"" <<sonG->author() << "\"

footer
\ttitle \" created with Brahms/Linux\"

header2
\ttitle \"- \\\% -\"

score
\ttime = " << _editor->part(0)->meter0() << "/" << _editor->part(0)->meter1() << "
\tbeamstyle = ";

      for (int i=0;i<met0;i++) {
	out << met1;
	if (i < met0-1) out << ", ";
      }

      out << "
\tscale = 0.8
\tmeasnum = y
\tstaffs = " << totalsystems << endl;
      // bracket:
      out << "
\tbracket = ";
      if (systems>0) {
	out << "1-" << systems;
	if (psystem>0) out << ", ";
      }
      if (psystem>0) {
	out << systems+1 << "-" << totalsystems;
      }
      out << endl;
      // barstyle:
      out << "
\tbarstyle = ";
      if (systems>0) {
	out << "1-" << systems;
	if (psystem>0) out << ", ";
      }
      if (psystem>0) {
	out << systems+1 << "-" << totalsystems;
      }
      out << endl;

      if (psystem>0) { // pianosystem
	out << "
\tvscheme = 2o" << endl;
      }
      int pNum = 0;
      if (systems>0) { // partiture
	for (N=0;N<parts;N++) {
	  part = _editor->part(N);
	  if (((ScoreTrack*)part->track())->PiP()) {
	    // int pNum = N+1;
	    pNum++;
	    absKey = abs(part->key());
	    keyChar = '#';
	    if (part->key()<0) keyChar = '&';
	    scTrack = (ScoreTrack*) part->track();
	
	    out << "staff " << pNum << "
\tlabel = \"" << scTrack->name()->getValue() << "\"
\tkey = " << absKey << keyChar << "
\tclef = " << bClef2mClef[part->clef()] << endl;
	  }
	}
      }
      if ( psystem > 0 ) { // pianosystem
	absKey = abs(_editor->part(0)->key());
	keyChar = '#';
	if (part->key()<0) keyChar = '&';
	out << "staff " << totalsystems-1 << "
\tkey = " << absKey << keyChar << "
\tclef = treble" << endl;
	out << "staff " << totalsystems << "
\tkey = " << absKey << keyChar << "
\tclef = bass" << endl;
      }
      out << "music" << endl;

      Position relPos = 0;
      Position lpos = 0; // DOIT: posLeft;
      pNum = 0;
      for (N=0;N<parts;N++) {
	part = _editor->part(N);
	// if (part->gTrack()->PiP()) {
	  pNum++;
	  globalStaffCounter = parts-N-1;
	
	  for (int i=0;i<7;i++) scrSigns[i]=allSigns[scrKey+7][i];
	
	  QtScoreGroup * myGroup = 0;
	  QtScoreGroup * tmp = 0;
	  lpos = 0; // DOIT: posLeft;
	  // relPos = 0 - part->start();
	  Event * atom = (Event*) part->first();
	  while (atom!=0) {
	    if (atom->isA()==NOTE) {
	      Note * note = (Note*) atom;
	      if (myGroup == 0) {
		myGroup = new NoteGroup(note,part->start());
		if (part->start(note).ticks() > 0) {
		  createBreakGroups(firstGroup, tmp, lpos, part->start(note).ticks(), part->start(), master, met0, met1);
		  tmp->sNext(myGroup);
		} else {
		  firstGroup = myGroup;
		}
	      } else {
		myGroup = myGroup->append(note,part->start(),master,met0,met1);
	      }
	    }
	
	    atom = (Event*) part->next(atom);
	    bool allParts = TRUE;
	    if (allParts==TRUE && atom==0 && part->next(part)!=0) { // to the following part ;-)
	      part = (Part*) part->next(part);
	      atom = (Event*)part->first();
	      scrKey = part->key();
	      clef = part->clef();
	    }
	  }
	
	
	  // now everything is packed up in groups, lets pack the
	  // groups into bars:
	
	
	  if (firstGroup) {
	    firstBar[N] = new NoteBar(firstGroup);
	    NoteBar * curBar = firstBar[N];
	    for (myGroup = firstGroup->Next(); myGroup!=0; myGroup = myGroup->Next()) {
	      curBar = curBar->append(myGroup,master,met0,met1);
	    }
	    if (curBar) curBar->fill(master,met0,met1);
	  }
	  // }
      }

      for (int i=0;i<parts;i++) myBar[i] = firstBar[i];
      int loop = 1;
      int iTreble = 0;
      int iBass = 0;
      while (loop) {
	if (systems>0) { // partiture
	  pNum = 0;
	  for (int i=0;i<parts;i++) {
	    if (((ScoreTrack*)_editor->part(i)->track())->PiP()) {
	      pNum++;
	      scrKey = _editor->part(i)->key();
	      for (int ii=0;ii<7;ii++) scrSigns[ii]=allSigns[scrKey+7][ii];
	      out << endl << "\t" << pNum << ": ";
	      relPos = _editor->part(i)->start() - lpos;
	      myBar[i]->mup(relPos,scrClef,master,met0,met1,&out,pNum-1); // error? ok, statt i pNum-1
	    }
	  }
	}
	if (psystem>0) { // piano system
	  pNum = totalsystems-1;
	  // scrKey?
	  // treble:
	  iTreble = 0;
	  for (int ii=0;ii<7;ii++) scrSigns[ii]=allSigns[scrKey+7][ii];
	  for (int i=0;i<parts;i++) {
	    if (((ScoreTrack*)_editor->part(i)->track())->PiPS()==1) { // 0: skip, 1: treble, 2: bass
	      iTreble++;
	      out << endl << "\t" << pNum << " " << iTreble << ": ";
	      relPos = _editor->part(i)->start() - lpos;
	      myBar[i]->mup(relPos,0,master,met0,met1,&out,pNum-1); // "0": treble-clef! error? ok, statt i pNum-1
	    }
	  }
	  // bass:
	  iBass = 0;
	  pNum = totalsystems;
	  for (int ii=0;ii<7;ii++) scrSigns[ii]=allSigns[scrKey+7][ii];
	  for (int i=0;i<parts;i++) {
	    if (((ScoreTrack*)_editor->part(i)->track())->PiPS()==2) { // 0: skip, 1: treble, 2: bass
	      iBass++;
	      out << endl << "\t" << pNum << " " << iBass << ": ";
	      relPos = _editor->part(i)->start() - lpos;
	      myBar[i]->mup(relPos,1,master,met0,met1,&out,pNum-1); // "0": treble-clef! error? ok, statt i pNum-1
	    }
	  }
	}
	out << endl << "bar";
	for (int i=0;i<parts;i++)
	  // if (_editor->part(i)->gTrack()->PiP())
	  myBar[i] = myBar[i]->Next();
	for (int i=0;i<parts;i++)
	  // if (_editor->part(i)->gTrack()->PiP())
	  if (myBar[i]==0) loop = 0;
      }
    }
    out << endl;
    out.close();
    char * command = new char[3*strlen(fname)+30];
    char * fname1 = new char[strlen(fname)+1];
    strcpy(fname1,fname);
    flen = strlen(fname1);
    fname1[flen-3] = 'p';
    fname1[flen-2] = 's';
    fname1[flen-1] = 0;
    sprintf(command,"mup %s > %s; kghostview %s &", fname, fname1, fname1);
    int e = ::system(command);
    if (e!=0) ME->slotStatusHelpMsg(i18n("An error has occured using mup or kghostview"));
    delete fname;
    delete fname1;
    delete command;
  }
  // DOIT: remove bars and groups, etc !!!

}

void KdeScoreContent::moveCursor(int ticks) {
  double pixPerTick = (width()-xoffset-4.0)/(_editor->right().ticks()-_editor->left().ticks());
  long pos = long((ticks-_editor->left().ticks())*pixPerTick);
  if (pos>width()-24) {
    _editor->moveleft(_editor->numberOfBars());
  }
  _position_cursor->move(pos+xoffset);

}

#endif
#include "kdeScoreContent.moc"
