#ifndef _KDESPD_C_
#define _KDESPD_C_

#include <iostream.h>
#include <stdio.h>

#include "kdeSPD.h"
#include "kdeScoreEditor.h"
#include "kdeScoreEditor2.h"
#include "kdeScoreContent.h"
#include "kdeScoreContent2.h"
#include "str.h"
#include "part.h"
#include "track.h"
#include "scoreTrack.h"
#include "prPartEditor.h"
#include "prMainEditor.h"

#include <qpushbutton.h>

extern PrMainEditor * mainEditor;

const char * psMenu[] = {"-","treble","bass",0};

KdeSPD::KdeSPD( QWidget * parent , const char * name , PrPartEditor * pe )
  : QLabel( parent, name ), _editor(pe)
{
  systems = _editor->parts();
  int deltay = systems*20;

  dialog = new QTabDialog();
  dialog->setFixedSize(340,200+2*deltay);

  // -------------------------------------
  //
  // PRINT SETUP
  //


  pref1 = new QWidget(dialog, "page 1");
  pref1->setFixedSize(340,200+2*deltay);
  // print systems
  group1 = new QGroupBox("Partiture", pref1, "printsetup");
  group1->setGeometry(20,20,300,60+deltay);

  label = new QLabel("print partiture",group1);
  ppbox = new QCheckBox(group1,"pp");
  ppbox->setChecked(mainEditor->PP());
  label->setGeometry(10,20,120,20);
  ppbox->setGeometry(120,20,20,20);
  connect(ppbox,SIGNAL(released()),SLOT(ppboxUpdate()));
  Part * part = 0;
  char * help = new char[64];
  for (int N=0;N<systems;N++) {
    part = _editor->part(N);
    sprintf(help,"System %d %.10s",N+1,part->track()->name()->getValue());
    //
    label = new QLabel(help,group1);
    partiture[N] = new QCheckBox(group1,"check");
    partiture[N]->setChecked(((ScoreTrack*)part->track())->PiP());
    label->setGeometry(30,40+N*20,260,20);
    partiture[N]->setGeometry(10,40+N*20,20,20);
    partiture[N]->setEnabled(mainEditor->PP());
    connect(partiture[N],SIGNAL(released()),SLOT(partitureUpdate()));
    ppValue[N] = ((ScoreTrack*)part->track())->PiP();
  }


  // print into pianosystem
  group2 = new QGroupBox("Piano System", pref1, "printsetup");
  group2->setGeometry(20,80+deltay,300,60+deltay);


  label = new QLabel("print piano system",group2);
  ppsbox = new QCheckBox(group2,"pp");
  ppsbox->setChecked(mainEditor->PPS());
  label->setGeometry(10,20,120,20);
  ppsbox->setGeometry(120,20,20,20);
  connect(ppsbox,SIGNAL(released()),SLOT(ppsboxUpdate()));

  for (int N=0;N<systems;N++) {
    part = _editor->part(N);
    //
    sprintf(help,"System %d %.10s",N+1,part->track()->name()->getValue());
    label = new QLabel(help,group2);
    pianosys[N] = new QComboBox(FALSE,group2,"ps");
    pianosys[N]->insertStrList( psMenu );
    pianosys[N]->setCurrentItem( ((ScoreTrack*)part->track())->PiPS() );
    label->setGeometry(60,40+N*20,220,20);
    pianosys[N]->setGeometry(10,40+N*20,50,20);
    pianosys[N]->setEnabled(mainEditor->PPS());
    connect(pianosys[N],SIGNAL(activated(int)),SLOT(pianosysUpdate(int)));
    ppsValue[N] = ((ScoreTrack*)part->track())->PiPS();
  }

  QPushButton * printb = new QPushButton( "Print", pref1 );
  // QPushButton * cancelb = new QPushButton( "Cancel", pref1 );
  printb->setGeometry(20,170+2*deltay,60,20);
  // cancelb->setGeometry(100,170+2*deltay,60,20);
  connect(printb,SIGNAL(released()),SLOT(printme()));
  // connect(cancelb,SIGNAL(released()),SLOT(cancelme()));


  dialog->addTab(pref1, "Print Setup");

  dialog->show();
  delete[] help;
}





void KdeSPD::ppboxUpdate() {
  mainEditor->sPP(ppbox->isChecked());
  for (int i=0; i<systems; i++) {
    partiture[i]->setEnabled(mainEditor->PP());
  }
}

void KdeSPD::ppsboxUpdate() {
  mainEditor->sPPS(ppsbox->isChecked());
  for (int i=0; i<systems; i++) {
    pianosys[i]->setEnabled(mainEditor->PPS());
  }
}

void KdeSPD::partitureUpdate() {
  int x = -1;
  for (int i=0; i<systems; i++) {
    if (partiture[i]->isChecked() != ppValue[i]) { x = i; i = systems; }
  }
  if ((x>-1) && (x<systems)) {
    ppValue[x] = partiture[x]->isChecked();
    ((ScoreTrack*)_editor->part(x)->track())->sPiP(ppValue[x]);
  } else cout << "PANIC: KdeSPD::partitureUpdate()" << endl;
}

void KdeSPD::pianosysUpdate(int ) {
  int x = -1;
  for (int i=0; i<systems; i++) {
    if (pianosys[i]->currentItem() != ppsValue[i]) { x = i; i = systems; }
  }
  if ((x>-1) && (x<systems)) {
    ppsValue[x] = pianosys[x]->currentItem();
    ((ScoreTrack*)_editor->part(x)->track())->sPiPS(ppsValue[x]);
  } else cout << "PANIC: KdeSPD::pianosysUpdate()" << endl;
}

void KdeSPD::printme() {
  ((KdeScoreEditor2*)_editor)->content()->printIt();
}

void KdeSPD::cancelme() {
  delete pref1;
  delete this;
}


#endif
#include "kdeSPD.moc"
