#ifndef _KDEPART_CPP_
#define _KDEPART_CPP_

#include <iostream.h>
#include <stdio.h>

#include <qpopupmenu.h>
#include <qwidget.h>
#include <qrect.h>
#include <qstring.h>
#include <qpainter.h>

#include <klocale.h>

#include "kdePart.h"
#include "kdeMainEditor.h"
#include "kdeEventEditor.h"
#include "kdePianoRollEditor.h"
#include "kdeScoreEditor2.h"
#include "kdeDrumEditor.h"
#include "kdeAudioEditor.h"
#include "kdeMasterEditor.h"
#include "kdeSampleEditor.h"
#include "brahmsResources.h"

#include "scoreTrack.h"
#include "str.h"
#include "song.h"
#include "part.h"
#include "note.h"
#include "track.h"
#include "event.h"
#include "addon.h"
#include "movePart.h"
#include "copyPart.h"
#include "copyGhostPart.h"
#include "splitPart.h"
#include "glueParts.h"
#include "removeElement.h"
#include "reference.h"
#include "newSelection.h"
#include "addToSelection.h"
#include "removeFromSelection.h"
#include "table.h"

extern Table * selectioN;

extern Song * sonG;
extern const char * gmNames[];
extern const char * gmCat[];
extern PrMainEditor * mainEditor;

#define ME ((KdeMainEditor*)mainEditor)


KdePart::KdePart(Part * pt)
  : QLabel(ME->right()),
    local_x(-1), _part(pt)
{
  setFrameStyle( QFrame::Panel | QFrame::Raised );
  setGeometry(0,0,1,1);
  mask = new QWidget(ME->right());
  mask->setBackgroundMode(QWidget::PaletteLight);
  mask->hide();

  

  instPM = new QPopupMenu(  );
  for (int i=0;i<16;i++) {
    instPMs[i] = new QPopupMenu(  );
    instPMs[i]->setCheckable(TRUE);
    for (int k=0;k<8;k++)
      instPMs[i]->insertItem(gmNames[i*8+k],i*8+k);
    connect(instPMs[i],SIGNAL(activated(int)),SLOT(instMenu(int)));
    instPM->insertItem(gmCat[i], instPMs[i]);
  }


  rbmenu = new QPopupMenu;
  buildMenu();
}

void KdePart::buildMenu() {
  rbmenu->clear();
  rbmenu->setMouseTracking( TRUE );
  int typ = _part->track()->isA();
  if (typ==SCORETRACK) rbmenu->connectItem( rbmenu->insertItem(i18n("Edit Score")), this, SLOT(scoreEdit()) );
  if (typ==DRUMTRACK) rbmenu->connectItem( rbmenu->insertItem(i18n("Edit Drummap")), this, SLOT(drumEdit()) );
  if (typ==SCORETRACK) rbmenu->connectItem( rbmenu->insertItem(i18n("Edit Piano Roll")), this, SLOT(pianoRollEdit()) );
  if (typ==SCORETRACK) rbmenu->connectItem( rbmenu->insertItem(i18n("Edit Sample Editor")), this, SLOT(sampleEdit()) );
  if (typ<MASTERTRACK) rbmenu->connectItem( rbmenu->insertItem(i18n("Edit Events")), this, SLOT(eventEdit()) );
  // rbmenu->connectItem( rbmenu->insertItem(i18n("Adjust Part Size")), this, SLOT(adjustPartSize()) );
  if (typ<MASTERTRACK) rbmenu->insertSeparator();
  if (typ==MASTERTRACK) {
    rbmenu->connectItem( rbmenu->insertItem(i18n("Edit Time Events")), this, SLOT(eventTimeEdit()) );
    rbmenu->insertSeparator();
  }
  if (typ==AUDIOTRACK) {
    rbmenu->connectItem( rbmenu->insertItem(i18n("Edit Wave Events")), this, SLOT(waveEdit()) );
    rbmenu->insertSeparator();
  }
  if (typ==COMMENTTRACK) {
    rbmenu->connectItem( rbmenu->insertItem(i18n("Edit comment")), this, SLOT(commentEdit()) );
    rbmenu->insertSeparator();
  }
  if (typ==SCORETRACK) {
    rbmenu->insertItem(i18n("Instrument"), instPM );
    rbmenu->insertSeparator();
  }

  if (true) { // typ<=MASTERTRACK) {
    char ** alist = ME->actionList();
    char ** clist = ME->categories();
    for (int i=0;clist[i]!=0;i++) {
      int * nlist = ME->actionListByCategory(clist[i]);
      QPopupMenu * catMenu = new QPopupMenu();
      for (int k=0;nlist[k]!=-1;k++) {
	if (ME->actionContext(nlist[k])&Addon::TREAT_PART) catMenu->insertItem(alist[nlist[k]],nlist[k]);
      }
      if (catMenu->count()>0) {
	rbmenu->insertItem(clist[i],catMenu,i);
	connect(catMenu,SIGNAL(activated(int)),SLOT(slotAddon(int)));
      }
    }
    rbmenu->insertSeparator();
  }
  rbmenu->connectItem( rbmenu->insertItem(i18n("Erase Part")), this, SLOT(deletePart()) );
}

void KdePart::slotAddon(int i) {
  if (ME->actionList()[0] != 0) {
    ME->performAction( i, part() );
  }
}

void KdePart::update(bool menu) {
  if (_part->track()==0) { cout << "jetzt kracht's: die Parts muessen ihre Tracks kennen!" << endl; }
  if (selectioN->hasEntry(_part)) setBackgroundMode(QWidget::PaletteLight);
  else                            setBackgroundMode(QWidget::PaletteBackground);
  
  if (menu) buildMenu();
  
  //
  // draw contents
  //
  int n = _part->track()->ord(sonG);
  // cout << _part->track()->name()->getValue() << ": " << n << endl;
  int hh = ME->trackHeight();
  int ww = 20;

  double ppt = ME->pixPerTick();
  int baroffset = ME->barOffset();
  Event * last = (Event*) _part->last();
  if (last) ww = int(ppt*last->internalEnd());

  int indent = 20;                                   // small space to the border.
  int left = 0;
  left += int(_part->start().ticks()*ppt);           // the part's offset
  if (baroffset>0) {                                 // the offset due to the view (starting at a certain bar)
    Position deltaPos = Position(baroffset+1,1,0);
    left -= int( deltaPos.ticks()*ppt );
  }
  if (left >= 0)        setGeometry(indent + left,n*hh, ww, hh);
  else if (left+ww > 0) setGeometry(indent,       n*hh, left+ww, hh);
  else                  setGeometry(indent - 2,   n*hh, 1, hh);
  repaint();
}

void KdePart::erase() { // this is called from the core destructor
  delete this;
}

void KdePart::hide() {
  QWidget::hide();
}

void KdePart::show() {
  QWidget::show();
}

Part * KdePart::part() { return _part; }


void KdePart::instMenu(int entry) {
  _part->setProgram(entry);

  // DOIT:((QtTrack*) part->gTrack()->gInterface())->sProgram(128);
  //  if (openScore!=0) openScore->scanvas->repaint( FALSE );
}

void KdePart::deletePart() {
  Track * tr = _part->track();
  sonG->doo(new RemoveElement(_part, tr));
  ME->update();
}

void KdePart::testPart() {

}

// *******************************************************************************
//
// Editors
// =======
//


void KdePart::scoreEdit() {
  KdeScoreEditor2 * ev = new KdeScoreEditor2(_part, ME);
  mainEditor->addEditor(ev);
  ev->show();

  //QtScore * sc = new QtScore(part);
  //sc->show();
  //qtmain->edList->add(sc);
}

void KdePart::drumEdit() {
  KdeDrumEditor * de = new KdeDrumEditor(_part);
  mainEditor->addEditor(de);
  de->show();
  
  //QtDrum * dr = new QtDrum(part);
  //dr->show();
  //qtmain->edList->add(dr);
}

void KdePart::pianoRollEdit() {
  KdePianoRollEditor * pn = new KdePianoRollEditor(_part);
  mainEditor->addEditor(pn);
  pn->KMainWindow::show();
  //pn->show();
  //qtmain->edList->add(pn);
}

void KdePart::sampleEdit() {
  KdeSampleEditor * se = new KdeSampleEditor(_part);
  mainEditor->addEditor(se);
  se->KMainWindow::show();
  //pn->show();
  //qtmain->edList->add(pn);
}

void KdePart::eventEdit() {
  KdeEventEditor * ev = new KdeEventEditor(_part);
  mainEditor->addEditor(ev);
  ev->KMainWindow::show();
  //qtmain->edList->add(ev);
}

void KdePart::eventTimeEdit() {
  KdeMasterEditor * ev = new KdeMasterEditor(_part);
  mainEditor->addEditor(ev);
  ev->KMainWindow::show();
}

void KdePart::commentEdit() {
  //QtCommentEdit * ev = new QtCommentEdit(part);
  //ev->show();
  //qtmain->edList->add(ev);
}

void KdePart::waveEdit() {
  KdeAudioEditor * ae = new KdeAudioEditor(_part);
  mainEditor->addEditor(ae);
  ae->KMainWindow::show();
}



void KdePart::closeEditor() {
  // stuff that needs to be done when an editor closes goes here!
  //repaint();
}



// *******************************************************************************
//
// Mouse Events
// ============
//


void KdePart::mousePressEvent( QMouseEvent * mouse ) {
  if (ME->tool()==ID_PANEL_ARROW) {
    if (mouse->button()==LeftButton) {
      mask->setGeometry(geometry());
      mask->show();
      local_x = mouse->x();
      local_y = mouse->y();
      mask_x = mask->x();
      mask_y = mask->y();
    }
  } else if (ME->tool()==ID_PANEL_CROP) {
    splitPoint = mapToParent(mouse->pos()).x();
    partSplit();
  } else if (ME->tool()==ID_PANEL_GLUE) {
    partGlue();
  }

  if (mouse->button()==RightButton) {
    splitPoint = mapToParent(mouse->pos()).x();
    rbmenu->popup( mapToGlobal(mouse->pos()), 0 );
  }
}

void KdePart::mouseMoveEvent( QMouseEvent * mouse ) {
  if (ME->tool()==ID_PANEL_ARROW) {
    if (local_x > -1) {
      int h = ME->trackHeight();
      int i = int(mapToParent(mouse->pos()).y() / h);
      mask->move(mouse->x() - local_x + mask_x, i*h);
      trackOrd = i;
    }
  }
}

void KdePart::mouseReleaseEvent( QMouseEvent * mouse )
{
  if (ME->tool()==ID_PANEL_ARROW) {
    // QRect rect = mask->geometry();
    Track * src = _part->track();
    Track * tgt = src;
    //cout << mouse->y()/ ME->trackHeight() << ", " <<  mapToParent(mouse->pos()).y()/ ME->trackHeight() << endl;
    //int i = int( mapToParent(mouse->pos()).y()/ ME->trackHeight());
    //cout << i << endl;
    if (trackOrd>=0 && sonG->size()>trackOrd)
      tgt = (Track*) sonG->get(trackOrd);
    mask->hide();
    if (mouse->x() != local_x) {
      int dx = int((mouse->x()-local_x)/ME->pixPerTick());
      Position p = _part->start() + dx;
      p.snap(ME->snap());
      if (ME->ctrl()) {
	//
	// COPY PART
	//
	if (ME->shft())
	  sonG->doo(new CopyGhostPart(p, _part, src, tgt));
	else
	  sonG->doo(new CopyPart(p, _part, src, tgt));
	int bar; int beat; int tick;
	sonG->bbt(bar,beat,tick,p);
	char * MSG = new char[40];
	sprintf(MSG,"Part copied to %d. %d. %d",bar,beat,tick);
	ME->slotStatusMsg(i18n(MSG));
	delete[] MSG;
      } else {
	//
	// MOVE PART
	//
	move(mouse->x()-local_x+mask_x, mask->y());
	sonG->doo(new MovePart(p, _part, src, tgt));
	int bar; int beat; int tick;
	sonG->bbt(bar,beat,tick,p);
	char * MSG = new char[40];
	sprintf(MSG,"Part moved to %d. %d. %d",bar,beat,tick);
	ME->slotStatusMsg(i18n(MSG));
	delete[] MSG;
      }
    } else {
      if (ME->selectArea()!=PARTS) {
	//
	// new selection:
	//
	sonG->doo(new NewSelection(new Reference(_part)));
	ME->selectArea(PARTS);
      } else {
	//
	// add / remove to / from selection:
	//
	if (mouse->state() & ShiftButton) {
	  if (selectioN->hasEntry(_part)) sonG->doo(new RemoveFromSelection(new Reference(_part)));
	  else { // only allow to select parts belonging to the same track:
	    Reference * ref = (Reference*)selectioN->first();
	    bool ok = true;
	    if ((ref!=0) && (ref->getValue()->isA()==PART)) {
	      Part * pt = (Part*) ref->getValue();
	      if (pt->track() != _part->track()) ok = false;
	    }
	    if (ok) sonG->doo(new AddToSelection(new Reference(_part)));
	    else ME->slotStatusMsg("Multiple parts must belong to the same track!");
	  }
	} else {
	  sonG->doo(new NewSelection(new Reference(_part)));
	}
      }
    }
  } else {
    ME->slotToolArrow();
  }
  ME->update();
}

void KdePart::paintEvent( QPaintEvent * pe ) {
  QFrame::paintEvent(pe);
  PartApp pa = sonG->partAppearance();
  switch (pa) {
  case CLEAN:
    break;
  case TRACKNAME:
    paintTrackName();
    break;
  case INSTRUMENT:
    paintInstrument();
    break;
  case EVENTS:
    paintEvents();
    break;
  }
}

void KdePart::paintTrackName() {
  QPainter p;

  p.begin(this);

  int ghosts = _part->ghosts();
  QString gh="";
  if (ghosts>0) gh = QString(" ("+QString::number(ghosts)+")");
  
  if (_part->ghostOf()) {
    QFont f = p.font();
    f.setItalic(true);
    p.setFont(f);
    p.setPen( Qt::blue );
  }
  p.drawText(4,16,_part->track()->name()->getValue() + gh);
  if (_part->ghostOf()) {
    QFont f = p.font();
    f.setItalic(false);
    p.setFont(f);
    p.setPen( Qt::black );
  }
  p.end();
}

void KdePart::paintInstrument() {
  Track * tr = _part->track();
  if ((tr->isA()==SCORETRACK)||(tr->isA()==DRUMTRACK)) {
    QPainter p;
    
    p.begin(this);
    p.drawText(4,16,gmNames[((ScoreTrack*)tr)->program()]);
    p.end();
  }
}

void KdePart::paintEvents() {
  Track * tr = _part->track();
  int ymid = height()/2;
  long pos = Position(ME->barOffset()+1,1,0).ticks();

  QPainter p;
  
  p.begin(this);
  double pixPerTick = ((KdeMainEditor*)mainEditor)->pixPerTick();
  for (Event * n = (Event*) _part->first();n!=0;n=(Event*)_part->next(n)) {
    int xx = int((n->internalStart().ticks()-pos)*pixPerTick);
    int yy = 44;
    if (n->isA()==NOTE) { yy = int(((Note*)n)->vel()*ymid*1.0/120); p.setPen(blue); }
    else if (n->isA()==MASTEREVENT) { p.setPen(red); }
    else { p.setPen(green); }
    p.drawLine(xx,ymid-yy,xx,ymid+yy);
  }
  p.end();
  
}

void KdePart::partCopy() {
  _part->partCopy();
  ME->slotStatusMsg(i18n("Part copied"));
  ME->update();
}

void KdePart::partGlue() {
  if (!_part->ghostOf()) {
    sonG->doo(new GlueParts(_part));
    ME->slotStatusMsg(i18n("Parts glued"));
  } else {
    ME->slotStatusMsg(i18n("Cannot glue ghostpart"));
  }
  ME->update();
}

void KdePart::partSplit() {
  if (!_part->ghostOf()) {
    Position p = Position((splitPoint-20)*1.0/ME->pixPerTick());
    p.snap(ME->snap());
    sonG->doo(new SplitPart(p,_part));
    ME->slotStatusMsg(i18n("Part split"));
  } else {
    ME->slotStatusMsg(i18n("Cannot split ghostpart"));
  }
  ME->update();
}





#endif
#include "kdePart.moc"
