#ifndef _KDEEVENTEDITOR_H_
#define _KDEEVENTEDITOR_H_

#include <kmainwindow.h>

#include "prPartEditor.h"

#include "kdeEventContent.h"
#include "kdeEventFrame.h"

class Part;
class QSplitter;
class QPopupMenu;
class KdeEventFrame;
class KdeEditorToolBar;
class KdeEditorScrollBar;

class KdeEventEditor : public KMainWindow, public PrPartEditor
{
  Q_OBJECT

 private:
  QSplitter * splitter;
  QPopupMenu      * _filemenu;
  QPopupMenu      * _editmenu;
  QPopupMenu      * _gridmenu;
  QPopupMenu      * _dynamicsmenu;
  QPopupMenu      * _viewmenu;
  KdeEditorScrollBar * _scrollbar;
  KdeEditorToolBar   * _toolbar;
  KdeEventContent * lw;
  KdeEventFrame * ew;
  bool _toolbarstate;
  bool _notebarstate;
  bool _buttonbarstate;
  bool _sliderstate;

  // Part * part;
  int _grid_id;
  int _dyn_id;
  int top;
  int itemh;
  int Pitch(int);
  
 public:
  KdeEventEditor();
  KdeEventEditor(Part * p);
  KdeEventEditor(Track * t);
  ~KdeEventEditor();
  void run();
  virtual void update();
  virtual void gui(GuiEvents ev, bool flag);
  virtual void print();
  virtual void settings();
  virtual void setCursorPosition(long ticks);

  // from former version:

  void setTop(int);
  int getTop();
  void updateEW();
  void setItemHeight(int);
  int itemHeight();
  KdeEventContent * content();
  KdeEventFrame * frame();

 public slots:
  void exit();
  void paintEvent ( QPaintEvent * );
  void resizeEvent( QResizeEvent * );
  void keyPressEvent( QKeyEvent * );
  void keyReleaseEvent( QKeyEvent * );
  void slotMenu( int );
  void slotGridMenu( int );
  void slotDynMenu( int );
  void slotViewMenu( int );

};

#endif
