#ifndef _SCOREITERATOR_H_
#define _SCOREITERATOR_H_

//
// usage:
//
// gi = new ScoreIterator(_editor);  // respects left and right positions
//
// for (ScoreIterator gi = ScoreIterator(_editor); !gi.done(); gi++) {
//   draw(gi);
// }
//
//
//
//
//
//

#include <ostream.h>

#include "position.h"
#include "iterator.h"
#include "table.h"
#include "systemIterator.h"

class PrPartEditor;
class Track;
class Part;
class Event;
class Note;

enum ScoreArea { LeftBorder, Clef, Indent, Score, RightBorder };

class ScoreIterator : public Iterator
{
 private:
  SystemIterator ** _iterator;
  ScoreBar       ** _bar;
  ScoreBar       ** _ref_bar;
  PrScoreEditor * _editor;
  int    _systems;
  int    _ptr;
  int    _max;
  int    _res;
  bool   _no_overlap;
  double _scale;
  int    _width;
  int    _xoffset;
  int    _xpos;
  long   _lpos;
  long   _rpos;
  void   incr();

 public:
  ScoreIterator(const ScoreIterator& i);

  ScoreIterator(PrScoreEditor * editor, int xoff, Position lpos = -1, Position rpos = -1);

  ~ScoreIterator();

  /** creates the Score from the events
   */
  void init();

  bool done();

  void paint();

  void print(ostream&);

  Element * operator *();

  Iterator& operator++();

  Iterator operator++(int);

  ScoreBar * firstBar(int) const;

  long ticks(int xpos, ScoreArea & area) const;

  int xposition(long ticks);
};

#endif
